/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download;

import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.game.download.version.GameVersion;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import java.io.File;

public class GameDownloadUtils {
    private static final String TAG = "GameDownloadUtils";
    private static final String FOLDER_GAME = "game";
    private static final String FOLDER_META_COCOS = "cocos";
    private static final String FOLDER_META_LUA = "lua";
    private static final String GAME_FILE_NAME = "game_state.config";
    private static final String FOLDER_PRE_DOWNLOAD = "pre_download";
    private static String sAppGameLuaDir = null;
    private static int sSDCardAvailable = -1;
    private static long sLastCheckSDCardAvailableTime = -1L;

    public static String getAppGameLuaDir() {
        if (StringUtils.isNotEmpty((String)sAppGameLuaDir)) {
            return sAppGameLuaDir;
        }
        File dir = RuntimeContext.sApplicationContext.getFilesDir();
        sAppGameLuaDir = dir.getAbsolutePath() + File.separator + FOLDER_GAME + File.separator + FOLDER_META_LUA + File.separator;
        return sAppGameLuaDir;
    }

    public static String getAppGameDir() {
        return GameDownloadUtils.getAppGameLuaDir();
    }

    public static boolean checkSDCardAvailableSize() {
        long curTime;
        if (sSDCardAvailable == 1 && (curTime = SystemClock.uptimeMillis()) > 0L && curTime - sLastCheckSDCardAvailableTime < 10000L) {
            return true;
        }
        sSDCardAvailable = YYFileUtils.getSDCardAvailableSize() > 0x3C00000L ? 1 : 0;
        sLastCheckSDCardAvailableTime = SystemClock.uptimeMillis();
        return sSDCardAvailable == 1;
    }

    @Deprecated
    public static String getGameFullPathOld(@NonNull BasicGameInfo info) {
        return GameDownloadUtils.getAppGameDir() + File.separator + info.gid + File.separator + GameDownloadUtils.getGamePkgName(info.gid, info.getModulerVer());
    }

    public static String getGameLocalFullPath(@NonNull BasicGameInfo info) {
        String version = TextUtils.isEmpty((CharSequence)GameVersion.INSTANCE.getVersion(info.gid)) ? info.getModulerVer() : GameVersion.INSTANCE.getVersion(info.gid);
        return GameDownloadUtils.getGameFullPath(info.gid, version);
    }

    public static String getGameWillDownloadPath(@NonNull BasicGameInfo info) {
        return GameDownloadUtils.getGameFullPath(info.gid, info.getModulerVer());
    }

    public static String getGameFullPath(String gid, String ver) {
        return GameDownloadUtils.getAppGameDir() + gid + File.separator + GameDownloadUtils.getGamePkgName(gid, ver);
    }

    public static String getSingleGameDir(@NonNull BasicGameInfo info) {
        return GameDownloadUtils.getAppGameDir() + info.getGid() + File.separator;
    }

    public static String getPreDownloadGameDir() {
        return GameDownloadUtils.getAppGameDir() + FOLDER_PRE_DOWNLOAD + File.separator;
    }

    public static String getPreDownloadGameFullPath(@NonNull BasicGameInfo info) {
        return GameDownloadUtils.getPreDownloadGameDir() + GameDownloadUtils.getSDGamePkgName(info);
    }

    public static String getSDGamePkgName(@NonNull BasicGameInfo info) {
        return GameDownloadUtils.getGamePkgName(info.getGid(), info.getModulerVer());
    }

    static String getGamePkgName(String gid, String ver) {
        return gid + "_" + ver + ".pkg";
    }

    public static String getPatchName(@NonNull BasicGameInfo info) {
        return GameVersion.INSTANCE.md5(info.getGid()) + "_" + info.getModulerMd5() + ".patch";
    }

    public static void clearOldGameFolder() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"clearOldGameFolder", (Object[])new Object[0]);
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                File innerDir = RuntimeContext.sApplicationContext.getFilesDir();
                String innerPath = innerDir.getAbsolutePath() + File.separator + GameDownloadUtils.FOLDER_GAME + File.separator + GameDownloadUtils.FOLDER_META_COCOS + File.separator;
                YYFileUtils.delete((File)new File(innerPath));
                String extPath = FileStorageUtils.getInstance().getExternalFileRootDir() + File.separator + GameDownloadUtils.FOLDER_GAME + File.separator + GameDownloadUtils.FOLDER_META_COCOS + File.separator;
                YYFileUtils.delete((File)new File(extPath));
            }
        });
    }

    public static boolean deleteGame(BasicGameInfo gameInfo) {
        if (gameInfo == null) {
            return false;
        }
        String path = GameDownloadUtils.getGameLocalFullPath(gameInfo);
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        GameVersion.INSTANCE.deleteGame(gameInfo.gid, true, true);
        return true;
    }

    public static void deleteAllGameDebug() {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        GameVersion.INSTANCE.deleteAllGame();
    }

    public static String getGameStateFilePath() {
        return GameDownloadUtils.getAppGameDir() + AccountUtil.getUid() + File.separator + GAME_FILE_NAME;
    }
}

