/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.MD5Utils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.game.R;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.IGameDownloadManager;
import com.yy.game.download.PreDownloadError;
import com.yy.game.download.PreDownloadGameControllerKt;
import com.yy.game.download.PreloadStatistics;
import com.yy.game.download.patch.PatchCallback;
import com.yy.game.download.patch.PatchConfig;
import com.yy.game.download.patch.PatchImpl;
import com.yy.game.download.patch.PatchStat;
import com.yy.game.download.stat.GameDownloadStat;
import com.yy.game.download.version.GameVersion;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.DownloadGameErrorInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.hiyo.game.service.IGameCenterService;
import downloader.DownloadClient;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class GameDownloadManager
implements IGameDownloadManager {
    private static final String TAG = "GameDL";
    private final Map<String, Long> mDownloadTimeCount = new HashMap<String, Long>(3);
    private Downloader mDownloadingTask;
    private final List<String> mPauseBusiness = new ArrayList<String>();
    private final Map<GameDownloadInfo.DownloadType, List<Downloader>> mDownloaderMap = new ConcurrentHashMap<GameDownloadInfo.DownloadType, List<Downloader>>();

    @Override
    public boolean downloadGame(@NonNull BasicGameInfo info) {
        return this.downloadGame(info, GameDownloadInfo.DownloadType.by_hand);
    }

    @Override
    public boolean downloadGame(@NonNull BasicGameInfo info, GameDownloadInfo.DownloadType type) {
        return this.downloadGame(info, type, type == GameDownloadInfo.DownloadType.silent ? 10 : 100);
    }

    @Override
    public boolean downloadGame(@NonNull BasicGameInfo info, GameDownloadInfo.DownloadType type, int priority) {
        boolean toast;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"downloadGame mDownloaders.size: %d, type: %s", (Object[])new Object[]{FP.size((Collection)this.mDownloaderMap.get(type)), type});
        }
        boolean bl = toast = type == GameDownloadInfo.DownloadType.by_hand || type == GameDownloadInfo.DownloadType.no_pause;
        if (!this.gameStatusToDownload(info, toast)) {
            return false;
        }
        if (info.downloadInfo.getState() == GameDownloadInfo.DownloadState.download_wait) {
            MLog.error((Object)TAG, (String)"downloadGame: state is wait,return", (Object[])new Object[0]);
            return false;
        }
        if (info.downloadInfo.downloadType == type && (info.downloadInfo.getState() == GameDownloadInfo.DownloadState.download_start || info.downloadInfo.getState() == GameDownloadInfo.DownloadState.downloading || info.downloadInfo.getState() == GameDownloadInfo.DownloadState.download_complete)) {
            MLog.error((Object)TAG, (String)"downloadGame is already start", (Object[])new Object[0]);
            return false;
        }
        if (info.downloadInfo.downloadType.getValue() < type.getValue()) {
            MLog.debug((Object)TAG, (String)("downloadGame upgrade downloadType to " + type.getValue()), (Object[])new Object[0]);
            info.downloadInfo.downloadType = type;
        }
        if (info.downloadInfo.downloadType.getValue() >= GameDownloadInfo.DownloadType.by_hand.getValue()) {
            if (this.hadDownloadingHandGame()) {
                if (info.downloadInfo.getState() != GameDownloadInfo.DownloadState.download_start && info.downloadInfo.getState() != GameDownloadInfo.DownloadState.downloading) {
                    info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_wait);
                }
            } else {
                this.watchGameInfo(info);
                info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_start);
            }
        }
        return this.download(type, info, priority) == 0;
    }

    public void cancelAutoDownload() {
        List<Downloader> silentList = this.mDownloaderMap.get(GameDownloadInfo.DownloadType.silent);
        if (!MLog.isLogLevelAboveDebug() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelAutoDownload silent size: %s", (Object[])new Object[]{FP.size(silentList)});
        }
        if (!FP.empty(silentList)) {
            for (Downloader downloader : silentList) {
                if (this.getDownloadingType() == GameDownloadInfo.DownloadType.silent && this.equalsDownloader(this.mDownloadingTask, downloader)) {
                    this.mDownloadingTask = null;
                }
                downloader.delete();
            }
            silentList.clear();
        }
        this.debugToast("\u53d6\u6d88\u81ea\u52a8\u6e38\u620f\u4e0b\u8f7d ");
    }

    @Override
    public void cancelDownload(BasicGameInfo info) {
        if (!MLog.isLogLevelAboveDebug() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"cancelDownload info: %s", (Object[])new Object[]{info});
        }
        if (info != null) {
            String url = info.getModulerUrl();
            if (info.patchInfo.isPatch) {
                url = this.getPatchUrl(info);
                info.patchInfo.isPatch = false;
            }
            Downloader d = DownloadClient.instance().findItem(url);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cancelDownload is downloading task: %s", (Object[])new Object[]{d != null ? d.getUrl() : ""});
            }
            this.unwatchGameInfo(info);
            GameDownloadStat.statCancel(RuntimeContext.sApplicationContext, (GameInfo)info, d != null ? d.downloadType : -1);
            DownloadClient.instance().removeTask(url);
            this.resetDownloadingTask(url);
            info.downloadInfo.downloadType = GameDownloadInfo.DownloadType.none;
            if (GameVersion.INSTANCE.isGamePkgValid(info)) {
                info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_complete);
            } else {
                info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_not);
            }
            this.debugToast("\u53d6\u6d88\u6e38\u620f\u4e0b\u8f7d " + info.getGid());
        }
    }

    @Override
    public void pauseAllDownload(String business) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"pauseAllDownload business: %s, mCanDownload: %s,mSilentDownloaders.size: %s, mDownloaders.size: %s, mDownloadingType: %s, mDownloadingTask: %s", (Object[])new Object[]{business, this.mPauseBusiness.size(), FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.silent)), FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand)), this.getDownloadingType(), this.mDownloadingTask != null ? this.mDownloadingTask.getUrl() : ""});
        }
        if (this.canPauseDownload()) {
            this.pauseAllDownloadTask();
            this.onNotifyPause();
            this.debugToast("\u6682\u505c\u6e38\u620f\u4e0b\u8f7d ");
        }
        this.mPauseBusiness.add(business);
    }

    @Override
    public void restartAllDownload(String business) {
        int originalSize = this.mPauseBusiness.size();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"restartAllDownload business: %s, mCanDownload: %s, mSilentDownloaders.size: %s, mDownloaders.size: %s, mDownloadingTask: %s", (Object[])new Object[]{business, originalSize, FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.silent)), FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand)), this.mDownloadingTask != null ? this.mDownloadingTask.getUrl() : ""});
        }
        this.mPauseBusiness.remove(business);
        if (originalSize > 0 && this.canPauseDownload()) {
            this.onNotifyRestart();
            this.restartAllDownloadTask();
            this.debugToast("[\u68c0\u67e5]\u91cd\u65b0\u5f00\u59cb\u6e38\u620f\u4e0b\u8f7d ");
        }
    }

    @Override
    public void onNetworkChanged(boolean oldValid, boolean newValid) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onNetworkChanged oldValid: %s, newValid: %s, mCanDownload: %b, mDownloadingType: %d, mSilentDownloaders.size: %s, mDownloaders.size: %s, mDownloadingTask: %s", (Object[])new Object[]{oldValid, newValid, this.mPauseBusiness.size(), this.getDownloadingType(), FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.silent)), FP.size((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand)), this.mDownloadingTask != null ? this.mDownloadingTask.getUrl() : ""});
        }
        if (!this.canPauseDownload()) {
            return;
        }
        if (oldValid == newValid) {
            return;
        }
        if (oldValid) {
            this.pauseAllDownloadTask();
        } else {
            this.restartAllDownloadTask();
        }
    }

    private boolean gameStatusToDownload(BasicGameInfo info, boolean toast) {
        if (info == null) {
            return false;
        }
        if (info instanceof GameInfo) {
            GameInfo gameInfo = (GameInfo)info;
            if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"gS: %s, gid: %s, isFixing: %b, isFull: %b", (Object[])new Object[]{gameInfo.getGname(), info.gid, gameInfo.isFixing(), gameInfo.isFull()});
            }
            if (gameInfo.isBetaTest()) {
                if (toast) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_beta_test_game), (int)1);
                }
            } else {
                if (gameInfo.isFull()) {
                    if (toast) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.tips_game_full), (int)1);
                    }
                    return false;
                }
                if (gameInfo.isFixing()) {
                    if (toast) {
                        TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.game_maintening), (int)1);
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private void pauseAllDownloadTask() {
        for (Map.Entry<GameDownloadInfo.DownloadType, List<Downloader>> entry : this.mDownloaderMap.entrySet()) {
            if (entry.getKey() == GameDownloadInfo.DownloadType.no_pause || FP.empty((Collection)entry.getValue())) continue;
            for (Downloader downloader : entry.getValue()) {
                if (downloader.downloadType == 3) continue;
                downloader.delete();
            }
        }
        if (this.mDownloadingTask != null && this.getDownloadingType() != GameDownloadInfo.DownloadType.no_pause) {
            this.mDownloadingTask.delete();
        }
    }

    private void restartAllDownloadTask() {
        YYTaskExecutor.execute(() -> {
            if (this.mDownloadingTask != null) {
                this.checkDownloadFileFinish(this.mDownloadingTask);
            }
            for (Map.Entry<GameDownloadInfo.DownloadType, List<Downloader>> entry : this.mDownloaderMap.entrySet()) {
                if (entry.getKey().getValue() < GameDownloadInfo.DownloadType.by_hand.getValue()) continue;
                for (Downloader downloader : entry.getValue()) {
                    if (this.mDownloadingTask == downloader) continue;
                    this.checkDownloadFileFinish(downloader);
                }
            }
        });
    }

    private boolean hadDownloadingHandGame() {
        return !FP.empty((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand)) || !FP.empty((Collection)this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand));
    }

    private void checkDownloadFileFinish(Downloader downloader) {
        if (downloader == null) {
            return;
        }
        if (downloader.mIsComplete) {
            IDownloadCallback callback2;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkDownloadFileFinish had download finish %s", (Object[])new Object[]{downloader});
            }
            if ((callback2 = downloader.getCallback()) != null) {
                callback2.onComplete(downloader);
            } else {
                this.resetDownloadingTask(downloader);
            }
        } else {
            downloader.start();
        }
    }

    @Override
    public boolean isGameValid(BasicGameInfo info) {
        return this.checkGameValid(info) == 0;
    }

    private int checkGameValid(BasicGameInfo info) {
        MLog.debug((Object)TAG, (String)"checkGameValid, info: %s", (Object[])new Object[]{info});
        if (GameVersion.INSTANCE.isGameInfoValid(info)) {
            if (RuntimeContext.isInGray()) {
                MLog.debug((Object)TAG, (String)"game file is valid, don't need to download again, info: %s", (Object[])new Object[]{info});
            }
            info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_finish);
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)info.getModulerUrl())) {
            if (!MLog.isLogLevelAboveDebug() && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkGameValid download url is empty, game info: %s", (Object[])new Object[]{info});
            }
            this.onError(info, 100, "download game url is empty");
            return 100;
        }
        if (!GameDownloadUtils.checkSDCardAvailableSize()) {
            this.onError(info, 101, "sdcard available size is not enough");
            return 101;
        }
        return 1;
    }

    private int checkGamePkgValid(BasicGameInfo info) {
        MLog.debug((Object)TAG, (String)"checkGameValid, info: %s", (Object[])new Object[]{info});
        if (GameVersion.INSTANCE.isGamePkgValid(info)) {
            if (RuntimeContext.isInGray()) {
                MLog.debug((Object)TAG, (String)"game file is valid, don't need to download again, info: %s", (Object[])new Object[]{info});
            }
            info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_finish);
            return 0;
        }
        if (TextUtils.isEmpty((CharSequence)info.getModulerUrl())) {
            if (!MLog.isLogLevelAboveDebug() && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkGameValid download url is empty, game info: %s", (Object[])new Object[]{info});
            }
            this.onError(info, 100, "download game url is empty");
            return 100;
        }
        if (!GameDownloadUtils.checkSDCardAvailableSize()) {
            this.onError(info, 101, "sdcard available size is not enough");
            return 101;
        }
        return 1;
    }

    private int download(GameDownloadInfo.DownloadType type, @NonNull BasicGameInfo info, int priority) {
        int valid = this.checkGamePkgValid(info);
        MLog.debug((Object)TAG, (String)"download type: %s, valid: %d, gid: %s, priority: %d", (Object[])new Object[]{type, valid, info.getGid(), priority});
        boolean isDebugGame = RemoteGameDebugService.Companion.useRemoteIp(info.getGid());
        MLog.debug((Object)TAG, (String)"isDebugGame %s , info: %s", (Object[])new Object[]{isDebugGame, info});
        if (isDebugGame) {
            valid = 1;
        }
        if (valid == 0) {
            return 0;
        }
        if (valid == 100 || valid == 101) {
            return 1;
        }
        if (!this.replaceSameTaskInstance(info, type)) {
            if (this.downloadGameAsync(type, info, priority)) {
                return 2;
            }
            return 1;
        }
        return 2;
    }

    private boolean replaceSameTaskInstance(@NonNull BasicGameInfo info, GameDownloadInfo.DownloadType type) {
        Downloader d = DownloadClient.instance().findItem(info.getModulerUrl());
        if (d != null && d.getCallback() instanceof GameDownloadCallback) {
            if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"replaceSameTaskInstance the same download task url had in queue, url: %s", (Object[])new Object[]{info.getModulerUrl()});
            }
            GameDownloadCallback cb = (GameDownloadCallback)d.getCallback();
            if (cb.type.getValue() < GameDownloadInfo.DownloadType.by_hand.getValue() && type.getValue() >= GameDownloadInfo.DownloadType.by_hand.getValue()) {
                if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"replaceSameTaskInstance same url but different type to download, gid: %s", (Object[])new Object[]{info.getGid()});
                }
                return false;
            }
            if (cb.gameInfo != info) {
                if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"replaceSameTaskInstance same url but different instance, gid: %s, old: %s, new: %s", (Object[])new Object[]{info.getGid(), cb.gameInfo.hashCode(), info.hashCode()});
                }
                if (this.mDownloadingTask == d) {
                    this.unwatchGameInfo(cb.gameInfo);
                    this.watchGameInfo(info);
                }
                cb.gameInfo = info;
                return true;
            }
        }
        return false;
    }

    private void onSucceed(final @NonNull BasicGameInfo info) {
        boolean shouldUpdateVersion;
        long currentVersion = StringUtils.safeParseInt((String)info.getModulerVer());
        long saveVersion = StringUtils.safeParseInt((String)GameVersion.INSTANCE.getVersion(info.gid));
        boolean isSaveGrayGame = GameVersion.INSTANCE.isGrayGame(info.getGid());
        boolean bl = shouldUpdateVersion = isSaveGrayGame || saveVersion < currentVersion;
        if (shouldUpdateVersion) {
            GameVersion.INSTANCE.addGame(info);
        }
        if (YYTaskExecutor.isMainThread()) {
            this.onNotifySucceed(info);
            if (shouldUpdateVersion) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        YYFileUtils.removeDirFiles((String)GameDownloadUtils.getSingleGameDir(info), (String[])new String[]{GameDownloadUtils.getGameLocalFullPath(info)});
                    }
                });
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameDownloadManager.this.onNotifySucceed(info);
                }
            });
            if (shouldUpdateVersion) {
                YYFileUtils.removeDirFiles((String)GameDownloadUtils.getSingleGameDir(info), (String[])new String[]{GameDownloadUtils.getGameLocalFullPath(info)});
            }
        }
    }

    @UiThread
    private void onNotifySucceed(@NonNull BasicGameInfo info) {
        info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_finish);
        this.unwatchGameInfo(info);
        Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_FINISH);
        info.waitDownloadGames = this.getNotSilentListSize();
        notification.extObj = info;
        NotificationCenter.getGlobalInstance().notify(notification);
        GameReportV1.Companion.reportGameDownload(info.gid, info.patchInfo.isPatch ? "2" : "1", 0L, "0");
    }

    private void onError(final @NonNull BasicGameInfo info, final int errorCode, final String errorInfo) {
        if (errorCode == 3 || errorCode == -2 || errorCode == -4 || errorCode == -3) {
            return;
        }
        if (errorCode == 4) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    FileUtils.delete((String)GameDownloadUtils.getSingleGameDir(info));
                }
            });
        }
        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GameDownloadManager.this.onNotifyError(info, errorCode, errorInfo);
            }
        });
    }

    @UiThread
    private void onNotifyError(@NonNull BasicGameInfo info, int errorCode, String errorInfo) {
        info.downloadInfo.downloadErrCode = errorCode;
        info.downloadInfo.downloadErrInfo = errorInfo;
        info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_fail);
        this.unwatchGameInfo(info);
        Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_ERROR);
        DownloadGameErrorInfo error = new DownloadGameErrorInfo();
        error.gameInfo = info;
        error.code = errorCode;
        error.msg = errorInfo;
        notification.extObj = error;
        NotificationCenter.getGlobalInstance().notify(notification);
        GameReportV1.Companion.reportGameDownload(info.gid, info.patchInfo.isPatch ? "2" : "1", 0L, String.valueOf(error.code));
    }

    private void onNotifyStart(@NonNull BasicGameInfo info) {
        Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_START);
        notification.extObj = info;
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private void onNotifyPause() {
        Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_PAUSE);
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private void onNotifyRestart() {
        Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_RESTART_ALL);
        notification.extObj = this.getNotSilentListSize();
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private void onProgress(@NonNull BasicGameInfo info, long total, long cur) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onProgress gid: %s, info hashCode: %s", (Object[])new Object[]{info.getGid(), info.hashCode()});
        }
        if (info.downloadInfo.getState() != GameDownloadInfo.DownloadState.downloading) {
            info.downloadInfo.setState(GameDownloadInfo.DownloadState.downloading);
        }
        if (info.downloadInfo.getTotalBytes() != total) {
            info.downloadInfo.setTotalBytes(total);
        }
        info.downloadInfo.setProgress(cur);
    }

    private String getNewDownloadUrl(BasicGameInfo info) {
        String url = info.getModulerUrl();
        if (EnvSettings.instance().getGameDownloadUriSettingValue() == EnvSettingType.Dev) {
            String returnVal = "";
            try {
                URI uri = new URI(url);
                returnVal = uri.getHost();
                url = url.replace(returnVal, "test-xhcomponent.oss-cn-shenzhen.aliyuncs.com");
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        } else if (EnvSettings.instance().getGameDownloadUriSettingValue() == EnvSettingType.Test) {
            String returnVal = "";
            try {
                URI uri = new URI(url);
                returnVal = uri.getHost();
                url = url.replace(returnVal, "kaixindou.kaixindou.net");
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return url;
    }

    private synchronized boolean downloadGameAsync(final GameDownloadInfo.DownloadType type, @NonNull BasicGameInfo info, int priority) {
        String fileName;
        String url;
        if (info.patchInfo.isPatch && info.patchInfo.patching && type == GameDownloadInfo.DownloadType.silent) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTPatch", (String)"patching gid: %s", (Object[])new Object[]{info.getGid()});
            }
            return false;
        }
        if (PreDownloadGameControllerKt.isPreDownloadActive() && this.isAlreadyPreDownloadCompleteFile(info)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("already pre downloaded complete file. isPreDownload :" + info.downloadInfo.isPreDownload), (Object[])new Object[0]);
            }
            if (info.downloadInfo.isPreDownload) {
                return true;
            }
            if (this.handleExistPkg(info, type, priority)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"handleExistPkg success.", (Object[])new Object[0]);
                }
                return true;
            }
        }
        boolean isAlreadyDownload = GameVersion.INSTANCE.isAlreadyDownload(info.gid);
        String version = GameVersion.INSTANCE.getVersion(info.gid);
        String md5 = GameVersion.INSTANCE.md5(info.gid);
        boolean isGrayGame = GameVersion.INSTANCE.isGrayGame(info.gid);
        boolean bl = info.patchInfo.isPatch = !isGrayGame && isAlreadyDownload && !info.patchInfo.patchError;
        if (RuntimeContext.isInGray() && FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTPatch", (String)("isAlreadyDownload = " + isAlreadyDownload + "info.isPatch = " + info.patchInfo.isPatch + "  info.gid = " + info.getGid() + " version = " + version + " md5 = " + md5 + " grayGame = " + isGrayGame), (Object[])new Object[0]);
        }
        if (!StringUtils.isEmpty((String)(url = info.getModulerUrl())) && url.endsWith(".zip") && info instanceof GameInfo && !((GameInfo)info).isWebGame()) {
            MLog.info((Object)TAG, (String)"can not download the zip package!!has update to lua,use the pkg package,gameinfo:%s", (Object[])new Object[]{info});
            this.onError(info, 102, "url is zip package");
            return false;
        }
        String newUrl = RemoteGameDebugService.Companion.replaceDownloadUrl(url, info.getGid());
        boolean useRemoteIp = false;
        if (StringUtils.isEmpty((String)newUrl)) {
            url = this.getNewDownloadUrl(info);
        } else {
            url = newUrl;
            useRemoteIp = true;
        }
        if (RuntimeContext.isInGray()) {
            MLog.debug((Object)TAG, (String)"type: %s, priority: %s, downloadUrl: %s!", (Object[])new Object[]{type, priority, url});
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            MLog.error((Object)TAG, (String)"downloadUrl: %s is empty, game info : %s", (Object[])new Object[]{url, info});
            return false;
        }
        if (info.patchInfo.isPatch) {
            String patchUrl = this.getPatchUrl(info);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTPatch", (String)("patchUrl = " + patchUrl), (Object[])new Object[0]);
            }
            info.patchInfo.patching = true;
            if (StringUtils.isEmpty((String)patchUrl)) {
                info.patchInfo.isPatch = false;
                info.patchInfo.patching = false;
            } else {
                url = patchUrl;
            }
        } else {
            info.patchInfo.patchError = false;
        }
        String fileParentPath = info.downloadInfo.isPreDownload ? GameDownloadUtils.getPreDownloadGameDir() : GameDownloadUtils.getSingleGameDir(info);
        String string2 = fileName = info.patchInfo.isPatch ? GameDownloadUtils.getPatchName(info) : GameDownloadUtils.getSDGamePkgName(info);
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"submit dowanloder url:%s,fileParentPath:%s,fileName:%s,type:%d", (Object[])new Object[]{url, fileParentPath, fileName, type.getValue()});
            if (info.patchInfo.isPatch) {
                FeatureLog.d((String)"FTPatch", (String)("fileName = " + fileName), (Object[])new Object[0]);
            }
        }
        Downloader.Builder builder = new Downloader.Builder(url, fileParentPath, fileName);
        builder.setPriority(priority);
        builder.setSupportContinueTransfer(true);
        builder.setTaskGroup(DownloadBussinessGroup.GAME_PACKAGE);
        if (info instanceof GameInfo) {
            GameInfo gameInfo = (GameInfo)info;
            builder.setTaskSubGroup(String.valueOf(gameInfo.getGameMode()));
        }
        if (!info.patchInfo.isPatch && !useRemoteIp) {
            if (RuntimeContext.sIsDebuggable) {
                FeatureLog.d((String)"FTPatch", (String)("check md5  url = " + info.getModulerUrl() + "  md5 = " + info.getModulerMd5()), (Object[])new Object[0]);
            }
            builder.setFileEtagCheckContent("md5", info.getModulerMd5());
        } else if (!info.patchInfo.isPatch && useRemoteIp && RuntimeContext.sIsDebuggable) {
            FeatureLog.d((String)"FTPatch", (String)("not check md5  url = " + info.getModulerUrl() + "  md5 = " + info.getModulerMd5()), (Object[])new Object[0]);
        }
        builder.setCallBack((IDownloadCallback)new GameDownloadCallback(info, type, priority));
        if (info.patchInfo.isPatch) {
            builder.setMaxRetryTimes(1);
            builder.setTaskGroup(DownloadBussinessGroup.GAME_PACKAGE_PATCH);
        }
        builder.setDownloadType(type.getValue());
        if (type == GameDownloadInfo.DownloadType.silent) {
            builder.setTaskSpeedLimitPerMicsecondValue(this.getSpeedLimitPerMicsecondValue());
            builder.setProgressInterval(-1L);
        } else {
            builder.setTaskSpeedLimitPerMicsecondValue(-1L);
            builder.setProgressInterval(50L);
        }
        final Downloader downloader = builder.build();
        downloader.downloadType = type.getValue();
        downloader.mIsPatch = info.patchInfo.isPatch;
        this.addDownloader(type, downloader);
        if (this.canDownload(type)) {
            downloader.start();
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"mDownloadingType: %s, type: %s, mDownloadingTask: %s, downloader: %s", (Object[])new Object[]{this.getDownloadingType(), type, this.mDownloadingTask, downloader});
            }
            if (this.isDifSilentDownloader(type, downloader)) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (GameDownloadManager.this.isDifSilentDownloader(type, downloader)) {
                            Downloader d = GameDownloadManager.this.mDownloadingTask;
                            if (!MLog.isLogLevelAboveDebug()) {
                                MLog.debug((Object)GameDownloadManager.TAG, (String)"delete d: %s", (Object[])new Object[]{d});
                            }
                            if (d != null) {
                                d.delete();
                            }
                        }
                    }
                }, (long)100L);
            }
        }
        return true;
    }

    private boolean isAlreadyPreDownloadCompleteFile(BasicGameInfo info) {
        return YYFileUtils.isFileExisted((String)this.getPreDownloadedPkgPath(info));
    }

    private String getPreDownloadedPkgPath(BasicGameInfo info) {
        return GameDownloadUtils.getPreDownloadGameDir() + GameDownloadUtils.getSDGamePkgName(info);
    }

    private boolean handleExistPkg(BasicGameInfo info, GameDownloadInfo.DownloadType type, int priority) {
        File existFile = new File(this.getPreDownloadedPkgPath(info));
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("handleExistPkg() -> existFile:" + existFile.getAbsolutePath()), (Object[])new Object[0]);
        }
        YYTaskExecutor.execute(() -> {
            block8: {
                String md51 = MD5Utils.fileMd5((File)existFile);
                if (StringUtils.endsWithIgnoreCase((String)info.getModulerMd5(), (String)md51)) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"handleExistPkg() -> md5 equals.", (Object[])new Object[0]);
                    }
                    try {
                        boolean moveSuccess;
                        File file = new File(GameDownloadUtils.getSingleGameDir(info) + GameDownloadUtils.getSDGamePkgName(info));
                        if (!file.exists()) {
                            YYFileUtils.createDir((String)GameDownloadUtils.getSingleGameDir(info), (boolean)false);
                            file.createNewFile();
                        }
                        if (moveSuccess = existFile.renameTo(file)) {
                            YYTaskExecutor.postToMainThread(() -> {
                                info.downloadInfo.setState(GameDownloadInfo.DownloadState.download_complete);
                                this.onSucceed(info);
                            });
                            PreloadStatistics.INSTANCE.reportHitPreloadCache(info.gid, info.getModulerVer(), 0L);
                            break block8;
                        }
                        this.reDownload(info, existFile, type, priority, PreDownloadError.MOVE_FILE_ERROR.getCode());
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (String)("handleExistPkg() -> copyFile failed," + e), (Object[])new Object[0]);
                        this.reDownload(info, existFile, type, priority, PreDownloadError.MOVE_FILE_ERROR.getCode());
                    }
                } else {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"handleExistPkg() -> md5 not equals.", (Object[])new Object[0]);
                    }
                    this.reDownload(info, existFile, type, priority, PreDownloadError.MD5_NOT_EQUALS.getCode());
                }
            }
        });
        return true;
    }

    private void reDownload(BasicGameInfo info, File existFile, GameDownloadInfo.DownloadType type, int priority, int errorCode) {
        YYFileUtils.delete((File)existFile);
        YYTaskExecutor.postToMainThread(() -> this.downloadGameAsync(type, info, priority));
        PreloadStatistics.INSTANCE.reportHitPreloadCache(info.gid, info.getModulerVer(), errorCode);
    }

    @NonNull
    private String getPatchUrl(@NonNull BasicGameInfo info) {
        return PatchConfig.getPatchUrl(info.getGid(), GameVersion.INSTANCE.md5(info.getGid()), info.getModulerMd5());
    }

    @Override
    public void deleteDownloadAndRest(BasicGameInfo gameInfo) {
        if (gameInfo != null) {
            if (this.mDownloaderMap.isEmpty()) {
                return;
            }
            String url = gameInfo.getModulerUrl();
            Downloader downloader = null;
            List<Downloader> matchDownloders = null;
            for (List<Downloader> list : this.mDownloaderMap.values()) {
                for (Downloader d : list) {
                    if (d == null || !StringUtils.equal((String)d.getUrl(), (String)url)) continue;
                    downloader = d;
                    matchDownloders = list;
                    break;
                }
                if (downloader == null || matchDownloders == null) continue;
                matchDownloders.remove(downloader);
                GameDownloadInfo downloadInfo = gameInfo.downloadInfo;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"deleteDownloadAndRest ,match!!!,state:%s", (Object[])new Object[]{downloadInfo.getState()});
                }
                if (downloadInfo == null) break;
                downloadInfo.setState(GameDownloadInfo.DownloadState.download_not);
                downloadInfo.setProgress(0L);
                downloadInfo.setTotalBytes(0L);
                break;
            }
        }
    }

    @Override
    public int getDownloadingGameCount() {
        return this.getNotSilentListSize();
    }

    @Override
    public boolean isExistGamePackage(String gid) {
        return GameVersion.INSTANCE.isAlreadyDownload(gid);
    }

    private int getNotSilentListSize() {
        CopyOnWriteArrayList byHandList = this.mDownloaderMap.get(GameDownloadInfo.DownloadType.by_hand);
        CopyOnWriteArrayList noPauseList = this.mDownloaderMap.get(GameDownloadInfo.DownloadType.no_pause);
        byHandList = byHandList != null ? new CopyOnWriteArrayList(byHandList) : null;
        noPauseList = noPauseList != null ? new CopyOnWriteArrayList(noPauseList) : null;
        return (byHandList != null ? byHandList.size() : 0) + (noPauseList != null ? noPauseList.size() : 0);
    }

    private void diffPatchFile(String fileParentPath, String fileName, BasicGameInfo gameInfo, final GameDownloadInfo.DownloadType type, final int priority) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTPatch", (String)"downloader.mIsPatch = true", (Object[])new Object[0]);
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTPatch", (String)("gameInfo.getModulerUrl() = " + gameInfo.getModulerUrl()), (Object[])new Object[0]);
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTPatch", (String)("gameInfo.getModulerMd5() = " + gameInfo.getModulerMd5()), (Object[])new Object[0]);
        }
        final String patchPath = fileParentPath + fileName;
        final String oldFilePath = GameDownloadUtils.getSingleGameDir(gameInfo) + GameDownloadUtils.getGamePkgName(gameInfo.getGid(), GameVersion.INSTANCE.getVersion(gameInfo.getGid()));
        PatchStat.patchDownloadCompleteStat(gameInfo.getGid());
        new PatchImpl().patch(oldFilePath, gameInfo, patchPath, new PatchCallback(){

            @Override
            public void onSucess(BasicGameInfo gameInfo) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.getGid() + " patch onSucess"), (Object[])new Object[0]);
                }
                PatchStat.patchSuccessStat(gameInfo.getGid());
                YYFileUtils.delete((File)new File(patchPath));
                gameInfo.patchInfo.patching = false;
                if (!gameInfo.downloadInfo.isPreDownload) {
                    YYFileUtils.delete((File)new File(oldFilePath));
                    GameDownloadManager.this.onSucceed(gameInfo);
                }
            }

            @Override
            public void onError(BasicGameInfo gameInfo, String errorMsg) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTPatch", (String)("gameid = " + gameInfo.getGid() + " patch onError"), (Object[])new Object[0]);
                }
                PatchStat.patchErrorStat(gameInfo.getGid(), errorMsg);
                YYFileUtils.delete((File)new File(patchPath));
                gameInfo.patchInfo.isPatch = false;
                gameInfo.patchInfo.patchError = true;
                GameDownloadManager.this.downloadGameAsync(type, gameInfo, priority);
            }
        });
    }

    private boolean canDownload(GameDownloadInfo.DownloadType type) {
        return this.canPauseDownload() || type == GameDownloadInfo.DownloadType.no_pause;
    }

    private boolean canDownload(BasicGameInfo gameInfo) {
        boolean isGamePlaying = false;
        try {
            if (ServiceManagerProxy.getServiceManager() != null && ((IGameCenterService)ServiceManagerProxy.getServiceManager().getService(IGameCenterService.class)).isPlaying(gameInfo)) {
                isGamePlaying = true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return !isGamePlaying;
    }

    private boolean canPauseDownload() {
        return this.mPauseBusiness.isEmpty();
    }

    private boolean isDifSilentDownloader(GameDownloadInfo.DownloadType type, Downloader downloader) {
        return this.mDownloadingTask != null && this.getDownloadingType() == GameDownloadInfo.DownloadType.silent && type.getValue() >= GameDownloadInfo.DownloadType.by_hand.getValue() && !this.equalsDownloader(this.mDownloadingTask, downloader);
    }

    private void addDownloader(GameDownloadInfo.DownloadType type, Downloader downloader) {
        List<Downloader> list;
        if (downloader == null) {
            return;
        }
        Downloader old = this.findDownloader(downloader);
        if (old != null) {
            this.removeDownloader(old);
        }
        if ((list = this.mDownloaderMap.get(type)) == null) {
            list = new CopyOnWriteArrayList<Downloader>();
            this.mDownloaderMap.put(type, list);
        }
        list.add(downloader);
    }

    private void removeDownloader(Downloader downloader) {
        if (downloader == null) {
            return;
        }
        String url = downloader.getUrl();
        this.removeDownloader(url);
    }

    private void removeDownloader(String url) {
        for (List<Downloader> list : this.mDownloaderMap.values()) {
            ArrayList<Downloader> rm = new ArrayList<Downloader>();
            for (Downloader d : list) {
                if (d == null || !StringUtils.equal((String)d.getUrl(), (String)url)) continue;
                rm.add(d);
            }
            list.removeAll(rm);
        }
    }

    private void setDownloadingTask(Downloader downloader) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"setDownloadingTask downloader: %s", (Object[])new Object[]{downloader != null ? downloader.getUrl() : ""});
        }
        this.mDownloadingTask = downloader;
    }

    private void resetDownloadingTask(Downloader downloader) {
        if (this.mDownloadingTask != null && this.equalsDownloader(this.mDownloadingTask, downloader)) {
            this.mDownloadingTask = null;
        }
        this.removeDownloader(downloader);
    }

    private void resetDownloadingTask(String url) {
        if (this.mDownloadingTask != null && StringUtils.equal((String)url, (String)this.mDownloadingTask.getUrl())) {
            this.mDownloadingTask = null;
        }
        this.removeDownloader(url);
    }

    private boolean equalsDownloader(Downloader d1, Downloader d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 != null && d2 != null) {
            String url1 = d1.getUrl();
            String url2 = d2.getUrl();
            return StringUtils.equal((String)url1, (String)url2);
        }
        return false;
    }

    @Nullable
    private Downloader findDownloader(Downloader downloader) {
        if (this.mDownloaderMap.isEmpty() || downloader == null) {
            return null;
        }
        String url = downloader.getUrl();
        for (List<Downloader> list : this.mDownloaderMap.values()) {
            for (Downloader d : list) {
                if (d == null || !StringUtils.equal((String)d.getUrl(), (String)url)) continue;
                return d;
            }
        }
        return null;
    }

    private void watchGameInfo(BasicGameInfo info) {
        if (info.downloadInfo.downloadType.getValue() >= GameDownloadInfo.DownloadType.by_hand.getValue()) {
            BasicGameInfo downloadInfo;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"watchGameInfo gid: %s", (Object[])new Object[]{info.getGid()});
            }
            if ((downloadInfo = this.getDownloadingInfo()) != info && downloadInfo != null) {
                Kvo.autoUnbindingFrom((KvoSource)downloadInfo.downloadInfo, (Object)this);
            }
            this.setDownloadingInfo(info);
            Kvo.autoBindingTo((KvoSource)info.downloadInfo, (Object)this);
        }
    }

    private void unwatchGameInfo(BasicGameInfo info) {
        BasicGameInfo downloadInfo = this.getDownloadingInfo();
        if (downloadInfo != null && info == downloadInfo) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"unwatchGameInfo gid: %s", (Object[])new Object[]{downloadInfo.getGid()});
            }
            Kvo.autoUnbindingFrom((KvoSource)downloadInfo.downloadInfo, (Object)this);
        }
    }

    @KvoMethodAnnotation(name="state", sourceClass=GameDownloadInfo.class)
    public void onState(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        GameDownloadInfo info = (GameDownloadInfo)event.source();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"onState gid: %s,  state: %s, type: %s", (Object[])new Object[]{info.gameId, info.getState(), info.downloadType});
        }
        BasicGameInfo downloadInfo = this.getDownloadingInfo();
        if ((event.oldValue() == GameDownloadInfo.DownloadState.downloading || event.oldValue() == GameDownloadInfo.DownloadState.download_start) && event.newValue() == GameDownloadInfo.DownloadState.download_pause) {
            this.cancelDownload(downloadInfo);
        }
    }

    private long getSpeedLimitPerMicsecondValue() {
        if (RuntimeContext.sIsDebuggable) {
            return 102L;
        }
        int value = SettingFlags.getIntValue((String)"slientdownloadlimit", (int)100);
        if (value > 20 && value < 1000) {
            return value * 1024 / 1000;
        }
        return -1L;
    }

    private void setDownloadingInfo(BasicGameInfo info) {
        BasicGameInfo downloadInfo;
        if (this.mDownloadingTask != null && this.mDownloadingTask.getCallback() instanceof GameDownloadCallback && (downloadInfo = ((GameDownloadCallback)this.mDownloadingTask.getCallback()).gameInfo) != info && StringUtils.equal((String)downloadInfo.gid, (String)info.gid)) {
            ((GameDownloadCallback)this.mDownloadingTask.getCallback()).gameInfo = info;
        }
    }

    private BasicGameInfo getDownloadingInfo() {
        if (this.mDownloadingTask != null && this.mDownloadingTask.getCallback() instanceof GameDownloadCallback) {
            return ((GameDownloadCallback)this.mDownloadingTask.getCallback()).gameInfo;
        }
        return null;
    }

    private GameDownloadInfo.DownloadType getDownloadingType() {
        if (this.mDownloadingTask != null && this.mDownloadingTask.getCallback() instanceof GameDownloadCallback) {
            return ((GameDownloadCallback)this.mDownloadingTask.getCallback()).type;
        }
        return null;
    }

    private void debugToast(String msg) {
        if (RuntimeContext.sIsDebuggable) {
            // empty if block
        }
    }

    public static interface IAutoDownloadCheckCallBack {
        public void onStart();

        public void onCancel();
    }

    private class GameDownloadCallback
    implements IDownloadCallback {
        BasicGameInfo gameInfo;
        GameDownloadInfo.DownloadType type;
        String fileParentPath;
        String fileName;
        String fullPath;
        int priority;

        GameDownloadCallback(BasicGameInfo info, GameDownloadInfo.DownloadType type, int priority) {
            this.gameInfo = info;
            this.type = type;
            this.priority = priority;
            this.fullPath = GameDownloadUtils.getGameWillDownloadPath(info);
            this.fileParentPath = GameDownloadUtils.getSingleGameDir(info);
            this.fileName = info.patchInfo.isPatch ? GameDownloadUtils.getPatchName(info) : GameDownloadUtils.getSDGamePkgName(info);
        }

        public void onComplete(Downloader downloader) {
            Long startDownload;
            downloader.mIsComplete = true;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDownloadManager.TAG, (String)"onComplete downloader: %s,  fullPath: %s, url: %s", (Object[])new Object[]{downloader, this.fullPath, this.gameInfo.getModulerUrl()});
            }
            GameDownloadManager.this.resetDownloadingTask(downloader);
            this.gameInfo.downloadInfo.setState(GameDownloadInfo.DownloadState.download_complete);
            if (downloader.mIsPatch) {
                GameDownloadManager.this.diffPatchFile(this.fileParentPath, this.fileName, this.gameInfo, this.type, this.priority);
            } else if (!this.gameInfo.downloadInfo.isPreDownload) {
                GameDownloadManager.this.onSucceed(this.gameInfo);
            }
            if (this.gameInfo.downloadInfo.isPreDownload) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameDownloadManager.TAG, (String)("preDownload success.file path:" + this.fileName), (Object[])new Object[0]);
                }
                PreloadStatistics.INSTANCE.reportPreloadComplete(this.gameInfo.gid, this.gameInfo.getModulerVer(), 0L);
            }
            if ((startDownload = (Long)GameDownloadManager.this.mDownloadTimeCount.remove(this.gameInfo.getGid())) != null) {
                long dif = Math.abs(System.currentTimeMillis() - startDownload);
                GameDownloadStat.statDownloadComplete(this.gameInfo.getGid(), this.type, dif, this.gameInfo.downloadInfo.isPreDownload);
            }
        }

        public void onError(Downloader downloader, int errorType, String errorInfo) {
            boolean noSpaceError = false;
            if (errorInfo != null && errorInfo.contains("write failed: ENOSPC")) {
                noSpaceError = true;
            }
            if (errorType == 3 || errorType == -2 || errorType == -4 || errorType == -3) {
                GameDownloadManager.this.replaceSameTaskInstance(this.gameInfo, this.type);
                if (GameDownloadManager.this.equalsDownloader(GameDownloadManager.this.mDownloadingTask, downloader)) {
                    GameDownloadManager.this.watchGameInfo(this.gameInfo);
                }
                if (noSpaceError) {
                    GameDownloadManager.this.cancelAutoDownload();
                }
                return;
            }
            GameDownloadManager.this.resetDownloadingTask(downloader);
            MLog.error((Object)GameDownloadManager.TAG, (String)"onError downloader: %s, fullPath: %s, url: %s, errorType: %s, errorInfo: %s", (Object[])new Object[]{downloader, this.fullPath, this.gameInfo.getModulerUrl(), errorType, errorInfo});
            boolean isPatch = this.gameInfo.patchInfo.isPatch;
            this.gameInfo.patchInfo.isPatch = false;
            this.gameInfo.patchInfo.patchError = true;
            if (this.gameInfo.downloadInfo.isPreDownload) {
                PreloadStatistics.INSTANCE.reportPreloadComplete(this.gameInfo.gid, this.gameInfo.getModulerVer(), errorType);
            }
            if (isPatch) {
                if (FeatureLog.isLogLevelBlowInfo()) {
                    FeatureLog.i((String)"FTPatch", (String)("gameid = " + this.gameInfo.getGid() + " patch download onError url = " + downloader.getUrl()), (Object[])new Object[0]);
                }
                GameDownloadManager.this.downloadGameAsync(this.type, this.gameInfo, this.priority);
            } else {
                Long startDownload = (Long)GameDownloadManager.this.mDownloadTimeCount.remove(this.gameInfo.getGid());
                if (startDownload != null) {
                    long dif = Math.abs(System.currentTimeMillis() - startDownload);
                    GameDownloadStat.statDownloadError(this.gameInfo.getGid(), this.type, dif, this.gameInfo.downloadInfo.isPreDownload);
                }
                GameDownloadManager.this.onError(this.gameInfo, errorType, errorInfo);
            }
            if (noSpaceError) {
                GameDownloadManager.this.cancelAutoDownload();
            }
        }

        public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)GameDownloadManager.TAG, (String)"onProgressChange %s, totalSize: %s, curSize: %s", (Object[])new Object[]{downloader.getUrl(), totalSize, curSize});
            }
            GameDownloadManager.this.onProgress(this.gameInfo, totalSize, curSize);
        }

        public void onStart(Downloader downloader) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDownloadManager.TAG, (String)"onStart downloader: %s, mCanDownload: %b, type: %s, fullPath: %s, url: %s", (Object[])new Object[]{downloader, GameDownloadManager.this.mPauseBusiness.isEmpty(), this.type, this.fullPath, this.gameInfo.getModulerUrl()});
            }
            GameDownloadManager.this.onNotifyStart(this.gameInfo);
            GameDownloadManager.this.setDownloadingTask(downloader);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDownloadManager.TAG, (String)" after setDownloadingTask mDownloadingType: %s, mDownloadingTask: %s", (Object[])new Object[]{GameDownloadManager.this.getDownloadingType(), GameDownloadManager.this.mDownloadingTask});
            }
            if (!GameDownloadManager.this.canDownload(this.type)) {
                downloader.delete();
                return;
            }
            GameDownloadStat.statDownloadStart(this.gameInfo.gid, this.type, this.gameInfo.downloadInfo.isPreDownload);
            GameDownloadManager.this.mDownloadTimeCount.put(this.gameInfo.getGid(), System.currentTimeMillis());
            if (this.gameInfo.downloadInfo.getState() != GameDownloadInfo.DownloadState.downloading) {
                this.gameInfo.downloadInfo.setState(GameDownloadInfo.DownloadState.download_start);
            }
            GameDownloadManager.this.watchGameInfo(this.gameInfo);
        }
    }
}

