/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download;

import com.yy.base.logger.MLog;
import com.yy.game.download.stat.DownloadMetric;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;

public class DownloadTaskTag {
    private static final String TAG = "DownloadTaskTag";
    private static final int MAX_RETRY_TIMES = 2;
    public int mMaxRetryTimes = 2;
    public String mUrl;
    public boolean mIsPatch = false;
    public BasicGameInfo mBasicGameInfo;
    public GameDownloadInfo.DownloadType mType;
    public int mPriority = 0;
    public int mCurRetryTimes = 0;
    public boolean mPassIfAlreadyCompleted = true;
    public long mStartTime = -1L;
    public long mCreateTaskTime = -1L;
    public boolean mIsMd5Error = false;
    public DownloadMetric mDownloadMetric = new DownloadMetric();

    public long calcCurUseTime() {
        return System.currentTimeMillis() - this.mStartTime;
    }

    public long calcCurTustTime() {
        return System.currentTimeMillis() - this.mCreateTaskTime;
    }

    public void notifyCreateTaskTime() {
        if (this.mCreateTaskTime == -1L) {
            this.mCreateTaskTime = System.currentTimeMillis();
        }
    }

    public void notifyStartTime() {
        if (this.mStartTime == -1L) {
            this.mStartTime = System.currentTimeMillis();
        }
    }

    public void resetStartTime() {
        this.mStartTime = -1L;
    }

    public void updateSuccessValue(String url, long useTime, long tust, long fileSize, String netlib, String realHost) {
        this.mUrl = url;
        this.mDownloadMetric.result = 1;
        this.mDownloadMetric.useTime = useTime;
        this.mDownloadMetric.tust = tust;
        this.mDownloadMetric.retryTimes = this.mCurRetryTimes;
        this.mDownloadMetric.fileSize = fileSize;
        this.mDownloadMetric.httpCode = 200;
        this.mDownloadMetric.netLib = netlib;
        this.mDownloadMetric.realHost = realHost;
        MLog.debug((Object)TAG, (String)("download complete " + this.mDownloadMetric.toString()), (Object[])new Object[0]);
    }

    public void updateFailValue(String url, long useTime, long tust, long fileSize, int errCode, String errMsg, String netlib, String realHost) {
        this.mUrl = url;
        this.mDownloadMetric.result = 0;
        this.mDownloadMetric.useTime = useTime;
        this.mDownloadMetric.tust = tust;
        this.mDownloadMetric.retryTimes = this.mCurRetryTimes;
        this.mDownloadMetric.fileSize = fileSize;
        this.mDownloadMetric.httpCode = -1;
        this.mDownloadMetric.errCode = errCode;
        this.mDownloadMetric.errMsg = errMsg;
        this.mDownloadMetric.netLib = netlib;
        this.mDownloadMetric.realHost = realHost;
        MLog.debug((Object)TAG, (String)("download fail " + this.mDownloadMetric.toString()), (Object[])new Object[0]);
    }
}

