/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.download;

import android.text.TextUtils;
import com.yy.appbase.util.AssetIndex;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.FP;
import com.yy.base.utils.FileUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.IBuiltInGameCallback;
import com.yy.game.download.version.GameVersion;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BuiltInGameManager {
    private static final String TAG = "BuiltInGameManager";
    private static final String SPLIT = "__hg__";

    public static BuiltInGameManager getInstance() {
        return InstanceHolder.instance;
    }

    public void checkBuiltInGame(final IBuiltInGameCallback callback2) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                BuiltInGameManager.this.parseAssetGame(callback2);
            }
        });
    }

    private void parseAssetGame(final IBuiltInGameCallback callback2) {
        try {
            String[] fileNames = AssetIndex.list((String)"game");
            if (fileNames != null && fileNames.length > 0) {
                for (final String fileName : fileNames) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)("assets game: " + fileName), (Object[])new Object[0]);
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            BuiltInGameManager.this.handlerGameFile(fileName, callback2);
                        }
                    }, (long)PageResponse.getDelay((int)1));
                }
            } else {
                this.onCallback(callback2, null, 10);
            }
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (String)"parseAssetGameInfo error", (Throwable)e, (Object[])new Object[0]);
            this.onCallback(callback2, null, 10);
        }
    }

    private void handlerGameFile(String fileName, IBuiltInGameCallback callback2) {
        if (TextUtils.isEmpty((CharSequence)fileName) || !fileName.contains(SPLIT)) {
            MLog.error((Object)TAG, (String)"built in game: %, name format is error", (Object[])new Object[]{fileName});
            this.onCallback(callback2, null, 13);
            return;
        }
        Object[] strInfo = fileName.split(SPLIT);
        if (!FP.empty((Object[])strInfo) && strInfo.length == 3) {
            String md5 = ((String)strInfo[2]).replace(".pkg", "");
            GameInfo info = GameInfo.newBuilder((GameInfoSource)GameInfoSource.HOME).gid((String)strInfo[0]).modulerVer((String)strInfo[1]).modulerMd5(md5).build();
            if (!GameVersion.INSTANCE.canSilentDownload(info.gid)) {
                MLog.debug((Object)TAG, (String)"had been delete by user, not need to add gid: %s", (Object[])new Object[]{info.gid});
                return;
            }
            boolean valid = this.checkGameFileValid(info, callback2);
            if (!valid) {
                boolean success2;
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"game is invalid, copy file from assets to sdcard, gameInfo: %s", (Object[])new Object[]{info});
                }
                if (success2 = this.copyAssetsFileToSd("game/" + fileName, GameDownloadUtils.getGameWillDownloadPath((BasicGameInfo)info))) {
                    this.onCallback(callback2, info, 0);
                    GameVersion.INSTANCE.addGame((BasicGameInfo)info);
                } else {
                    this.onCallback(callback2, info, 12);
                }
            } else if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"game: %s, is valid, not need to copy file from assets to sdcard", (Object[])new Object[]{info});
            }
        } else {
            this.onCallback(callback2, null, 13);
        }
    }

    private void onCallback(final IBuiltInGameCallback callback2, final GameInfo info, final int code) {
        if (callback2 == null) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                callback2.onFinished(info, code);
            }
        });
    }

    private boolean checkGameFileValid(GameInfo info, IBuiltInGameCallback callback2) {
        File[] files;
        int sdVersion = StringUtils.safeParseInt((String)info.getModulerVer());
        boolean valid = GameVersion.INSTANCE.isGamePkgValid((BasicGameInfo)info);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"game is valid: %s , gameInfo: %s", (Object[])new Object[]{valid, info});
        }
        if (valid) {
            this.onCallback(callback2, info, 1);
            return true;
        }
        String dir = GameDownloadUtils.getSingleGameDir((BasicGameInfo)info);
        File dirFile = new File(dir);
        if (dirFile.exists() && dirFile.isDirectory() && (files = dirFile.listFiles()) != null && files.length > 0) {
            for (File f : files) {
                String name = f.getName();
                if (TextUtils.isEmpty((CharSequence)name)) continue;
                if (name.endsWith(".pkg.tmp")) {
                    name = name.substring(0, name.length() - 8);
                } else if (name.endsWith(".pkg")) {
                    name = name.substring(0, name.length() - 4);
                }
                String[] names = name.split("_");
                if (names.length <= 0) continue;
                String version = names[names.length - 1];
                int v = StringUtils.safeParseInt((String)version);
                if (sdVersion < v) {
                    this.onCallback(callback2, info, 2);
                    return true;
                }
                if (v != sdVersion) continue;
                if (!RemoteGameDebugService.Companion.checkMD5(info.getGid())) {
                    return true;
                }
                boolean md5Valid = YYFileUtils.checkFileMd5((File)f, (String)info.getModulerMd5(), (long)0L);
                if (!md5Valid) continue;
                this.onCallback(callback2, info, 2);
                return true;
            }
        }
        YYFileUtils.delete((File)dirFile);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyAssetsFileToSd(String assetsPath, String sdPath) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"copyAssetsFileToSd assetsPath: %s, sdPath: %s", (Object[])new Object[]{assetsPath, sdPath});
        }
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = RuntimeContext.sApplicationContext.getAssets().open(assetsPath);
            File sdFileTemp = FileUtils.createNewFile((String)(sdPath + ".tmp"));
            fos = new FileOutputStream(sdFileTemp);
            byte[] buffer = new byte[1024];
            int byteCount = 0;
            while ((byteCount = is.read(buffer)) != -1) {
                fos.write(buffer, 0, byteCount);
            }
            fos.flush();
            File sdFile = FileUtils.createNewFile((String)sdPath);
            boolean rename = sdFileTemp.renameTo(sdFile);
            if (!rename) {
                MLog.error((Object)TAG, (String)"copyAssetsFileToSd rename failed sdFileTemp: %s, sdPath: %s", (Object[])new Object[]{sdFileTemp.getAbsolutePath(), sdPath});
            }
            boolean bl = rename;
            return bl;
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"copyAssetsFileToSd error", (Throwable)e, (Object[])new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class InstanceHolder {
        static BuiltInGameManager instance = new BuiltInGameManager();

        private InstanceHolder() {
        }
    }
}

