/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.data;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.GameHistoryBean;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.data.GamePlayRecordBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.appbase.kvomodule.BizModule;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnGameHistoryCallback;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.base.config.GameEmojiConfig;
import com.yy.hiyo.game.kvomodule.GameEmoji;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.kvomodule.IGamePlayLoadCallBack;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.webservice.WebEnvSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import okhttp3.Call;

public class GameModuleImpl
extends BizModule<GameInfoModuleData>
implements GameInfoModule,
OnGameInfoChangedListener {
    private static final String TAG = "GameModuleImpl";
    private final Object playGameInfoLock = new Object();
    private volatile List<GameHistoryBean> mPlayHistory;
    private volatile boolean isLoadDataFinish = false;
    private boolean mPlayHistoryPulling;
    private boolean mPlayHistoryWithUserPulling;
    private INotify mNotifyHandler;
    private boolean mPlayHistoryLoadedFromDB = false;
    private List<Runnable> cacheBizTask = new CopyOnWriteArrayList<Runnable>();
    private IConfigListener<GameEmojiConfig> mGameEmojiConfig = new IConfigListener<GameEmojiConfig>(){

        public void onUpdateConfig(@Nullable GameEmojiConfig data) {
            if (data != null) {
                ((GameInfoModuleData)GameModuleImpl.this.mData).setGameEmojis(data.getEmojis());
            }
        }
    };

    public GameModuleImpl(GameInfoModuleData mData) {
        super((BaseModuleData)mData);
        UnifyConfig.INSTANCE.registerListener(BssCode.GAME_EMOJIS, this.mGameEmojiConfig);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_WEB_VIEW_WINDOW_CLOSED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.URI_WINDOW_STOP, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification != null) {
            Object extObj = notification.extObj;
            if (notification.id == NotificationDef.N_WEB_VIEW_WINDOW_CLOSED) {
                if (extObj instanceof WebEnvSettings) {
                    WebEnvSettings settings = (WebEnvSettings)extObj;
                    this.stopPlayActivityGame(settings.originUrl);
                }
            } else if (notification.id == NotificationDef.URI_WINDOW_STOP && extObj instanceof Uri) {
                Uri uri = (Uri)extObj;
                this.stopPlayActivityGame(uri.toString());
            }
        }
    }

    private void resetGameWithUidHistory() {
        this.mPlayHistoryWithUserPulling = false;
        SettingFlags.setBoolean((String)("pullgamehistory" + AccountUtil.getUid()), (boolean)false);
    }

    private void preloadPlayRecordBean() {
        MyBox playrecord;
        IServiceManager serviceManager = this.getService();
        if (serviceManager == null) {
            serviceManager = ServiceManagerProxy.getServiceManager();
        }
        if ((playrecord = ((IDBService)ServiceManagerProxy.getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class)) != null) {
            playrecord.getAll(new MyBox.IGetItemsCallBack(){

                public void onLoaded(ArrayList datas) {
                    GameModuleImpl.this.mPlayHistoryLoadedFromDB = true;
                }
            });
        }
        this.pullOldHistroyToFile();
        this.initGameHistoryFromFile(serviceManager);
    }

    private void pullOldHistroyToFile() {
        if (this.mPlayHistoryPulling && this.mPlayHistoryWithUserPulling) {
            return;
        }
        final boolean hasPullWithUser = SettingFlags.getBoolean((String)("pullgamehistory" + AccountUtil.getUid()), (boolean)false);
        final boolean hasPull = SettingFlags.getBoolean((String)"pullgamehistory", (boolean)false);
        if (AccountUtil.getUid() > 0L && !hasPull || AccountUtil.getUid() > 0L && !hasPullWithUser) {
            this.mPlayHistoryPulling = true;
            this.mPlayHistoryWithUserPulling = true;
            ((IUserInfoService)this.getService().getService(IUserInfoService.class)).getGameHistory(AccountUtil.getUid(), new OnGameHistoryCallback(){

                public void onUISuccess(List<GameHistoryBean> list, int id2) {
                    GameModuleImpl.this.mPlayHistoryPulling = false;
                    GameModuleImpl.this.mPlayHistoryWithUserPulling = false;
                    if (list == null || list.size() <= 0) {
                        return;
                    }
                    GameModuleImpl.this.mPlayHistory = list;
                    ArrayList<GamePlayRecordBean> items = new ArrayList<GamePlayRecordBean>(list.size());
                    ArrayList<GamePlayRecordBean> playRecordBeans = new ArrayList<GamePlayRecordBean>(list.size());
                    for (GameHistoryBean tempHistory : list) {
                        if (tempHistory == null || tempHistory.totalCount <= 0 || StringUtils.isEmpty((String)tempHistory.gameId)) continue;
                        if (!hasPull) {
                            items.add(new GamePlayRecordBean(tempHistory.gameId, tempHistory.totalCount));
                        }
                        if (hasPullWithUser) continue;
                        playRecordBeans.add(new GamePlayRecordBean(tempHistory.gameId, tempHistory.totalCount));
                    }
                    if (!hasPull) {
                        GameModuleImpl.this.addGameHistoryGlobalToFile(items);
                    }
                    if (!hasPullWithUser) {
                        GameModuleImpl.this.addGameHistoryWithUserToFile(playRecordBeans);
                    }
                }

                public void onError(Call call, Exception e, int id2) {
                    GameModuleImpl.this.mPlayHistoryPulling = false;
                    GameModuleImpl.this.mPlayHistoryWithUserPulling = false;
                }

                public void onResponseError(int id2, String message, String response) {
                    GameModuleImpl.this.mPlayHistoryPulling = false;
                    GameModuleImpl.this.mPlayHistoryWithUserPulling = false;
                }
            });
        }
    }

    private void addGameHistoryGlobalToFile(ArrayList<GamePlayRecordBean> items) {
        MyBox playrecord = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (playrecord != null && items.size() > 0) {
            playrecord.updateItems(items, true);
            playrecord.getAll(new MyBox.IGetItemsCallBack(){

                public void onLoaded(ArrayList datas) {
                    SettingFlags.setBoolean((String)"pullgamehistory", (boolean)true);
                }
            });
        }
    }

    private void addGameHistoryWithUserToFile(ArrayList<GamePlayRecordBean> items) {
        MyBox playrecord = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (playrecord != null && items.size() > 0) {
            playrecord.updateItems(items, true);
            playrecord.getAll(new MyBox.IGetItemsCallBack(){

                public void onLoaded(ArrayList datas) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameModuleImpl.TAG, (String)"addGameHistoryWithUserToFile", (Object[])new Object[0]);
                    }
                    SettingFlags.setBoolean((String)("pullgamehistory" + AccountUtil.getUid()), (boolean)true);
                }
            });
        }
    }

    public GameInfo getGame(String gid) {
        GamePlayInfo playInfo;
        GameInfo info = null;
        if (!StringUtils.isEmpty((String)gid) && (playInfo = (GamePlayInfo)((GameInfoModuleData)this.mData).getGameCacheInfo().get(gid)) != null) {
            info = playInfo.getGameInfo();
        }
        return info;
    }

    public void updateGameInfo(GameInfo gameInfo) {
        ((GameInfoModuleData)this.mData).updateGameInfo(gameInfo);
    }

    public void startPlayGame(final GameInfo gameInfo) {
        if (!this.isReady) {
            this.cacheTask(new Runnable(){

                @Override
                public void run() {
                    GameModuleImpl.this.startPlayGame(gameInfo);
                }
            });
            return;
        }
        if (gameInfo != null && gameInfo.getGameMode() == 10) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"hago show startPlayGame block!!!", (Object[])new Object[0]);
            }
            return;
        }
        MLog.debug((Object)TAG, (String)"startPlayGame gameInfo: %s", (Object[])new Object[]{gameInfo});
        this.startFavGame(gameInfo);
    }

    public void stopPlayGame(final GameInfo gameInfo) {
        if (!this.isReady) {
            this.cacheTask(new Runnable(){

                @Override
                public void run() {
                    GameModuleImpl.this.stopPlayGame(gameInfo);
                }
            });
            return;
        }
        if (gameInfo != null && gameInfo.getGameMode() == 10) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"hago show stopPlayGame block!!!", (Object[])new Object[0]);
            }
            return;
        }
        MLog.debug((Object)TAG, (String)"stopPlayGame gameInfo: %s", (Object[])new Object[]{gameInfo});
        this.stopFavGame(gameInfo);
    }

    public void startPlayActivityGame(String gid, GameInfo gameInfo) {
        MLog.debug((Object)TAG, (String)"startPlayActivityGame gid: %s", (Object[])new Object[]{gid});
        GameInfo actualGameInfo = gameInfo;
        if (actualGameInfo != null) {
            MLog.debug((Object)TAG, (String)"startPlayActivityGame find gameInfo by GameInfoService", (Object[])new Object[0]);
        } else {
            actualGameInfo = ((IGameInfoService)this.getService().getService(IGameInfoService.class)).getGameInfoByGid(gid);
        }
        if (actualGameInfo != null) {
            String jumpUri = actualGameInfo.getJumpUri();
            if (actualGameInfo.getGameMode() == 0 && !StringUtils.isEmpty((String)jumpUri) && (jumpUri.startsWith("http") || jumpUri.startsWith("hago"))) {
                MLog.debug((Object)TAG, (String)"startPlayActivityGame gid: %s, uri: %s", (Object[])new Object[]{actualGameInfo.getGid(), actualGameInfo.getJumpUri()});
                this.startFavGame(actualGameInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlayActivityGame(String url) {
        MLog.debug((Object)TAG, (String)"stopPlayActivityGame uri: %s", (Object[])new Object[]{url});
        Object object = this.playGameInfoLock;
        synchronized (object) {
            GameInfo gameInfo;
            GamePlayInfoDBBean last = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (last != null && last.getGameMode() == 0 && StringUtils.equal((String)url, (String)last.getExt()) && (gameInfo = ((IGameInfoService)this.getService().getService(IGameInfoService.class)).getGameInfoByGid(last.getGameId())) != null) {
                MLog.debug((Object)TAG, (String)"stopPlayActivityGame gid: %s, uri: %s", (Object[])new Object[]{gameInfo.getGid(), gameInfo.getJumpUri()});
                this.stopFavGame(gameInfo);
            }
        }
    }

    public void addToFavorGame(GameInfo gameInfo) {
        this.startFavGame(gameInfo);
        this.stopFavGame(gameInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFavGame(GameInfo gameInfo) {
        Object object = this.playGameInfoLock;
        synchronized (object) {
            if (gameInfo == null || StringUtils.isEmpty((String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start play game err,game:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            GamePlayInfoDBBean last = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (last != null && last.getGameMode() == 0 && !TextUtils.isEmpty((CharSequence)last.getExt()) && last.getExt().startsWith("http")) {
                this.stopPlayActivityGame(last.getExt());
            }
            GamePlayInfoDBBean playInfo = new GamePlayInfoDBBean();
            playInfo.setStartTs(System.currentTimeMillis());
            playInfo.setGameId(gameInfo.getGid());
            playInfo.setGameMode(gameInfo.getGameMode());
            playInfo.setUid(AccountUtil.getUid());
            playInfo.setLastVersion(gameInfo.getModulerVer());
            if (playInfo.getGameMode() == 0) {
                playInfo.setExt(gameInfo.getJumpUri());
            }
            ((GameInfoModuleData)this.mData).setPlayingGame(playInfo);
            ((GameInfoModuleData)this.mData).gameRunningContext.setGameRunning(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopFavGame(GameInfo gameInfo) {
        Object object = this.playGameInfoLock;
        synchronized (object) {
            MyBox myBox;
            IDBService service;
            if (gameInfo == null || StringUtils.isEmpty((String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"stop play game err,game:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            GamePlayInfoDBBean mLast = ((GameInfoModuleData)this.mData).getPlayingGame();
            if (mLast == null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"start play game is null,cur:%s", (Object[])new Object[]{gameInfo});
                }
                return;
            }
            if (!StringUtils.equal((String)mLast.getGameId(), (String)gameInfo.getGid())) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"game id not match, lastId:%s, curId:%s", (Object[])new Object[]{mLast.getGameId(), gameInfo.getGid()});
                }
                return;
            }
            long curTs = System.currentTimeMillis();
            long distance = curTs - mLast.getStartTs();
            mLast.setEndTs(curTs);
            mLast.setGamingTs(distance);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"play game end, gameInfo: %s", (Object[])new Object[]{mLast.getGameId()});
            }
            if ((service = (IDBService)this.getService().getService(IDBService.class)) != null && (myBox = service.boxForGlobal(GamePlayInfoDBBean.class)) != null) {
                myBox.updateItem((BaseDBBean)mLast, true);
            }
            ((GameInfoModuleData)this.mData).updateGameInfo(gameInfo);
            ((GameInfoModuleData)this.mData).appendPlayGame(mLast);
            ((GameInfoModuleData)this.mData).setPlayingGame(null);
            ((GameInfoModuleData)this.mData).gameRunningContext.setGameRunning(false);
            this.notifyPlayDataChange();
        }
    }

    public long getLastGamePlayDuration(String gid) {
        GamePlayInfo playInfo;
        long duration = 0L;
        if (!StringUtils.isEmpty((String)gid) && (playInfo = (GamePlayInfo)((GameInfoModuleData)this.mData).getGameCacheInfo().get(gid)) != null) {
            duration = playInfo.getLastTimePlayDuration();
        }
        return duration;
    }

    public List<GameEmoji> getGameEmojis() {
        return ((GameInfoModuleData)this.mData).getGameEmojis();
    }

    public void onGameJoinSuccess(GamePlayContext context) {
        String gameId;
        GameInfo gameInfo = context.getGameInfo();
        if (gameInfo != null && gameInfo.getGameMode() != 10 && StringUtils.isNotEmpty((String)(gameId = gameInfo.getGid()))) {
            boolean isCoins = context.getExtendData().get("isGoldGame") != null && (Boolean)context.getExtendData().get("isGoldGame") != false;
            this.updateGlobalHistory(gameId, isCoins);
            this.updateWithUserGameHistoryWithCoins(gameId, isCoins);
        }
    }

    private void updateWithUserGameHistory(String gameId) {
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        this.updateGameHistory(gameId, box, false);
    }

    private void updateWithUserGameHistoryWithCoins(String gameId, boolean isCoins) {
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        this.updateGameHistory(gameId, box, isCoins);
    }

    private void updateGlobalHistory(String gameId, boolean isCoins) {
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        this.updateGameHistory(gameId, box, isCoins);
    }

    private void updateGameHistory(final String gameId, final MyBox box, final boolean isCoins) {
        if (box != null) {
            box.getItemByIndex((Object)gameId, new MyBox.IGetItemsCallBack(){

                public void onLoaded(ArrayList datas) {
                    Object o;
                    GamePlayRecordBean item = null;
                    if (datas != null && datas.size() > 0 && (o = datas.get(0)) instanceof GamePlayRecordBean) {
                        item = (GamePlayRecordBean)o;
                        if (isCoins) {
                            item.setGoldPlaytimes(item.getGoldPlaytimes() + 1);
                        }
                        item.setPlayTimes(item.getPlayTimes() + 1);
                    }
                    if (item == null) {
                        box.addItem((BaseDBBean)new GamePlayRecordBean(gameId, 1, isCoins ? 1 : 0));
                    }
                    box.updateItem(item, true);
                }
            });
        }
    }

    public boolean hasGamePlayed(String gid) {
        GamePlayRecordBean item;
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (box == null) {
            return true;
        }
        ArrayList<String> indexs = new ArrayList<String>(1);
        indexs.add(gid);
        ArrayList object = box.getItemsFromMem(indexs);
        if (object != null && object.size() > 0 && (item = (GamePlayRecordBean)object.get(0)) != null) {
            return item.hasPlayed();
        }
        List<GameHistoryBean> items = this.mPlayHistory;
        if (items != null && items.size() > 0) {
            for (GameHistoryBean item2 : items) {
                if (item2 == null || !StringUtils.equal((String)item2.gameId, (String)gid)) continue;
                return item2.playerCount > 0;
            }
        }
        boolean pullFromServer = SettingFlags.getBoolean((String)"pullgamehistory", (boolean)false);
        return RuntimeContext.isNewInstalled() ? false : !pullFromServer;
    }

    public boolean hasGamePlayedWithUser(String gid) {
        GamePlayRecordBean item;
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (box == null) {
            return true;
        }
        ArrayList<String> indexs = new ArrayList<String>(1);
        indexs.add(gid);
        ArrayList object = box.getItemsFromMem(indexs);
        if (object != null && object.size() > 0 && (item = (GamePlayRecordBean)object.get(0)) != null) {
            return item.hasPlayed();
        }
        return false;
    }

    private void initGameHistoryFromFile(IServiceManager serviceManager) {
        MyBox box = ((IDBService)serviceManager.getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (box == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"initGameHistoryFromFile bos is null", (Object[])new Object[0]);
            }
            return;
        }
        box.getAll(new MyBox.IGetItemsCallBack(){

            public void onLoaded(ArrayList datas) {
            }
        });
    }

    public boolean isPlayingGame() {
        return ((GameInfoModuleData)this.mData).gameRunningContext.isGameRunning();
    }

    public List<GamePlayInfoDBBean> getAllPlayInfos() {
        return ((GameInfoModuleData)this.mData).getPlayInfoDBBeans();
    }

    public GamePlayInfoDBBean getPlayingInfo() {
        return ((GameInfoModuleData)this.mData).getPlayingGame();
    }

    public void getDurationPlayInfo(final long durationBeforeNow, final GameInfoModuleData.MatchCallback callback2) {
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new Runnable(){

                @Override
                public void run() {
                    GameModuleImpl.this.getDurationPlayInfo(durationBeforeNow, callback2);
                }
            });
            return;
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean(new GameInfoModuleData.Matcher(){
            private long curTs = System.currentTimeMillis();
            private long oldestTs = this.curTs - durationBeforeNow;

            public boolean match(GamePlayInfoDBBean infoDBBean) {
                return this.oldestTs <= infoDBBean.getStartTs() && infoDBBean.getStartTs() <= this.curTs;
            }
        }, callback2);
    }

    public void getSelectGameModelData(final int gameModel, final GameInfoModuleData.MatchCallback callback2) {
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new Runnable(){

                @Override
                public void run() {
                    GameModuleImpl.this.getSelectGameModelData(gameModel, callback2);
                }
            });
            return;
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean(new GameInfoModuleData.Matcher(){

            public boolean match(GamePlayInfoDBBean infoDBBean) {
                return infoDBBean != null && infoDBBean.getGameMode() == gameModel;
            }
        }, callback2);
    }

    public void getMatchGamePlayInfo(final GameInfoModuleData.Matcher matcher, final GameInfoModuleData.MatchCallback callback2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u5f00\u59cb\u83b7\u53d6\u6570\u636e\uff1a" + this.isLoadDataFinish), (Object[])new Object[0]);
        }
        if (!this.isLoadDataFinish) {
            this.cacheBizTask.add(new Runnable(){

                @Override
                public void run() {
                    GameModuleImpl.this.getMatchGamePlayInfo(matcher, callback2);
                }
            });
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("\u52a0\u8f7d\u6210\u529f\u4e86 \u53ef\u4ee5\u83b7\u53d6\u6570\u636e--" + this.isLoadDataFinish), (Object[])new Object[0]);
        }
        ((GameInfoModuleData)this.mData).getMatchPlayInfoBean(matcher, callback2);
    }

    public List<SingleGameBestHistoryInfo> requestSingleGameBestScore(List<String> gameIds, boolean hasCacheReturnWithoutCallback, final INetRespCallback<List<SingleGameBestHistoryInfo>> callback2) {
        ArrayList<SingleGameBestHistoryInfo> retData = new ArrayList<SingleGameBestHistoryInfo>();
        if (gameIds == null || gameIds.isEmpty()) {
            return retData;
        }
        ArrayList<String> gameIdList = new ArrayList<String>(gameIds);
        StringBuilder idListStr = new StringBuilder("");
        for (int i = 0; i < gameIdList.size(); ++i) {
            String id2 = (String)gameIdList.get(i);
            if (TextUtils.isEmpty((CharSequence)id2)) continue;
            if (!TextUtils.isEmpty((CharSequence)idListStr) && i > 0) {
                idListStr.append(",");
            }
            idListStr.append(id2);
            SingleGameBestHistoryInfo cache = ((GameInfoModuleData)this.mData).getSingleGameBestScore(id2);
            if (cache == null) continue;
            retData.add(cache);
        }
        if (gameIdList.size() == retData.size() && hasCacheReturnWithoutCallback) {
            return retData;
        }
        String gameIdListStr = idListStr.toString();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"requestBestHistory, list: %s", (Object[])new Object[]{gameIdListStr});
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("gidList", gameIdListStr);
        HttpUtil.httpReq((String)(UriProvider.getIkxdApiHost() + "/single/bestHistory"), params, (int)2, (INetRespCallback)new INetRespCallback<List<SingleGameBestHistoryInfo>>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)GameModuleImpl.TAG, (String)"[requestBestHistory]", (Throwable)e, (Object[])new Object[0]);
                if (callback2 != null) {
                    callback2.onError(call, e, id2);
                }
            }

            public void onResponse(String response, BaseResponseBean<List<SingleGameBestHistoryInfo>> res, int id2) {
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)GameModuleImpl.TAG, (String)"[requestBestHistory] response: %s", (Object[])new Object[]{response});
                }
                if (res != null && res.isSuccess()) {
                    if (res.data != null) {
                        for (SingleGameBestHistoryInfo info : (List)res.data) {
                            if (info == null) continue;
                            ((GameInfoModuleData)GameModuleImpl.this.mData).updateSingleGameBestScore(info);
                        }
                    } else {
                        MLog.error((Object)GameModuleImpl.TAG, (String)"[requestBestHistory] null data", (Object[])new Object[0]);
                    }
                } else {
                    MLog.error((Object)GameModuleImpl.TAG, (String)"[requestBestHistory] msg: %s", (Object[])new Object[]{res == null ? "null res" : res.message});
                }
                if (callback2 != null) {
                    callback2.onResponse(response, res, id2);
                }
            }
        });
        return retData;
    }

    public void ensurePlayDataLoaded(final IGamePlayLoadCallBack callBack) {
        if (this.mPlayHistoryLoadedFromDB) {
            if (callBack != null) {
                callBack.onLoadFinish();
            }
            return;
        }
        MyBox playrecord = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayRecordBean.class);
        if (playrecord != null) {
            playrecord.getAll(new MyBox.IGetItemsCallBack(){

                public void onLoaded(ArrayList datas) {
                    GameModuleImpl.this.mPlayHistoryLoadedFromDB = true;
                    if (callBack != null) {
                        callBack.onLoadFinish();
                    }
                }
            });
        } else if (callBack != null) {
            callBack.onError();
        }
    }

    public long getPlayGoldTimes(String gid) {
        GamePlayRecordBean item;
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (box == null) {
            return 0L;
        }
        ArrayList<String> indexs = new ArrayList<String>(1);
        indexs.add(gid);
        ArrayList object = box.getItemsFromMem(indexs);
        if (object != null && object.size() > 0 && (item = (GamePlayRecordBean)object.get(0)) != null) {
            return item.getGoldPlaytimes();
        }
        return 0L;
    }

    public long getPlayTimes(String gid) {
        GamePlayRecordBean item;
        MyBox box = ((IDBService)this.getService().getService(IDBService.class)).boxForCurUser(GamePlayRecordBean.class);
        if (box == null) {
            return 0L;
        }
        ArrayList<String> indexs = new ArrayList<String>(1);
        indexs.add(gid);
        ArrayList object = box.getItemsFromMem(indexs);
        if (object != null && object.size() > 0 && (item = (GamePlayRecordBean)object.get(0)) != null) {
            return item.getPlayTimes();
        }
        return 0L;
    }

    public void onCreate(IServiceManager serviceManager, Environment evn) {
        super.onCreate(serviceManager, evn);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GameModuleImpl.this.mNotifyHandler == null) {
                    GameModuleImpl.this.mNotifyHandler = new INotify(){

                        public void notify(Notification notification) {
                            if (notification == null) {
                                return;
                            }
                            if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
                                GameModuleImpl.this.init();
                                if (AccountUtil.getUid() > 0L) {
                                    GameModuleImpl.this.resetGameWithUidHistory();
                                    if (RuntimeContext.sIsAppStartFinished) {
                                        GameModuleImpl.this.pullOldHistroyToFile();
                                    }
                                } else {
                                    GameModuleImpl.this.mPlayHistory = null;
                                }
                            } else if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
                                GameModuleImpl.this.init();
                                GameModuleImpl.this.preloadPlayRecordBean();
                            }
                        }
                    };
                }
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, GameModuleImpl.this.mNotifyHandler);
                if (RuntimeContext.sIsAppStartFinished) {
                    GameModuleImpl.this.init();
                    GameModuleImpl.this.preloadPlayRecordBean();
                    return;
                }
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, GameModuleImpl.this.mNotifyHandler);
            }
        });
    }

    private void init() {
        AConfigData data;
        final MyBox myBox = ((IDBService)this.getService().getService(IDBService.class)).boxForGlobal(GamePlayInfoDBBean.class);
        ((IGameInfoService)this.getService().getService(IGameInfoService.class)).addGameInfoListener((OnGameInfoChangedListener)this, true);
        if (myBox != null) {
            myBox.getAll((MyBox.IGetItemsCallBack)new MyBox.IGetItemsCallBack<GamePlayInfoDBBean>(){

                public void onLoaded(ArrayList<GamePlayInfoDBBean> datas) {
                    ArrayList<GamePlayInfoDBBean> deleteHagoShow = new ArrayList<GamePlayInfoDBBean>();
                    if (datas != null && !datas.isEmpty()) {
                        for (GamePlayInfoDBBean item : datas) {
                            if (item.getGameMode() != 10) continue;
                            deleteHagoShow.add(item);
                        }
                        datas.removeAll(deleteHagoShow);
                        ((GameInfoModuleData)GameModuleImpl.this.mData).initialTotal(datas);
                    }
                    if (!deleteHagoShow.isEmpty()) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)GameModuleImpl.TAG, (String)"delete hago show size:%d", (Object[])new Object[]{deleteHagoShow.size()});
                        }
                        myBox.deleteItems(deleteHagoShow);
                    }
                    GameModuleImpl.this.isLoadDataFinish = true;
                    GameModuleImpl.this.executeCacheBizTask();
                    GameModuleImpl.this.notifyPlayDataChange();
                }
            });
        }
        if ((data = UnifyConfig.INSTANCE.getConfigData(BssCode.GAME_EMOJIS)) instanceof GameEmojiConfig) {
            ((GameInfoModuleData)this.mData).setGameEmojis(((GameEmojiConfig)data).getEmojis());
        }
    }

    private void executeCacheBizTask() {
        if (!this.cacheBizTask.isEmpty()) {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.cacheBizTask);
            for (Runnable r : runnables) {
                if (r == null) continue;
                r.run();
            }
            this.cacheBizTask.clear();
        }
    }

    private void notifyPlayDataChange() {
        ((GameInfoModuleData)this.mData).setPlayInfoChange(new Object());
    }

    public void onGameInfoChanged(GameInfoSource type, final List<GameInfo> list) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (list != null && !list.isEmpty()) {
                    for (GameInfo info : list) {
                        ((GameInfoModuleData)GameModuleImpl.this.mData).updateGameInfo(info);
                    }
                    ((GameInfoModuleData)GameModuleImpl.this.mData).setPlayInfoChange(new Object());
                }
            }
        });
    }

    protected void unbindDataWhenDestroy() {
        super.unbindDataWhenDestroy();
        IGameInfoService service = (IGameInfoService)ServiceManagerProxy.getInstance().getService(IGameInfoService.class);
        if (service != null) {
            service.removeGameInfoListener((OnGameInfoChangedListener)this);
        }
    }
}

