/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.data;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.game.base.bean.GameCategory;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.kvomodule.GameInfoModuleData;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.callback.OnGameInfoChangedListener;
import com.yy.hiyo.game.service.callback.OnGetImGameInfosCallback;
import com.yy.hiyo.game.service.callback.OnImGameInfoCHangedListener;
import com.yy.hiyo.game.service.callback.OnPkGameInfoChangedListener;
import com.yy.hiyo.home.base.homepage.HomeReportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

@DontProguardClass
public class GameInfoService
extends DefaultController
implements IGameInfoService {
    private static final String TAG = "GameInfoService";
    private final List<GameInfo> mGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> mImGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> singleGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> sameGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> voiceRoomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> floatGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> inVoiceRoomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> createRoomGameList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> pkGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private List<OnImGameInfoCHangedListener> mImGameInfoCHangedListeners = new ArrayList<OnImGameInfoCHangedListener>();
    private OnPkGameInfoChangedListener mPkGameInfoChangedListener;
    private final List<GameInfo> mRandomGameInfoList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameInfo> mNoneModeGameList = new CopyOnWriteArrayList<GameInfo>();
    private final List<GameCategory> mGameCategory = new CopyOnWriteArrayList<GameCategory>();
    private final List<OnGameInfoChangedListener> mGameInfoListener = new CopyOnWriteArrayList<OnGameInfoChangedListener>();
    private volatile boolean hasLoadRoomGameList = false;
    private volatile boolean hasLoadInRoomGameList = false;

    public GameInfoService(Environment env) {
        super(env);
    }

    @Nullable
    public GameInfo getGameInfoByGid(String gid) {
        List findList;
        List[] findArray;
        GameInfo info = null;
        List[] listArray = findArray = new List[]{this.mGameInfoList, this.singleGameInfoList, this.sameGameInfoList, this.voiceRoomGameInfoList, this.inVoiceRoomGameInfoList, this.floatGameInfoList, this.mNoneModeGameList};
        int n = listArray.length;
        for (int i = 0; i < n && (info = this.findGameInfo(findList = listArray[i], gid)) == null; ++i) {
        }
        return info;
    }

    @Nullable
    public GameInfo getGameInfoByIdWithType(String gid, GameInfoSource gameInfoSource) {
        GameInfo info = null;
        switch (gameInfoSource) {
            case HOME: {
                info = this.findGameInfo(this.mGameInfoList, gid);
                break;
            }
            case SINGLE: {
                info = this.findGameInfo(this.singleGameInfoList, gid);
                break;
            }
            case SAMESCEEN: {
                info = this.findGameInfo(this.sameGameInfoList, gid);
                break;
            }
            case VOICE_ROOM: {
                info = this.findGameInfo(this.voiceRoomGameInfoList, gid);
                break;
            }
            case IN_VOICE_ROOM: {
                info = this.findGameInfo(this.inVoiceRoomGameInfoList, gid);
                break;
            }
            case FLOAT_PLAY: {
                info = this.findGameInfo(this.floatGameInfoList, gid);
                break;
            }
            default: {
                info = this.getGameInfoByGid(gid);
            }
        }
        return info;
    }

    private GameInfo findGameInfo(List<GameInfo> list, String gid) {
        if (TextUtils.isEmpty((CharSequence)gid) || FP.empty(list)) {
            return null;
        }
        for (GameInfo info : list) {
            if (info == null || !gid.equals(info.getGid())) continue;
            return info;
        }
        return null;
    }

    @Nullable
    public List<GameInfo> getHomeGameInfoList() {
        if (!FP.empty(this.mGameInfoList)) {
            return Collections.unmodifiableList(this.mGameInfoList);
        }
        return null;
    }

    @Nullable
    public List<GameInfo> getIMGameInfoList() {
        if (!FP.empty(this.mImGameInfoList)) {
            return Collections.unmodifiableList(this.mImGameInfoList);
        }
        return null;
    }

    @Nullable
    public void getIMMainGameInfoList(final OnGetImGameInfosCallback callback2) {
        if (callback2 == null) {
            return;
        }
        GameInfoModule gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class);
        long durationBeforeNow = 604800000L;
        gameInfoModule.getMatchGamePlayInfo(new GameInfoModuleData.Matcher(){
            private long curTs = System.currentTimeMillis();
            private long oldestTs = this.curTs - 604800000L;

            public boolean match(GamePlayInfoDBBean infoDBBean) {
                boolean flag1 = infoDBBean.getUid() == AccountUtil.getUid();
                boolean flag2 = this.oldestTs <= infoDBBean.getStartTs() && infoDBBean.getStartTs() <= this.curTs;
                return flag1 && flag2;
            }
        }, new GameInfoModuleData.MatchCallback(){

            public void onGetResult(List<GamePlayInfo> gamePlayInfos) {
                if (callback2 != null) {
                    callback2.onImGameInfoGet(gamePlayInfos);
                }
            }
        });
    }

    @Nonnull
    public List<GameInfo> getVoiceRoomGameInfoList() {
        if (!FP.empty(this.voiceRoomGameInfoList)) {
            return Collections.unmodifiableList(this.voiceRoomGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<GameInfo> getFloatGameInfoList() {
        if (!FP.empty(this.floatGameInfoList)) {
            return Collections.unmodifiableList(this.floatGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<GameInfo> getInVoiceRoomGameInfoList() {
        if (!FP.empty(this.inVoiceRoomGameInfoList)) {
            return Collections.unmodifiableList(this.inVoiceRoomGameInfoList);
        }
        return Collections.emptyList();
    }

    public List<GameInfo> getCreateRoomGameList() {
        if (FP.empty(this.createRoomGameList)) {
            GameInfo gameInfo = null;
            for (GameCategory category : this.mGameCategory) {
                if (!category.isOutter() || FP.empty((Collection)category.getGameIds())) continue;
                for (String gameId : category.getGameIds()) {
                    gameInfo = this.findGameInfo(gameId, this.inVoiceRoomGameInfoList);
                    if (gameInfo == null || gameInfo.isHide() || "dayingjia".equals(gameInfo.gid)) continue;
                    this.createRoomGameList.add(gameInfo);
                }
            }
        }
        return this.createRoomGameList;
    }

    @Nullable
    private GameInfo findGameInfo(String gid, List<GameInfo> gameInfos) {
        for (GameInfo gameInfo : gameInfos) {
            if (!TextUtils.equals((CharSequence)gameInfo.gid, (CharSequence)gid)) continue;
            return gameInfo;
        }
        return null;
    }

    @Nonnull
    public List<GameInfo> getAllGameInfoList() {
        ArrayList<GameInfo> list = new ArrayList<GameInfo>();
        list.addAll(this.mGameInfoList);
        list.addAll(this.singleGameInfoList);
        return list;
    }

    @NonNull
    public List<GameInfo> getAllPkGameInfoList() {
        if (!FP.empty(this.pkGameInfoList)) {
            return Collections.unmodifiableList(this.pkGameInfoList);
        }
        return Collections.emptyList();
    }

    @Nullable
    public List<GameInfo> getRandomGameInfoList() {
        if (!FP.empty(this.mRandomGameInfoList)) {
            return Collections.unmodifiableList(this.mRandomGameInfoList);
        }
        return null;
    }

    public GameInfo getVoiceRoomGameInfoByGid(String gid) {
        GameInfo gameInfo = null;
        gameInfo = this.findGameInfo(this.voiceRoomGameInfoList, gid);
        return gameInfo;
    }

    public void addGameInfoListener(OnGameInfoChangedListener listener, boolean notifyWhenAdd) {
        if (listener == null) {
            return;
        }
        if (notifyWhenAdd) {
            this.notifyGameInfoChanged(GameInfoSource.HOME, this.mGameInfoList, listener);
            this.notifyGameInfoChanged(GameInfoSource.SINGLE, this.singleGameInfoList, listener);
            this.notifyGameInfoChanged(GameInfoSource.SAMESCEEN, this.sameGameInfoList, listener);
            this.notifyGameInfoChanged(GameInfoSource.VOICE_ROOM, this.voiceRoomGameInfoList, listener);
            this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList, listener);
        }
        if (!this.mGameInfoListener.contains(listener)) {
            this.mGameInfoListener.add(listener);
        }
    }

    public void setImGameInfoListener(OnImGameInfoCHangedListener listener, boolean notifyWhenAdd) {
        this.mImGameInfoCHangedListeners.add(listener);
        if (listener != null && notifyWhenAdd && !FP.empty(this.mImGameInfoList)) {
            listener.onImGameChanged(Collections.unmodifiableList(this.mImGameInfoList));
        }
    }

    public void addPkGameInfoListener(OnPkGameInfoChangedListener listener, boolean notifyWhenAdd) {
        this.mPkGameInfoChangedListener = listener;
        if (this.mPkGameInfoChangedListener != null && notifyWhenAdd) {
            this.mPkGameInfoChangedListener.onPkGameInfoChanged(Collections.unmodifiableList(this.pkGameInfoList));
        }
    }

    public void removePkGameInfoListener() {
        this.mPkGameInfoChangedListener = null;
    }

    public void updateHomeGameInfo(List<GameInfo> list, boolean update) {
        if (!FP.empty(list)) {
            MLog.debug((Object)TAG, (String)"updateHomeGameInfo list: %d, update: %b", (Object[])new Object[]{list.size(), update});
            ArrayList<GameInfo> copyOld = new ArrayList<GameInfo>(this.mGameInfoList);
            this.mGameInfoList.clear();
            if (update) {
                ArrayList<GameInfo> updateList = new ArrayList<GameInfo>(list.size());
                for (GameInfo info : list) {
                    GameInfo old = this.findGameInfo(copyOld, info.getGid());
                    if (old != null) {
                        old.updateInfo(GameInfo.newBuilder((GameInfo)info));
                    } else {
                        old = info;
                    }
                    updateList.add(old);
                }
                if (!updateList.isEmpty()) {
                    this.mGameInfoList.removeAll(updateList);
                    this.mGameInfoList.addAll(updateList);
                }
            } else {
                this.mGameInfoList.addAll(list);
            }
            this.notifyGameInfoChanged(GameInfoSource.HOME, this.mGameInfoList);
            if (!FP.empty(this.mGameInfoList)) {
                ArrayList<GameInfo> listCopy = new ArrayList<GameInfo>(this.mGameInfoList);
                if (this.mImGameInfoList.isEmpty()) {
                    this.mImGameInfoList.clear();
                    for (GameInfo info : listCopy) {
                        if (info.isHide() || info.getGameMode() != 1 && info.getGameMode() != 4 && info.getGameMode() != 7) continue;
                        this.mImGameInfoList.add(info);
                    }
                    this.notifyImGameInfoChanged();
                }
                this.pkGameInfoList.clear();
                for (GameInfo info : listCopy) {
                    if (info == null || info.getGameMode() != 1) continue;
                    this.pkGameInfoList.add(info);
                }
                this.notifyPkGameInfoListChanged();
                this.mRandomGameInfoList.clear();
                for (GameInfo info : listCopy) {
                    if (info == null || !info.isShowForRandRoom()) continue;
                    this.mRandomGameInfoList.add(info);
                }
            }
        }
    }

    public void updateImGameInfo(List<GameInfo> list) {
        if (!FP.empty(list)) {
            this.mImGameInfoList.clear();
            this.mImGameInfoList.addAll(list);
            this.notifyImGameInfoChanged();
        }
    }

    public void updateSingleGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateSingleGameInfo from %d", (Object[])new Object[]{list != null ? list.size() : 0});
        }
        if (!FP.empty(list)) {
            this.singleGameInfoList.clear();
            this.singleGameInfoList.addAll(list);
            this.notifyGameInfoChanged(GameInfoSource.SINGLE, this.singleGameInfoList);
        }
    }

    public void updateSameScreenGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateSameScreenGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (FP.empty(list)) {
            return;
        }
        this.sameGameInfoList.clear();
        this.sameGameInfoList.addAll(list);
        this.notifyGameInfoChanged(GameInfoSource.SAMESCEEN, this.sameGameInfoList);
    }

    public void updateVoiceRoomGameInfo(List<GameInfo> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateVoiceRoomGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (list == null) {
            return;
        }
        this.voiceRoomGameInfoList.clear();
        this.voiceRoomGameInfoList.addAll(list);
        this.notifyGameInfoChanged(GameInfoSource.VOICE_ROOM, this.voiceRoomGameInfoList);
    }

    public void updateInVoiceRoomGameInfo(List<GameInfo> list, List<GameInfo> floatList) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"updateVoiceRoomGameInfo list: %s", (Object[])new Object[]{FP.size(list)});
        }
        if (list == null) {
            return;
        }
        this.inVoiceRoomGameInfoList.clear();
        this.inVoiceRoomGameInfoList.addAll(list);
        this.floatGameInfoList.clear();
        this.floatGameInfoList.addAll(floatList);
        this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList);
    }

    public void updateVoiceRoomGameCateInfo(@Nullable List<GameCategory> voiceRoomGameCategory) {
        this.mGameCategory.clear();
        if (voiceRoomGameCategory != null) {
            this.mGameCategory.addAll(voiceRoomGameCategory);
        }
    }

    public List<GameCategory> getVoiceRoomGameCategory() {
        return this.mGameCategory;
    }

    public void addOrUpdateNoneModeGameInfo(List<GameInfo> gameInfoList) {
        if (FP.empty(gameInfoList)) {
            MLog.warn((Object)TAG, (String)"addOrUpdateGameInfo fail, gameInfo is null or empty", (Object[])new Object[0]);
            return;
        }
        MLog.debug((Object)TAG, (String)("addOrUpdateGameInfo list: " + gameInfoList.size()), (Object[])new Object[0]);
        for (GameInfo newGameInfo : gameInfoList) {
            GameInfo old = this.getGameInfoByGid(newGameInfo.getGid());
            if (old == null) {
                MLog.debug((Object)TAG, (String)"addOrUpdateGameInfo add gameInfo: %s", (Object[])new Object[]{newGameInfo});
                this.mNoneModeGameList.add(newGameInfo);
                continue;
            }
            if (old.getGameMode() != 0) continue;
            old.updateInfo(GameInfo.newBuilder((GameInfo)newGameInfo));
            MLog.debug((Object)TAG, (String)"addOrUpdateGameInfo update gameInfo: %s", (Object[])new Object[]{old});
        }
    }

    public void onAccountChanged() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAccountChanged", (Object[])new Object[0]);
        }
        this.inVoiceRoomGameInfoList.clear();
        this.notifyGameInfoChanged(GameInfoSource.IN_VOICE_ROOM, this.inVoiceRoomGameInfoList);
    }

    public void removeGameInfoListener(OnGameInfoChangedListener listener) {
        if (!this.mGameInfoListener.contains(listener)) {
            return;
        }
        this.mGameInfoListener.remove(listener);
    }

    private void notifyImGameInfoChanged() {
        if (FP.empty(this.mImGameInfoList) || this.mImGameInfoCHangedListeners.isEmpty()) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.notifyChange();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameInfoService.this.notifyChange();
                }
            });
        }
    }

    private void notifyChange() {
        for (OnImGameInfoCHangedListener item : this.mImGameInfoCHangedListeners) {
            item.onImGameChanged(Collections.unmodifiableList(this.mImGameInfoList));
        }
    }

    private void notifyGameInfoChanged(final GameInfoSource source, List<GameInfo> gameList) {
        if (FP.empty(gameList) || this.mGameInfoListener.isEmpty()) {
            return;
        }
        final ArrayList<GameInfo> infos = new ArrayList<GameInfo>(gameList);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (OnGameInfoChangedListener listener : GameInfoService.this.mGameInfoListener) {
                    listener.onGameInfoChanged(source, infos);
                }
            }
        });
    }

    private void notifyGameInfoChanged(final GameInfoSource source, List<GameInfo> gameList, final OnGameInfoChangedListener listener) {
        if (FP.empty(gameList) || listener == null) {
            return;
        }
        final ArrayList<GameInfo> infos = new ArrayList<GameInfo>(gameList);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                listener.onGameInfoChanged(source, infos);
            }
        });
    }

    public boolean isAllGameListReady() {
        return !FP.empty(this.mGameInfoList);
    }

    public boolean isOftenPlayUser(String gameId) {
        boolean isOftenPlayUser = false;
        KvoSource source = KvoModuleManager.getModuleData(GameInfoModule.class);
        if (source instanceof GameInfoModuleData) {
            List gamePlayList;
            GamePlayInfo gamePlayInfo;
            Map gamePlayInfoMap = ((GameInfoModuleData)source).getGameCacheInfo();
            if (!TextUtils.isEmpty((CharSequence)gameId) && gamePlayInfoMap != null && (gamePlayInfo = (GamePlayInfo)gamePlayInfoMap.get(gameId)) != null && !FP.empty((Collection)(gamePlayList = gamePlayInfo.getGamePlayList()))) {
                CommonConfigData data;
                int count = 0;
                int days = 7;
                int times = 15;
                AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
                if (config instanceof CommonConfig && (data = ((CommonConfig)config).getData()) != null) {
                    days = data.oftenPlayUserDays;
                    times = data.oftenPlayUserTimes;
                }
                for (GamePlayInfoDBBean item : gamePlayList) {
                    long diff;
                    if (item == null || (diff = System.currentTimeMillis() - item.getEndTs()) > (long)(days * 24 * 60 * 60 * 1000) || item.getUid() != AccountUtil.getUid()) continue;
                    ++count;
                }
                if (count >= times) {
                    isOftenPlayUser = true;
                }
            }
        }
        return isOftenPlayUser;
    }

    public boolean hasLoadRoomGameList() {
        return this.hasLoadRoomGameList || !this.voiceRoomGameInfoList.isEmpty();
    }

    public boolean hasLoadInRoomGameList() {
        return this.hasLoadInRoomGameList || !this.inVoiceRoomGameInfoList.isEmpty();
    }

    public void setRoomGameLoaded() {
        this.hasLoadRoomGameList = true;
    }

    public void setRoomInGameLoaded() {
        this.hasLoadInRoomGameList = true;
    }

    public String getAlgorithmTokenUrlencode() {
        return HomeReportUtils.INSTANCE.getAlgorithmTokenUrlencode();
    }

    private void notifyPkGameInfoListChanged() {
        if (this.mPkGameInfoChangedListener == null) {
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            this.mPkGameInfoChangedListener.onPkGameInfoChanged(Collections.unmodifiableList(this.pkGameInfoList));
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GameInfoService.this.mPkGameInfoChangedListener.onPkGameInfoChanged(Collections.unmodifiableList(GameInfoService.this.pkGameInfoList));
                }
            });
        }
    }

    public void resetGame() {
        ((ICoinsService)ServiceManagerProxy.getService(ICoinsService.class)).resetGame();
        this.voiceRoomGameInfoList.clear();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                FileStorageUtils.getInstance().saveToFile(true, "", "VoiceRoomGameList");
            }
        });
    }
}

