/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d.net;

import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.MediaType;
import com.yy.grace.Request;
import com.yy.grace.RequestBody;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.webgame.runtime.GameLauncher;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class CocsGameHttpProxy {
    private static final String TAG = "CocsGameHttpProxy";
    private static final MediaType DEFAULT_MEADIA_TYPE = MediaType.get((String)"application/x-www-form-urlencoded");

    public static void cocosGameHttpProxy(final int method, final String url, byte[] body, String requestHeaders, int readTimeoutMS, int writeTimeoutMS, int connectTimeOutMS, final int tag, final GameLauncher mGameLauncher) {
        MLog.debug((Object)TAG, (String)("cocosGameHttpProxy method " + method + " url " + url), (Object[])new Object[0]);
        Request.Builder<ResponseBody> builder = new Request.Builder<ResponseBody>(){};
        builder.url(url).connectTimeout((long)connectTimeOutMS, TimeUnit.MILLISECONDS).readTimeout((long)readTimeoutMS, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMS, TimeUnit.MILLISECONDS).tag((Object)tag);
        String contentType = null;
        if (!TextUtils.isEmpty((CharSequence)requestHeaders)) {
            String[] headerList = requestHeaders.split(",");
            int len = headerList.length;
            for (int i = 0; i < len; ++i) {
                String[] keyValuePair = headerList[i].split(":");
                if (keyValuePair.length == 2) {
                    String key = keyValuePair[0].trim();
                    String value = keyValuePair[1].trim();
                    builder.header(key, value);
                    if (!key.equals("Content-Type")) continue;
                    contentType = value;
                    continue;
                }
                MLog.error((Object)TAG, (String)("Invalid key value pair: " + keyValuePair.length), (Object[])new Object[0]);
            }
        }
        RequestBody requestBody = null;
        if (body != null) {
            MediaType mediaType = TextUtils.isEmpty(contentType) ? DEFAULT_MEADIA_TYPE : MediaType.parse(contentType);
            requestBody = RequestBody.create((MediaType)mediaType, (byte[])body);
        }
        switch (method) {
            case 0: {
                builder.get();
                break;
            }
            case 1: {
                builder.post(requestBody);
                break;
            }
            case 2: {
                builder.put(requestBody);
                break;
            }
            case 3: {
                if (requestBody != null) {
                    builder.delete(requestBody);
                    break;
                }
                builder.delete();
                break;
            }
            case 4: {
                builder.patch(requestBody);
                break;
            }
            default: {
                MLog.error((Object)TAG, (String)("onHttpConnectionSend, wrong method: " + method), (Object[])new Object[0]);
            }
        }
        builder.group((Request.Group)BizScenc.GAME_SERVICE);
        GraceUtil.getGrace().newCall(builder.build()).enqueue((Callback)new Callback<ResponseBody>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                MLog.debug((Object)CocsGameHttpProxy.TAG, (String)("onResponse method " + method + " url " + url), (Object[])new Object[0]);
                ResponseBody body = null;
                try {
                    body = (ResponseBody)response.body();
                    byte[] data = null;
                    if (body != null) {
                        data = body.bytes();
                    }
                    if (mGameLauncher != null) {
                        mGameLauncher.notifyHttpConnectionResponse(response.code(), response.raw().headersToString(), data, tag);
                    }
                }
                catch (IOException e) {
                    MLog.error((Object)CocsGameHttpProxy.TAG, (String)("request error " + url), (Throwable)e, (Object[])new Object[0]);
                    if (mGameLauncher != null) {
                        mGameLauncher.notifyHttpConnectionFailure(e.getMessage(), tag);
                    }
                }
                finally {
                    if (response != null && response.body() != null) {
                        ((ResponseBody)response.body()).close();
                    }
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable e) {
                MLog.error((Object)CocsGameHttpProxy.TAG, (String)"Http Request (%s) onFailure: %s, tag: %d", (Object[])new Object[]{url, e != null ? e.getMessage() : "Unknown", tag});
                if (mGameLauncher != null) {
                    mGameLauncher.notifyHttpConnectionFailure(e.getMessage(), tag);
                }
            }
        });
    }
}

