/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.game.cocos2d.IWebSocket;
import com.yy.game.cocos2d.IWebSocketCallback;
import com.yy.game.cocos2d.net.GameWebInfo;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import common.Header;
import ikxd.gameproxy.GameDataNotify;
import ikxd.gameproxy.GameDataReq;
import ikxd.gameproxy.GameProxy;
import ikxd.gameproxy.Uri;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import okio.ByteString;

public class WebSocketProxy
implements IWebSocket {
    private static final String TAG = "JavaWebSocketProxy";
    private static final String TAG_PROXY = "WebSocketProxy";
    static final int SERVICE_ERROR = -1001;
    static final int SOCKET_ERROR = -1002;
    static final int SERVICE_SOCKET_CLOSE = -1003;
    private boolean sIsGameProxyRegistered = false;
    private static final int WS_PROXY_COMMAND_OPEN = 1;
    private static final int WS_PROXY_COMMAND_MSG = 2;
    private static final int WS_PROXY_COMMAND_CLOSE = 3;
    private static final int WS_PROXY_COMMAND_ERROR = 4;
    private static final int CONNECT_SUCCESS = 2;
    private static final int CONNECTING = 1;
    private static final int DIS_CONNECTED = 4;
    private final ArrayList<ConnectIDContextStruct> sWSCIDNeedClosed = new ArrayList(8);
    private int sNetworkState = 2;
    private IProtoNotify sNotify = new IProtoNotify<GameProxy>(){

        public String serviceName() {
            return "ikxd_gameproxy_d";
        }

        public void onNotify(@NonNull GameProxy result) {
            if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)WebSocketProxy.TAG_PROXY, (String)"IKXD_GAMEPROXY_notify", (Object[])new Object[0]);
            }
            if (result.uri == Uri.kUriGameDataNotify) {
                GameDataNotify gameDataNotify;
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)WebSocketProxy.TAG_PROXY, (String)"kUriGameDataNotify_have receive", (Object[])new Object[0]);
                }
                if ((gameDataNotify = result.game_data_notify) != null) {
                    if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)WebSocketProxy.TAG_PROXY, (String)"kUriGameDataNotify_have receive gameDataNotify=%s", (Object[])new Object[]{gameDataNotify});
                    }
                    WebSocketProxy.this.appReceiveData(result.header.roomid, new String(gameDataNotify.header.toByteArray()), gameDataNotify.body.toByteArray());
                }
            }
        }
    };
    private ISocketStateChangeListener sSocketStateChangeListener = new ISocketStateChangeListener(){

        public void onSocketStateChanged(int code, String wsUrl, String errorInfo) {
            MLog.error((Object)WebSocketProxy.TAG, (String)"onSocketStateChanged code=%d", (Object[])new Object[]{code});
            int state = 4;
            if (code == 102) {
                state = 2;
            } else if (code == 103) {
                state = 1;
            }
            WebSocketProxy.this.onAppChannelStateChanged(state, errorInfo);
        }
    };
    private final HashMap<Integer, WeakReference<WebSocketProxy>> sWebSocketProxyMap = new HashMap(1);
    private static int sCIDCounter = 0;
    private final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final int READY_STATE_CONNECTING = 0;
    private static final int READY_STATE_OPEN = 1;
    private static final int READY_STATE_CLOSING = 2;
    private static final int READY_STATE_CLOSED = 3;
    private final byte[] mProxySendTextHeader;
    private final byte[] mProxySendBinaryHeader;
    private final byte[] mProxyCloseHeader;
    private static final int WEBSOCKET_TIMEOUT_MS = 10000;
    private static final int WEBSOCKET_ERROR_DELAY_MS = 1000;
    private final int mCID;
    private IWebSocketCallback mWebSocketCallback;
    private int mReadyState = 0;
    private String mContext = "";
    private String mGameId = "";
    private final Handler mTimeoutHandler = new Handler(Looper.getMainLooper());
    private Runnable mErrorRunnable = new Runnable(){

        @Override
        public void run() {
            WebSocketProxy.this.notifyWebSocketOnError("", -2);
        }
    };

    private boolean isChannelReady() {
        return this.sNetworkState == 2;
    }

    public void proxySend(String context, byte[] header, byte[] body) {
        if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG_PROXY, (String)"proxySend %s", (Object[])new Object[]{context});
        }
        GameDataReq req = new GameDataReq.Builder().header(ByteString.of((byte[])header)).body(ByteString.of((byte[])body)).build();
        final Header pheader = ProtoManager.getInstance().getHeaderBuilder("ikxd_gameproxy_d").roomid(context).gameid(this.mGameId).build();
        GameProxy gameProxy = new GameProxy.Builder().header(pheader).uri(Uri.kUriGameDataReq).game_data_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)gameProxy, (IProtoCallback)new IProtoCallback<GameProxy>(){

            public void onResponse(@Nullable GameProxy message) {
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)WebSocketProxy.TAG_PROXY, (String)"proxySend retryWhenTimeout : %s ,seqId = %s", (Object[])new Object[]{canRetry, pheader.seqid});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)WebSocketProxy.TAG_PROXY, (String)"proxySend retryWhenError", (Object[])new Object[0]);
                return false;
            }

            public long getCacheEffectiveTime() {
                return 0L;
            }
        });
    }

    public static int isWSConnected() {
        if (!SettingFlags.getBoolean((String)"gameuseclientws", (boolean)true)) {
            return 0;
        }
        return ProtoManager.getInstance().isWSConnected() ? 1 : 0;
    }

    public void registerGameProxyNotify() {
        if (!this.sIsGameProxyRegistered) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"registerGameProxyNotify", (Object[])new Object[0]);
            }
            ProtoManager.getInstance().registerNotify(this.sNotify);
            ProtoManager.getInstance().addSocketStateChangeListener(this.sSocketStateChangeListener);
            this.sIsGameProxyRegistered = true;
        }
    }

    public void unregisterGameProxyNotify() {
        if (this.sIsGameProxyRegistered) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"unregisterGameProxyNotify", (Object[])new Object[0]);
            }
            ProtoManager.getInstance().unregisterNotify(this.sNotify);
            ProtoManager.getInstance().removeSocketStateChangeListener(this.sSocketStateChangeListener);
            this.sIsGameProxyRegistered = false;
        }
    }

    private ProxyDataHeader parseHeader(String header) {
        String trimmedHeader = header.trim();
        if (trimmedHeader.charAt(0) != '[') {
            MLog.error((Object)TAG, (String)("trimmedHeader[0] is not [, header: " + header), (Object[])new Object[0]);
            return null;
        }
        if (trimmedHeader.charAt(trimmedHeader.length() - 1) != ']') {
            MLog.error((Object)TAG, (String)("trimmedHeader[' + (trimmedHeader.length-1) + '] is not ], header: " + header), (Object[])new Object[0]);
            return null;
        }
        String removeBracketHeader = trimmedHeader.substring(1, trimmedHeader.length() - 1);
        String[] elements = removeBracketHeader.split(",");
        if (elements.length != 2 && elements.length != 3) {
            MLog.error((Object)TAG, (String)("Wrong element count: " + elements.length + ", header: " + header), (Object[])new Object[0]);
            return null;
        }
        ProxyDataHeader ret = new ProxyDataHeader();
        ret.command = Integer.parseInt(elements[0].trim());
        ret.connectID = Integer.parseInt(elements[1].trim());
        ret.opcode = elements.length == 3 ? Integer.parseInt(elements[2].trim()) : -1;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appReceiveData(String context, String header, byte[] body) {
        ProxyDataHeader headerObj = this.parseHeader(header);
        if (headerObj == null) {
            MLog.error((Object)TAG, (String)"appReceiveData, parseHeader failed, header: %s", (Object[])new Object[]{header});
            return;
        }
        int command2 = headerObj.command;
        int connectionID = headerObj.connectID;
        WeakReference<WebSocketProxy> weakWs = null;
        HashMap<Integer, WeakReference<WebSocketProxy>> hashMap = this.sWebSocketProxyMap;
        synchronized (hashMap) {
            weakWs = this.sWebSocketProxyMap.get(connectionID);
        }
        if (weakWs == null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"appReceiveData, couldn't find WebSocket instance!", (Object[])new Object[0]);
            }
            return;
        }
        WebSocketProxy ws = (WebSocketProxy)weakWs.get();
        if (ws == null || ws.mWebSocketCallback == null) {
            MLog.error((Object)TAG, (String)"appReceiveData, couldn't find WebSocket instance!", (Object[])new Object[0]);
            return;
        }
        if (command2 == 1) {
            ws.notifyWebSocketOnOpen("");
        } else if (command2 == 2) {
            if (headerObj.opcode == 1) {
                ws.notifyWebSocketOnStringMessage(new String(body));
            } else {
                ws.notifyWebSocketOnBinaryMessage(body);
            }
        } else if (command2 == 4) {
            ws.notifyWebSocketOnError("", -1001);
        } else if (command2 == 3) {
            ws.notifyWebSocketOnClose("");
        } else {
            MLog.error((Object)TAG, (String)"Invalid command: %d", (Object[])new Object[]{command2});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<WebSocketProxy> getWebSocketProxyList() {
        ArrayList<WebSocketProxy> gameProxys = null;
        HashMap<Integer, WeakReference<WebSocketProxy>> hashMap = this.sWebSocketProxyMap;
        synchronized (hashMap) {
            if (this.sWebSocketProxyMap.size() <= 0) {
                return null;
            }
            gameProxys = new ArrayList<WebSocketProxy>(this.sWebSocketProxyMap.size());
            WeakReference<WebSocketProxy> weakWs = null;
            WebSocketProxy ws = null;
            Set<Integer> keys = this.sWebSocketProxyMap.keySet();
            if (keys != null && keys.size() > 0) {
                for (Integer key : keys) {
                    weakWs = this.sWebSocketProxyMap.get(key);
                    if (weakWs == null || (ws = (WebSocketProxy)weakWs.get()) == null || ws.mWebSocketCallback == null) continue;
                    gameProxys.add(ws);
                }
            }
        }
        return gameProxys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAppChannelStateChanged(int state, String errorInfo) {
        ArrayList<WebSocketProxy> gameProxys;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"onAppChannelStateChanged: state: %d", (Object[])new Object[]{state});
        }
        this.sNetworkState = state;
        if (state == 2) {
            ArrayList<ConnectIDContextStruct> arrayList = this.sWSCIDNeedClosed;
            synchronized (arrayList) {
                for (ConnectIDContextStruct e : this.sWSCIDNeedClosed) {
                    String closeHeader = "[3," + e.mConnectID + "]";
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"onAppChannelStateChanged, send close event (cid: %d, context: %s) to game proxy!", (Object[])new Object[]{e.mConnectID, e.mContext});
                    }
                    this.proxySend(e.mContext, closeHeader.getBytes(), this.EMPTY_BYTE_ARRAY);
                }
                this.sWSCIDNeedClosed.clear();
            }
        }
        if (state == 4 && (gameProxys = this.getWebSocketProxyList()) != null && !gameProxys.isEmpty()) {
            for (WebSocketProxy item : gameProxys) {
                ArrayList<ConnectIDContextStruct> arrayList = this.sWSCIDNeedClosed;
                synchronized (arrayList) {
                    this.sWSCIDNeedClosed.add(new ConnectIDContextStruct(item.mCID, item.mContext));
                }
                item.notifyWebSocketOnError(errorInfo, -1002);
            }
        }
    }

    WebSocketProxy() {
        this.mCID = ++sCIDCounter;
        this.mProxySendTextHeader = ("[2," + this.mCID + ",1]").getBytes();
        this.mProxySendBinaryHeader = ("[2," + this.mCID + ",2]").getBytes();
        this.mProxyCloseHeader = ("[3," + this.mCID + "]").getBytes();
    }

    protected void finalize() throws Throwable {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"finalize: mCID: %d", (Object[])new Object[]{this.mCID});
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(String url, String protocols, IWebSocketCallback cb, String roomId, String gameId) {
        this.registerGameProxyNotify();
        this.mContext = roomId;
        this.mGameId = gameId;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"WS open, context: %s", (Object[])new Object[]{this.mContext});
        }
        this.mWebSocketCallback = cb;
        if (this.isChannelReady()) {
            HashMap<Integer, WeakReference<WebSocketProxy>> hashMap = this.sWebSocketProxyMap;
            synchronized (hashMap) {
                this.sWebSocketProxyMap.put(this.mCID, new WeakReference<WebSocketProxy>(this));
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"open, sWebSocketProxyMap size: %d", (Object[])new Object[]{this.sWebSocketProxyMap.size()});
                }
            }
            String header = "[1," + this.mCID + ",\"" + url + "\"]";
            this.proxySend(this.mContext, header.getBytes(), this.EMPTY_BYTE_ARRAY);
            this.mTimeoutHandler.postDelayed(this.mErrorRunnable, 10000L);
        } else {
            this.mTimeoutHandler.postDelayed(this.mErrorRunnable, 1000L);
        }
    }

    @Override
    public void sendString(String message) {
        if (this.mReadyState == 1) {
            if (this.isChannelReady()) {
                this.proxySend(this.mContext, this.mProxySendTextHeader, message.getBytes());
            } else {
                MLog.error((Object)TAG, (String)"sendString, channel isn't ready!", (Object[])new Object[0]);
            }
        } else {
            MLog.error((Object)TAG, (String)"sendString ws isn't opened!", (Object[])new Object[0]);
        }
    }

    @Override
    public void sendBinary(byte[] message) {
        if (this.mReadyState == 1) {
            if (this.isChannelReady()) {
                this.proxySend(this.mContext, this.mProxySendBinaryHeader, message);
            } else {
                MLog.error((Object)TAG, (String)"sendBinary, channel isn't ready!", (Object[])new Object[0]);
            }
        } else {
            MLog.error((Object)TAG, (String)"sendBinary ws isn't opened!", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"WS connection id (%d), context (%s) requests to close!", (Object[])new Object[]{this.mCID, this.mContext});
        }
        if (this.mReadyState == 2 || this.mReadyState == 3) {
            return;
        }
        this.mReadyState = 2;
        if (this.isChannelReady()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"close, ws cid (%d) context (%s) send close event to gameproxy!", (Object[])new Object[]{this.mCID, this.mContext});
            }
            this.proxySend(this.mContext, this.mProxyCloseHeader, this.EMPTY_BYTE_ARRAY);
        } else {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"channel isn't ready, cache cid (%d) context (%s)", (Object[])new Object[]{this.mCID, this.mContext});
            }
            ArrayList<ConnectIDContextStruct> arrayList = this.sWSCIDNeedClosed;
            synchronized (arrayList) {
                this.sWSCIDNeedClosed.add(new ConnectIDContextStruct(this.mCID, this.mContext));
            }
        }
        this.unregisterGameProxyNotify();
        this.notifyWebSocketOnClose("");
    }

    @Override
    public void cleanup() {
        this.unregisterGameProxyNotify();
    }

    private void clearTimeoutTimer() {
        if (this.mErrorRunnable != null) {
            this.mTimeoutHandler.removeCallbacks(this.mErrorRunnable);
            this.mErrorRunnable = null;
        }
    }

    private void notifyWebSocketOnOpen(String selectedProtocol) {
        this.mReadyState = 1;
        this.clearTimeoutTimer();
        if (this.mWebSocketCallback != null) {
            this.mWebSocketCallback.onWebSocketOpen(selectedProtocol, new GameWebInfo());
        }
    }

    private void notifyWebSocketOnStringMessage(String message) {
        if (this.mWebSocketCallback != null) {
            this.mWebSocketCallback.onWebSocketStringMessage(message);
        }
    }

    private void notifyWebSocketOnBinaryMessage(byte[] message) {
        if (this.mWebSocketCallback != null) {
            this.mWebSocketCallback.onWebSocketBinaryMessage(message);
        }
    }

    private void notifyWebSocketOnError(final String errorInfo, final int code) {
        if (this.mReadyState == 2 || this.mReadyState == 3) {
            MLog.warn((Object)TAG, (String)"notifyWebSocketOnError, cid (%d) is closing or closed!", (Object[])new Object[]{this.mCID});
            return;
        }
        this.mReadyState = 2;
        this.mTimeoutHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (WebSocketProxy.this.mWebSocketCallback != null) {
                    WebSocketProxy.this.mWebSocketCallback.onWebSocketError(errorInfo, null, null, code);
                }
                WebSocketProxy.this.notifyWebSocketOnCloseWithoutDelay(errorInfo);
            }
        }, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebSocketOnCloseWithoutDelay(String reason) {
        if (this.mReadyState != 3) {
            this.clearTimeoutTimer();
            this.mReadyState = 3;
            if (this.mWebSocketCallback != null) {
                this.mWebSocketCallback.onWebSocketClose(reason, -1);
            }
            HashMap<Integer, WeakReference<WebSocketProxy>> hashMap = this.sWebSocketProxyMap;
            synchronized (hashMap) {
                this.sWebSocketProxyMap.remove(this.mCID);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"notifyWebSocketOnCloseWithoutDelay, sWebSocketProxyMap size: %d", (Object[])new Object[]{this.sWebSocketProxyMap.size()});
                }
            }
        } else {
            MLog.error((Object)TAG, (String)"notifyWebSocketOnCloseWithoutDelay cid %d was closed!", (Object[])new Object[]{this.mCID});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWebSocketOnClose(final String reason) {
        if (this.mReadyState != 3) {
            this.clearTimeoutTimer();
            this.mReadyState = 3;
            final IWebSocketCallback cb = this.mWebSocketCallback;
            this.mTimeoutHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (cb != null) {
                        cb.onWebSocketClose(reason, -1);
                    }
                }
            }, 1000L);
            HashMap<Integer, WeakReference<WebSocketProxy>> hashMap = this.sWebSocketProxyMap;
            synchronized (hashMap) {
                this.sWebSocketProxyMap.remove(this.mCID);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"notifyWebSocketOnClose, sWebSocketProxyMap size: %d", (Object[])new Object[]{this.sWebSocketProxyMap.size()});
                }
            }
        } else {
            MLog.error((Object)TAG, (String)"notifyWebSocketOnClose cid %d was closed!", (Object[])new Object[]{this.mCID});
        }
    }

    static class ProxyDataHeader {
        int command;
        int connectID;
        int opcode;

        ProxyDataHeader() {
        }
    }

    private static class ConnectIDContextStruct {
        int mConnectID;
        String mContext;

        ConnectIDContextStruct(int cid, String context) {
            this.mConnectID = cid;
            this.mContext = context;
        }
    }
}

