/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.ws.OkHttpWsClientWrap;
import com.yy.base.okhttp.websocket.ws.RealWebSocket;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.cocos2d.IWebSocket;
import com.yy.game.cocos2d.IWebSocketCallback;
import com.yy.game.cocos2d.net.GameWebInfo;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class WebSocketDirect
implements IWebSocket {
    private static final String TAG = "WebSocketDirect";
    private OkHttpClient mOkHttpClient;
    private boolean mIsShareOkHttpClient;
    private WebSocket mWebSocketImpl;
    private IWebSocketCallback mWebSocketCallback;
    GameWebInfo mGameWebInfo = new GameWebInfo();

    WebSocketDirect(OkHttpClient okHttpClient, boolean shareOkHttpClient) {
        this.mOkHttpClient = okHttpClient;
        this.mIsShareOkHttpClient = shareOkHttpClient;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"WebSocketDirect.finalize", (Object[])new Object[0]);
        }
    }

    @Override
    public void open(String url, String protocols, IWebSocketCallback cb, String roomId, String gameId) {
        this.mWebSocketCallback = cb;
        Headers.Builder headerBuilder = new Headers.Builder();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"websocket.open : %s", (Object[])new Object[]{url});
        }
        if (!protocols.isEmpty()) {
            headerBuilder.add("Sec-WebSocket-Protocol", protocols);
        }
        Headers headers = headerBuilder.build();
        Request request = new Request.Builder().get().headers(headers).url(url).build();
        OkHttpWsClientWrap hagoWsClient = new OkHttpWsClientWrap(this.mOkHttpClient.newBuilder());
        hagoWsClient.setUseCommonState(false);
        this.mWebSocketImpl = hagoWsClient.newWebSocket(request, new WebSocketListener(){
            private boolean mIsOnCloseCallbackInvoked = false;

            public void onOpen(WebSocket webSocket, Response response) {
                super.onOpen(webSocket, response);
                String selectedProtocol = response.header("Sec-WebSocket-Protocol", "");
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)WebSocketDirect.TAG, (String)"websocket.onOpen, selectedProtocol: %s", (Object[])new Object[]{selectedProtocol});
                }
                if (webSocket instanceof RealWebSocket) {
                    WebSocketDirect.this.mGameWebInfo.setRemoteIp(((RealWebSocket)webSocket).getRemoteIp());
                }
                WebSocketDirect.this.mWebSocketCallback.onWebSocketOpen(selectedProtocol, WebSocketDirect.this.mGameWebInfo);
            }

            public void onMessage(WebSocket webSocket, String text) {
                super.onMessage(webSocket, text);
                WebSocketDirect.this.mWebSocketCallback.onWebSocketStringMessage(text);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                super.onMessage(webSocket, bytes);
                WebSocketDirect.this.mWebSocketCallback.onWebSocketBinaryMessage(bytes.toByteArray());
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)WebSocketDirect.TAG, (String)"websocket.onClosing", (Object[])new Object[0]);
                }
                super.onClosing(webSocket, code, reason);
            }

            public void onClosed(WebSocket webSocket, final int code, final String reason) {
                super.onClosed(webSocket, code, reason);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)WebSocketDirect.TAG, (String)"websocket.onClosed, code: %d, reason: %s", (Object[])new Object[]{code, reason});
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!mIsOnCloseCallbackInvoked) {
                            WebSocketDirect.this.mWebSocketCallback.onWebSocketClose(reason, code);
                            mIsOnCloseCallbackInvoked = true;
                        }
                    }
                }, (long)1000L);
            }

            public void onFailure(WebSocket webSocket, final Throwable t, final Response response) {
                super.onFailure(webSocket, t, response);
                MLog.error((Object)WebSocketDirect.TAG, (String)"websocket.onFailure: %s", (Object[])new Object[]{t != null ? t.toString() : ""});
                final String errorInfo = t != null ? t.toString() : "";
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebSocketDirect.this.mWebSocketCallback.onWebSocketError(errorInfo, t, response, -2);
                        if (!mIsOnCloseCallbackInvoked) {
                            WebSocketDirect.this.mWebSocketCallback.onWebSocketClose("", -1);
                            mIsOnCloseCallbackInvoked = true;
                        }
                    }
                }, (long)1000L);
            }
        });
    }

    @Override
    public void sendString(String message) {
        if (this.mWebSocketImpl != null) {
            this.mWebSocketImpl.send(message);
        } else {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("WebSocketDirectsendString when WebSocketImpl not Exist!");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendString when WebSocketImpl not Exist!", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void sendBinary(byte[] message) {
        if (this.mWebSocketImpl != null) {
            this.mWebSocketImpl.send(ByteString.of((byte[])message, (int)0, (int)message.length));
        } else {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("WebSocketDirectsendBinary when WebSocketImpl not Exist!");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"sendBinary when WebSocketImpl not Exist!", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void close() {
        if (this.mWebSocketImpl != null) {
            this.mWebSocketImpl.close(1000, "close by myself");
        } else {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("WebSocketDirectclose when WebSocketImpl not Exist!");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"close when WebSocketImpl not Exist!", (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void cleanup() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("cleanup: mIsShareOkHttpClient: " + this.mIsShareOkHttpClient), (Object[])new Object[0]);
        }
        if (!this.mIsShareOkHttpClient && this.mOkHttpClient != null) {
            WebSocketDirect.cleanupOkHttpClient(this.mOkHttpClient);
        }
    }

    private static void cleanupOkHttpClient(OkHttpClient client) {
        try {
            if (client != null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cleanupOkHttpClient", (Object[])new Object[0]);
                }
                client.dispatcher().cancelAll();
                client.dispatcher().executorService().shutdown();
                client.connectionPool().evictAll();
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"cleanupOkHttpClient failed, message: %s", (Object[])new Object[]{e.getMessage()});
        }
    }
}

