/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d;

import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.game.cocos2d.IWsMonitor;
import com.yy.game.cocos2d.net.GameWebInfo;
import com.yy.yylite.commonbase.hiido.CalActionDefine;
import com.yy.yylite.commonbase.hiido.HiidoGroupReporter;
import com.yy.yylite.commonbase.hiido.HiidoNormalEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J$\u0010$\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010)\u001a\u00020!2\b\u0010*\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010,\u001a\u00020!2\u0006\u0010-\u001a\u00020\u0010H\u0016J\b\u0010.\u001a\u00020!H\u0016J\u0012\u0010/\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010+H\u0016J\u0012\u0010/\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u00101\u001a\u00020!2\u0006\u00102\u001a\u00020\u0003H\u0016J\u0012\u00103\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0002J(\u00104\u001a\u00020!2\u0006\u00102\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u00105\u001a\u00020!2\u0006\u00102\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u00106\u001a\u00020!2\u0006\u00102\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J \u00107\u001a\u00020!2\u0006\u00108\u001a\u00020+2\u0006\u0010\"\u001a\u00020#2\u0006\u00109\u001a\u00020\fH\u0002J\u0010\u0010:\u001a\u00020!2\u0006\u00108\u001a\u00020+H\u0002R\u0014\u0010\u0007\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\tR\u000e\u0010\u0019\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/yy/game/cocos2d/NetMetricsMonitor;", "Lcom/yy/game/cocos2d/IWsMonitor;", "gameId", "", "netType", "roomId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "TAG", "getTAG", "()Ljava/lang/String;", "getGameId", "isClosed", "", "isFailed", "isOpened", "mGameWebInfo", "Lcom/yy/game/cocos2d/net/GameWebInfo;", "getMGameWebInfo", "()Lcom/yy/game/cocos2d/net/GameWebInfo;", "setMGameWebInfo", "(Lcom/yy/game/cocos2d/net/GameWebInfo;)V", "mIsGroup", "mUrl", "getNetType", "getRoomId", "successCode", "timeStart", "", "getConnectMetricsUri", "type", "getConnectedMetricsUri", "isRunning", "onClosed", "", "code", "", "onError", "t", "", "response", "Lokhttp3/Response;", "onMessage", "text", "", "onOpen", "gameWebInfo", "onRequestClose", "onSendString", "message", "open", "url", "reportConnect", "reportConnectFail", "reportConnectOpen", "reportConnectedFail", "reportReceiveEvent", "bytes", "isFlush", "reportSendEvent", "game_debug"})
public final class NetMetricsMonitor
implements IWsMonitor {
    @NotNull
    private final String TAG = "NetMetricsMonitor";
    private volatile boolean isOpened;
    private volatile boolean isFailed;
    private volatile boolean isClosed;
    private String successCode;
    private long timeStart;
    private String mUrl;
    private boolean mIsGroup;
    @Nullable
    private GameWebInfo mGameWebInfo;
    @NotNull
    private final String gameId;
    @NotNull
    private final String netType;
    @NotNull
    private final String roomId;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @Nullable
    public final GameWebInfo getMGameWebInfo() {
        return this.mGameWebInfo;
    }

    public final void setMGameWebInfo(@Nullable GameWebInfo gameWebInfo) {
        this.mGameWebInfo = gameWebInfo;
    }

    @Override
    public void open(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        this.mIsGroup = SettingFlags.getBoolean((String)"key_hiido_group_report", (boolean)false);
        this.mUrl = url;
        this.timeStart = System.currentTimeMillis();
    }

    @Override
    public void onOpen(@NotNull GameWebInfo gameWebInfo) {
        Intrinsics.checkParameterIsNotNull((Object)gameWebInfo, (String)"gameWebInfo");
        this.isOpened = true;
        this.mGameWebInfo = gameWebInfo;
        this.reportConnectOpen(this.mUrl, this.netType, this.successCode, this.timeStart);
        this.reportConnect("0");
    }

    @Override
    public void onRequestClose() {
        this.onClosed(0);
    }

    @Override
    public void onClosed(int code) {
        if (!this.isFailed && !this.isClosed) {
            this.reportConnectedFail(this.mUrl, this.netType, String.valueOf(code), this.timeStart);
            this.reportReceiveEvent(new byte[0], code, true);
        }
        this.isClosed = true;
    }

    @Override
    public void onError(@Nullable Throwable t, @Nullable Response response, int code) {
        int code2 = -2;
        if (this.isClosed || this.isFailed) {
            return;
        }
        this.isFailed = true;
        if (t != null) {
            code2 = NetworkUtils.getErrorCodeByExc((Throwable)t);
        } else if (response != null) {
            code2 = response.code();
        }
        if (this.isOpened) {
            this.reportConnectedFail(this.mUrl, this.netType, String.valueOf(code2), this.timeStart);
            this.reportReceiveEvent(new byte[0], code2, true);
        } else {
            this.reportConnectFail(this.mUrl, this.netType, String.valueOf(code2), this.timeStart);
            this.reportConnect(String.valueOf(code2));
        }
    }

    private final boolean isRunning() {
        return !this.isClosed && !this.isFailed;
    }

    @Override
    public void onMessage(@Nullable String text) {
        block1: {
            String string2 = text;
            if (string2 == null) break block1;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            if (!this.isRunning()) {
                return;
            }
            String string4 = text;
            NetMetricsMonitor netMetricsMonitor = this;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            netMetricsMonitor.reportReceiveEvent(byArray2, 0, false);
        }
    }

    @Override
    public void onMessage(@NotNull byte[] text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (!this.isRunning()) {
            return;
        }
        this.reportReceiveEvent(text, 0, false);
    }

    @Override
    public void onSendString(@Nullable String message) {
        block2: {
            if (!this.isRunning()) {
                return;
            }
            String string2 = message;
            if (string2 == null) break block2;
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            String string4 = it;
            NetMetricsMonitor netMetricsMonitor = this;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string5.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            netMetricsMonitor.reportSendEvent(byArray2);
        }
    }

    @Override
    public void onSendString(@Nullable byte[] message) {
        block1: {
            if (!this.isRunning()) {
                return;
            }
            if (message == null) break block1;
            byte[] byArray = message;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            this.reportSendEvent(it);
        }
    }

    private final void reportConnectOpen(String url, String type, String code, long timeStart) {
        MLog.debug((Object)this.TAG, (String)("reportMetrics() " + url + ", code:" + code), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCode((String)this.getConnectMetricsUri(type), (long)(System.currentTimeMillis() - timeStart), (String)code);
    }

    private final void reportConnectFail(String url, String type, String code, long timeStart) {
        MLog.debug((Object)this.TAG, (String)("reportMetrics() " + url + ", code:" + code), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCode((String)this.getConnectMetricsUri(type), (long)(System.currentTimeMillis() - timeStart), (String)code);
    }

    private final void reportConnectedFail(String url, String type, String code, long timeStart) {
        MLog.debug((Object)this.TAG, (String)("reportMetrics() " + url + ", code:" + code), (Object[])new Object[0]);
        HiidoStatis.reportAppMonitorReturnCode((String)this.getConnectedMetricsUri(type), (long)(System.currentTimeMillis() - timeStart), (String)code);
    }

    private final String getConnectMetricsUri(String type) {
        return "ly_connect_" + type + "/" + this.gameId;
    }

    private final String getConnectedMetricsUri(String type) {
        return "ly_connected_" + type + "/" + this.gameId;
    }

    private final void reportSendEvent(byte[] bytes) {
        if (!this.mIsGroup) {
            return;
        }
        HiidoNormalEvent event = new HiidoNormalEvent("app_game_connection", "connection", this.roomId);
        long curTime = System.currentTimeMillis();
        String string2 = URLUtils.getDomainName((String)this.mUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLUtils.getDomainName(mUrl)");
        HiidoNormalEvent hiidoNormalEvent = event.withDimens("d2", string2).withDimens("d1", this.gameId);
        Object object = this.mGameWebInfo;
        if (object == null || (object = ((GameWebInfo)object).getRemoteIp()) == null) {
            object = "";
        }
        hiidoNormalEvent.withDimens("d3", (String)object).withDimens("d4", "0").withValue("v1", (Number)(curTime - this.timeStart), CalActionDefine.MAX).withValue("v2", (Number)1, CalActionDefine.SUM).withValue("v4", (Number)bytes.length, CalActionDefine.SUM).withExtra("ud1", this.netType);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
    }

    private final void reportReceiveEvent(byte[] bytes, int code, boolean isFlush) {
        if (!this.mIsGroup) {
            return;
        }
        HiidoNormalEvent event = new HiidoNormalEvent("app_game_connection", "connection", this.roomId);
        long curTime = System.currentTimeMillis();
        String string2 = URLUtils.getDomainName((String)this.mUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLUtils.getDomainName(mUrl)");
        HiidoNormalEvent hiidoNormalEvent = event.withDimens("d2", string2).withDimens("d1", this.gameId);
        Object object = this.mGameWebInfo;
        if (object == null || (object = ((GameWebInfo)object).getRemoteIp()) == null) {
            object = "";
        }
        hiidoNormalEvent.withDimens("d3", (String)object).withDimens("d4", String.valueOf(code)).withValue("v1", (Number)(curTime - this.timeStart), CalActionDefine.MAX).withValue("v3", (Number)1, CalActionDefine.SUM).withValue("v5", (Number)bytes.length, CalActionDefine.SUM).withExtra("ud1", this.netType);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        if (isFlush) {
            HiidoGroupReporter.INSTANCE.flushEvent(event);
        }
    }

    private final void reportConnect(String code) {
        if (!this.mIsGroup) {
            return;
        }
        HiidoNormalEvent event = new HiidoNormalEvent("app_game_connection", "create", this.roomId);
        long curTime = System.currentTimeMillis();
        String string2 = URLUtils.getDomainName((String)this.mUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLUtils.getDomainName(mUrl)");
        HiidoNormalEvent hiidoNormalEvent = event.withDimens("d2", string2).withDimens("d1", this.gameId);
        Object object = this.mGameWebInfo;
        if (object == null || (object = ((GameWebInfo)object).getRemoteIp()) == null) {
            object = "";
        }
        HiidoNormalEvent hiidoNormalEvent2 = hiidoNormalEvent.withDimens("d3", (String)object);
        String string3 = code;
        if (string3 == null) {
            Intrinsics.throwNpe();
        }
        hiidoNormalEvent2.withDimens("d4", string3).withValue("v2", (Number)(curTime - this.timeStart), CalActionDefine.SUM).withExtra("ud1", this.netType);
        HiidoGroupReporter.INSTANCE.reportGroupEvent(event);
        HiidoGroupReporter.INSTANCE.flushEvent(event);
    }

    @NotNull
    public final String getGameId() {
        return this.gameId;
    }

    @NotNull
    public final String getNetType() {
        return this.netType;
    }

    @NotNull
    public final String getRoomId() {
        return this.roomId;
    }

    public NetMetricsMonitor(@NotNull String gameId, @NotNull String netType, @NotNull String roomId) {
        Intrinsics.checkParameterIsNotNull((Object)gameId, (String)"gameId");
        Intrinsics.checkParameterIsNotNull((Object)netType, (String)"netType");
        Intrinsics.checkParameterIsNotNull((Object)roomId, (String)"roomId");
        this.gameId = gameId;
        this.netType = netType;
        this.roomId = roomId;
        this.TAG = "NetMetricsMonitor";
        this.successCode = "0";
        this.mUrl = "";
    }
}

