/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.game.cocos2d.NetMetricsMonitor;
import com.yy.game.cocos2d.net.GameWebInfo;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import common.Header;
import ikxd.gameproxy.GameDataNotify;
import ikxd.gameproxy.GameDataReq;
import ikxd.gameproxy.GameProxy;
import ikxd.gameproxy.Uri;
import okio.ByteString;

public enum GameProxyModel {
    instance;

    static final String TAG = "GameProxyModel";
    public static final int CONNECT_SUCCESS = 2;
    public static final int CONNECTING = 1;
    public static final int DIS_CONNECTED = 4;
    private static final int WS_PROXY_COMMAND_OPEN = 1;
    private static final int WS_PROXY_COMMAND_MSG = 2;
    private static final int WS_PROXY_COMMAND_CLOSE = 3;
    private static final int WS_PROXY_COMMAND_ERROR = 4;
    NetMetricsMonitor mNetMetricsMonitor;
    int connectId = 0;
    String roomId = "";
    IProtoNotify notify = new IProtoNotify<GameProxy>(){

        public String serviceName() {
            return "ikxd_gameproxy_d";
        }

        public void onNotify(@NonNull GameProxy result) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)GameProxyModel.TAG, (String)"IKXD_GAMEPROXY_notify", (Object[])new Object[0]);
            }
            if (result.uri == Uri.kUriGameDataNotify) {
                GameDataNotify gameDataNotify;
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)GameProxyModel.TAG, (String)"kUriGameDataNotify_have receive", (Object[])new Object[0]);
                }
                if ((gameDataNotify = result.game_data_notify) != null) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)GameProxyModel.TAG, (String)"kUriGameDataNotify_have receive gameDataNotify=%s", (Object[])new Object[]{gameDataNotify});
                    }
                    GameProxyModel.this.onAppReceiveData(result.header.roomid, new String(gameDataNotify.header.toByteArray()), gameDataNotify.body.toByteArray());
                    AppCallGameProxy.getSingleton().appReceiveData(result.header.roomid, gameDataNotify.header.toByteArray(), gameDataNotify.body.toByteArray());
                }
            }
        }
    };
    ISocketStateChangeListener socketStateChangeListener = new ISocketStateChangeListener(){

        public void onSocketStateChanged(int code, String wsUrl, String errorInfo) {
            MLog.error((Object)GameProxyModel.TAG, (String)"onSocketStateChanged code=%d", (Object[])new Object[]{code});
            if (code == 102) {
                AppCallGameProxy.getSingleton().appChannelStateChanged("", System.currentTimeMillis(), 2);
            } else if (code == 103) {
                AppCallGameProxy.getSingleton().appChannelStateChanged("", System.currentTimeMillis(), 1);
            } else if (AppCallGameProxy.getSingleton() != null) {
                AppCallGameProxy.getSingleton().appChannelStateChanged("", System.currentTimeMillis(), 4);
            }
        }
    };

    public void proxySend(String hash, byte[] header, byte[] body, String gameId) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"proxySend %s", (Object[])new Object[]{hash});
        }
        GameDataReq req = new GameDataReq.Builder().header(ByteString.of((byte[])header)).body(ByteString.of((byte[])body)).build();
        Header.Builder pHeaderBuilder = ProtoManager.getInstance().getHeaderBuilder("ikxd_gameproxy_d").roomid(hash);
        if (gameId != null) {
            pHeaderBuilder.gameid(gameId);
        }
        final Header pHeader = pHeaderBuilder.build();
        GameProxy gameProxy = new GameProxy.Builder().header(pHeader).uri(Uri.kUriGameDataReq).game_data_req(req).build();
        this.onAppSendData(hash, new String(ByteString.of((byte[])header).toByteArray()), body);
        ProtoManager.getInstance().send((AndroidMessage)gameProxy, (IProtoCallback)new IProtoCallback<GameProxy>(){

            public void onResponse(@Nullable GameProxy message) {
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.error((Object)GameProxyModel.TAG, (String)"proxySend retryWhenTimeout : %s ,seqId = %s", (Object[])new Object[]{canRetry, pHeader.seqid});
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)GameProxyModel.TAG, (String)"proxySend retryWhenError", (Object[])new Object[0]);
                return false;
            }

            public long getCacheEffectiveTime() {
                return 0L;
            }
        });
    }

    private void onAppReceiveData(String context, String header, byte[] body) {
        ProxyDataHeader headerObj = this.parseHeader(header);
        if (headerObj == null) {
            MLog.error((Object)TAG, (String)"appReceiveData, parseHeader failed, header: %s", (Object[])new Object[]{header});
            return;
        }
        int command2 = headerObj.command;
        if (this.mNetMetricsMonitor == null) {
            return;
        }
        if (!this.roomId.equals(context) || this.connectId != headerObj.connectID) {
            return;
        }
        if (command2 == 1) {
            this.mNetMetricsMonitor.onOpen(new GameWebInfo());
        } else if (command2 == 2) {
            if (headerObj.opcode == 1) {
                this.mNetMetricsMonitor.onMessage(new String(body));
            } else {
                this.mNetMetricsMonitor.onMessage(body);
            }
        } else if (command2 == 4) {
            this.mNetMetricsMonitor.onError(null, null, -1001);
        } else if (command2 == 3) {
            this.mNetMetricsMonitor.onClosed(-1003);
        } else {
            MLog.error((Object)TAG, (String)"Invalid command: %d", (Object[])new Object[]{command2});
        }
    }

    private void onAppSendData(String context, String header, byte[] body) {
        ProxyDataHeader headerObj = this.parseHeader(header);
        if (headerObj == null) {
            MLog.error((Object)TAG, (String)"appReceiveData, parseHeader failed, header: %s", (Object[])new Object[]{header});
            return;
        }
        int command2 = headerObj.command;
        if (this.mNetMetricsMonitor == null) {
            return;
        }
        if (command2 == 1) {
            this.roomId = context;
            this.connectId = headerObj.connectID;
            this.mNetMetricsMonitor.open(headerObj.url);
        }
        if (!this.roomId.equals(context) || this.connectId != headerObj.connectID) {
            return;
        }
        if (command2 == 2) {
            this.mNetMetricsMonitor.onSendString(body);
        } else if (command2 == 3) {
            this.mNetMetricsMonitor.onClosed(0);
        }
    }

    private ProxyDataHeader parseHeader(String header) {
        String trimmedHeader = header.trim();
        if (trimmedHeader.charAt(0) != '[') {
            MLog.error((Object)TAG, (String)("trimmedHeader[0] is not [, header: " + header), (Object[])new Object[0]);
            return null;
        }
        if (trimmedHeader.charAt(trimmedHeader.length() - 1) != ']') {
            MLog.error((Object)TAG, (String)("trimmedHeader[' + (trimmedHeader.length-1) + '] is not ], header: " + header), (Object[])new Object[0]);
            return null;
        }
        String removeBracketHeader = trimmedHeader.substring(1, trimmedHeader.length() - 1);
        String[] elements = removeBracketHeader.split(",");
        if (elements.length != 2 && elements.length != 3) {
            MLog.error((Object)TAG, (String)("Wrong element count: " + elements.length + ", header: " + header), (Object[])new Object[0]);
            return null;
        }
        ProxyDataHeader ret = new ProxyDataHeader();
        ret.command = Integer.parseInt(elements[0].trim());
        ret.connectID = Integer.parseInt(elements[1].trim());
        if (elements.length == 3) {
            if (ret.command == 1) {
                ret.url = elements[2].trim();
                ret.url = ret.url.replaceAll("\"", "");
            } else {
                ret.opcode = Integer.parseInt(elements[2].trim());
            }
        } else {
            ret.opcode = -1;
        }
        return ret;
    }

    public static int isWSConnected() {
        if (!SettingFlags.getBoolean((String)"gameuseclientws", (boolean)true)) {
            return 0;
        }
        return ProtoManager.getInstance().isWSConnected() ? 1 : 0;
    }

    public void registerGameProxyNotify() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"registerGameProxyNotify", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().registerNotify(this.notify);
        ProtoManager.getInstance().addSocketStateChangeListener(this.socketStateChangeListener);
    }

    public void unregisterGameProxyNotify() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"unregisterGameProxyNotify", (Object[])new Object[0]);
        }
        ProtoManager.getInstance().unregisterNotify(this.notify);
        ProtoManager.getInstance().removeSocketStateChangeListener(this.socketStateChangeListener);
    }

    public void setNetMetricsMonitor(NetMetricsMonitor netMetricsMonitor) {
        this.mNetMetricsMonitor = netMetricsMonitor;
    }

    static class ProxyDataHeader {
        int command;
        int connectID;
        int opcode;
        String url;

        ProxyDataHeader() {
        }
    }
}

