/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.cocos2d;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import com.getkeepsafe.relinker.ReLinker;
import com.yy.appbase.common.CommonCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.OkHttpUtils;
import com.yy.base.taskexecutor.NewYYTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.FP;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ThrowUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.game.R;
import com.yy.game.cocos2d.EngineConfig;
import com.yy.game.cocos2d.EngineContext;
import com.yy.game.cocos2d.GameWebSocketDelegate;
import com.yy.game.cocos2d.IWebSocket;
import com.yy.game.cocos2d.IWebSocketCallback;
import com.yy.game.cocos2d.NetMetricsMonitor;
import com.yy.game.cocos2d.WebSocketFactory;
import com.yy.game.cocos2d.callback.IGameEngineCallback;
import com.yy.game.cocos2d.net.CocsGameHttpProxy;
import com.yy.game.cocos2d.net.GameWebInfo;
import com.yy.game.gamemodule.GameLoger;
import com.yy.game.gameproxy.GameProxyDef;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.game.module.gameroom.ui.EngineConfigGeneratorKt;
import com.yy.game.module.gameroom.ui.IGameEngine;
import com.yy.game.utils.LogSizeHelper;
import com.yy.hago.gamesdk.remotedebug.RemoteGameDebugService;
import com.yy.hiyo.game.base.CocoViewBean;
import com.yy.hiyo.game.base.gamemode.IGameDownloadInterface;
import com.yy.hiyo.game.base.gamemode.IGameMessageInterface;
import com.yy.hiyo.game.base.helper.GameReportV1;
import com.yy.webgame.runtime.GameLauncher;
import com.yy.webgame.runtime.IGameLauncherCallback;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class CocosGameEngine
implements IGameEngine {
    private static final String TAG = "CocosGameView";
    private GameLauncher mGameLauncher;
    private Activity mActivity;
    private IGameEngineCallback mIGameEngineCallback;
    private View mView;
    private View mSurfaceView;
    private boolean mEnableAutoTouch = true;
    private int mAutoTouchTimeGap = 500;
    private long mAutoTochDownTime;
    private boolean isShown = true;
    private static volatile boolean sHasInited;
    private static LogSizeHelper logSizeHelper;
    private OkHttpClient mOkHttpClient;
    private final Object mLock = new Object();
    private boolean mIsAllNetworkConnectionCleanup = false;
    private boolean mIsValid = true;
    private final Object mValidLock = new Object();
    private boolean mIsUseSameOkHttpClientForWS = true;
    private EngineConfig mEngineConfig = new EngineConfig();
    private EngineContext mEngineContext = new EngineContext();
    private Set<IGameMessageInterface.IGameMessageNotify> messageNotifySet = new HashSet<IGameMessageInterface.IGameMessageNotify>();
    private final HashMap<Integer, IWebSocket> mWebSocketMap = new HashMap(1);
    private static final MediaType MEDIA_TYPE_DEFAULT;
    private View.OnLayoutChangeListener mGameViewLayoutChangeListener = new View.OnLayoutChangeListener(){

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (CocosGameEngine.this.mView != null && CocosGameEngine.this.mIGameEngineCallback != null) {
                CocoViewBean cocoViewBean = new CocoViewBean();
                int[] location = new int[2];
                CocosGameEngine.this.mView.getLocationOnScreen(location);
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)"onLayoutChange", (String)(location[0] + "," + location[1]), (Object[])new Object[0]);
                }
                cocoViewBean.setLocation(location);
                cocoViewBean.setWidth(CocosGameEngine.this.mView.getWidth());
                cocoViewBean.setHeight(CocosGameEngine.this.mView.getHeight());
                CocosGameEngine.this.mIGameEngineCallback.onCoCosViewLocationChange(cocoViewBean);
            }
        }
    };
    private GameLauncher.IStartRuntimeCallback mIStartRuntimeCallback = new GameLauncher.IStartRuntimeCallback(){

        public void onStartRuntimeSuccess() {
            MLog.debug((Object)CocosGameEngine.TAG, (String)"onRuntimeReady", (Object[])new Object[0]);
            GameReportV1.Companion.reportRuntime(((CocosGameEngine)CocosGameEngine.this).mIGameEngineCallback.getCurGameContext().getGameInfo().gid, "0");
            CocosGameEngine.this.loadJs();
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onCocosInitFinish();
            }
        }

        public void onStartRuntimeFailure(int errorCode, String message) {
            MLog.error((Object)CocosGameEngine.TAG, (String)"onStartRuntimeFailure errorCode: %d, message: %s", (Object[])new Object[]{errorCode, message});
            GameReportV1.Companion.reportRuntime(((CocosGameEngine)CocosGameEngine.this).mIGameEngineCallback.getCurGameContext().getGameInfo().gid, String.valueOf(errorCode));
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onCocosInitError(errorCode, message);
            }
        }
    };
    private GameLauncher.IStartGameCallback iStartGameCallback = new GameLauncher.IStartGameCallback(){

        public void onStartGameSuccess() {
            MLog.debug((Object)CocosGameEngine.TAG, (String)"onStartGameSuccess", (Object[])new Object[0]);
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onStartGameSuccess();
            }
            CocosGameEngine.this.autoTouchStart();
        }

        public void onStartGameFailure(int errorCode, String message) {
            MLog.debug((Object)CocosGameEngine.TAG, (String)"onStartGameFailure errorCode: %d, message: %s", (Object[])new Object[]{errorCode, message});
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onCocosInitError(errorCode, message);
            }
        }

        public void onGameReady() {
            MLog.debug((Object)CocosGameEngine.TAG, (String)"onGameReady", (Object[])new Object[0]);
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (CocosGameEngine.this.mIGameEngineCallback != null) {
                        CocosGameEngine.this.mIGameEngineCallback.onGameReady();
                    }
                });
            }
        }
    };
    GameLauncher.IExitGameCallback iExitGameCallback = new GameLauncher.IExitGameCallback(){

        public void onExitGameSuccess() {
            CocosGameEngine.this.cleanupAllNetworkConnections();
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onExitGameSuccess();
            }
            CocosGameEngine.this.messageNotifySet.clear();
        }

        public void onExitGameFailure(int errorCode, String message) {
            CocosGameEngine.this.cleanupAllNetworkConnections();
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onExitGameFailure(errorCode, message);
            }
            CocosGameEngine.this.messageNotifySet.clear();
        }
    };
    private Set<String> errorScriptLocation = new HashSet<String>();
    private IGameLauncherCallback iGameLauncherCallback = new IGameLauncherCallback(){

        public void onReceiveMessage(String type, Map<String, Object> msgObj, int tag) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)CocosGameEngine.TAG, (String)"onReceiveMessage type: %s, msgObj: %s, tag: %s, size: %d", (Object[])new Object[]{type, msgObj, tag, FP.size((Collection)CocosGameEngine.this.messageNotifySet)});
            }
            for (IGameMessageInterface.IGameMessageNotify messageNotify : CocosGameEngine.this.messageNotifySet) {
                messageNotify.onReceiveMessage(type, msgObj, tag);
            }
        }

        public Object onReceiveMessageSync(String type, Map<String, Object> msgObj, int tag) {
            for (IGameMessageInterface.IGameMessageNotify messageNotify : CocosGameEngine.this.messageNotifySet) {
                if (messageNotify == null) continue;
                return messageNotify.onReceiveMessageSync(type, msgObj, tag);
            }
            return "";
        }

        public void onReportException(int type, String location, String message, String content, String extJson) {
            if (!CocosGameEngine.this.errorScriptLocation.contains(message)) {
                MLog.error((Object)CocosGameEngine.TAG, (String)("onReportScriptException location:" + location + ", message:" + message + ", stack:" + content), (Object[])new Object[0]);
                CocosGameEngine.this.errorScriptLocation.add(message);
                if (CocosGameEngine.this.mIGameEngineCallback != null) {
                    CocosGameEngine.this.mIGameEngineCallback.onGameErrorReport(type, location, message, content, extJson);
                }
            }
        }

        public void onSetCrashExtensionField(String info) {
            if (StringUtils.isEmpty((String)info)) {
                return;
            }
            if (info.length() > 500) {
                info = info.substring(0, 500);
            }
            CrashSdk.INSTANCE.addExtend("cocosCrashInfo", info);
        }

        public void onStatisticEvent(final String event, final String jsonData) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)CocosGameEngine.TAG, (String)"sendHiddoEventToApp  event=%s jsonData=%s", (Object[])new Object[]{event, jsonData});
            }
            if (CocosGameEngine.this.mEngineConfig == null) {
                MLog.error((Object)CocosGameEngine.TAG, (String)"sendHiddoEventToApp  mEngineConfig is null", (Object[])new Object[0]);
                return;
            }
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!StringUtils.isEmpty((String)jsonData)) {
                            Map eventMap = (Map)JsonParser.parseJsonObject((String)jsonData, Map.class);
                            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId(event);
                            hiidoEvent.putMap(eventMap);
                            hiidoEvent.put("gid", AppCallGameProxy.gameId);
                            hiidoEvent.put("roomid", CocosGameEngine.this.mIGameEngineCallback.getCurGameContext().getRoomId());
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)CocosGameEngine.TAG, (String)JsonParser.toJson((Object)hiidoEvent.getEventProperty()), (Object[])new Object[0]);
                            }
                            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)CocosGameEngine.TAG, (Throwable)e);
                    }
                }
            });
        }

        public void onNotifyNetProxySendData(String context, byte[] header, byte[] body) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("context", context);
            map.put("header", header);
            map.put("body", body);
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)CocosGameEngine.TAG, (String)"onNotifyNetProxySendData context: %s, map: %s, size: %d", (Object[])new Object[]{context, map, FP.size((Collection)CocosGameEngine.this.messageNotifySet)});
            }
            for (IGameMessageInterface.IGameMessageNotify messageNotify : CocosGameEngine.this.messageNotifySet) {
                messageNotify.onReceiveMessage("gameSendData", map, GameProxyDef.DEF_TAG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketRequestOpen(final String url, String protocols, final int tag) {
            boolean useWebsocketProxy = !CocosGameEngine.this.mEngineConfig.getUseFixLuaWebSocket();
            OkHttpClient client = CocosGameEngine.this.mIsUseSameOkHttpClientForWS ? CocosGameEngine.this.getOkHttpClient() : CocosGameEngine.this.createOkHttpClient();
            String netType = "direct";
            if (useWebsocketProxy) {
                netType = "proxy";
            }
            String roomId = CocosGameEngine.this.mIGameEngineCallback.getCurGameContext().getRoomId();
            NetMetricsMonitor monitor = new NetMetricsMonitor(((CocosGameEngine)CocosGameEngine.this).mIGameEngineCallback.getCurGameContext().getGameInfo().gid, netType, roomId == null ? "" : roomId);
            GameWebSocketDelegate ws = new GameWebSocketDelegate(monitor, WebSocketFactory.newWebSocket(useWebsocketProxy ? 1 : 0, client, CocosGameEngine.this.mIsUseSameOkHttpClientForWS));
            HashMap hashMap = CocosGameEngine.this.mWebSocketMap;
            synchronized (hashMap) {
                CocosGameEngine.this.mWebSocketMap.put(tag, ws);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)CocosGameEngine.TAG, (String)"onWebSocketRequestOpen: %d, protocols: %s, mWebSocketMap size: %d, useWebsocketProxy: %s", (Object[])new Object[]{tag, protocols, CocosGameEngine.this.mWebSocketMap.size(), useWebsocketProxy ? "true" : "false"});
                }
            }
            final long timeStart = System.currentTimeMillis();
            if (CocosGameEngine.this.mIGameEngineCallback != null && CocosGameEngine.this.mIGameEngineCallback.getCurGameContext() != null) {
                ws.open(url, protocols, new IWebSocketCallback(){

                    @Override
                    public void onWebSocketOpen(String selectedProtocol, GameWebInfo gameWebInfo) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)CocosGameEngine.TAG, (String)"onWebSocketOpen: %d, selectedProtocol: %s", (Object[])new Object[]{tag, selectedProtocol});
                        }
                        CocosGameEngine.this.mEngineContext.setCurWebSocketUrl(url);
                        if (CocosGameEngine.this.mGameLauncher != null) {
                            CocosGameEngine.this.mGameLauncher.notifyWebSocketOnOpen(selectedProtocol, tag);
                        }
                        CocosGameEngine.this.reportMetrics(url, "ws", "0", timeStart);
                    }

                    @Override
                    public void onWebSocketStringMessage(String message) {
                        if (CocosGameEngine.this.mGameLauncher != null) {
                            CocosGameEngine.this.mGameLauncher.notifyWebSocketOnStringMessage(message, tag);
                        }
                    }

                    @Override
                    public void onWebSocketBinaryMessage(byte[] message) {
                        if (CocosGameEngine.this.mGameLauncher != null) {
                            CocosGameEngine.this.mGameLauncher.notifyWebSocketOnBinaryMessage(message, tag);
                        }
                    }

                    @Override
                    public void onWebSocketError(String errorInfo, Throwable t, Response response, int code) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info((Object)CocosGameEngine.TAG, (String)"onWebSocketError: %d, errorInfo: %s", (Object[])new Object[]{tag, errorInfo});
                        }
                        if (CocosGameEngine.this.mGameLauncher != null) {
                            CocosGameEngine.this.mGameLauncher.notifyWebSocketOnError(errorInfo, tag);
                        }
                        if (!CocosGameEngine.this.mIsAllNetworkConnectionCleanup) {
                            CocosGameEngine.this.reportMetrics(url, "ws", "-1", timeStart);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onWebSocketClose(String reason, int code) {
                        if (CocosGameEngine.this.mGameLauncher != null) {
                            CocosGameEngine.this.mGameLauncher.notifyWebSocketOnClose(reason, tag);
                        }
                        HashMap hashMap = CocosGameEngine.this.mWebSocketMap;
                        synchronized (hashMap) {
                            IWebSocket wsInstance = (IWebSocket)CocosGameEngine.this.mWebSocketMap.get(tag);
                            if (wsInstance != null) {
                                wsInstance.cleanup();
                            }
                            CocosGameEngine.this.mWebSocketMap.remove(tag);
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)CocosGameEngine.TAG, (String)"onWebSocketClose: %d, reason: %s, mWebSocketMap size: %d", (Object[])new Object[]{tag, reason, CocosGameEngine.this.mWebSocketMap.size()});
                            }
                        }
                    }
                }, CocosGameEngine.this.mIGameEngineCallback.getCurGameContext().getRoomId(), ((CocosGameEngine)CocosGameEngine.this).mIGameEngineCallback.getCurGameContext().getGameInfo().gid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketRequestSendString(String message, int tag) {
            HashMap hashMap = CocosGameEngine.this.mWebSocketMap;
            synchronized (hashMap) {
                if (CocosGameEngine.this.mWebSocketMap.containsKey(tag)) {
                    ((IWebSocket)CocosGameEngine.this.mWebSocketMap.get(tag)).sendString(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketRequestSendBinary(byte[] message, int tag) {
            HashMap hashMap = CocosGameEngine.this.mWebSocketMap;
            synchronized (hashMap) {
                if (CocosGameEngine.this.mWebSocketMap.containsKey(tag)) {
                    ((IWebSocket)CocosGameEngine.this.mWebSocketMap.get(tag)).sendBinary(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWebSocketRequestClose(int tag) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)CocosGameEngine.TAG, (String)"onWebSocketRequestClose: %d", (Object[])new Object[]{tag});
            }
            HashMap hashMap = CocosGameEngine.this.mWebSocketMap;
            synchronized (hashMap) {
                if (CocosGameEngine.this.mWebSocketMap.containsKey(tag)) {
                    ((IWebSocket)CocosGameEngine.this.mWebSocketMap.get(tag)).close();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHttpConnectionSend(int method, String url, byte[] body, String requestHeaders, int readTimeoutMS, int writeTimeoutMS, int connectTimeOutMS, int tag) {
            Object object = CocosGameEngine.this.mValidLock;
            synchronized (object) {
                if (!CocosGameEngine.this.mIsValid) {
                    return;
                }
            }
            YYTaskExecutor.execute(() -> CocsGameHttpProxy.cocosGameHttpProxy(method, url, body, requestHeaders, readTimeoutMS, writeTimeoutMS, connectTimeOutMS, tag, CocosGameEngine.this.mGameLauncher));
        }

        public void onHttpConnectionAbort(int tag) {
            try {
                if (CocosGameEngine.this.mOkHttpClient != null) {
                    List queuedCalls = CocosGameEngine.this.getOkHttpClient().dispatcher().queuedCalls();
                    for (Call call : queuedCalls) {
                        Object savedTag = call.request().tag();
                        if (savedTag == null || !savedTag.equals(tag)) continue;
                        call.cancel();
                    }
                    List runningCalls = CocosGameEngine.this.getOkHttpClient().dispatcher().runningCalls();
                    for (Call call : runningCalls) {
                        Object savedTag = call.request().tag();
                        if (savedTag == null || !savedTag.equals(tag)) continue;
                        call.cancel();
                    }
                }
            }
            catch (Exception e) {
                MLog.error((Object)CocosGameEngine.TAG, (String)"onHttpConnectionAbort failed: ", (Throwable)e, (Object[])new Object[0]);
            }
        }

        public void onTryDownloadFile(String s, int i) {
            MLog.debug((Object)CocosGameEngine.TAG, (String)"onTryDownloadFile url: %s, tag: %d, iGameViewCallback == null: %b", (Object[])new Object[]{s, i, CocosGameEngine.this.mIGameEngineCallback == null});
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onTryDownloadFile(s, i);
            }
        }

        public boolean onPreHandleTouchEvent(MotionEvent event) {
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                return CocosGameEngine.this.mIGameEngineCallback.onPreHandleTouchEvent(event);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onExitGameError(int a) {
            MLog.error((Object)CocosGameEngine.TAG, (String)"on exit exception:%d", (Object[])new Object[]{a});
            Object object = CocosGameEngine.this.mValidLock;
            synchronized (object) {
                CocosGameEngine.this.mIsValid = false;
            }
            CocosGameEngine.this.cleanupAllNetworkConnections();
            if (CocosGameEngine.this.mIGameEngineCallback != null) {
                CocosGameEngine.this.mIGameEngineCallback.onExitGameError();
            }
            CocosGameEngine.this.messageNotifySet.clear();
        }
    };
    IGameMessageInterface iGameMessageInterface = new IGameMessageInterface(){

        public void sendMessage(String type, Map<String, Object> msgObj, int tag) {
            block6: {
                if (CocosGameEngine.this.mGameLauncher != null) {
                    if (type.equals("appReceiveData")) {
                        String context = (String)msgObj.get("context");
                        byte[] header = (byte[])msgObj.get("header");
                        byte[] body = (byte[])msgObj.get("body");
                        CocosGameEngine.this.mGameLauncher.notifyReceiveDataFromNetProxy(context, header, body);
                    } else {
                        try {
                            CocosGameEngine.this.mGameLauncher.sendMessage(type, msgObj, tag);
                        }
                        catch (NullPointerException e) {
                            if (e != null && e.toString() != null && e.toString().contains("org.cocos2dx.lib.lua.GLSurfaceViewEx")) {
                                MLog.error((Object)CocosGameEngine.TAG, (Throwable)e);
                            }
                            if (!RuntimeContext.sIsDebuggable) break block6;
                            ThrowUtils.throwException((Throwable)e);
                        }
                    }
                }
            }
        }

        public void registerGameMessageNotify(IGameMessageInterface.IGameMessageNotify gameMessageNotify) {
            CocosGameEngine.this.messageNotifySet.add(gameMessageNotify);
        }

        public void unRegisterGameMessageNotify(IGameMessageInterface.IGameMessageNotify gameMessageNotify) {
            CocosGameEngine.this.messageNotifySet.remove(gameMessageNotify);
        }

        public int getLogMinLevel() {
            if (SystemUtils.isCpPackage()) {
                return MLog.getVerboseLevel();
            }
            return MLog.getLogLevel();
        }
    };
    private IGameDownloadInterface downloadInterface = new IGameDownloadInterface(){

        public void onGetFileSuccess(@NotNull String filePath, @NotNull String dest, int tag, boolean isFromCache) {
            if (CocosGameEngine.this.mGameLauncher != null) {
                CocosGameEngine.this.mGameLauncher.notifyDownloadFileSuccess(dest, true, tag);
            }
        }

        public void onGetFileFail(@NotNull String filePath, int tag, int code, @Nullable String msg) {
            if (CocosGameEngine.this.mGameLauncher != null) {
                CocosGameEngine.this.mGameLauncher.notifyDownloadFileFailure(tag);
            }
        }

        public void fileNotInManifest(int tag) {
            if (CocosGameEngine.this.mGameLauncher != null) {
                CocosGameEngine.this.mGameLauncher.notifyNotDownloadFileRequest(tag);
            }
        }

        public void onProgress(String url, int current, int total, int tag) {
            if (CocosGameEngine.this.mGameLauncher != null) {
                CocosGameEngine.this.mGameLauncher.notifyDownloadFileProgress(current, total, tag);
            }
        }
    };

    public CocosGameEngine(Activity activity) {
        if (RuntimeContext.sIsDebuggable && logSizeHelper == null) {
            logSizeHelper = new LogSizeHelper();
        }
        this.mIsUseSameOkHttpClientForWS = SettingFlags.getBoolean((String)"game_ws_use_same_client", (boolean)true);
        this.mActivity = activity;
        this.mGameLauncher = new GameLauncher();
        this.mGameLauncher.setGameLauncherCallback(this.iGameLauncherCallback);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"CocosGameView.finalize", (Object[])new Object[0]);
        }
    }

    private void loadJs() {
        if (this.mEngineConfig.getEngineType().equals("jsEngine") || this.mEngineConfig.getEngineType().equals("js_ar")) {
            boolean open;
            String jsCode = "";
            if ((RuntimeContext.sIsDebuggable || SystemUtils.isCpPackage()) && (open = SettingFlags.getBoolean((String)"key_game_fps_debug", (boolean)false))) {
                jsCode = jsCode + "yyrt.openDebugView();\n";
            }
            if (this.mEngineConfig.getEngineGameMode() == 9) {
                jsCode = jsCode + this.readSdk();
            }
            this.mGameLauncher.evalString(jsCode);
        }
    }

    @Override
    public void exitQueue() {
    }

    @Override
    public void selectResolution(int level) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSdk() {
        InputStream inS = null;
        try {
            if (this.mActivity != null) {
                Resources res = this.mActivity.getResources();
                inS = res.openRawResource(R.raw.hagosdk);
                byte[] b = new byte[inS.available()];
                inS.read(b);
                String string2 = new String(b);
                return string2;
            }
            String res = "console.log('load sdk error')";
            return res;
        }
        catch (Exception e) {
            String string3 = "console.log('load sdk error')";
            return string3;
        }
        finally {
            if (inS != null) {
                try {
                    inS.close();
                }
                catch (IOException e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
        }
    }

    private OkHttpClient createOkHttpClient() {
        OkHttpClient.Builder build = OkHttpUtils.getDefault().getOkHttpClient().newBuilder().connectionPool(new ConnectionPool(this.getMaxIdleConnections(), 5L, TimeUnit.MINUTES)).pingInterval(0L, TimeUnit.SECONDS).protocols(Arrays.asList(Protocol.HTTP_1_1));
        if (PageResponse.isNewTaskExecuteEnable()) {
            build.dispatcher(new Dispatcher(NewYYTaskExecutor.getCachePool()));
        } else {
            build.dispatcher(new Dispatcher());
        }
        return build.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OkHttpClient getOkHttpClient() {
        if (this.mOkHttpClient == null) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mOkHttpClient == null) {
                    this.mOkHttpClient = this.createOkHttpClient();
                }
            }
        }
        return this.mOkHttpClient;
    }

    private int getMaxIdleConnections() {
        return this.mIsUseSameOkHttpClientForWS ? 5 : 2;
    }

    private static void cleanupOkHttpClient(OkHttpClient client) {
        try {
            if (client != null) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"cleanupOkHttpClient", (Object[])new Object[0]);
                }
                client.dispatcher().cancelAll();
                client.dispatcher().executorService().shutdown();
                client.connectionPool().evictAll();
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"cleanupOkHttpClient failed, message: %s", (Object[])new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupAllWebSockets() {
        HashMap<Integer, IWebSocket> hashMap = this.mWebSocketMap;
        synchronized (hashMap) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"cleanupAllWebSockets, size: %d", (Object[])new Object[]{this.mWebSocketMap.size()});
            }
            if (!this.mWebSocketMap.isEmpty()) {
                Collection<IWebSocket> webSockets = this.mWebSocketMap.values();
                for (IWebSocket ws : webSockets) {
                    if (ws == null) continue;
                    ws.close();
                    ws.cleanup();
                }
                this.mWebSocketMap.clear();
            }
        }
    }

    private void cleanupAllHttpConnections() {
        if (this.mOkHttpClient != null) {
            CocosGameEngine.cleanupOkHttpClient(this.getOkHttpClient());
        }
    }

    private synchronized void cleanupAllNetworkConnections() {
        if (!this.mIsAllNetworkConnectionCleanup) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)CocosGameEngine.TAG, (String)"cleanupAllNetworkConnections", (Object[])new Object[0]);
                    }
                    CocosGameEngine.this.cleanupAllWebSockets();
                    CocosGameEngine.this.cleanupAllHttpConnections();
                }
            });
            this.mIsAllNetworkConnectionCleanup = true;
        }
    }

    @Override
    public void loadGame(String path, String[] pkglist) {
        GameLauncher gameLauncher;
        this.mEngineConfig.setGamePath(path);
        this.mEngineConfig.setPkgList(pkglist);
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"loadGame path=%s", (Object[])new Object[]{path});
        }
        if ((gameLauncher = this.mGameLauncher) != null) {
            gameLauncher.startGame(this.mActivity, this.mEngineConfig.getAddResourceConfig(), this.iStartGameCallback);
            GameReportV1.Companion.reportCallStartGame(this.mIGameEngineCallback.getCurGameContext().getGameInfo().gid);
            this.mSurfaceView = this.mGameLauncher.getSurfaceView();
            if (this.mSurfaceView != null) {
                this.mSurfaceView.setContentDescription((CharSequence)"cocos_game_view");
            }
        }
    }

    @Override
    public void reLoadGame() {
    }

    @Override
    public void onCreate(ViewGroup parentViewGroup) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("Cocos2dxGameViewLife onCreate, mIsValid: " + this.mIsValid), (Object[])new Object[0]);
        }
        CommonCallback callback2 = () -> {
            if (this.mActivity == null) {
                this.mIGameEngineCallback.onCocosInitError(-1005, "onCreate activity == null");
                return;
            }
            YYTaskExecutor.execute(() -> {
                this.mEngineConfig = EngineConfigGeneratorKt.makeEngineConfig(this.mIGameEngineCallback.getCurGameContext(), (Context)this.mActivity, this.mEngineConfig);
            }, () -> this.startRuntime(parentViewGroup));
        };
        if (this.mIGameEngineCallback != null) {
            this.mIGameEngineCallback.onPreCreateCocos(callback2);
        }
        if (logSizeHelper != null) {
            logSizeHelper.reset();
        }
    }

    private void startRuntime(ViewGroup parentViewGroup) {
        if (this.mGameLauncher != null) {
            HashMap<String, Object> gameMap = new HashMap<String, Object>();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)"baseGame", (String)"startRuntime mEngineConfig=%s", (Object[])new Object[]{this.mEngineConfig.toString()});
            }
            this.engineExtConfig("enableThreadInspector", "keyGameThreadInspector", false, gameMap);
            this.engineExtConfig("asyncDestroySLObject", "keyAsyncDestroySlObject", true, gameMap);
            this.engineExtConfig("asyncWriteV8Bytecode", "keyAsyncWriteV8Bytecode", true, gameMap);
            this.engineExtConfig("localStorageInSubThread", "keyDbInSubThread", true, gameMap);
            this.mGameLauncher.startRuntime(this.mActivity, this.mEngineConfig.getStartRuntimConfig(), this.mIStartRuntimeCallback);
            this.mView = this.mGameLauncher.getGameView();
            this.mSurfaceView = "js_ar".equals(this.mEngineConfig.getEngineType()) ? this.mIGameEngineCallback.getOuterSurfaceView() : this.mGameLauncher.getSurfaceView();
            if (this.mView != null) {
                this.mView.addOnLayoutChangeListener(this.mGameViewLayoutChangeListener);
                parentViewGroup.addView(this.mView, new ViewGroup.LayoutParams(-1, -1));
            }
            this.checkSurfaceViewConfig();
        }
    }

    private void engineExtConfig(String configKey, String settingFlagKey, boolean defValue, Map<String, Object> gameMap) {
        gameMap.put(configKey, SettingFlags.getBoolean((String)settingFlagKey, (boolean)defValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroy() {
        Object object = this.mValidLock;
        synchronized (object) {
            this.mIsValid = false;
        }
        if (this.mGameLauncher != null) {
            this.mEnableAutoTouch = false;
            View v = this.mGameLauncher.getGameView();
            if (v != null && v.getParent() instanceof ViewGroup) {
                ((ViewGroup)v.getParent()).removeView(v);
            }
            this.cleanupAllNetworkConnections();
            this.mGameLauncher.onDestroy();
        }
        if (logSizeHelper != null) {
            logSizeHelper.logTotalLogSize();
            logSizeHelper.reset();
        }
    }

    @Override
    public void onResume() {
        if (this.mGameLauncher != null && !this.isShown) {
            this.isShown = true;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onShown", (Object[])new Object[0]);
            }
            this.mGameLauncher.onResume();
            if (this.mIGameEngineCallback != null) {
                this.mIGameEngineCallback.onGameViewShow();
            }
        }
    }

    private void checkSurfaceViewConfig() {
        if (this.mSurfaceView instanceof SurfaceView) {
            SurfaceView sfv = (SurfaceView)this.mSurfaceView;
            if (this.mEngineConfig.isOnTop()) {
                sfv.setZOrderOnTop(true);
            } else if (this.mEngineConfig.isMediaOverlay()) {
                sfv.setZOrderMediaOverlay(true);
            }
        }
    }

    @Override
    public void onPause() {
        if (this.mGameLauncher != null && this.isShown) {
            this.isShown = false;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"GameWindowLife onHidden", (Object[])new Object[0]);
            }
            this.mGameLauncher.onPause();
            if (this.mIGameEngineCallback != null) {
                this.mIGameEngineCallback.onGameViewHide();
            }
        }
    }

    @Override
    public void setEngineCallback(IGameEngineCallback uiCallbacks) {
        this.mIGameEngineCallback = uiCallbacks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exitGame() {
        Object object = this.mValidLock;
        synchronized (object) {
            this.mIsValid = false;
        }
        if (this.mGameLauncher != null) {
            this.mGameLauncher.exitGame(this.iExitGameCallback);
            this.mActivity = null;
            if (this.mView != null) {
                this.mView.removeOnLayoutChangeListener(this.mGameViewLayoutChangeListener);
                this.mView = null;
            }
            this.mSurfaceView = null;
        }
    }

    @Override
    public EngineContext getEngineContext() {
        return this.mEngineContext;
    }

    @Override
    public MutableLiveData<Integer> getEngineNetState() {
        return null;
    }

    @Override
    public IGameMessageInterface getGameMessageInterface() {
        return this.iGameMessageInterface;
    }

    @Override
    public IGameDownloadInterface getGameDownloadInterface() {
        return this.downloadInterface;
    }

    private void autoTouchStart() {
        if (!RuntimeContext.sIsDebuggable || this.mEngineConfig.getGameMode() == 10) {
            return;
        }
        this.mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautofirstpage", (boolean)false);
        if (this.mEnableAutoTouch) {
            this.mAutoTouchTimeGap = SettingFlags.getIntValue((String)"gameautotouchtime", (int)400);
        } else {
            this.mEnableAutoTouch = SettingFlags.getBoolean((String)"gameautoopen", (boolean)false);
            this.mAutoTouchTimeGap = SettingFlags.getIntValue((String)"gameautotouchtime");
        }
        if (this.mAutoTouchTimeGap < 50) {
            this.mAutoTouchTimeGap = 50;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!CocosGameEngine.this.mEnableAutoTouch) {
                    return;
                }
                long touchDownTime = SystemClock.uptimeMillis();
                int x = ScreenUtils.getInstance().getWidthPixels() / 10 * ((int)(System.currentTimeMillis() % 9L) + 1);
                int y = ScreenUtils.getInstance().getHeightPixels() / 5 * ((int)(System.currentTimeMillis() % 5L) + 1);
                MotionEvent downEvent = MotionEvent.obtain((long)touchDownTime, (long)touchDownTime, (int)0, (float)x, (float)y, (int)0);
                Random random = new Random();
                float moveX = 0.0f;
                float moveY = 0.0f;
                if (random.nextBoolean()) {
                    moveX = (float)x + random.nextFloat() * 200.0f - 100.0f;
                    moveY = (float)y + random.nextFloat() * 200.0f - 100.0f;
                }
                if (moveX == 0.0f && moveY == 0.0f) {
                    moveX = x;
                    moveY = y;
                }
                MotionEvent upEvent = MotionEvent.obtain((long)touchDownTime, (long)touchDownTime, (int)1, (float)moveX, (float)moveY, (int)0);
                MotionEvent moveEvent = MotionEvent.obtain((long)touchDownTime, (long)touchDownTime, (int)2, (float)moveX, (float)moveY, (int)0);
                if (CocosGameEngine.this.mSurfaceView != null) {
                    CocosGameEngine.this.mSurfaceView.onTouchEvent(downEvent);
                    if (moveX != 0.0f && moveY != 0.0f) {
                        CocosGameEngine.this.mSurfaceView.onTouchEvent(moveEvent);
                    }
                    CocosGameEngine.this.mSurfaceView.onTouchEvent(upEvent);
                }
                downEvent.recycle();
                moveEvent.recycle();
                upEvent.recycle();
                CocosGameEngine.this.autoTouchStart();
            }
        }, (long)this.mAutoTouchTimeGap);
    }

    public static synchronized void onLoadNativeLibraries() {
        if (sHasInited) {
            return;
        }
        MLog.debug((Object)TAG, (String)"Cocos so onLoadNativeLibraries", (Object[])new Object[0]);
        GameLauncher.setLogger((GameLauncher.ILogger)new GameLauncherLogger());
        GameLauncher.setAutoLoadRuntimeSo((boolean)false);
        try {
            ApplicationInfo ai = RuntimeContext.sApplicationContext.getPackageManager().getApplicationInfo(RuntimeContext.sApplicationContext.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String libName = bundle.getString("android.app.lib_name");
            ReLinker.loadLibrary((Context)RuntimeContext.sApplicationContext, (String)libName, null, null);
            GameLauncher.initScriptVM((AssetManager)RuntimeContext.sApplicationContext.getAssets());
            sHasInited = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getMetricsUri(String type) {
        return "ly_" + type + "/" + AppCallGameProxy.gameId;
    }

    private void reportMetrics(String url, String type, String code, long timeStart) {
        MLog.verbose((Object)TAG, (String)("reportMetrics() " + url + ", code:" + code), (Object[])new Object[0]);
        HiidoStatis.reportReturnCode((String)this.getMetricsUri(type), (long)(System.currentTimeMillis() - timeStart), (String)String.valueOf(code));
    }

    protected void executeInMain(Runnable command2) {
        if (command2 != null) {
            if (YYTaskExecutor.isMainThread()) {
                command2.run();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)command2);
            }
        }
    }

    static {
        MEDIA_TYPE_DEFAULT = MediaType.parse((String)"application/x-www-form-urlencoded");
    }

    private static class GameLauncherLogger
    implements GameLauncher.ILogger {
        private GameLauncherLogger() {
        }

        public void onLogMessage(int priority, String tag, String msg) {
            switch (priority) {
                case 2: {
                    MLog.verbose((Object)tag, (String)msg, (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    GameLoger.debug(tag, msg, new Object[0]);
                    break;
                }
                case 4: {
                    GameLoger.info(tag, msg, new Object[0]);
                    break;
                }
                case 5: {
                    GameLoger.warn(tag, msg, new Object[0]);
                    break;
                }
                case 6: {
                    GameLoger.error(tag, msg);
                    break;
                }
            }
            RemoteGameDebugService.Companion.writeLog(msg);
            if (logSizeHelper != null) {
                logSizeHelper.appendLog(priority, msg);
            }
        }

        public void onLogMessage(int priority, String tag, String msg, Throwable throwable) {
            if (priority == 6) {
                MLog.error((Object)tag, (String)msg, (Throwable)throwable, (Object[])new Object[0]);
            } else {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"cocosLua", (String)"\u65e5\u5fd7\u63a5\u53e3\u4f7f\u7528\uff0c\u629b\u51fa\u5f02\u5e38\u5fc5\u987b\u4f7f\u7528error\u7ea7\u522b\u65e5\u5fd7", (Object[])new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)tag, (String)msg, (Object[])new Object[0]);
                }
            }
            RemoteGameDebugService.Companion.writeLog(msg);
            if (logSizeHelper != null) {
                logSizeHelper.appendLog(priority, msg);
            }
        }
    }
}

