/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.bean;

import com.yy.appbase.data.BaseDBBean;
import com.yy.appbase.data.GameResultDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.base.GameNotificationDef;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.GameWinDBQueryResult;
import java.util.ArrayList;

public class GameResultDb {
    static final String TAG = "GameResultDb";

    private GameResultDb() {
    }

    public static final GameResultDb getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void insertGameResult(final GameResultBean gameResultBean, final MyBox myBox) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameResultDBBean.Builder builder = GameResultDBBean.newBuilder();
                builder.gameid(gameResultBean.getGameID()).playTime(gameResultBean.getResultTime().longValue()).users(JsonParser.toJson((Object)gameResultBean.getUsers())).loses(JsonParser.toJson((Object)gameResultBean.getLosers())).winners(JsonParser.toJson((Object)gameResultBean.getWinners()));
                GameResultDBBean dbBean = builder.build();
                myBox.addItem((BaseDBBean)dbBean);
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Notification notification = Notification.obtain((int)GameNotificationDef.GAME_RESULT_INSEAT_SUCCESS);
                        notification.extObj = gameResultBean;
                        NotificationCenter.getGlobalInstance().notify(notification);
                    }
                });
            }
        });
    }

    public void queryGameWinCount(final GameResultBean gameResultBean, MyBox myBox) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"queryGameWin", (Object[])new Object[0]);
        }
        if (gameResultBean == null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        if (myBox == null) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("winners" + gameResultBean.getWinners()), (Object[])new Object[0]);
        }
        myBox.getAll(new MyBox.IGetItemsCallBack(){

            public void onLoaded(final ArrayList datas) {
                if (datas == null) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)GameResultDb.TAG, (String)"\u6ca1\u6709\u7ed3\u679c", (Object[])new Object[0]);
                    }
                    return;
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        GameResultDBBean.Builder resultBuilder = GameResultDBBean.newBuilder();
                        GameResultDBBean gameResultDBBean = resultBuilder.gameid(gameResultBean.getGameID()).users(JsonParser.toJson((Object)gameResultBean.getUsers())).winners(JsonParser.toJson((Object)gameResultBean.getWinners())).gameid(gameResultBean.getGameID()).build();
                        int count = 0;
                        for (Object bean : datas) {
                            if (!(bean instanceof GameResultDBBean) || !((GameResultDBBean)bean).getUsers().equals(gameResultDBBean.getUsers()) || !((GameResultDBBean)bean).getWinners().equals(gameResultDBBean.getWinners())) continue;
                            ++count;
                        }
                        final GameWinDBQueryResult.Builder builder = GameWinDBQueryResult.newBuilder();
                        builder.gameCount(count);
                        builder.gameResultBean(gameResultBean);
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Notification notification = Notification.obtain((int)GameNotificationDef.GAME_WIN_COUNT);
                                notification.extObj = builder.build();
                                NotificationCenter.getGlobalInstance().notify(notification);
                            }
                        });
                    }
                });
            }
        });
    }

    public void delGameWinToday(final GameResultBean gameResultBean, final MyBox myBox) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"delGameWinToday", (Object[])new Object[0]);
        }
        if (myBox == null) {
            return;
        }
        if (gameResultBean == null) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"\u5220\u9664\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final ArrayList palytimes = new ArrayList();
                myBox.getAll(new MyBox.IGetItemsCallBack(){

                    public void onLoaded(ArrayList datas) {
                        for (Object bean : datas) {
                            if (!(bean instanceof GameResultDBBean) || ((GameResultDBBean)bean).getPlayTime() > gameResultBean.getResultTime()) continue;
                            palytimes.add(((GameResultDBBean)bean).getPlayTime());
                        }
                        myBox.deleteByIndexs(palytimes);
                    }
                });
            }
        });
    }

    private static class SingletonHolder {
        private static final GameResultDb INSTANCE = new GameResultDb();

        private SingletonHolder() {
        }
    }
}

