/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.bean;

import android.content.Context;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateFormatUtils;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.game.bean.GameMatch2v2NotifyRes;
import com.yy.game.bean.GameMultiModeBean;
import com.yy.game.bean.GamePlayCountBean;
import com.yy.game.bean.I2V2PkMatchListener;
import com.yy.game.bean.IPkMatchListener;
import com.yy.game.download.flag.GameFlag;
import com.yy.game.metric.GameMetricCode;
import com.yy.game.metric.GameMetricHelper;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.game.GameBaseMsgDef;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.IMGamePkAcceptNotifyBean;
import com.yy.hiyo.game.base.IMGamePkCancelNotifyBean;
import com.yy.hiyo.game.base.IMGamePkNotifyBean;
import com.yy.hiyo.game.base.PkGameResource;
import com.yy.hiyo.game.base.bean.GameDef;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameMatchNotifyRes;
import com.yy.hiyo.game.base.bean.MatchPoolAnswerNotifyRes;
import com.yy.hiyo.game.base.bean.MatchPoolDownloadFinishReq;
import com.yy.hiyo.game.base.bean.MatchPoolInviteAnswerReq;
import com.yy.hiyo.game.base.bean.MatchPoolInviteNotifyRes;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.IIMPKGameListener;
import com.yy.hiyo.im.base.ImRecommendGameInfoManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import common.Header;
import ikxd.gameresult.PKWinStreakPush;
import ikxd.gameresult.PushProto;
import ikxd.gameresult.PushResultUri;
import ikxd.pkgame.AcceptMatchInviteNotify;
import ikxd.pkgame.AcceptMatchInviteReq;
import ikxd.pkgame.CancelMatchInviteNotify;
import ikxd.pkgame.GameDownloadFinishReq;
import ikxd.pkgame.IKXDPKGameUri;
import ikxd.pkgame.IKXDPkGameProto;
import ikxd.pkgame.MatchInviteNotify;
import ikxd.pkgame.PPKGameImPkCheckReq;
import ikxd.pkgame.PPKGameImPkCheckRes;
import ikxd.pkgame.PPkGameImPkAcceptNotify;
import ikxd.pkgame.PPkGameImPkCancelNotify;
import ikxd.pkgame.PPkGameImPkNotify;
import ikxd.pkgame.PPkGameUserMatchCancelReq;
import ikxd.pkgame.PPkGameUserMatchHeartbeatReq;
import ikxd.pkgame.PPkGameUserMatchNotify;
import ikxd.pkgame.PPkGameUserMatchReq;
import ikxd.pkgame.PPkGameUserMatchType;
import ikxd.pkgame.RejectMatchInviteReq;
import ikxd.pkgame.TeammateInfo;
import ikxd.pkgame.User2V2MatchNotify;
import ikxd.pkgame.User2V2TeammateLeaveNotify;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.ihago.money.api.mpl.GetUserVitalityRupeeRes;
import net.ihago.money.api.mpl.GetVitalityRupeeReq;
import okhttp3.Call;

public enum GameDataModel {
    instance;

    private static final long DEFAULT_MATCH_BEATTIME = 3L;
    private static final long HAVE_UID = 1L;
    private static final long NOT_HAVE_UID = 2L;
    private static final int MAX_RETRY_TIME = 3;
    public static final int GAME_NOT_HAVE = 1001;
    public static final int GAME_MAINTAIN = 1010;
    public static final int GAME_FULL = 1011;
    public static final int GAME_MPL_ID_INVALID = 1013;
    public static final int GAME_MPL_POWER_LOW = 1014;
    public static final int GAME_MPL_MONEY_LOW = 1015;
    public static final int REQ_SUCCESS = 0;
    public static Map<String, Integer> game_lose_count;
    private static final String GAME_EXPRESS_REQ = "emoji/list";
    private static final String DEV_DOMAIN = "ikxd-svr-test.yy.com";
    private static final String TAG = "GameDataModel";
    public static Map<String, GamePlayCountBean> mGamePlayedMap;
    public static Map<String, GameMultiModeBean> mModePlayedMap;
    private volatile long mBeatTime = 3L;
    private PKWinStreakPush mWinStreakData;
    private String mMatchGameId = "";
    private boolean isGoldGame = false;
    private ConcurrentLinkedQueue<IPkMatchListener> mGameMatchListener = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<IIMPKGameListener> mPKGameListener = new ConcurrentLinkedQueue();
    private volatile long mCurrentMatchSeqID = 0L;
    private Runnable mBeatTimer = new Runnable(){

        @Override
        public void run() {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)GameDataModel.TAG, (String)"matchbeat", (Object[])new Object[0]);
            }
            GameDataModel.this.startGameMatchBeat();
            GameDataModel.this.gameMatchHeartBeatReq();
        }
    };
    private Runnable mBeatConsumeTimer = new Runnable(){

        @Override
        public void run() {
            GameDataModel.this.gameMatchCancelReq(3L);
            GameDataModel.this.stopGameMatchBeat();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"gameMatchReq retry", (Object[])new Object[0]);
            }
            YYTaskExecutor.removeTask((Runnable)GameDataModel.this.mBeatConsumeTimer);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (GameDataModel.this.mGameMatchListener != null) {
                        for (IPkMatchListener matchListener : GameDataModel.this.mGameMatchListener) {
                            matchListener.onGameMatchRetry();
                        }
                    }
                }
            });
        }
    };
    GameProtoNotify gameProtoNotify = new GameProtoNotify();
    IProtoNotify mGameResultNotify = new IProtoNotify<PushProto>(){

        public String serviceName() {
            return "ikxd_game";
        }

        public void onNotify(@NonNull PushProto rootPro) {
            try {
                if (rootPro.uri == PushResultUri.kPKWinStreakPush) {
                    GameDataModel.this.mWinStreakData = (PKWinStreakPush)PKWinStreakPush.ADAPTER.decode(rootPro.data);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameDataModel.TAG, (String)"receive WinStreakPush data %s", (Object[])new Object[]{GameDataModel.this.mWinStreakData == null ? "null" : "win streak count " + ((GameDataModel)GameDataModel.this).mWinStreakData.win_streak_count});
                    }
                }
            }
            catch (Exception e) {
                MLog.error((Object)GameDataModel.TAG, (Throwable)e);
            }
        }
    };

    public void addGameMatchListener(IPkMatchListener listener) {
        if (this.mGameMatchListener == null) {
            this.mGameMatchListener = new ConcurrentLinkedQueue();
        }
        if (listener != null && !this.mGameMatchListener.contains(listener)) {
            this.mGameMatchListener.add(listener);
        }
    }

    public void removeGameMatchListener(IPkMatchListener listener) {
        if (this.mGameMatchListener != null) {
            this.mGameMatchListener.remove(listener);
        }
    }

    public void addPKGameListener(IIMPKGameListener listener) {
        if (this.mPKGameListener == null) {
            this.mPKGameListener = new ConcurrentLinkedQueue();
        }
        if (listener != null && !this.mPKGameListener.contains(listener)) {
            this.mPKGameListener.add(listener);
        }
    }

    public void removePKGameListener(IIMPKGameListener listener) {
        if (this.mPKGameListener != null) {
            this.mPKGameListener.remove(listener);
        }
    }

    public void postGameJoin(GameModel gameModel, int gameFrom) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (gameModel.getRoomid() != null) {
            map.put("roomId", gameModel.getRoomid());
        }
        if (gameModel.getGameInfo() != null) {
            map.put("gameId", gameModel.getGameInfo().getGid());
            Object result = MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC, (Object)gameModel);
            if (result instanceof Boolean && ((Boolean)result).booleanValue()) {
                map.put("isActivity", "true");
                map.put("activityMethodUri", (String)MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC, (Object)gameModel));
            }
        }
        if (gameModel.getOtherInfo() != null) {
            map.put("oppositeUid", String.valueOf(gameModel.getOtherInfo().getUid()));
        }
        map.put("ent_id", String.valueOf(gameFrom));
        HttpUtil.httpReq((String)UriProvider.GAME_JOIN_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
            }
        });
    }

    public void postGameMatch(GameModel gameDataModel) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (gameDataModel.getRoomid() != null) {
            map.put("roomId", gameDataModel.getRoomid());
        }
        if (gameDataModel.getGameInfo() != null) {
            map.put("gameId", gameDataModel.getGameInfo().getGid());
        }
        if (gameDataModel.getOtherInfo() != null) {
            map.put("oppositeUid", String.valueOf(gameDataModel.getOtherInfo().getUid()));
        }
        HttpUtil.httpReq((String)UriProvider.GAME_MATCH_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
            }
        });
    }

    public void postGameForceExit(GameModel gameDataModel, int gameFrom) {
        this.postGameForceExit(gameDataModel.getRoomid(), gameDataModel.getGameInfo() != null ? gameDataModel.getGameInfo().getGid() : null, gameDataModel.getOtherInfo() != null ? gameDataModel.getOtherInfo().getUid() : 0L, gameFrom);
    }

    public void postGameForceExit(String roomId, String gameId, long oppositeUid, int gameFrom) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (roomId != null) {
            map.put("roomId", roomId);
        }
        if (StringUtils.isNotEmpty((String)gameId)) {
            map.put("gameId", gameId);
        }
        if (oppositeUid > 0L) {
            map.put("oppositeUid", String.valueOf(oppositeUid));
        }
        map.put("ent_id", String.valueOf(gameFrom));
        HttpUtil.httpReq((String)UriProvider.GAME_FORCEEXIT_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)GameDataModel.TAG, (String)"report game force exit fail", (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameDataModel.TAG, (String)"report game force exit:%s", (Object[])new Object[]{response});
                }
            }
        });
    }

    public void postGameLeave(GameModel gameDataModel, int gameFrom) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (gameDataModel.getRoomid() != null) {
            map.put("roomId", gameDataModel.getRoomid());
        }
        if (gameDataModel.getGameInfo() != null) {
            map.put("gameId", gameDataModel.getGameInfo().getGid());
        }
        if (gameDataModel.getOtherInfo() != null) {
            map.put("oppositeUid", String.valueOf(gameDataModel.getOtherInfo().getUid()));
        }
        map.put("ent_id", String.valueOf(gameFrom));
        HttpUtil.httpReq((String)UriProvider.GAME_LEAVE_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
            }
        });
    }

    public void postGameLeave(GamePlayContext gameRunningContext, int gameFrom) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (gameRunningContext.getRoomId() != null) {
            map.put("roomId", gameRunningContext.getRoomId());
        }
        if (gameRunningContext.getGameInfo() != null) {
            map.put("gameId", gameRunningContext.getGameInfo().getGid());
        }
        if (gameRunningContext.getOtherUserInfo() != null) {
            map.put("oppositeUid", String.valueOf(gameRunningContext.getOtherUserInfo().getUid()));
        }
        map.put("ent_id", String.valueOf(gameFrom));
        HttpUtil.httpReq((String)UriProvider.GAME_LEAVE_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
            }
        });
    }

    public void postGameResult(GameModel gameModel, String result) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (gameModel != null) {
            map.put("roomId", gameModel.getRoomid());
        }
        if (gameModel != null && gameModel.getGameInfo() != null) {
            map.put("gameId", gameModel.getGameInfo().getGid());
            Object activityResult = MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.IS_ACTIVITY_SYNC, (Object)gameModel);
            if (activityResult instanceof Boolean && ((Boolean)activityResult).booleanValue()) {
                map.put("isActivity", "true");
                map.put("activityMethodUri", (String)MsgDispatcher.getInstance().sendMessageSync(GameBaseMsgDef.CallOutSide.GET_ACTIVITY_ID_SYNC, (Object)gameModel));
            }
        }
        map.put("result", result);
        HttpUtil.httpReq((String)UriProvider.GAME_RESULT_POST, map, (int)2, (INetRespCallback)new INetRespCallback<Object>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)GameDataModel.TAG, (String)("postGameResult error " + e.toString()), (Object[])new Object[0]);
            }

            public void onResponse(String response, BaseResponseBean<Object> res, int id2) {
            }
        });
    }

    public void gameMatchReq(UserInfoKS userInfoKS, GameInfo gameInfo, int targetSex, GameMatchContext gameMatchContext) {
        this.gameMatchReq(userInfoKS, gameInfo, targetSex, "", gameMatchContext);
    }

    private boolean needAiInvite30OldUser() {
        boolean needAiInvite = NAB.B.equals((Object)NewABDefine.HAGO_ANDROID_30OLD_AI_INVITE_1029.getTest());
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"needAiInvite30OldUser needAiInvite: %s AB: %s", (Object[])new Object[]{needAiInvite, NewABDefine.HAGO_ANDROID_30OLD_AI_INVITE_1029.getTest()});
        }
        if (!needAiInvite) {
            return false;
        }
        long registerTime = AccountUtil.getRegisterTime();
        if (registerTime <= 0L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"needAiInvite30OldUser registerTime <= 0", (Object[])new Object[0]);
            }
            return false;
        }
        long oneDay = 86400000L;
        long registerDay = registerTime / oneDay;
        long nowDay = System.currentTimeMillis() / oneDay;
        if (nowDay - registerDay < 30L) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"needAiInvite30OldUser nowDay - registerDay < 30  %s  %s", (Object[])new Object[]{registerDay, nowDay});
            }
            return false;
        }
        String key = "need_ai_invite_uid_" + AccountUtil.getUid();
        String date = GameFlag.getOld30MatchAi(key);
        if (FP.empty((CharSequence)date)) {
            Calendar today = Calendar.getInstance();
            String dateStr = DateFormatUtils.dateToString((Date)today.getTime(), (String)"yyyy-MM-dd");
            GameFlag.updateOld30MatchAI(key, dateStr);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"needAiInvite30OldUser updateOld30MatchAI : %s", (Object[])new Object[]{dateStr});
            }
            return true;
        }
        Calendar today = Calendar.getInstance();
        String dateStr = DateFormatUtils.dateToString((Date)today.getTime(), (String)"yyyy-MM-dd");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"needAiInvite30OldUser getDate: %s  dateStr: %s", (Object[])new Object[]{date, dateStr});
        }
        return StringUtils.equalsIgnoreCase((String)dateStr, (String)date);
    }

    public void gameMatchReq(UserInfoKS userInfoKS, GameInfo gameInfo, int targetSex, String pkId, GameMatchContext gameMatchContext) {
        if (gameInfo == null || userInfoKS == null || StringUtils.isEmpty((String)userInfoKS.avatar) || StringUtils.isEmpty((String)userInfoKS.nick)) {
            MLog.error((Object)TAG, (String)"game match req error,gameinfo:%s,user:%s", (Object[])new Object[]{gameInfo, userInfoKS});
            return;
        }
        double latitude = 0.0;
        double longitude = 0.0;
        if (LocationHelper.getLocationInfo((boolean)true) != null) {
            LocationInfo locationInfo = LocationHelper.getLocationInfo((boolean)true);
            latitude = locationInfo.getLatitude();
            longitude = locationInfo.getLongitude();
        }
        int matchAiSex = 0;
        boolean isFirstPlayThisGame = false;
        long targetUid = 0L;
        String mplId = "";
        GameInfoModule gameInfoModule = (GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class);
        if (gameInfoModule != null) {
            isFirstPlayThisGame = !gameInfoModule.hasGamePlayed(gameInfo.getGid());
        }
        boolean isMatchAi = false;
        if (gameMatchContext != null && gameMatchContext.getExtendValue("isMatchAi", (Object)false) != null) {
            isMatchAi = (Boolean)gameMatchContext.getExtendValue("isMatchAi", (Object)false);
        }
        if (gameMatchContext != null && gameMatchContext.getExtendValue("matchTargetUid", (Object)0L) != null) {
            long aiUid = (Long)gameMatchContext.getExtendValue("matchTargetUid", (Object)0L);
            if (isMatchAi && aiUid > 0L) {
                targetUid = aiUid;
            }
        }
        if (gameMatchContext != null && gameMatchContext.getExtendValue("matchAiSex", (Object)0) != null) {
            matchAiSex = (Integer)gameMatchContext.getExtendValue("matchAiSex", (Object)0);
            if (isMatchAi && matchAiSex > 0) {
                targetSex = matchAiSex;
            }
        }
        if (gameMatchContext != null && gameMatchContext.getExtendValue("matchAiSex", (Object)0) != null) {
            mplId = (String)gameMatchContext.getExtendValue("mpl_id", (Object)"");
        }
        boolean hasPlayCoinGame = true;
        Object cacheValue = null;
        if (gameMatchContext != null && (cacheValue = gameMatchContext.getExtendValue("hasPlayGoldGame", (Object)true)) instanceof Boolean) {
            hasPlayCoinGame = (Boolean)cacheValue;
        }
        if (!hasPlayCoinGame) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"never play gold game, match ai!", (Object[])new Object[0]);
            }
            isMatchAi = true;
        }
        long coins = ((ICoinsService)ServiceManagerProxy.getServiceManager().getService(ICoinsService.class)).coinStateData().gameCoinCount;
        boolean need30OldMatchAi = this.needAiInvite30OldUser();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"need30OldMatchAi: %s", (Object[])new Object[]{need30OldMatchAi});
        }
        if (need30OldMatchAi && RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"need30OldMatchAi", (int)1);
        }
        long coinsTimes = ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getPlayGoldTimes(gameInfo.gid);
        PPkGameUserMatchReq.Builder builder = new PPkGameUserMatchReq.Builder().game_id(gameInfo.getGid()).avatar_url(userInfoKS.getAvatar()).nick(userInfoKS.getNick() == null ? "" : userInfoKS.getNick()).is_first_play(Boolean.valueOf(isFirstPlayThisGame)).type(Long.valueOf(PPkGameUserMatchType.k_pkgame_user_match_type_normal.getValue())).age(Long.valueOf(DateUtils.getAge((String)userInfoKS.getBirthday()))).sex(Long.valueOf(userInfoKS.getSex())).is_new_user(Boolean.valueOf(AccountUtil.isTodayRegister() || need30OldMatchAi)).match_ai(Boolean.valueOf(isMatchAi)).ai_uid(Long.valueOf(targetUid)).target_sex(Long.valueOf(targetSex)).game_ver(Long.valueOf(StringUtils.parseLong((String)gameInfo.getModulerVer()))).is_gold(Boolean.valueOf(gameInfo.isGoldMode())).gold_balance(Long.valueOf(coins)).gold_times(Long.valueOf(coinsTimes)).birthday(userInfoKS.birthday == null ? "" : userInfoKS.birthday).client_random(Boolean.valueOf(false));
        if (latitude != 0.0) {
            builder.latitude(Float.valueOf((float)latitude));
        }
        if (longitude != 0.0) {
            builder.longitude(Float.valueOf((float)longitude));
        }
        if (StringUtils.isNotEmpty((String)pkId)) {
            builder.pk_id(pkId);
        }
        String payload = "";
        if (!TextUtils.isEmpty((CharSequence)mplId)) {
            JsonStringBuilder jsonBuilder = JsonStringBuilder.newBuilder();
            jsonBuilder.put("src", (Object)"mlp").put("id", (Object)mplId);
            payload = jsonBuilder.buildJson();
        } else if (TextUtils.isEmpty((CharSequence)payload)) {
            payload = gameMatchContext.getExtendValue("js_paylod", (Object)"").toString();
        }
        builder.source(payload);
        if (game_lose_count.get(gameInfo.getGid()) != null) {
            builder.game_defeat_count(Long.valueOf(game_lose_count.get(gameInfo.getGid()).longValue()));
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"start game match,is new user:%b, uid:%d, isGoldGame:%b", (Object[])new Object[]{AccountUtil.isTodayRegister(), AccountUtil.getUid(), gameInfo.isGoldMode()});
        }
        PPkGameUserMatchReq req = builder.build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"gameMatchReq seqid=%s", (Object[])new Object[]{header.seqid});
        }
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameUserMatchReq).user_match_req(req).build();
        this.startGameMatchConsumeBeat();
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
                GameMetricCode.USE_MATCH_TIME = 0L;
                if (response == null) {
                    GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, "10009");
                    return;
                }
                GameDataModel.this.stopGameMatchConsumeBeat();
                Header header = response.header;
                if (header.seqid < GameDataModel.this.mCurrentMatchSeqID) {
                    GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, "10008");
                    return;
                }
                GameDataModel.this.mCurrentMatchSeqID = header.seqid;
                long code = header.code;
                if (code == 1001L || code == 1010L || code == 1011L || code == 1013L || code == 1014L || code == 1015L) {
                    if (GameDataModel.this.mGameMatchListener != null) {
                        int failType;
                        int n = code == 1001L ? 4 : (failType = code == 1010L ? 5 : 6);
                        if (code == 1013L) {
                            failType = 8;
                        } else if (code == 1014L) {
                            failType = 9;
                        } else if (code == 1015L) {
                            failType = 10;
                        }
                        GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, GameMetricCode.getPkGameUserMatchResultCode(failType));
                        for (IPkMatchListener matchListener : GameDataModel.this.mGameMatchListener) {
                            matchListener.onGameMatchFail(failType);
                        }
                    }
                    return;
                }
                if (response.uri == IKXDPKGameUri.kUriIKXDPkGameUserMatchRes && header.code == 0L && response.user_match_res != null) {
                    GameDataModel.this.isGoldGame = response.user_match_res.is_gold;
                    GameDataModel.this.mBeatTime = response.user_match_res.heartbeat_interval_seconds;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameDataModel.TAG, (String)("kUriIKXDPkGameUserMatchRes beatTime:" + GameDataModel.this.mBeatTime), (Object[])new Object[0]);
                    }
                    if (GameDataModel.this.mBeatTime <= 0L) {
                        GameDataModel.this.mBeatTime = 3L;
                    }
                    GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, "0");
                    GameMetricCode.USE_MATCH_TIME = SystemClock.elapsedRealtime();
                    GameDataModel.this.startGameMatchBeat();
                    return;
                }
                GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchReq", time, "99999");
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameDataModel.TAG, (String)"gameMatchReq retryWhenTimeout:", (Object[])new Object[0]);
                }
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameDataModel.TAG, (String)"gameMatchReq retryWhenError:", (Object[])new Object[0]);
                }
                return false;
            }
        });
    }

    private void startGameMatchBeat() {
        YYTaskExecutor.removeTask((Runnable)this.mBeatTimer);
        YYTaskExecutor.execute((Runnable)this.mBeatTimer, (long)(this.mBeatTime * 1000L));
    }

    public void stopGameMatchBeat() {
        YYTaskExecutor.removeTask((Runnable)this.mBeatTimer);
    }

    private void startGameMatchConsumeBeat() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"startGameMatchConsumeBeat", (Object[])new Object[0]);
        }
        if (this.isMatchRetry()) {
            YYTaskExecutor.removeTask((Runnable)this.mBeatConsumeTimer);
            YYTaskExecutor.execute((Runnable)this.mBeatConsumeTimer, (long)(this.getMatchRetryTime() * 1000L));
        }
    }

    public void stopGameMatchConsumeBeat() {
        YYTaskExecutor.removeTask((Runnable)this.mBeatConsumeTimer);
    }

    public void gameMatchHeartBeatReq() {
        PPkGameUserMatchHeartbeatReq req = new PPkGameUserMatchHeartbeatReq.Builder().type(Long.valueOf(PPkGameUserMatchType.k_pkgame_user_match_type_normal.getValue())).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameUserMatchHeartbeatReq).user_match_heartbeat_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                if (response != null && response.uri == IKXDPKGameUri.kUriIKXDPkGameUserMatchHeartbeatRes && response.user_match_heartbeat_res.exist_uid == 2L) {
                    GameDataModel.this.stopGameMatchBeat();
                    for (IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                        gameMatchListener.onGameMatchFail(7);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void registerGameNotify() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)this.gameProtoNotify);
    }

    public void gameMatchCancelReq(@GameDef.Trigger long triggerEvent) {
        PPkGameUserMatchCancelReq req = new PPkGameUserMatchCancelReq.Builder().type(Long.valueOf(PPkGameUserMatchType.k_pkgame_user_match_type_normal.getValue())).trigger_event(Long.valueOf(triggerEvent)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPkGameCancelUserMatchReq).user_match_cancel_req(req).build();
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto message) {
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void checkGameImPkValid(String pkId) {
        PPKGameImPkCheckReq req = new PPKGameImPkCheckReq.Builder().pk_id(pkId).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto pkGameProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriIKXDPKGameImPkCheckReq).im_pk_check_req(req).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"checkGameImPkValid==>seqid=%s", (Object[])new Object[]{header.seqid});
        }
        ProtoManager.getInstance().send((AndroidMessage)pkGameProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public void onResponse(@Nullable IKXDPkGameProto response) {
                if (response != null && response.uri == IKXDPKGameUri.kUriIKXDPKGameImPkCheckRes) {
                    PPKGameImPkCheckRes ppkGameImPkCheckRes = response.im_pk_check_res;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)GameDataModel.TAG, (String)("PPKGameImPkCheckRes " + ppkGameImPkCheckRes.b_valid), (Object[])new Object[0]);
                    }
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    public void registerGameResultNotify() {
        ProtoManager.getInstance().registerNotify(this.mGameResultNotify);
    }

    public PKWinStreakPush getWinStreakData() {
        return this.mWinStreakData;
    }

    public void setmWinStreakData(PKWinStreakPush mWinStreakData) {
        this.mWinStreakData = mWinStreakData;
    }

    public static Map<String, Integer> getGame_lose_count() {
        return game_lose_count;
    }

    public static void putGame_lose_count(String key, int count) {
        game_lose_count.put(key, count);
    }

    public long getMatchRetryTime() {
        int time = SettingFlags.getIntValue((String)"pkmatchgametime", (int)8);
        return Math.max(5, time);
    }

    public boolean isMatchRetry() {
        return SettingFlags.getBoolean((String)"pkmatchgameretry", (boolean)true);
    }

    public String getMatchGameId() {
        return this.mMatchGameId;
    }

    public void setMatchGameId(String mMatchGameId) {
        this.mMatchGameId = mMatchGameId;
    }

    public void getMplRewardLimit(String gameId, final ICommonCallback<GetUserVitalityRupeeRes> callback2) {
        GetVitalityRupeeReq req = new GetVitalityRupeeReq.Builder().sequence(Long.valueOf(System.currentTimeMillis())).uid(Long.valueOf(AccountUtil.getUid())).game_id(gameId).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)req, (IProtoCallback)new IProtoCallback<GetUserVitalityRupeeRes>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)GameDataModel.TAG, (String)"getMplRewardLimit timeout", (Object[])new Object[0]);
                        callback2.onFail(0, "timeout", new Object[0]);
                    }
                });
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MLog.error((Object)GameDataModel.TAG, (String)"getMplRewardLimit timeout", (Object[])new Object[0]);
                        callback2.onFail(0, "timeout", new Object[0]);
                    }
                });
                return false;
            }

            public void onResponse(@NonNull GetUserVitalityRupeeRes message, long code, String msg) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)GameDataModel.TAG, (String)"getMplRewardLimit success", (Object[])new Object[0]);
                }
                callback2.onSuccess((Object)message, new Object[0]);
            }
        });
    }

    public void answerMatchPoolInvite(final MatchPoolInviteAnswerReq reqBean) {
        if (reqBean == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)("answerMatchPoolInvite reqBean: " + reqBean), (Object[])new Object[0]);
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        IKXDPkGameProto reqProto = null;
        if (reqBean.getAccept()) {
            AcceptMatchInviteReq matchInviteReq = new AcceptMatchInviteReq.Builder().invite_id(reqBean.getInviteId()).game_id(reqBean.getGameId()).game_ver(Long.valueOf(reqBean.getGameVer())).need_download(Boolean.valueOf(reqBean.getNeedDownload())).invitee_uid(Long.valueOf(reqBean.getInviteeUid())).invitee_sex(Long.valueOf(reqBean.getInviteeSex())).invitee_nick(reqBean.getInviteeNick()).invitee_avatar(reqBean.getInviteeAvatar()).build();
            reqProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriAcceptMatchInviteReq).accept_match_invite_req(matchInviteReq).build();
        } else {
            RejectMatchInviteReq matchInviteReq = new RejectMatchInviteReq.Builder().invite_id(reqBean.getInviteId()).build();
            reqProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriRejectMatchInviteReq).reject_match_invite_req(matchInviteReq).build();
        }
        ProtoManager.getInstance().send((AndroidMessage)reqProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }

            public void onResponse(@Nullable IKXDPkGameProto message) {
                IKXDPKGameUri targetUri = reqBean.getAccept() ? IKXDPKGameUri.kUriAcceptMatchInviteRes : IKXDPKGameUri.kUriRejectMatchInviteRes;
                if (message != null && message.uri == targetUri) {
                    MLog.debug((Object)GameDataModel.TAG, (String)("answerMatchPoolInvite accept: " + reqBean.getAccept() + " response success"), (Object[])new Object[0]);
                } else {
                    MLog.error((Object)GameDataModel.TAG, (String)("answerMatchPoolInvite accept: " + reqBean.getAccept() + " response null"), (Object[])new Object[0]);
                }
            }
        });
    }

    public void answerMatchPoolDownloadFinish(MatchPoolDownloadFinishReq reqBean) {
        if (reqBean == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)("answerMatchPoolDownloadFinish reqBean: " + reqBean), (Object[])new Object[0]);
        Header header = ProtoManager.getInstance().getHeader("ikxd_pkgame_d");
        GameDownloadFinishReq finishReq = new GameDownloadFinishReq.Builder().invite_id(reqBean.getInviteId()).game_id(reqBean.getGameId()).game_ver(Long.valueOf(reqBean.getGameVer())).build();
        IKXDPkGameProto reqProto = new IKXDPkGameProto.Builder().header(header).uri(IKXDPKGameUri.kUriGameDownloadFinishReq).game_download_finish_req(finishReq).build();
        ProtoManager.getInstance().send((AndroidMessage)reqProto, (IProtoCallback)new IProtoCallback<IKXDPkGameProto>(){

            public boolean retryWhenTimeout(boolean canRetry) {
                return true;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }

            public void onResponse(@Nullable IKXDPkGameProto message) {
                if (message != null && message.uri == IKXDPKGameUri.kUriGameDownloadFinishRes && message.game_download_finish_res != null) {
                    MLog.debug((Object)GameDataModel.TAG, (String)"answerMatchPoolDownloadFinish response success", (Object[])new Object[0]);
                } else {
                    MLog.error((Object)GameDataModel.TAG, (String)"answerMatchPoolDownloadFinish response null", (Object[])new Object[0]);
                }
            }
        });
    }

    static {
        game_lose_count = new HashMap<String, Integer>();
        mGamePlayedMap = new ConcurrentHashMap<String, GamePlayCountBean>();
        mModePlayedMap = new ConcurrentHashMap<String, GameMultiModeBean>();
    }

    class GameProtoNotify
    implements IProtoNotify<IKXDPkGameProto> {
        GameProtoNotify() {
        }

        public String serviceName() {
            return "ikxd_pkgame_d";
        }

        public void onNotify(@NonNull IKXDPkGameProto result) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)("receive notify uri: " + result.uri), (Object[])new Object[0]);
            }
            switch (result.uri) {
                case kUriMatchInviteNotify: {
                    this.handleMatchInviteNotify(result);
                    break;
                }
                case kUriAcceptMatchInviteNotify: 
                case kUriCancelMatchInviteNotify: {
                    this.handleMatchInviteAnswer(result);
                    break;
                }
                case kUriIKXDPkGameUserMatchNotify: {
                    this.handleGameUserMatchNotify(result);
                    break;
                }
                case kUriUser2V2MatchNotify: {
                    this.handle2V2MatchNotify(result);
                    break;
                }
                case kUriIKXDPkGameImPkNotify: {
                    this.handleImPkNotify(result);
                    break;
                }
                case kUriIKXDPKGameImPkAcceptNotify: {
                    this.handleImPkAccept(result);
                    break;
                }
                case kUriIKXDPkGameImPkCancelNotify: {
                    this.handleImPkCancel(result);
                    break;
                }
                case kUriUser2V2TeammateLeaveNotify: {
                    this.handle2V2TeammateLeave(result);
                    break;
                }
            }
        }

        private void handleMatchInviteNotify(IKXDPkGameProto result) {
            MatchInviteNotify matchInviteNotify = result.match_invite_notify;
            if (matchInviteNotify == null) {
                MLog.error((Object)GameDataModel.TAG, (String)"IKXDPKGameUri.kUriMatchInviteNotify null", (Object[])new Object[0]);
                return;
            }
            MLog.debug((Object)GameDataModel.TAG, (String)"IKXDPKGameUri.kUriMatchInviteNotify, gameId: %s, inviter: %s, invitee: %s, inviterNick: %s", (Object[])new Object[]{matchInviteNotify.game_id, matchInviteNotify.inviter_uid, matchInviteNotify.invitee_uid, matchInviteNotify.inviter_nick});
            GameDataModel.this.stopGameMatchConsumeBeat();
            MatchPoolInviteNotifyRes.Builder builder = new MatchPoolInviteNotifyRes.Builder();
            builder.setGameId(matchInviteNotify.game_id);
            builder.setGameVer(matchInviteNotify.game_ver.longValue());
            builder.setInviteId(matchInviteNotify.invite_id);
            builder.setInviteeUid(matchInviteNotify.invitee_uid.longValue());
            builder.setInviterUid(matchInviteNotify.inviter_uid.longValue());
            builder.setInviterNick(matchInviteNotify.inviter_nick);
            builder.setInviterSex(matchInviteNotify.inviter_sex.longValue());
            builder.setInviterAvatar(matchInviteNotify.inviter_avatar);
            final MatchPoolInviteNotifyRes notifyRes = builder.build();
            for (final IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        gameMatchListener.onMatchInviteNotify(notifyRes);
                    }
                });
            }
        }

        private void handleMatchInviteAnswer(IKXDPkGameProto result) {
            MatchPoolAnswerNotifyRes.Builder builder = new MatchPoolAnswerNotifyRes.Builder();
            if (result.uri == IKXDPKGameUri.kUriAcceptMatchInviteNotify) {
                AcceptMatchInviteNotify acceptMatchInviteNotify = result.accept_match_invite_notify;
                if (acceptMatchInviteNotify == null) {
                    MLog.error((Object)GameDataModel.TAG, (String)"IKXDPKGameUri.kUriAcceptMatchInviteNotify null", (Object[])new Object[0]);
                    return;
                }
                builder.setAccepted(true);
                builder.setInviteId(acceptMatchInviteNotify.invite_id);
                builder.setInviterUid(acceptMatchInviteNotify.inviter_uid.longValue());
                builder.setInviteeAvatar(acceptMatchInviteNotify.invitee_avatar);
                builder.setInviteeUid(acceptMatchInviteNotify.invitee_uid.longValue());
                builder.setInviteeNick(acceptMatchInviteNotify.invitee_nick);
                builder.setInviteeSex(acceptMatchInviteNotify.invitee_sex.longValue());
            } else {
                CancelMatchInviteNotify cancelMatchInviteNotify = result.cancel_match_invite_notify;
                if (cancelMatchInviteNotify == null) {
                    MLog.error((Object)GameDataModel.TAG, (String)"IKXDPKGameUri.kUriCancelMatchInviteNotify null", (Object[])new Object[0]);
                    return;
                }
                builder.setAccepted(false);
                builder.setInviteId(cancelMatchInviteNotify.invite_id);
            }
            final MatchPoolAnswerNotifyRes res = builder.build();
            for (final IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        gameMatchListener.onMatchInviteResponse(res);
                    }
                });
            }
        }

        private void handleGameUserMatchNotify(IKXDPkGameProto result) {
            PPkGameUserMatchNotify gameNotify = result.user_match_notify;
            if (gameNotify == null) {
                MLog.warn((Object)GameDataModel.TAG, (String)"kUriIKXDPkGameUserMatchNotify fail, notify is null", (Object[])new Object[0]);
                return;
            }
            if (!StringUtils.equal((String)gameNotify.game_id, (String)GameDataModel.this.mMatchGameId)) {
                MLog.warn((Object)GameDataModel.TAG, (String)("kUriIKXDPkGameUserMatchNotify fail, game not match: " + gameNotify.game_id), (Object[])new Object[0]);
                long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
                GameMetricCode.USE_MATCH_TIME = 0L;
                GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "10005");
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"kUriIKXDPkGameUserMatchNotify:othernickname %s %s", (Object[])new Object[]{gameNotify.nick, gameNotify.uid});
            }
            GameDataModel.this.gameMatchCancelReq(1L);
            GameDataModel.this.stopGameMatchBeat();
            GameDataModel.this.stopGameMatchConsumeBeat();
            PkGameResource.Builder resourceBuild = PkGameResource.newBuilder();
            resourceBuild.roomid(gameNotify.resource.roomId).token(gameNotify.resource.roomId.getBytes()).url(gameNotify.resource.url);
            final GameMatchNotifyRes.Builder resBuilder = GameMatchNotifyRes.newBuilder();
            resBuilder.ai(gameNotify.ai.booleanValue()).avatar_url(gameNotify.avatar_url).game_id(gameNotify.game_id).nick(gameNotify.nick).resource(resourceBuild.build()).sex(gameNotify.sex.longValue()).tips(gameNotify.tips).uid(gameNotify.uid.longValue()).matchTips(gameNotify.matchTips).matchRule(gameNotify.match_rule.longValue()).isGoldGame(gameNotify.is_gold.booleanValue());
            if (!StringUtils.isEmpty((String)gameNotify.recom_reason)) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"ImRecommendGameInfoManager", (String)"RecomReason()=%s, ReasonType=%d, isGoldGame:%b", (Object[])new Object[]{gameNotify.recom_reason, gameNotify.reason_type, gameNotify.is_gold});
                }
                ImRecommendGameInfoManager.INSTANCE.setMatchReason(gameNotify.recom_reason);
            }
            for (final IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        gameMatchListener.onGameMatchSuccess(resBuilder.build());
                    }
                });
            }
        }

        private void handle2V2MatchNotify(IKXDPkGameProto result) {
            UserInfoKS userInfoKS;
            User2V2MatchNotify gameNotify = result.user_2V2_match_notify;
            if (gameNotify == null) {
                MLog.error((Object)GameDataModel.TAG, (String)"kUriUser2V2MatchNotify matchNotify is null", (Object[])new Object[0]);
                return;
            }
            if (!StringUtils.equal((String)gameNotify.game_id, (String)GameDataModel.this.mMatchGameId)) {
                long time = GameMetricCode.USE_MATCH_TIME > 0L ? SystemClock.elapsedRealtime() - GameMetricCode.USE_MATCH_TIME : 0L;
                GameMetricCode.USE_MATCH_TIME = 0L;
                GameMetricHelper.reportToMetric("pkGame/kUriIKXDPkGameUserMatchNotify", time, "10005");
                return;
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"\u6536\u52302v2\u6e38\u620f\u5339\u914d\u6210\u529f\u901a\u77e5", (Object[])new Object[0]);
            }
            GameDataModel.this.gameMatchCancelReq(1L);
            GameDataModel.this.stopGameMatchBeat();
            GameDataModel.this.stopGameMatchConsumeBeat();
            PkGameResource.Builder resourceBuild = PkGameResource.newBuilder();
            resourceBuild.roomid(gameNotify.resource.roomId).token(gameNotify.resource.roomId.getBytes()).url(gameNotify.resource.url);
            final GameMatch2v2NotifyRes.Builder resBuilder = GameMatch2v2NotifyRes.newBuilder();
            resBuilder.game_id(gameNotify.game_id).matchTips(gameNotify.matchTips).resource(resourceBuild.build());
            LinkedHashMap<Long, UserInfoKS> blueTeamMap = new LinkedHashMap<Long, UserInfoKS>();
            LinkedHashMap<Long, UserInfoKS> redTeamMap = new LinkedHashMap<Long, UserInfoKS>();
            UserInfoModule module = (UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class);
            for (TeammateInfo teammateInfo : gameNotify.blue) {
                userInfoKS = new UserInfoKS();
                userInfoKS.update(teammateInfo);
                userInfoKS = module.updateUserInfoIfNotExist(userInfoKS);
                blueTeamMap.put(teammateInfo.uid, userInfoKS);
            }
            for (TeammateInfo teammateInfo : gameNotify.red) {
                userInfoKS = new UserInfoKS();
                userInfoKS.update(teammateInfo);
                userInfoKS = module.updateUserInfoIfNotExist(userInfoKS);
                redTeamMap.put(teammateInfo.uid, userInfoKS);
            }
            if (blueTeamMap.containsKey(AccountUtil.getUid())) {
                resBuilder.myTeamMap(blueTeamMap);
                resBuilder.otherTeamMap(redTeamMap);
            } else {
                resBuilder.otherTeamMap(blueTeamMap);
                resBuilder.myTeamMap(redTeamMap);
            }
            for (final IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (gameMatchListener instanceof I2V2PkMatchListener) {
                            ((I2V2PkMatchListener)gameMatchListener).on2V2GameMatchSuccess(resBuilder.build());
                        }
                    }
                });
            }
        }

        private void handleImPkNotify(IKXDPkGameProto result) {
            Header header = result.header;
            PPkGameImPkNotify gameNotify = result.im_pk_notify;
            IMGamePkNotifyBean.Builder builder = IMGamePkNotifyBean.newBuilder();
            IMGamePkNotifyBean imGamePkNotifyBean = builder.from_type(gameNotify.from_type.longValue()).game_id(gameNotify.game_id).pk_id(gameNotify.pk_id).source_uid(gameNotify.source_uid.longValue()).code(header.code.longValue()).build();
            for (IIMPKGameListener listener : GameDataModel.this.mPKGameListener) {
                listener.onPKGameNotify(imGamePkNotifyBean);
            }
        }

        private void handleImPkAccept(IKXDPkGameProto result) {
            Header header = result.header;
            PPkGameImPkAcceptNotify gameNotify = result.im_pk_accept_notify;
            PkGameResource.Builder resBuilder = PkGameResource.newBuilder();
            PkGameResource resource = resBuilder.roomid(gameNotify.resource.roomId).token(gameNotify.resource.token.toByteArray()).url(gameNotify.resource.url).payload(gameNotify.resource.info_payload).build();
            IMGamePkAcceptNotifyBean.Builder builder = IMGamePkAcceptNotifyBean.newBuilder();
            IMGamePkAcceptNotifyBean imGamePkNotifyBean = builder.from_type(gameNotify.from_type.longValue()).accept(gameNotify.accept.booleanValue()).pk_id(gameNotify.pk_id).accept_uid(gameNotify.accept_uid.longValue()).gameid(gameNotify.gameid).refuse_type((long)gameNotify.refuse_type.intValue()).resource(resource).isGoldGame(gameNotify.is_gold.booleanValue()).code(header.code.longValue()).build();
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"kUriIKXDPKGameImPkAcceptNotify,isGoldGame:%b", (Object[])new Object[]{gameNotify.is_gold});
            }
            for (IIMPKGameListener listener : GameDataModel.this.mPKGameListener) {
                listener.onPKGameAccptNotify(imGamePkNotifyBean);
            }
        }

        private void handleImPkCancel(IKXDPkGameProto result) {
            Header header = result.header;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"kUriIKXDPkGameImPkCancelNotify", (Object[])new Object[0]);
            }
            PPkGameImPkCancelNotify gameNotify = result.im_pk_cancel_notify;
            IMGamePkCancelNotifyBean.Builder builder = IMGamePkCancelNotifyBean.newBuilder();
            IMGamePkCancelNotifyBean imGamePkNotifyBean = builder.pk_id(gameNotify.pk_id).code(header.code.longValue()).build();
            for (IIMPKGameListener listener : GameDataModel.this.mPKGameListener) {
                listener.onPKGameCancelNotify(imGamePkNotifyBean);
            }
        }

        private void handle2V2TeammateLeave(IKXDPkGameProto result) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameDataModel.TAG, (String)"kUriIKXDPkGameImPkCancelNotify", (Object[])new Object[0]);
            }
            final User2V2TeammateLeaveNotify gameNotify = result.user_2V2_teammate_leave_notify;
            for (final IPkMatchListener gameMatchListener : GameDataModel.this.mGameMatchListener) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (gameMatchListener instanceof I2V2PkMatchListener) {
                            ((I2V2PkMatchListener)gameMatchListener).on2V2GameMatchCancelNotify(gameNotify.pk_id);
                        }
                    }
                });
            }
        }
    }
}

