/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game.bean;

import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.game.bean.FriendBean;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import common.Header;
import ikxd.apigateway.ApiGateway;
import ikxd.apigateway.GetHFAFriendsReq;
import ikxd.apigateway.GetHFAFriendsRes;
import ikxd.apigateway.Uri;
import ikxd.apigateway.UserInfo;
import java.util.ArrayList;
import java.util.List;

public class FriendListDataModel {
    private static final String TAG = "FriendListDataModel";
    private static FriendListDataModel instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FriendListDataModel getInstance() {
        if (instance != null) return instance;
        Class<FriendListDataModel> clazz = FriendListDataModel.class;
        synchronized (FriendListDataModel.class) {
            if (instance != null) return instance;
            instance = new FriendListDataModel();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private FriendListDataModel() {
    }

    public void requestFriendList(final IRequestFriendListCallback callback2) {
        GetHFAFriendsReq req = new GetHFAFriendsReq.Builder().limit(Long.valueOf(40L)).build();
        Header header = ProtoManager.getInstance().getHeader("ikxd_apigateway_d");
        ApiGateway gateway = new ApiGateway.Builder().header(header).get_hfa_friends_req(req).uri(Uri.kUriGetHFAFriendsReq).build();
        ProtoManager.getInstance().send((AndroidMessage)gateway, (IProtoCallback)new IProtoCallback<ApiGateway>(){

            public void onResponse(@Nullable ApiGateway apiGateway) {
                if (apiGateway == null) {
                    MLog.error((Object)FriendListDataModel.TAG, (String)"getFriends error, proto is null", (Object[])new Object[0]);
                    FriendListDataModel.this.postFail(callback2);
                    return;
                }
                GetHFAFriendsRes getHFAFriendsRes = apiGateway.get_hfa_friends_res;
                List userInfos = getHFAFriendsRes.users;
                ArrayList<FriendBean> list = new ArrayList<FriendBean>();
                for (UserInfo userInfo : userInfos) {
                    list.add(new FriendBean(userInfo));
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)FriendListDataModel.TAG, (String)"on get friends success,size:%d", (Object[])new Object[]{list.size()});
                }
                FriendListDataModel.this.postSuccess(list, callback2);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)FriendListDataModel.TAG, (String)("on load friends timeout:" + canRetry), (Object[])new Object[0]);
                }
                FriendListDataModel.this.postFail(callback2);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)FriendListDataModel.TAG, (String)"on load friends error:%s ,code:%d", (Object[])new Object[]{reason, code});
                }
                FriendListDataModel.this.postFail(callback2);
                return false;
            }
        });
    }

    private void postSuccess(List<FriendBean> findFriends, IRequestFriendListCallback callback2) {
        YYTaskExecutor.postToMainThread(() -> {
            if (callback2 != null) {
                callback2.onSuccess(findFriends);
            }
        });
    }

    private void postFail(final IRequestFriendListCallback callback2) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callback2 != null) {
                    callback2.onFail();
                }
            }
        });
    }

    public static interface IRequestFriendListCallback {
        public void onSuccess(List<FriendBean> var1);

        public void onFail();
    }
}

