/*
 * Decompiled with CFR 0.152.
 */
package com.yy.game;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.callback.ICommonCallback;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.GameResultDBBean;
import com.yy.appbase.data.MyBox;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.NavigationUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.game.R;
import com.yy.game.TjgGameReportHelper;
import com.yy.game.bean.GameDataModel;
import com.yy.game.bean.GameResultDb;
import com.yy.game.cocos2d.CocosGameEngine;
import com.yy.game.download.BuiltInGameManager;
import com.yy.game.download.GameDownloadManager;
import com.yy.game.download.GameDownloadUtils;
import com.yy.game.download.IBuiltInGameCallback;
import com.yy.game.download.IGameDownloadManager;
import com.yy.game.download.version.GameVersion;
import com.yy.game.download.version.GameVersionInfo;
import com.yy.game.download.version.GameVersionPresenter;
import com.yy.game.gamemodule.activity.mpl.MPLDataModel;
import com.yy.game.gameproxy.appcallgame.AppCallGameProxy;
import com.yy.game.module.channelgame.model.GameListModel;
import com.yy.game.module.gameinvite.PkGameInviteCodeHelp;
import com.yy.game.module.gameload.LoadGamePageManager;
import com.yy.game.module.gamesource.GameSourceDialogPresenter;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.channelgame.IChannelGameListModel;
import com.yy.hiyo.game.service.IAppCallGameProxy;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import com.yy.hiyo.game.source.IGameSourceDialoger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.ihago.activity.srv.mpl.IsMplValidRes;

public class GameController
extends DefaultWindowController
implements IGameService,
IBuiltInGameCallback {
    private static final String TAG = "GameController";
    private boolean isInit = false;
    private boolean isNetValid;
    private IGameDownloadManager mGameDownloadManager;
    private GameLifecycle mGameLife;
    private final GameVersionPresenter mGameVersionPresenter;
    private GameListModel mChannelGameListModel = null;

    public GameController(Environment env) {
        super(env);
        GameDataModel.instance.registerGameNotify();
        GameDataModel.instance.registerGameResultNotify();
        AppCallGameProxy.initGameJavascriptProxy(env);
        this.mGameVersionPresenter = new GameVersionPresenter();
    }

    public boolean downloadGame(@NonNull GameInfo info) {
        if (GameInfo.isLocalGamePlugin((GameInfo)info)) {
            return true;
        }
        return this.getGameDownloadManager().downloadGame((BasicGameInfo)info);
    }

    public boolean downloadGame(@NonNull GameInfo info, GameDownloadInfo.DownloadType type) {
        if (GameInfo.isLocalGamePlugin((GameInfo)info)) {
            return true;
        }
        return this.getGameDownloadManager().downloadGame((BasicGameInfo)info, type);
    }

    public boolean downloadGame(@NonNull GameInfo info, GameDownloadInfo.DownloadType type, int priority) {
        if (GameInfo.isLocalGamePlugin((GameInfo)info)) {
            return true;
        }
        return this.getGameDownloadManager().downloadGame((BasicGameInfo)info, type, priority);
    }

    public boolean isGameValid(@NonNull GameInfo info) {
        return this.isGameValid(info, false);
    }

    public boolean isGameValid(@NonNull GameInfo info, boolean checkByType) {
        if (GameInfo.isLocalGamePlugin((GameInfo)info)) {
            return true;
        }
        if (checkByType && (info.isWebIndineGame() || info.isCloudGame())) {
            return true;
        }
        return this.getGameDownloadManager().isGameValid((BasicGameInfo)info);
    }

    public boolean isGamePkgValid(@NonNull GameInfo info) {
        if (GameInfo.isLocalGamePlugin((GameInfo)info)) {
            return true;
        }
        return GameVersion.INSTANCE.isGamePkgValid((BasicGameInfo)info);
    }

    public boolean isGamePackageExist(String gid) {
        return this.getGameDownloadManager().isExistGamePackage(gid);
    }

    public int getGameDownloadType(@NonNull GameInfo info) {
        return GameVersion.INSTANCE.getGameDownloadType((BasicGameInfo)info);
    }

    public void queryWinInfofromDB(GameResultBean gameResultBean) {
        if (gameResultBean == null) {
            return;
        }
        Collections.sort(gameResultBean.getUsers());
        Collections.sort(gameResultBean.getWinners());
        MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
        if (myBox == null) {
            return;
        }
        GameResultDb.getInstance().queryGameWinCount(gameResultBean, myBox);
    }

    public void delResutlDB() {
        MyBox myBox = ((IDBService)this.getServiceManager().getService(IDBService.class)).boxForCurUser(GameResultDBBean.class);
        if (myBox == null) {
            return;
        }
        GameResultBean.Builder builder = GameResultBean.newBuilder();
        GameResultBean bean = builder.resultTime(Long.valueOf(this.getStartTimeOfDay(""))).build();
        GameResultDb.getInstance().delGameWinToday(bean, myBox);
    }

    private long getStartTimeOfDay(String timeZone) {
        Calendar calendar = Calendar.getInstance(Calendar.getInstance().getTimeZone());
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    @Override
    public void onFinished(@Nullable GameInfo gameInfo, int code) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"built in game copy finish code: %s, gameId: %s", (Object[])new Object[]{code, gameInfo});
        }
        if (gameInfo == null) {
            return;
        }
        if (code == 0 && this.getServiceManager().getService(IGameInfoService.class) != null) {
            GameInfo info = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameInfo.getGid());
            if (info != null) {
                int builtinVersion = StringUtils.safeParseInt((String)gameInfo.getModulerVer());
                int version = StringUtils.safeParseInt((String)info.getModulerVer());
                if (version > builtinVersion) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)TAG, (String)"built in game builtinVersion < gameList.version, builtinVersion: %s, version: %s", (Object[])new Object[]{builtinVersion, version});
                    }
                    return;
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"built in game builtinVersion >= gameList.version and cancel download and notify download finish, builtinVersion: %s, version: %s", (Object[])new Object[]{builtinVersion, version});
                }
                this.getGameDownloadManager().cancelDownload((BasicGameInfo)info);
                Notification notification = Notification.obtain((int)NotificationIdDef.GAME_DOWNLOAD_FINISH);
                notification.extObj = info;
                NotificationCenter.getGlobalInstance().notify(notification);
                TjgGameReportHelper.Companion.reportGameDownLoadSuccess(gameInfo);
            } else {
                MLog.error((Object)TAG, (String)"built in game copy finish but not in game list, may had not request game list", (Object[])new Object[0]);
            }
        }
    }

    public boolean checkMinSupportVersion(String gameId) {
        boolean supportCurrentVersion = true;
        GameInfo gameInfo = ((IGameInfoService)this.getServiceManager().getService(IGameInfoService.class)).getGameInfoByGid(gameId);
        if (gameInfo != null) {
            try {
                int curVer = 0;
                int[] ver = VersionUtil.getLocal((Context)this.mContext);
                if (ver != null && ver.length >= 3) {
                    String ver0 = StringUtils.formatWitUSLocal((String)(ver[0] > 9 ? "%d" : "0%d"), (Object[])new Object[]{ver[0]});
                    String ver1 = StringUtils.formatWitUSLocal((String)(ver[1] > 9 ? "%d" : "0%d"), (Object[])new Object[]{ver[1]});
                    String ver2 = StringUtils.formatWitUSLocal((String)(ver[2] > 9 ? "%d" : "0%d"), (Object[])new Object[]{ver[2]});
                    String verStr = ver0 + ver1 + ver2;
                    if (!TextUtils.isEmpty((CharSequence)verStr)) {
                        curVer = StringUtils.parseInt((String)verStr);
                    }
                }
                if (gameInfo.getMinSupportAppVersion() != 0 && gameInfo.getMinSupportAppVersion() > curVer) {
                    OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.short_summary_min_support_version, (Object[])new Object[]{gameInfo.getGname()}), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, true, new OkCancelDialogListener(){

                        public void onCancel() {
                        }

                        public void onOk() {
                            if (!NavigationUtils.openGooglePlay((Context)GameController.this.mContext)) {
                                try {
                                    NavigationUtils.navToBrower((Context)GameController.this.mContext, (String)"market://details?id=com.yy.hiyo");
                                }
                                catch (Exception e) {
                                    MLog.warn((Object)GameController.TAG, (String)"open google play error %s", (Object[])new Object[]{e});
                                    NavigationUtils.navToBrower((Context)GameController.this.mContext, (String)"https://play.google.com/store/apps/details?id=com.yy.hiyo");
                                }
                            }
                        }
                    });
                    this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
                    supportCurrentVersion = false;
                }
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, (String)"checkMinSupportVersion", (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return supportCurrentVersion;
    }

    public void pauseAllDownload(String business) {
        this.getGameDownloadManager().pauseAllDownload(business);
    }

    public void cancelDownload(GameInfo gameInfo) {
        this.getGameDownloadManager().cancelDownload((BasicGameInfo)gameInfo);
    }

    public void restartAllDownload(String business) {
        this.getGameDownloadManager().restartAllDownload(business);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    private IGameDownloadManager getGameDownloadManager() {
        if (this.mGameDownloadManager != null) return this.mGameDownloadManager;
        Class<GameController> clazz = GameController.class;
        synchronized (GameController.class) {
            if (this.mGameDownloadManager != null) return this.mGameDownloadManager;
            this.mGameDownloadManager = new GameDownloadManager();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mGameDownloadManager;
        }
    }

    private void registerGameLifecycle() {
        if (this.mGameLife == null) {
            this.mGameLife = new GameLifecycle();
        }
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameMatchEvent((IMatchGameLifecycle)this.mGameLife);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)this.mGameLife);
        ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).registerTeamMatchLifecycle((ITeamMatchLifecycle)this.mGameLife);
    }

    private void reportGameInfoInit() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList<GameInfo> gameInfos = new ArrayList<GameInfo>();
                for (GameInfo gameInfo : ((IGameInfoService)GameController.this.getServiceManager().getService(IGameInfoService.class)).getAllGameInfoList()) {
                    if (!GameController.this.isGameValid(gameInfo)) continue;
                    gameInfos.add(gameInfo);
                }
                TjgGameReportHelper.Companion.reportGameInfoServicesInit(gameInfos);
            }
        });
    }

    public void init() {
        GameDownloadUtils.clearOldGameFolder();
        BuiltInGameManager.getInstance().checkBuiltInGame(this);
        if (!this.isInit) {
            this.isNetValid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
            this.isInit = true;
        }
        this.registerGameLifecycle();
        this.reportGameInfoInit();
        this.mGameVersionPresenter.init();
    }

    public void checkNet() {
        boolean valid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        this.getGameDownloadManager().onNetworkChanged(this.isNetValid, valid);
        this.isNetValid = valid;
    }

    public void onAccountChange() {
        this.mGameVersionPresenter.initVersion(true);
    }

    public void onLogout() {
        GameVersion.INSTANCE.logout();
    }

    public void checkUpdatePlayGameInfo() {
        this.mGameVersionPresenter.checkUpdatePlayGameInfo();
    }

    public void checkDeleteGame() {
        this.mGameVersionPresenter.checkDeleteGame();
    }

    public void deleteAllGameDebug() {
        GameDownloadUtils.deleteAllGameDebug();
    }

    public void preLoadGamePage(String gid) {
        LoadGamePageManager.getInstance().preLoadGamePage(gid);
    }

    public void loadGameLoadingPage(RecycleImageView imageView, String gid) {
        LoadGamePageManager.getInstance().loadGameLoadingPage(imageView, gid);
    }

    public void parseCodeWithToast(long code) {
        PkGameInviteCodeHelp.Companion.parseCodeWithToast(code);
    }

    public IAppCallGameProxy getAppCallGameProxy() {
        return AppCallGameProxy.getSingleton();
    }

    public void deleteDownloadAndRest(GameInfo gameInfo) {
        this.getGameDownloadManager().deleteDownloadAndRest((BasicGameInfo)gameInfo);
    }

    public void getIsMplValid(ICommonCallback<IsMplValidRes> callback2) {
        MPLDataModel.INSTANCE.getIsMplValid(callback2);
    }

    public IGameSourceDialoger createGameSourceDialoger(DialogLinkManager dialogLinkManager) {
        return new GameSourceDialogPresenter(dialogLinkManager);
    }

    public void loadNativeLibraries() {
        CocosGameEngine.onLoadNativeLibraries();
    }

    public List<String> getDownloadedGid() {
        ArrayList<String> result = new ArrayList<String>();
        List<GameVersionInfo> downloadGame = GameVersion.INSTANCE.getDownloadGame();
        if (!FP.empty(downloadGame)) {
            for (GameVersionInfo item : downloadGame) {
                if (item == null) continue;
                result.add(item.getGameId());
            }
        }
        return result;
    }

    public IChannelGameListModel getChannelGameListModel() {
        if (this.mChannelGameListModel == null) {
            this.mChannelGameListModel = new GameListModel();
        }
        return this.mChannelGameListModel;
    }

    public int getDownloadingGameCount() {
        return this.mGameDownloadManager != null ? this.mGameDownloadManager.getDownloadingGameCount() : 0;
    }

    public boolean isExistGamePackage(String gid) {
        return this.getGameDownloadManager().isExistGamePackage(gid);
    }

    class GameLifecycle
    extends GameLifeWrapper
    implements IMatchGameLifecycle,
    ITeamMatchLifecycle {
        GameLifecycle() {
        }

        public void onJoinGame(GamePlayContext context) {
            GameController.this.pauseAllDownload("playing_game");
            GameController.this.restartAllDownload("match_game");
        }

        public void onPreloadGame(GamePlayContext context) {
        }

        public void onGameExited(GamePlayContext context, int gameExitType) {
            GameController.this.restartAllDownload("playing_game");
        }

        public void prepareGameMatch(GameInfo ginfo, @Nonnull GameMatchContext matchConfig) {
        }

        public void onGameMatchStart(GameInfo info, @Nonnull GameMatchContext matchConfig) {
            GameController.this.pauseAllDownload("match_game");
        }

        public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
            if (matchType != 0) {
                GameController.this.restartAllDownload("match_game");
            }
        }

        public void onPrepareTeamMatch(GameTeamMatchContext context) {
        }

        public void onTeamReady(String teamId) {
        }

        public void onTeamMatchFinish(GameTeamMatchContext context) {
        }

        public void onDestroy() {
        }
    }
}

