/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.service.bean;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.hiyo.game.base.GameModel;
import com.yy.hiyo.game.base.GameResultBean;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.bean.AbstractGameContext;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameInviteContext;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class GamePlayContext
extends AbstractGameContext {
    protected GameMatchContext pkMatchContext;
    protected GameInviteContext inviteContext;
    protected String gameResult;
    protected Map<Long, UserInfoKS> userInfoKSMap = new LinkedHashMap<Long, UserInfoKS>();
    protected GameInfo gameInfo;
    protected String gameUrl;
    protected String gameLang;
    protected String roomId;
    protected GameResultBean gameResultBean;
    protected GameModel gameModel;
    protected String gamePlayTimes;
    protected boolean exceptionFinish = false;
    public String gamePath = "";
    public boolean isFromLudoDuli = true;

    public GameResultBean getGameResultBean() {
        return this.gameResultBean;
    }

    public void setGameResultBean(GameResultBean gameResultBean) {
        this.gameResultBean = gameResultBean;
    }

    public GamePlayContext(GameContextDef.JoinFrom joinFrom) {
        super(joinFrom);
    }

    public GameMatchContext getPkMatchContext() {
        return this.pkMatchContext;
    }

    public void setPkMatchContext(GameMatchContext pkMatchContext) {
        this.pkMatchContext = pkMatchContext;
    }

    public GameInviteContext getInviteContext() {
        return this.inviteContext;
    }

    public void setInviteContext(GameInviteContext inviteContext) {
        this.inviteContext = inviteContext;
    }

    public String getGameResult() {
        return this.gameResult;
    }

    public void setGameResult(String gameResult) {
        this.gameResult = gameResult;
    }

    public void updateUserInfo(long uid, UserInfoKS infoKS) {
        MLog.debug((Object)"NewUserPathController", (String)"updateUserInfo uid: %s, info uid: %s, info nick: %s, info avatar: %s info shadowUid: %s", (Object[])new Object[]{uid, infoKS.uid, infoKS.nick, infoKS.avatar, infoKS.shadowUid});
        if (this.userInfoKSMap != null) {
            this.userInfoKSMap.put(uid, infoKS);
        }
    }

    public UserInfoKS getUserInfo(long uid) {
        return this.userInfoKSMap.get(uid);
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public void setGameInfo(GameInfo gameInfo) {
        this.gameInfo = gameInfo;
    }

    public String getGameUrl() {
        return this.gameUrl;
    }

    public void setGameUrl(String gameUrl) {
        this.gameUrl = gameUrl;
    }

    public String getGameLang() {
        return this.gameLang;
    }

    public void setGameLang(String gameLang) {
        this.gameLang = gameLang;
    }

    public String getRoomId() {
        return this.roomId;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public String getGamePlayTimes() {
        return this.gamePlayTimes;
    }

    public void setGamePlayTimes(String gamePlayTimes) {
        this.gamePlayTimes = gamePlayTimes;
    }

    public Collection<UserInfoKS> getAllUsers() {
        return this.userInfoKSMap.values();
    }

    public UserInfoKS getOtherUserInfo() {
        Collection<UserInfoKS> userInfoKSs = this.userInfoKSMap.values();
        for (UserInfoKS infoKS : userInfoKSs) {
            if (infoKS == null || infoKS.uid == AccountUtil.getUid()) continue;
            return infoKS;
        }
        return null;
    }

    public GameModel buildGameModel() {
        UserInfoBean self = this.getMyUserInfo();
        UserInfoBean other = this.getOtherUserInfos();
        int size = this.mExtendData.size();
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        for (Map.Entry entry : this.mExtendData.entrySet()) {
            if (entry == null || !(entry.getValue() instanceof String)) continue;
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.gameModel = GameModel.newBuilder().game_url(this.gameUrl).gameInfo(this.gameInfo).gameResult(this.gameResult).laugh(this.gameLang).multiMode(this.gameInfo.getGameMode()).roomid(this.roomId).myUserInfo(self).otherInfo(other).ext(map).build();
        return this.gameModel;
    }

    protected UserInfoBean getMyUserInfo() {
        Collection<UserInfoKS> infoKS = this.userInfoKSMap.values();
        for (UserInfoKS info : infoKS) {
            if (info.uid != AccountUtil.getUid()) continue;
            return new UserInfoBean(info);
        }
        return null;
    }

    protected UserInfoBean getOtherUserInfos() {
        Collection<UserInfoKS> infoKS = this.userInfoKSMap.values();
        for (UserInfoKS info : infoKS) {
            if (info.uid == AccountUtil.getUid()) continue;
            return new UserInfoBean(info);
        }
        return null;
    }

    public List<Long> getInGameUsersId() {
        Collection<UserInfoKS> infoKS = this.userInfoKSMap.values();
        ArrayList<Long> uidList = new ArrayList<Long>(infoKS.size());
        for (UserInfoKS info : infoKS) {
            if (info == null) continue;
            uidList.add(info.uid);
        }
        return uidList;
    }

    public boolean isExceptionFinish() {
        return this.exceptionFinish;
    }

    public void setExceptionFinish(boolean exceptionFinish) {
        this.exceptionFinish = exceptionFinish;
    }
}

