/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.IdRes;
import com.yy.appbase.R;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResolutionUtils;
import java.lang.ref.WeakReference;

@Deprecated
public class GameTagView
extends YYTextView {
    private static final String TAG = "GameTagView";
    public static final int DEFAULT_WIDTH = ResolutionUtils.dip2Px((float)28.0f);
    public static final int DEFAULT_HEIGHT = ResolutionUtils.dip2Px((float)16.0f);
    public static final int NORMAL = 0;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_RIGHT = 3;
    public static final int BOTTOM_LEFT = 4;
    private InnerBitmapLoadListener mBitmapLoadListener;
    private static final int INVALID_COLOR = Integer.MIN_VALUE;
    @ColorInt
    private int mContentBgColor = Integer.MIN_VALUE;
    private int mCornerType = 0;
    @IdRes
    private int mContentDrawableId;
    private String mUrl;

    public GameTagView(Context context) {
        super(context);
        this.init();
    }

    public GameTagView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public GameTagView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.WenYueXinQingNianTi));
        this.setContentDrawableId(R.id.tag_content_color);
    }

    public void setContentBgColor(int color) {
        Drawable contentDrawable;
        Drawable bg = this.getBackground();
        if (bg instanceof LayerDrawable && color != Integer.MIN_VALUE && (contentDrawable = ((LayerDrawable)bg).findDrawableByLayerId(this.getContentDrawableId())) != null) {
            contentDrawable.setColorFilter((ColorFilter)new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN));
        }
        this.invalidate();
        LayoutUtil.setPadding((View)this, (int)this.getPaddingLeft(), (int)this.getPaddingTop(), (int)this.getPaddingRight(), (int)this.getPaddingBottom());
    }

    private int getContentDrawableId() {
        return R.id.tag_content_color;
    }

    public void setContentDrawableId(int contentColorId) {
        this.mUrl = "";
        this.setBackgroundToNull();
        this.mContentDrawableId = contentColorId;
    }

    public void setSize(int width, int height) {
        ViewGroup.LayoutParams params = this.getLayoutParams();
        params.width = width;
        params.height = height;
        this.setLayoutParams(params);
    }

    public void setBgUrl(String url) {
        this.setBackgroundToNull();
        this.mUrl = url;
        this.mBitmapLoadListener = new InnerBitmapLoadListener((View)this, url);
        ImageLoader.loadBitmap((Context)this.getContext(), (String)url, (ImageLoader.BitmapLoadListener)this.mBitmapLoadListener, (int)this.getMeasuredWidth(), (int)this.getMeasuredHeight());
    }

    public void setCornerType(int cornerType) {
        this.mCornerType = cornerType;
        switch (cornerType) {
            case 0: {
                this.setBackgroundResource(R.drawable.game_tag_normal);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.setBackgroundResource(R.drawable.game_tag_top_right);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private class InnerBitmapLoadListener
    implements ImageLoader.BitmapLoadListener {
        WeakReference<View> mReference;
        String url;

        InnerBitmapLoadListener(View view, String url) {
            this.mReference = new WeakReference<View>(view);
            this.url = url;
        }

        public void onLoadFailed(Exception e) {
            MLog.error((Object)GameTagView.TAG, (Throwable)e);
        }

        public void onResourceReady(Bitmap bitmap) {
            View target;
            if (TextUtils.isEmpty((CharSequence)this.url) || !this.url.equals(GameTagView.this.mUrl)) {
                return;
            }
            View view = target = this.mReference != null ? (View)this.mReference.get() : null;
            if (target != null && target.getContext() != null) {
                BitmapDrawable drawable2 = new BitmapDrawable(target.getResources(), bitmap);
                if (Build.VERSION.SDK_INT >= 16) {
                    target.setBackground((Drawable)drawable2);
                } else {
                    target.setBackgroundDrawable((Drawable)drawable2);
                }
            }
        }
    }
}

