/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.gamemode;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.yy.base.utils.DontProguardClass;
import net.ihago.rec.srv.home.CommonLabel;

@DontProguardClass
public class GameLabel
implements Parcelable {
    @SerializedName(value="textColor")
    public String textColor;
    @SerializedName(value="text")
    public String text;
    @SerializedName(value="bgUrl")
    public String bgUrl;
    public static final Parcelable.Creator<GameLabel> CREATOR = new Parcelable.Creator<GameLabel>(){

        public GameLabel createFromParcel(Parcel in) {
            return new GameLabel(in);
        }

        public GameLabel[] newArray(int size) {
            return new GameLabel[size];
        }
    };

    public GameLabel() {
    }

    protected GameLabel(Parcel in) {
        this.textColor = in.readString();
        this.text = in.readString();
        this.bgUrl = in.readString();
    }

    public boolean isLebalValid() {
        return !TextUtils.isEmpty((CharSequence)this.textColor) || !TextUtils.isEmpty((CharSequence)this.text) || !TextUtils.isEmpty((CharSequence)this.bgUrl);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.textColor);
        dest.writeString(this.text);
        dest.writeString(this.bgUrl);
    }

    public static GameLabel from(CommonLabel info) {
        GameLabel label = new GameLabel();
        label.bgUrl = info.BgURL;
        label.text = info.Text;
        label.textColor = info.TextColor;
        return label;
    }

    public String toString() {
        return "GameLabel{textColor='" + this.textColor + '\'' + ", text='" + this.text + '\'' + ", bgUrl='" + this.bgUrl + '\'' + '}';
    }
}

