/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.bean;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.game.base.bean.BasicGameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.gamemode.GameLabel;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import com.yy.hiyo.game.base.gamemode.GameRule;
import com.yy.hiyo.game.base.gamemode.MultiModeInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.ihago.rec.srv.home.GameItemStatic;

@DontProguardClass
public class GameInfo
extends BasicGameInfo {
    public static final int OPERATE_CANCEL = 0;
    public static final int OPERATE_DECLINE = 1;
    public static final int OPERATE_JOIN = 2;
    public static final int GAME_INVALID = 3;
    public static final int GAME_MODE_TEAM = 4;
    public static final int MODE_NONE = 0;
    public static final int MODE_PK = 1;
    public static final int MODE_SAME_SCREEN = 2;
    public static final int MODE_SINGLE = 3;
    public static final int MODE_TEAM = 4;
    public static final int MODE_DOUBLE_COOPERATION = 5;
    public static final int MODE_INDIE = 6;
    public static final int MODE_2V2 = 7;
    public static final int MODE_ROOM_GAME = 8;
    public static final int MODE_WEB_GAME = 9;
    public static final int MODE_HAGO_SHOW = 10;
    public static final int MODE_CLOUD = 11;
    public static final int SUB_MODE_DEFAULT = 0;
    public static final int SUB_MODE_ROOM_CHESS_GAME = 1;
    public static final int SUB_MODE_ROOM_ASSIST_GAME = 2;
    public static final int COCOS_JS = 1;
    public static final int H5 = 2;
    public static final int COCOS_LUA = 3;
    public static final int CLOUD = 100;
    public static final String BASE_GID = "base";
    public static final String KTV_GID = "ktv";
    public static final String MICUP_GID = "micup";
    public static final String PICKME_GID = "pickme";
    public static final String BOCAI_GID = "dayingjia";
    public static final String CHAT_ROOM = "chat";
    public static final String RADIO_GID = "radio";
    public static final String MULTI_VIDEO_GID = "multivideo";
    public static final String RADIO_VIDEO = "radio_video";
    public static final String MLBB_GID = "MLBB";
    public static final String BAIJIALE_GID = "baijiale_yn";
    public static final String YANGYANGXIAOCHU_GID = "yangyangxiaochu";
    public static final String SHUISHIWODI_GID = "shuishiwodi_yn";
    public static final String NIHUAWOCAI_GID = "nihuawocai_yn";
    public static final String LUDOYUYINFANG_GID = "ludoyuyinfang";
    public static final Collection<String> DEFAULT_LOCAL_ROOM_GAMES = Arrays.asList("chat", "ktv", "multivideo", "radio", "micup", "pickme", "dayingjia", "MLBB");
    public static final List<String> ROOM_GAME_LIST = Arrays.asList("pickme", "micup", "nihuawocai_yn", "yangyangxiaochu", "baijiale_yn");
    private String gname;
    private String desc;
    private String iconUrl;
    private String imIconUrl;
    private int screenDire;
    private int roomTemplate;
    private String singleGameShareBgUrl = "";
    private String singleGameIMBanner = "";
    @Deprecated
    private int teamTemplate;
    private int playerCount;
    private String scoreType;
    private int voiceType;
    private int gameMode;
    private int subGameMode;
    private boolean isPopupGame;
    private String popupsProportion;
    private int gameType;
    private boolean fixing;
    private String defLang;
    private List<String> langList;
    private boolean quickNews;
    private boolean isFull;
    private boolean isHot;
    private boolean isWaitingOffline;
    private boolean isBetaTest;
    private int minSupportAppVersion;
    private int minPlayerCount;
    private long goldDayStartTime;
    private long goldDayEndTime;
    private boolean goldMode;
    private boolean goldGame;
    private String teamTmpDynamicUrl;
    private String teamTmpStaticUrl;
    private MultiModeInfo multiModeInfo;
    private GameLabel gameLabel;
    private long asNewTime;
    private String gameRule;
    private String gameRuleBgUrl;
    private String gamePrepareBgUrl;
    private boolean hide;
    private int socketType;
    private String gamePkgName;
    private boolean quickJoin;
    private String ruleBgUrl;
    private List<GameRule> gameRuleList;
    private String gameBColor;
    private boolean isSupportQuickJoin = false;
    public Map<String, String> ext;
    private String actSvga;
    private String chanGameDesc;
    private boolean showForRandRoom = false;
    private boolean onlyOwnerShowRadio = false;
    private String tagUrl = "";
    private int mImGameInviteSource;
    private Map<String, String> tagMaps;
    private int mPrecipitationSource;
    private boolean keyNoteDesc = false;
    private boolean isAr = false;
    private boolean supportFullScreen = false;
    private boolean isFirstPublish = false;
    private int voiceRoomFlag = -1;
    private boolean isOutterGame = false;

    public static boolean isLocalGamePlugin(GameItemStatic bean) {
        if (bean != null) {
            return DEFAULT_LOCAL_ROOM_GAMES.contains(bean.GID) || bean.IsOutterGame != false;
        }
        return false;
    }

    public static boolean isSupportRoomGame(GameInfo info) {
        return info != null && info.getGameMode() == 8;
    }

    public static boolean isLocalGamePlugin(GameInfo info) {
        return info != null && (DEFAULT_LOCAL_ROOM_GAMES.contains(info.gid) || info.isOutterGame);
    }

    private GameInfo(Builder builder) {
        super(builder.fromSource);
        this.updateInfo(builder);
    }

    public void updateInfo(Builder builder) {
        this.id = builder.id;
        this.gid = builder.gid;
        this.gname = builder.gname;
        this.desc = builder.desc;
        this.iconUrl = builder.iconUrl;
        this.imIconUrl = builder.imIconUrl;
        this.screenDire = builder.screenDire;
        this.roomTemplate = builder.roomTemplate;
        this.modulerUrl = builder.modulerUrl;
        this.modulerMd5 = builder.modulerMd5;
        this.modulerVer = builder.modulerVer;
        this.singleGameShareBgUrl = builder.singleGameShareBgUrl;
        this.singleGameIMBanner = builder.singleGameIMBanner;
        this.scoreType = builder.scoreType;
        this.gameMode = builder.gameMode;
        this.subGameMode = builder.subGameMode;
        this.isPopupGame = builder.isPopupGame;
        this.popupsProportion = builder.popupsProportion;
        this.gameType = builder.gameType;
        this.teamTemplate = builder.teamTemplate;
        this.playerCount = builder.playerCount;
        this.fixing = builder.fixing;
        this.defLang = builder.defLang;
        this.langList = builder.langList;
        this.voiceType = builder.voiceType;
        this.quickNews = builder.quickNews;
        this.downloadInfo.gameId = this.gid;
        this.ext = builder.ext;
        this.isFull = builder.isFull;
        this.isHot = builder.isHot;
        this.isWaitingOffline = builder.isWaitingOffline;
        this.isBetaTest = builder.isBetaTest;
        this.minSupportAppVersion = builder.minSupportAppVersion;
        this.multiModeInfo = builder.multiModeInfo;
        this.gameLabel = builder.gameLabel;
        this.teamTmpDynamicUrl = builder.teamTmpDynamicUrl;
        this.teamTmpStaticUrl = builder.teamTmpStaticUrl;
        this.minPlayerCount = builder.minPlayerCount;
        this.asNewTime = builder.asNewTime;
        this.gameRule = builder.gameRule;
        this.gameRuleBgUrl = builder.gameRuleBgUrl;
        this.gamePrepareBgUrl = builder.gamePrepareBgUrl;
        this.hide = builder.hide;
        this.goldDayStartTime = builder.goldDayStartTime;
        this.goldDayEndTime = builder.goldDayEndTime;
        this.goldMode = builder.goldMode;
        this.quickJoin = builder.quickJoin;
        this.socketType = builder.socketType;
        this.ruleBgUrl = builder.ruleBgUrl;
        this.gameRuleList = builder.gameRuleList;
        this.gameBColor = builder.gameBcolor;
        this.actSvga = builder.actSvga;
        this.isSupportQuickJoin = builder.isSupportQuickJoin;
        this.moduleGray = builder.moduleGray;
        this.chanGameDesc = builder.chanGameDesc;
        this.showForRandRoom = builder.showForRandRoom;
        this.tagUrl = builder.tagUrl;
        this.tagMaps = builder.tagMaps;
        this.keyNoteDesc = builder.keyNoteDesc;
        this.isAr = builder.isAr;
        this.gamePkgName = builder.gamePkgName;
        this.supportFullScreen = builder.supportFullScreen;
        this.isFirstPublish = builder.isFirstPublish;
        this.minCompatibleVer = builder.minCompatibleVer;
        this.voiceRoomFlag = builder.voiceRoomFlag;
        this.isOutterGame = builder.isOutterGame;
    }

    public static Builder newBuilder(GameInfoSource source) {
        return new Builder(source);
    }

    public static Builder newBuilder(GameInfo copy) {
        Builder builder = new Builder(copy.fromSource);
        builder.gid = copy.getGid();
        builder.id = copy.getId();
        builder.gname = copy.getGname();
        builder.desc = copy.getDesc();
        builder.iconUrl = copy.getIconUrl();
        builder.imIconUrl = copy.getImIconUrl();
        builder.screenDire = copy.getScreenDire();
        builder.roomTemplate = copy.getRoomTemplate();
        builder.modulerUrl = copy.getModulerUrl();
        builder.modulerMd5 = copy.getModulerMd5();
        builder.modulerVer = copy.getModulerVer();
        builder.singleGameShareBgUrl = copy.getSingleGameShareBgUrl();
        builder.singleGameIMBanner = copy.getSingleGameIMBanner();
        builder.scoreType = copy.getScoreType();
        builder.gameMode = copy.getGameMode();
        builder.subGameMode = copy.getSubGameMode();
        builder.isPopupGame = copy.isPopupGame();
        builder.popupsProportion = copy.popupsProportion();
        builder.gameType = copy.getGameType();
        builder.teamTemplate = copy.getTeamTemplate();
        builder.playerCount = copy.getPlayerCount();
        builder.fixing = copy.isFixing();
        builder.langList = copy.getLangList();
        builder.defLang = copy.getDefLang();
        builder.voiceType = copy.getVoiceType();
        builder.quickNews = copy.isQuickNews();
        builder.ext = copy.getExt();
        builder.isFull = copy.isFull();
        builder.isHot = copy.isHot();
        builder.isWaitingOffline = copy.isWaitingOffline();
        builder.isBetaTest = copy.isBetaTest();
        builder.minSupportAppVersion = copy.getMinSupportAppVersion();
        builder.multiModeInfo = copy.multiModeInfo;
        builder.gameLabel = copy.gameLabel;
        builder.teamTmpDynamicUrl = copy.teamTmpDynamicUrl;
        builder.teamTmpStaticUrl = copy.teamTmpStaticUrl;
        builder.minPlayerCount = copy.minPlayerCount;
        builder.asNewTime = copy.asNewTime;
        builder.gameRule = copy.gameRule;
        builder.gameRuleBgUrl = copy.gameRuleBgUrl;
        builder.gamePrepareBgUrl = copy.gamePrepareBgUrl;
        builder.hide = copy.hide;
        builder.quickJoin = copy.quickJoin;
        builder.goldDayStartTime = copy.goldDayStartTime;
        builder.goldDayEndTime = copy.goldDayEndTime;
        builder.goldMode = copy.goldMode;
        builder.gameRuleList = copy.gameRuleList;
        builder.gameBcolor = copy.gameBColor;
        builder.ruleBgUrl = copy.ruleBgUrl;
        builder.actSvga = copy.actSvga;
        builder.isSupportQuickJoin = copy.isSupportQuickJoin;
        builder.moduleGray = copy.moduleGray;
        builder.chanGameDesc = copy.chanGameDesc;
        builder.socketType = copy.socketType;
        builder.showForRandRoom = copy.showForRandRoom;
        builder.tagUrl = copy.tagUrl;
        builder.tagMaps = copy.tagMaps;
        builder.keyNoteDesc = copy.keyNoteDesc;
        builder.isAr = copy.isAr;
        builder.supportFullScreen = copy.supportFullScreen;
        builder.gamePkgName = copy.gamePkgName;
        builder.minCompatibleVer = copy.minCompatibleVer;
        builder.voiceRoomFlag = copy.voiceRoomFlag;
        builder.isOutterGame = copy.isOutterGame;
        return builder;
    }

    private boolean isFlag(long flag, int type) {
        return (flag & (long)(1 << type)) == 1L;
    }

    @Override
    public String getGid() {
        return this.gid;
    }

    public String getGname() {
        return this.gname;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getImIconUrl() {
        return this.imIconUrl;
    }

    public int getScreenDire() {
        return this.screenDire;
    }

    public void setScreenDir(int dir) {
        this.screenDire = dir;
    }

    public boolean isHorizontalScreen() {
        return this.screenDire == 2;
    }

    public int getRoomTemplate() {
        return this.roomTemplate;
    }

    public String getSingleGameShareBgUrl() {
        return this.singleGameShareBgUrl;
    }

    public String getScoreType() {
        return this.scoreType;
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    @Deprecated
    public int getTeamTemplate() {
        return this.teamTemplate;
    }

    public int getGameMode() {
        return this.gameMode;
    }

    public int getSubGameMode() {
        return this.subGameMode;
    }

    public boolean isPopupGame() {
        return this.isPopupGame;
    }

    public String popupsProportion() {
        return this.popupsProportion;
    }

    public int getGameType() {
        return this.gameType;
    }

    public String getDefLang() {
        return this.defLang;
    }

    public List<String> getLangList() {
        return this.langList;
    }

    public int getVoiceType() {
        return this.voiceType;
    }

    public boolean isQuickNews() {
        return this.quickNews;
    }

    public Map<String, String> getExt() {
        return this.ext;
    }

    public MultiModeInfo getMultiModeInfo() {
        return this.multiModeInfo;
    }

    public void setExt(Map<String, String> ext) {
        this.ext = ext;
    }

    public String getSingleGameIMBanner() {
        return this.singleGameIMBanner;
    }

    public boolean isQuickJoin() {
        return this.quickJoin;
    }

    public boolean isFixing() {
        return this.fixing;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public void setFull(boolean full) {
        this.isFull = full;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean hot) {
        this.isHot = hot;
    }

    public boolean isWaitingOffline() {
        return this.isWaitingOffline;
    }

    public void setWaitingOffline(boolean waitingOffline) {
        this.isWaitingOffline = waitingOffline;
    }

    public boolean isBetaTest() {
        return this.isBetaTest;
    }

    public void setBetaTest(boolean betaTest) {
        this.isBetaTest = betaTest;
    }

    public int getMinSupportAppVersion() {
        return this.minSupportAppVersion;
    }

    public void setMinSupportAppVersion(int minSupportAppVersion) {
        this.minSupportAppVersion = minSupportAppVersion;
    }

    public GameLabel getGameLabel() {
        return this.gameLabel;
    }

    public void setGameLabel(GameLabel gameLabel) {
        this.gameLabel = gameLabel;
    }

    public String getTeamTmpDynamicUrl() {
        return this.teamTmpDynamicUrl;
    }

    public void setTeamTmpDynamicUrl(String teamTmpDynamicUrl) {
        this.teamTmpDynamicUrl = teamTmpDynamicUrl;
    }

    public String getTeamTmpStaticUrl() {
        return this.teamTmpStaticUrl;
    }

    public void setTeamTmpStaticUrl(String teamTmpStaticUrl) {
        this.teamTmpStaticUrl = teamTmpStaticUrl;
    }

    public int getMinPlayerCount() {
        return this.minPlayerCount;
    }

    public void setMinPlayerCount(int minPlayerCount) {
        this.minPlayerCount = minPlayerCount;
    }

    public long getAsNewTime() {
        return this.asNewTime;
    }

    public void setAsNewTime(long asNewTime) {
        this.asNewTime = asNewTime;
    }

    public String getGameRule() {
        return this.gameRule;
    }

    public void setGameRule(String gameRule) {
        this.gameRule = gameRule;
    }

    public String getGameRuleBgUrl() {
        return this.gameRuleBgUrl;
    }

    public void setGameRuleBgUrl(String gameRuleBgUrl) {
        this.gameRuleBgUrl = gameRuleBgUrl;
    }

    public String getGamePrepareBgUrl() {
        return this.gamePrepareBgUrl;
    }

    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    public long getGoldDayStartTime() {
        return this.goldDayStartTime;
    }

    public long getGoldDayEndTime() {
        return this.goldDayEndTime;
    }

    public boolean isGoldMode() {
        return this.goldMode;
    }

    public void setGoldMode(boolean goldMode) {
        this.goldMode = goldMode;
    }

    public boolean isGoldGame() {
        return this.goldGame;
    }

    public void setGoldGame(boolean goldGame) {
        this.goldGame = goldGame;
    }

    public int getSocketType() {
        return this.socketType;
    }

    public String getRuleBgUrl() {
        return this.ruleBgUrl;
    }

    public void setRuleBgUrl(String ruleBgUrl) {
        this.ruleBgUrl = ruleBgUrl;
    }

    public List<GameRule> getGameRuleList() {
        return this.gameRuleList;
    }

    public void setGameRuleList(List<GameRule> gameRuleList) {
        this.gameRuleList = gameRuleList;
    }

    public boolean isOnlyOwnerShowRadio() {
        return this.onlyOwnerShowRadio;
    }

    public void setOnlyOwnerShowRadio(boolean onlyOwnerShowRadio) {
        this.onlyOwnerShowRadio = onlyOwnerShowRadio;
    }

    public String getGameBColor() {
        return this.gameBColor;
    }

    public void setGameBColor(String gameBColor) {
        this.gameBColor = gameBColor;
    }

    public boolean isSupportQuickJoin() {
        return this.isSupportQuickJoin;
    }

    public void setIsSupportQuickJoin(boolean supportQuickJoin) {
        this.isSupportQuickJoin = supportQuickJoin;
    }

    public String getChanGameDesc() {
        return this.chanGameDesc;
    }

    public boolean isShowForRandRoom() {
        return this.showForRandRoom;
    }

    public void setShowForRandRoom(boolean showForRandRoom) {
        this.showForRandRoom = showForRandRoom;
    }

    public String getTagUrl() {
        return this.tagUrl;
    }

    public void setTagUrl(String tagUrl) {
        this.tagUrl = tagUrl;
    }

    public Map<String, String> getTagMaps() {
        return this.tagMaps;
    }

    public void setTagMaps(Map<String, String> tagMaps) {
        this.tagMaps = tagMaps;
    }

    public int getImGameInviteSource() {
        return this.mImGameInviteSource;
    }

    public void setImGameInviteSource(int imGameInviteSource) {
        this.mImGameInviteSource = imGameInviteSource;
    }

    public int getPrecipitationSource() {
        return this.mPrecipitationSource;
    }

    public void setPrecipitationSource(int precipitationSource) {
        this.mPrecipitationSource = precipitationSource;
    }

    public String getGamePkgName() {
        return this.gamePkgName;
    }

    public boolean isKeyNoteDesc() {
        return this.keyNoteDesc;
    }

    public static boolean isNewGameLoadSupport(GameInfo gameInfo) {
        return gameInfo.isWebIndineGame() || gameInfo.isPkGame() || gameInfo.isIndineGame();
    }

    @Override
    public boolean isGameIdEquals(GameInfo other) {
        boolean ret = false;
        if (other != null && !TextUtils.isEmpty((CharSequence)this.gid)) {
            ret = this.gid.equals(other.getGid());
        }
        return ret;
    }

    public boolean isRoomCheesGame() {
        return 1 == this.subGameMode;
    }

    public boolean isRoomAssistGame() {
        return this.subGameMode == 2;
    }

    public String toString() {
        if (RuntimeContext.sIsDebuggable) {
            return "GameInfo{hashCode='" + this.hashCode() + '\'' + "gid='" + this.gid + '\'' + ", gname='" + this.gname + '\'' + ", desc='" + this.desc + '\'' + ", iconUrl='" + this.iconUrl + '\'' + ", imIconUrl='" + this.imIconUrl + '\'' + ", gameMode='" + this.gameMode + '\'' + ", subgameMode='" + this.subGameMode + '\'' + ", screenDire=" + this.screenDire + ", roomTemplate=" + this.roomTemplate + ", modulerUrl='" + this.modulerUrl + '\'' + ", modulerMd5='" + this.modulerMd5 + '\'' + ", modulerVer='" + this.modulerVer + '\'' + ", singleGameShareBgUrl='" + this.singleGameShareBgUrl + '\'' + ", singleGameIMBanner='" + this.singleGameIMBanner + '\'' + ", teamTemplate=" + this.teamTemplate + ", playerCount=" + this.playerCount + ", fixing=" + this.fixing + ", voiceType=" + this.voiceType + ", quickNews=" + this.quickNews + ", isFull=" + this.isFull + ", isHot=" + this.isHot + ", isWaitingOffline" + this.isWaitingOffline + ", isBetaTest" + this.isBetaTest + ", minSupportAppVersion" + this.minSupportAppVersion + ", teamTmpDynamicUrl " + this.teamTmpDynamicUrl + ", teamTmpStaticUrl " + this.teamTmpStaticUrl + ", quickJoin " + this.quickJoin + ", isGoldMode " + this.goldMode + ", goldGame " + this.goldGame + ", socketType " + this.socketType + ", isSupportQuickJoin " + this.isSupportQuickJoin + ", gameType " + this.gameType + ", minCompatibleVer " + this.minCompatibleVer + ", gamePkgName" + this.gamePkgName + ", isOutterGame " + this.isOutterGame + '}';
        }
        return this.gid + " " + this.hashCode();
    }

    public List<Integer> getMutiModeIdList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.multiModeInfo != null && this.multiModeInfo.getModeList() != null) {
            for (GameModeInfo gameModeInfo : this.multiModeInfo.getModeList()) {
                list.add(gameModeInfo.getId());
            }
        }
        return list;
    }

    public boolean isWebGame() {
        return this.gameMode == 9 || this.gameType == 2;
    }

    public boolean isJSGame() {
        return this.gameType == 1 || this.gameType == 2;
    }

    public boolean isARGame() {
        return this.isAr;
    }

    public boolean isSupportFullScreen() {
        return this.supportFullScreen;
    }

    public boolean isFirstPublish() {
        return this.isFirstPublish;
    }

    public boolean isCloudGame() {
        return this.gameType == 100;
    }

    public boolean isWebIndineGame() {
        return this.gameMode == 9 && this.gameType == 2 && !this.isPopupGame;
    }

    public boolean isPkGame() {
        return this.gameMode == 1;
    }

    public boolean isIndineGame() {
        return this.gameMode == 6;
    }

    public int getVoiceRoomFlag() {
        return this.voiceRoomFlag;
    }

    public void setVoiceRoomFlag(int voiceRoomFlag) {
        this.voiceRoomFlag = voiceRoomFlag;
    }

    public boolean getIsOutterGame() {
        return this.isOutterGame;
    }

    public void setIsOutterGame(boolean isOutterGame) {
        this.isOutterGame = isOutterGame;
    }

    @Nullable
    public String getJumpUri() {
        if (this.ext != null) {
            return this.ext.get("jumpUri");
        }
        return null;
    }

    public static class Builder {
        private long id;
        private String gid;
        private String gname;
        private String desc;
        private String iconUrl;
        private String imIconUrl;
        private int screenDire;
        private int roomTemplate;
        private String modulerUrl;
        private String modulerMd5;
        private String modulerVer;
        private String pkId;
        private String singleGameShareBgUrl;
        private String singleGameIMBanner;
        private String scoreType;
        private int gameMode;
        private int subGameMode;
        private boolean isPopupGame;
        private String popupsProportion;
        private int gameType;
        private int teamTemplate;
        private int playerCount;
        private boolean fixing;
        private String defLang;
        private List<String> langList;
        private int voiceType;
        private boolean quickNews;
        public Map<String, String> ext;
        private boolean isFull;
        private boolean isHot;
        private boolean isWaitingOffline;
        private boolean isBetaTest;
        private int minSupportAppVersion;
        private MultiModeInfo multiModeInfo;
        private GameLabel gameLabel;
        private String teamTmpDynamicUrl;
        private String teamTmpStaticUrl;
        private int minPlayerCount;
        private long asNewTime;
        private String gameRule;
        private String gameRuleBgUrl;
        private String gamePrepareBgUrl;
        private boolean hide;
        private boolean quickJoin;
        private long goldDayStartTime;
        private long goldDayEndTime;
        private boolean goldMode;
        private int socketType;
        private String ruleBgUrl;
        private List<GameRule> gameRuleList;
        private String gameBcolor;
        private String actSvga;
        private boolean isSupportQuickJoin = false;
        private boolean moduleGray;
        private String chanGameDesc;
        private boolean showForRandRoom = false;
        private String tagUrl = "";
        private boolean isAr = false;
        private Map<String, String> tagMaps;
        private boolean supportFullScreen;
        private boolean isFirstPublish = false;
        private String gamePkgName;
        private long minCompatibleVer;
        GameInfoSource fromSource;
        private boolean keyNoteDesc = false;
        private int voiceRoomFlag = -1;
        private boolean isOutterGame = false;

        private Builder(GameInfoSource fromSource) {
            this.fromSource = fromSource;
        }

        public Builder goldDayStartTime(long goldDayStartTime) {
            this.goldDayStartTime = goldDayStartTime;
            return this;
        }

        public Builder goldDayEndTime(long goldDayEndTime) {
            this.goldDayEndTime = goldDayEndTime;
            return this;
        }

        public Builder goldMode(boolean goldMode) {
            this.goldMode = goldMode;
            return this;
        }

        public Builder gid(String gid) {
            this.gid = gid;
            return this;
        }

        public Builder id(long id2) {
            this.id = id2;
            return this;
        }

        public Builder gname(String name) {
            this.gname = name;
            return this;
        }

        public Builder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Builder iconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder imIconUrl(String url) {
            this.imIconUrl = url;
            return this;
        }

        public Builder screenDire(int dire) {
            this.screenDire = dire;
            return this;
        }

        public Builder rootTemplate(int tpl) {
            this.roomTemplate = tpl;
            return this;
        }

        public Builder modulerUrl(String url) {
            this.modulerUrl = url;
            return this;
        }

        public Builder modulerMd5(String url) {
            this.modulerMd5 = url;
            return this;
        }

        public Builder modulerVer(String ver) {
            this.modulerVer = ver;
            return this;
        }

        public Builder singleGameShareUrl(String url) {
            this.singleGameShareBgUrl = url;
            return this;
        }

        public Builder singleGameIMBanner(String bannerUrl) {
            this.singleGameIMBanner = bannerUrl;
            return this;
        }

        public Builder scoreType(String type) {
            this.scoreType = type;
            return this;
        }

        public Builder gameMode(int gameMode) {
            this.gameMode = gameMode;
            return this;
        }

        public Builder subGameMode(int subGameMode) {
            this.subGameMode = subGameMode;
            return this;
        }

        public Builder isPopupGame(boolean isPopupGame) {
            this.isPopupGame = isPopupGame;
            return this;
        }

        public Builder popupsProportion(String popupsProportion) {
            this.popupsProportion = popupsProportion;
            return this;
        }

        public Builder gameType(int gameType) {
            this.gameType = gameType;
            return this;
        }

        public Builder teamTemplate(int teamTemplate) {
            this.teamTemplate = teamTemplate;
            return this;
        }

        public Builder playerCount(int playerCount) {
            this.playerCount = playerCount;
            return this;
        }

        public Builder fixing(boolean fixing) {
            this.fixing = fixing;
            return this;
        }

        public Builder defLang(String defLang) {
            this.defLang = defLang;
            return this;
        }

        public Builder langList(List<String> langList) {
            this.langList = langList;
            return this;
        }

        public Builder voiceType(int voiceType) {
            this.voiceType = voiceType;
            return this;
        }

        public Builder quickNews(boolean quickNews) {
            this.quickNews = quickNews;
            return this;
        }

        public Builder ext(Map<String, String> ext) {
            this.ext = ext;
            return this;
        }

        public Builder isFull(boolean isFull) {
            this.isFull = isFull;
            return this;
        }

        public Builder isHot(boolean isHot) {
            this.isHot = isHot;
            return this;
        }

        public Builder asNewTime(long asNewTime) {
            this.asNewTime = asNewTime;
            return this;
        }

        public Builder isBetaTest(boolean isBetaTest) {
            this.isBetaTest = isBetaTest;
            return this;
        }

        public Builder isWaitingOffline(boolean isWaitingOffline) {
            this.isWaitingOffline = isWaitingOffline;
            return this;
        }

        public Builder minSupportAppVersion(int version) {
            this.minSupportAppVersion = version;
            return this;
        }

        public Builder multiModeInfo(MultiModeInfo multiModeInfo) {
            this.multiModeInfo = multiModeInfo;
            return this;
        }

        public Builder gameLabel(GameLabel gameLabel) {
            this.gameLabel = gameLabel;
            return this;
        }

        public Builder teamTmpDynamicUrl(String teamTmpDynamicUrl) {
            this.teamTmpDynamicUrl = teamTmpDynamicUrl;
            return this;
        }

        public Builder teamTnpStaticUrl(String teamTmpStaticUrl) {
            this.teamTmpStaticUrl = teamTmpStaticUrl;
            return this;
        }

        public Builder minPlayerCount(int minPlayerCount) {
            this.minPlayerCount = minPlayerCount;
            return this;
        }

        public Builder gameRule(String gameRule) {
            this.gameRule = gameRule;
            return this;
        }

        public Builder gameRuleBgUrl(String gameRuleBgUrl) {
            this.gameRuleBgUrl = gameRuleBgUrl;
            return this;
        }

        public Builder gamePrepareBgUrl(String gamePrepareBgUrl) {
            this.gamePrepareBgUrl = gamePrepareBgUrl;
            return this;
        }

        public Builder hide(boolean isHide) {
            this.hide = isHide;
            return this;
        }

        public Builder quickJoin(Boolean quickJoin) {
            this.quickJoin = quickJoin;
            return this;
        }

        public Builder socketType(int socketType) {
            this.socketType = socketType;
            return this;
        }

        public Builder ruleBgUrl(String ruleBgUrl) {
            this.ruleBgUrl = ruleBgUrl;
            return this;
        }

        public Builder gameRuleList(List<GameRule> gameRules) {
            this.gameRuleList = gameRules;
            return this;
        }

        public Builder gameBcolor(String gameBcolor) {
            this.gameBcolor = gameBcolor;
            return this;
        }

        public Builder actSvga(String svgaUrl) {
            this.actSvga = svgaUrl;
            return this;
        }

        public Builder isSupportQuickJoin(boolean supportQuickJoin) {
            this.isSupportQuickJoin = supportQuickJoin;
            return this;
        }

        public Builder moduleGray(boolean moduleGray) {
            this.moduleGray = moduleGray;
            return this;
        }

        public Builder chanGameDesc(String chanGameDesc) {
            this.chanGameDesc = chanGameDesc;
            return this;
        }

        public Builder showForRandRoom(boolean showForRandRoom) {
            this.showForRandRoom = showForRandRoom;
            return this;
        }

        public Builder isAr(boolean isAr) {
            this.isAr = isAr;
            return this;
        }

        public GameInfo build() {
            return new GameInfo(this);
        }

        public Builder tagUrl(String flagsURL) {
            this.tagUrl = flagsURL;
            return this;
        }

        public Builder tagMaps(Map<String, String> tagMaps) {
            this.tagMaps = tagMaps;
            return this;
        }

        public Builder keyNoteDesc(boolean keyNoteDesc) {
            this.keyNoteDesc = keyNoteDesc;
            return this;
        }

        public Builder gamePkgName(String gamePkgName) {
            this.gamePkgName = gamePkgName;
            return this;
        }

        public Builder supportFullScreen(boolean supportFullScreen) {
            this.supportFullScreen = supportFullScreen;
            return this;
        }

        public Builder isFirstPublish(boolean isFirstPublish) {
            this.isFirstPublish = isFirstPublish;
            return this;
        }

        public Builder minCompatibleVer(long minCompatibleVer) {
            this.minCompatibleVer = minCompatibleVer;
            return this;
        }

        public Builder voiceRoomFlag(int voiceRoomFlag) {
            this.voiceRoomFlag = voiceRoomFlag;
            return this;
        }

        public Builder isOutterGame(boolean isOutterGame) {
            this.isOutterGame = isOutterGame;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GameType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubGameMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GameMode {
    }
}

