/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.bean;

import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import java.util.HashMap;
import java.util.Map;

public class GameDownloadInfo
extends KvoSource {
    public static final float THRESHOLD_PROGRESS = 0.995f;
    public static final float FREE_PROGRESS = 10.0f;
    public static final String kvo_state = "state";
    @KvoFieldAnnotation(name="state")
    private DownloadState state = DownloadState.download_not;
    public static final String kvo_progress = "progress";
    @KvoFieldAnnotation(name="progress")
    private long progress;
    public static final String kvo_totalBytes = "totalBytes";
    @KvoFieldAnnotation(name="totalBytes")
    private long totalBytes;
    public String gameId;
    public DownloadType downloadType = DownloadType.none;
    public DownloadType lastFinishType = DownloadType.none;
    private DownloadFrom from = DownloadFrom.not;
    public final float randomInitProgress = this.randInitProgress();
    public int downloadErrCode = 0;
    public String downloadErrInfo = "";
    public boolean isPreDownload = false;
    private Map<String, Object> ext;

    public void setState(DownloadState state) {
        if (state == DownloadState.download_finish || state == DownloadState.download_fail) {
            if (state == DownloadState.download_finish) {
                this.lastFinishType = this.downloadType;
                if (this.downloadType != DownloadType.silent && this.from == DownloadFrom.home) {
                    this.addExt("needSplashLight", true);
                }
            }
            this.progress = 0L;
            this.totalBytes = 0L;
            this.downloadType = DownloadType.none;
            this.from = DownloadFrom.not;
        }
        this.setValue(kvo_state, (Object)state);
    }

    public void setProgress(long progress) {
        this.setValue(kvo_progress, progress);
    }

    public void setTotalBytes(long totalBytes) {
        this.setValue(kvo_totalBytes, totalBytes);
    }

    public void setFrom(DownloadFrom from) {
        if (from == null) {
            this.from = DownloadFrom.not;
            return;
        }
        this.from.from |= from.from;
    }

    public DownloadState getState() {
        return this.state;
    }

    public long getProgress() {
        return this.progress;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public DownloadFrom getFrom() {
        return this.from;
    }

    public boolean sameFrom(DownloadFrom from) {
        if (from == null || this.from == null) {
            return false;
        }
        return (this.from.from & from.from) == from.from;
    }

    public boolean isDownloading() {
        return this.downloadType != DownloadType.silent && (this.getState() == DownloadState.download_start || this.getState() == DownloadState.downloading || this.getState() == DownloadState.download_complete);
    }

    public boolean isPause() {
        return this.downloadType != DownloadType.silent && this.getState() == DownloadState.download_pause;
    }

    public void pause() {
        if (this.downloadType != DownloadType.silent && (this.getState() == DownloadState.downloading || this.getState() == DownloadState.download_start)) {
            this.setState(DownloadState.download_pause);
        }
    }

    public void addExt(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.ext == null) {
            this.ext = new HashMap<String, Object>();
        }
        this.ext.put(key, value);
    }

    public <T> T getExt(String key, T defaultValue) {
        if (defaultValue == null || key == null || this.ext == null) {
            return defaultValue;
        }
        Object obj = this.ext.get(key);
        if (defaultValue.getClass().isInstance(obj)) {
            return (T)obj;
        }
        return defaultValue;
    }

    public void removeExt(String key) {
        if (key == null || this.ext == null) {
            return;
        }
        this.ext.remove(key);
    }

    private float randInitProgress() {
        return (float)((Math.random() * 7.0 + 5.0) / 100.0);
    }

    public static float downloadInterpolation(float input) {
        if (input > 0.995f) {
            return 1.0f;
        }
        return (float)Math.tanh((double)input * 2.5);
    }

    public float getDownloadInterpolation(float progress) {
        if (progress > 0.995f) {
            return 1.0f;
        }
        float newProgress = (float)Math.tanh((double)progress * 2.5);
        if (newProgress > 0.0f && newProgress < this.randomInitProgress) {
            newProgress = this.randomInitProgress;
        }
        return newProgress;
    }

    public boolean isSilentDownload() {
        return this.downloadType == DownloadType.silent || this.downloadType == DownloadType.none;
    }

    public static interface ExtKey {
        public static final String needSplashLight = "needSplashLight";
    }

    public static enum DownloadFrom {
        not(0),
        home(1),
        im(4),
        single(8),
        sameScreen(16),
        web(32);

        int from;

        private DownloadFrom(int from) {
            this.from = from;
        }
    }

    public static enum DownloadType {
        none(0),
        silent(1),
        by_hand(10),
        no_pause(20);

        private int value;

        private DownloadType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum DownloadState {
        download_not(0),
        download_start(1),
        downloading(2),
        download_pause(3),
        download_wait(4),
        download_complete(5),
        download_finish(6),
        download_fail(7),
        wait_in_line(8);

        private int value;

        private DownloadState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

