/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.audio;

import com.yy.appbase.util.FileDirHelper;
import com.yy.base.utils.StringUtils;
import java.io.File;

public class AudioPathUtils {
    public static final String AUDIO_CACHE_DIR = AudioPathUtils.getAudioCache();
    public static final String URL_AUDIO_CACHE_DIR = AudioPathUtils.getUrlAudioCache();

    public static String getFileNameByAudioUrl(String audioUrl) {
        if (StringUtils.isEmpty((String)audioUrl)) {
            return null;
        }
        try {
            return audioUrl.substring(audioUrl.lastIndexOf(47) + 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getAudioCache() {
        return StringUtils.formatWitUSLocal((String)FileDirHelper.getAudioConfigDir(), (Object[])new Object[]{"soundConfig"});
    }

    private static String getUrlAudioCache() {
        return StringUtils.formatWitUSLocal((String)FileDirHelper.getAudioConfigDir(), (Object[])new Object[]{"PKGameUrlAudio"});
    }

    public static String getAudioCachePathByUrl(String url) {
        return AUDIO_CACHE_DIR + File.separator + AudioPathUtils.getFileNameByAudioUrl(url);
    }

    public static String getAudioCachePathByName(String fileName) {
        return AUDIO_CACHE_DIR + File.separator + fileName;
    }
}

