/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.kvomodule;

import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.appbase.kvomodule.BaseModuleData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GamePlayInfo;
import com.yy.hiyo.game.base.bean.GameRunningDataContainer;
import com.yy.hiyo.game.kvomodule.GameEmoji;
import com.yy.hiyo.game.kvomodule.GameRunningContext;
import com.yy.hiyo.game.kvomodule.SingleGameBestHistoryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GameInfoModuleData
extends BaseModuleData {
    private static final String TAG = "GameInfoModuleData";
    private GamePlayInfoDBBean playingGame;
    private GameRunningDataContainer mRunningGameData = new GameRunningDataContainer();
    private Map<String, GamePlayInfo> mGameCacheInfo = new ConcurrentHashMap<String, GamePlayInfo>();
    private Map<String, GameInfo> mGameInfos = new HashMap<String, GameInfo>();
    private Map<String, SingleGameBestHistoryInfo> mSingleGameBestScore = new ConcurrentHashMap<String, SingleGameBestHistoryInfo>();
    public static final String kvo_playInfoChange = "playInfoChange";
    @KvoFieldAnnotation(name="playInfoChange")
    private Object playInfoChange;
    private List<GameEmoji> gameEmojis = new ArrayList<GameEmoji>();
    private List<GamePlayInfoDBBean> playInfoDBBeans = new ArrayList<GamePlayInfoDBBean>();
    public GameRunningContext gameRunningContext = new GameRunningContext();

    public GamePlayInfoDBBean getPlayingGame() {
        return this.playingGame;
    }

    public void setPlayingGame(GamePlayInfoDBBean mPlayingGame) {
        this.playingGame = mPlayingGame;
    }

    public void setPlayInfoChange(Object playInfoChange) {
        this.setValue(kvo_playInfoChange, playInfoChange);
    }

    private synchronized GamePlayInfo getOrCreateGamePlayInfo(String gid) {
        if (StringUtils.isEmpty((String)gid)) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("getOrCreateGameInfo err:gid is empty");
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"getOrCreateGameInfo err:gid is empty", (Object[])new Object[0]);
            }
            return null;
        }
        GamePlayInfo ginfo = this.mGameCacheInfo.get(gid);
        if (ginfo == null) {
            ginfo = new GamePlayInfo(gid);
            this.mGameCacheInfo.put(gid, ginfo);
        }
        return ginfo;
    }

    public Map<String, GamePlayInfo> getGameCacheInfo() {
        return this.mGameCacheInfo;
    }

    public void appendPlayGame(GamePlayInfoDBBean gameInfo) {
        if (gameInfo == null || StringUtils.isEmpty((String)gameInfo.getGameId())) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException(StringUtils.formatWitUSLocal((String)"appendPlayGame err:gameInfo:%s", (Object[])new Object[]{gameInfo}));
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"appendPlayGame err:%s", (Object[])new Object[]{gameInfo});
            }
            return;
        }
        this.playInfoDBBeans.add(gameInfo);
        GamePlayInfo ginfo = this.getOrCreateGamePlayInfo(gameInfo.getGameId());
        if (ginfo != null) {
            ginfo.appendPlayGameInfo(gameInfo);
        }
    }

    public void initialTotal(List<GamePlayInfoDBBean> totals) {
        if (totals != null && !totals.isEmpty()) {
            this.playInfoDBBeans.addAll(totals);
            HashMap<String, ArrayList<GamePlayInfoDBBean>> cacheTotalGames = new HashMap<String, ArrayList<GamePlayInfoDBBean>>();
            for (GamePlayInfoDBBean infoDBBean : totals) {
                if (infoDBBean == null || StringUtils.isEmpty((String)infoDBBean.getGameId())) {
                    if (RuntimeContext.sIsDebuggable) {
                        throw new RuntimeException(StringUtils.formatWitUSLocal((String)"appendPlayGame err:gameInfo:%s", (Object[])new Object[]{infoDBBean}));
                    }
                    if (!MLog.isLogLevelBlowInfo()) continue;
                    MLog.info((Object)TAG, (String)"initialTotal err:%s", (Object[])new Object[]{infoDBBean});
                    continue;
                }
                ArrayList<GamePlayInfoDBBean> gamePlayInfoDBBeans = (ArrayList<GamePlayInfoDBBean>)cacheTotalGames.get(infoDBBean.getGameId());
                if (gamePlayInfoDBBeans == null) {
                    gamePlayInfoDBBeans = new ArrayList<GamePlayInfoDBBean>();
                    cacheTotalGames.put(infoDBBean.getGameId(), gamePlayInfoDBBeans);
                }
                gamePlayInfoDBBeans.add(infoDBBean);
            }
            if (!cacheTotalGames.isEmpty()) {
                for (String gid : cacheTotalGames.keySet()) {
                    GamePlayInfo orCreateGamePlayInfo = this.getOrCreateGamePlayInfo(gid);
                    if (orCreateGamePlayInfo == null) continue;
                    orCreateGamePlayInfo.initialTotal((List)cacheTotalGames.get(gid));
                }
            }
        }
    }

    public List<GamePlayInfoDBBean> getPlayInfoDBBeans() {
        return this.playInfoDBBeans;
    }

    public void updateGameInfo(GameInfo info) {
        GamePlayInfo ginfo;
        if (info != null && !StringUtils.isEmpty((String)info.getGid()) && (ginfo = this.getOrCreateGamePlayInfo(info.getGid())) != null) {
            ginfo.setGameInfo(info);
        }
        if (info != null) {
            this.mGameInfos.put(info.getGid(), info);
        }
    }

    public List<GameEmoji> getGameEmojis() {
        return this.gameEmojis;
    }

    public void setGameEmojis(List<GameEmoji> mGameEmojis) {
        this.gameEmojis = mGameEmojis;
    }

    public SingleGameBestHistoryInfo getSingleGameBestScore(String gid) {
        if (!StringUtils.isEmpty((String)gid)) {
            return this.mSingleGameBestScore.get(gid);
        }
        return null;
    }

    public void updateSingleGameBestScore(SingleGameBestHistoryInfo info) {
        if (info != null) {
            this.mSingleGameBestScore.put(info.gameId, info);
        }
    }

    public GameRunningDataContainer getRunningGameData() {
        return this.mRunningGameData;
    }

    public void getMatchPlayInfoBean(Matcher matcher, MatchCallback callback) {
        if (matcher == null) {
            if (callback != null) {
                callback.onGetResult(new ArrayList<GamePlayInfo>());
            }
            return;
        }
        ArrayList<GamePlayInfoDBBean> copy = new ArrayList<GamePlayInfoDBBean>(this.playInfoDBBeans);
        HashMap<String, GamePlayInfo> map = new HashMap<String, GamePlayInfo>();
        for (GamePlayInfoDBBean item : copy) {
            if (item == null || matcher == null || !matcher.match(item)) continue;
            GamePlayInfo gamePlayInfo = (GamePlayInfo)map.get(item.getGameId());
            if (gamePlayInfo == null) {
                gamePlayInfo = new GamePlayInfo(item.getGameId());
                gamePlayInfo.setGameModel(item.getGameMode());
                gamePlayInfo.setGameInfo(this.mGameInfos.get(item.getGameId()));
                map.put(item.getGameId(), gamePlayInfo);
            }
            gamePlayInfo.appendPlayGameInfo(item);
        }
        ArrayList<GamePlayInfo> result = new ArrayList<GamePlayInfo>(map.values());
        if (callback != null) {
            callback.onGetResult(result);
        }
    }

    public void resetData() {
        super.resetData();
        this.playingGame = null;
        if (this.mRunningGameData != null) {
            this.mRunningGameData.reset();
        }
        this.mGameCacheInfo.clear();
        this.mSingleGameBestScore.clear();
        this.gameEmojis.clear();
    }

    public static interface MatchCallback {
        public void onGetResult(List<GamePlayInfo> var1);
    }

    public static interface Matcher {
        public boolean match(GamePlayInfoDBBean var1);
    }
}

