/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.wrapper;

import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.module.appcallgamemodle.AppNotifyGameDefine;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.OpenGameContext;
import com.yy.hiyo.game.service.callback.IOpenGameFunc;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import java.util.Map;

public class OpenGameWrapper {
    private static final String TAG = "OpenGameWrapper";
    private final IServiceManager serviceManager;
    private IOpenGameFunc iOpenGameFunc;
    private OpenGameContext mContext;
    private GameLifeWrapper mGameLifeExt;
    private GameLifeWrapper mGameLifeWrapperInner = new GameLifeWrapper(){

        @Override
        public void onGameExited(GamePlayContext context, int gameExitType) {
            super.onGameExited(context, gameExitType);
            if (context == OpenGameWrapper.this.mContext) {
                OpenGameWrapper.this.onDetach();
                if (OpenGameWrapper.this.mGameLifeExt != null) {
                    OpenGameWrapper.this.mGameLifeExt.onGameExited(context, gameExitType);
                }
                OpenGameWrapper.this.mContext = null;
            }
        }

        @Override
        public void onPreloadGame(GamePlayContext context) {
            super.onPreloadGame(context);
            if (context == OpenGameWrapper.this.mContext && OpenGameWrapper.this.mGameLifeExt != null) {
                OpenGameWrapper.this.mGameLifeExt.onPreloadGame(context);
            }
        }

        @Override
        public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
            super.onLoadGameFinish(context, finishType, window);
            if (context == OpenGameWrapper.this.mContext && OpenGameWrapper.this.mGameLifeExt != null) {
                OpenGameWrapper.this.mGameLifeExt.onLoadGameFinish(context, finishType, window);
            }
        }

        @Override
        public void onGameReady(GamePlayContext context) {
            super.onGameReady(context);
            if (context == OpenGameWrapper.this.mContext && OpenGameWrapper.this.mGameLifeExt != null) {
                OpenGameWrapper.this.mGameLifeExt.onGameReady(context);
            }
        }

        @Override
        public void onGameViewShow(GamePlayContext context) {
            super.onGameReady(context);
            if (context == OpenGameWrapper.this.mContext && OpenGameWrapper.this.mGameLifeExt != null) {
                OpenGameWrapper.this.mGameLifeExt.onGameViewShow(context);
            }
        }

        @Override
        public void onGameViewHide(GamePlayContext context) {
            super.onGameReady(context);
            if (context == OpenGameWrapper.this.mContext && OpenGameWrapper.this.mGameLifeExt != null) {
                OpenGameWrapper.this.mGameLifeExt.onGameViewHide(context);
            }
        }
    };
    private IGameFuncRegister funcRegister = null;

    public OpenGameWrapper(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        if (serviceManager == null) {
            if (RuntimeContext.sIsDebuggable) {
                throw new RuntimeException("service manager can not be null");
            }
            MLog.error((Object)TAG, (String)"service manager can not be null", (Object[])new Object[0]);
        }
    }

    public OpenGameWrapper() {
        this(ServiceManagerProxy.getServiceManager());
    }

    public boolean startGame(GameLifeWrapper gameLifeWrapper, OpenGameContext context) {
        boolean success = false;
        if (this.serviceManager == null) {
            return success;
        }
        if (this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).registerGameLifecycle(this.mGameLifeWrapperInner);
        }
        this.mContext = context;
        this.mGameLifeExt = gameLifeWrapper;
        GameInfo info = this.mContext.getGameInfo();
        if (this.funcRegister == null) {
            this.funcRegister = new IGameFuncRegister(){

                @Override
                public void registerGameFunc(IOpenGameFunc iOpenGameFunc) {
                    OpenGameWrapper.this.iOpenGameFunc = iOpenGameFunc;
                }
            };
        }
        this.mContext.gameFuncRegister = this.funcRegister;
        if (((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).joinGame(info, this.mContext) == 0) {
            success = true;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"join game ,game info:%s, success:%b", (Object[])new Object[]{info, success});
        }
        return success;
    }

    public void exitGame() {
        if (this.iOpenGameFunc != null) {
            this.iOpenGameFunc.exitGame();
        }
    }

    public void onShow() {
        if (this.iOpenGameFunc != null && this.iOpenGameFunc.gameUiCallback() != null) {
            this.iOpenGameFunc.gameUiCallback().onShow();
        }
    }

    public void onHide() {
        if (this.iOpenGameFunc != null && this.iOpenGameFunc.gameUiCallback() != null) {
            this.iOpenGameFunc.gameUiCallback().onHide();
        }
    }

    public void onDetach() {
        if (this.iOpenGameFunc != null && this.iOpenGameFunc.gameUiCallback() != null) {
            this.iOpenGameFunc.gameUiCallback().onDetach(this.mContext);
        }
        this.iOpenGameFunc = null;
        this.funcRegister = null;
        if (this.serviceManager.getService(IGameCenterService.class) != null) {
            ((IGameCenterService)this.serviceManager.getService(IGameCenterService.class)).unRegisterGameLifecycle(this.mGameLifeWrapperInner);
        }
    }

    public void appCallGameWithType(String type, Map<String, Object> msgObj, int tag, int mode) {
        if (this.iOpenGameFunc != null) {
            this.iOpenGameFunc.appCallGameWithType(type, msgObj, tag, mode);
        }
    }

    public void notifyGameWithOutRegister(String res, AppNotifyGameDefine baseGameNotify) {
        if (this.iOpenGameFunc != null) {
            this.iOpenGameFunc.notifyGameWithOutRegister(res, baseGameNotify);
        }
    }

    public static interface IGameFuncRegister {
        public void registerGameFunc(IOpenGameFunc var1);
    }
}

