/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.widget.label;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.hiyo.game.base.widget.label.GameFlowLayout;
import com.yy.hiyo.game.base.widget.label.LabelAdapter;
import com.yy.hiyo.game.base.widget.label.LabelView;

public class LabelFlowLayout
extends GameFlowLayout
implements LabelAdapter.OnDataChangedListener {
    private LabelAdapter mLabelAdapter;
    private OnLabelClickListener mOnLabelClickListener;
    private OnUnableSelectListener mOnUnableSelectListener;

    public void setOnLabelClickListener(OnLabelClickListener onLabelClickListener) {
        this.mOnLabelClickListener = onLabelClickListener;
    }

    public void setOnUnableSelectListener(OnUnableSelectListener onUnableSelectListener) {
        this.mOnUnableSelectListener = onUnableSelectListener;
    }

    public LabelFlowLayout(Context context) {
        super(context);
    }

    public LabelFlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LabelFlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setAdapter(LabelAdapter adapter) {
        this.mLabelAdapter = adapter;
        this.mLabelAdapter.setOnDataChangedListener(this);
        this.mLabelAdapter.getSelectedList().clear();
        this.changeAdapter();
    }

    private void changeAdapter() {
        this.removeAllViews();
        LabelAdapter adapter = this.mLabelAdapter;
        LabelView labelViewContainer = null;
        int i = 0;
        while (i < adapter.getCount()) {
            View labelView = adapter.getView(this, i, adapter.getItem(i));
            labelViewContainer = new LabelView(this.getContext());
            labelView.setDuplicateParentStateEnabled(true);
            if (labelView.getLayoutParams() != null) {
                labelViewContainer.setLayoutParams(labelView.getLayoutParams());
            }
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
            labelView.setLayoutParams(lp);
            labelViewContainer.addView(labelView);
            this.addView((View)labelViewContainer);
            if (adapter.getSelectedList().contains(adapter.getItem(i))) {
                this.setChildChecked(i, labelViewContainer);
            }
            labelView.setClickable(false);
            final LabelView finalLabelViewContainer = labelViewContainer;
            final int position = i++;
            labelViewContainer.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    LabelFlowLayout.this.doSelect(finalLabelViewContainer, position);
                }
            });
        }
    }

    private void setChildChecked(int position, LabelView view) {
        view.setChecked(true);
        this.mLabelAdapter.onSelected(position, view.getLabelView());
    }

    private void setChildUnChecked(int position, LabelView view) {
        view.setChecked(false);
        this.mLabelAdapter.unSelected(position, view.getLabelView());
    }

    private void doSelect(LabelView child, int position) {
        if (!child.isChecked()) {
            if (this.mLabelAdapter.getLeftCount() <= 0 && this.mOnUnableSelectListener != null) {
                this.mOnUnableSelectListener.onUnableSelect();
                return;
            }
            this.setChildChecked(position, child);
            if (this.mOnLabelClickListener != null) {
                this.mOnLabelClickListener.onLabelClick((View)child, position, true, this);
            }
        } else {
            this.setChildUnChecked(position, child);
            if (this.mOnLabelClickListener != null) {
                this.mOnLabelClickListener.onLabelClick((View)child, position, false, this);
            }
        }
    }

    public LabelAdapter getAdapter() {
        return this.mLabelAdapter;
    }

    @Override
    public void onChanged() {
        this.changeAdapter();
    }

    public static interface OnUnableSelectListener {
        public void onUnableSelect();
    }

    public static interface OnLabelClickListener {
        public boolean onLabelClick(View var1, int var2, boolean var3, GameFlowLayout var4);
    }
}

