/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.ui.utils.AvatarUtils;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.game.base.R;
import com.yy.hiyo.game.base.widget.IMatchSuccessView;
import java.util.ArrayList;
import java.util.List;

public class MatchSuccessAvatarView
extends YYRelativeLayout
implements IMatchSuccessView {
    private static final int MAX_ITEM = 5;
    private int avatartSize = ResolutionUtils.dip2Px((float)51.0f);
    private int avatarSpace = -ResolutionUtils.dip2Px((float)10.0f);
    private int avatarBorderSize = ResolutionUtils.dip2Px((float)3.0f);
    private static int[] ids = new int[]{R.id.match_success_avatar_1, R.id.match_success_avatar_2, R.id.match_success_avatar_3, R.id.match_success_avatar_4, R.id.match_success_avatar_5};

    public MatchSuccessAvatarView(Context context) {
        super(context);
        this.initView();
    }

    public MatchSuccessAvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MatchSuccessAvatarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    private void initView() {
    }

    @Override
    public void setData(List<UserInfoKS> userInfoList) {
        this.removeAllViews();
        if (FP.empty(userInfoList)) {
            return;
        }
        List<CircleImageView> circleImageViewList = this.createAvatarViews(userInfoList);
        this.addAvatarViews(circleImageViewList);
    }

    @Override
    public void setStringData(List<String> mUserHead) {
        ArrayList<UserInfoKS> userList = new ArrayList<UserInfoKS>();
        if (mUserHead != null) {
            for (int i = 0; i < mUserHead.size(); ++i) {
                String head = mUserHead.get(i);
                UserInfoKS userInfoKS = new UserInfoKS();
                userInfoKS.setAvatar(head);
                userInfoKS.setSex(0);
                userList.add(userInfoKS);
            }
        }
        List<CircleImageView> circleImageViewList = this.createAvatarViews(userList);
        this.addAvatarViews(circleImageViewList);
    }

    private List<CircleImageView> createAvatarViews(List<UserInfoKS> userInfoList) {
        int startIndex;
        ArrayList<CircleImageView> circleImageViewList = new ArrayList<CircleImageView>(5);
        if (userInfoList.size() > 5) {
            CircleImageView circleImageView = new CircleImageView(this.getContext());
            circleImageView.setBackgroundResource(R.drawable.shape_match_success_avatar_more_bg);
            circleImageView.setImageResource(R.drawable.ic_match_success_more);
            circleImageViewList.add(circleImageView);
        }
        for (int i = startIndex = Math.min(5 - circleImageViewList.size() - 1, userInfoList.size() - 1); i >= 0; --i) {
            UserInfoKS userInfo = userInfoList.get(i);
            CircleImageView circleImageView = new CircleImageView(this.getContext());
            circleImageView.setBorderColor(-1);
            circleImageView.setBorderWidth(this.avatarBorderSize);
            circleImageViewList.add(circleImageView);
            String url = userInfo.avatar + YYImageUtils.getThumbnailPostfix((int)75);
            ImageLoader.loadImage((RecycleImageView)circleImageView, (String)url, (int)0, (int)AvatarUtils.getDefaultAvatar((int)userInfo.sex));
        }
        return circleImageViewList;
    }

    private void addAvatarViews(List<CircleImageView> avatarViewList) {
        for (int i = 0; i < avatarViewList.size() && i < 5; ++i) {
            CircleImageView avatarView = avatarViewList.get(i);
            avatarView.setId(ids[i]);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(this.avatartSize, this.avatartSize);
            if (i == 0) {
                lp.addRule(11);
                if (Build.VERSION.SDK_INT >= 17) {
                    lp.addRule(21);
                }
            } else {
                int rightMargin;
                int toLeftOfId = ids[i - 1];
                lp.addRule(0, toLeftOfId);
                lp.rightMargin = rightMargin = this.avatarSpace;
                if (Build.VERSION.SDK_INT >= 17) {
                    lp.addRule(16, toLeftOfId);
                    lp.setMarginEnd(rightMargin);
                }
            }
            this.addView((View)avatarView, (ViewGroup.LayoutParams)lp);
        }
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (lp != null) {
            int avatarCount = avatarViewList.size();
            lp.width = avatarCount == 0 ? 0 : this.avatartSize * avatarCount + this.avatarSpace * (avatarCount - 1);
        }
    }

    public void setAvatartSize(int avatartSize) {
        this.avatartSize = avatartSize;
    }

    public void setAvatarSpace(int avatarSpace) {
        this.avatarSpace = avatarSpace;
    }

    public void setAvatarBorderSize(int size) {
        this.avatarBorderSize = ResolutionUtils.dip2Px((float)size);
    }
}

