/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.bean;

import com.yy.appbase.data.GamePlayInfoDBBean;
import com.yy.base.utils.DontProguardClass;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@DontProguardClass
public class GamePlayInfo {
    private static final String TAG = "GamePlayInfo";
    private String gameId;
    private GameInfo gameInfo;
    private long totalPlayTime;
    private int playCount;
    private int gameModel;
    private List<GamePlayInfoDBBean> gamePlayList = new CopyOnWriteArrayList<GamePlayInfoDBBean>();

    public GamePlayInfo(String gameId) {
        this.gameId = gameId;
    }

    public String getGameId() {
        return this.gameId;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public void setGameInfo(GameInfo gameInfo) {
        this.gameInfo = gameInfo;
    }

    public long getTotalPlayTime() {
        return this.totalPlayTime;
    }

    public void setTotalPlayTime(long totalPlayTime) {
        this.totalPlayTime = totalPlayTime;
    }

    public int getPlayCount() {
        return this.playCount;
    }

    public void setPlayCount(int playCount) {
        if (this.playCount != playCount) {
            this.playCount = playCount;
        }
    }

    public long getLatestPlayTs() {
        if (this.gamePlayList.isEmpty()) {
            return 0L;
        }
        GamePlayInfoDBBean data = this.gamePlayList.get(this.gamePlayList.size() - 1);
        return data != null ? data.getStartTs() : 0L;
    }

    public void appendPlayGameInfo(GamePlayInfoDBBean playInfo) {
        if (playInfo != null) {
            this.gamePlayList.add(playInfo);
            long ts = playInfo.getGamingTs();
            this.setTotalPlayTime(ts + this.totalPlayTime);
            this.setPlayCount(this.gamePlayList.size());
        }
    }

    public void initialTotal(List<GamePlayInfoDBBean> playInfos) {
        long totalTs = 0L;
        int playCounts = 0;
        if (playInfos != null) {
            this.gamePlayList.addAll(playInfos);
            for (GamePlayInfoDBBean i : playInfos) {
                if (i == null) continue;
                totalTs += i.getGamingTs();
            }
            playCounts = playInfos.size();
        }
        this.setTotalPlayTime(totalTs);
        this.setPlayCount(playCounts);
    }

    public long getLastTimePlayDuration() {
        long duration = 0L;
        if (this.gamePlayList.isEmpty()) {
            duration = 0L;
        } else {
            GamePlayInfoDBBean info = this.gamePlayList.get(this.gamePlayList.size() - 1);
            if (info != null) {
                duration = info.getGamingTs();
            }
        }
        return duration;
    }

    public List<GamePlayInfoDBBean> getGamePlayList() {
        return this.gamePlayList;
    }

    public int getGameModel() {
        return this.gameModel;
    }

    public void setGameModel(int gameModel) {
        this.gameModel = gameModel;
    }

    public String toString() {
        return "GamePlayInfo{gameId='" + this.gameId + '\'' + ", totalPlayTime=" + this.totalPlayTime + ", playCount=" + this.playCount + '}';
    }
}

