/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base;

import android.text.TextUtils;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.TeamUserInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GameModel {
    private static final String TAG = "GameModel";
    GameInfo gameInfo;
    UserInfoBean myUserInfo;
    UserInfoBean otherInfo;
    String mGameUrl;
    String roomid;
    String laugh;
    List<TeamUserInfo> teamUserInfoList;
    Map<String, Object> ext;
    String gameResult;
    int multiMode;

    private GameModel(Builder builder) {
        this.gameInfo = builder.gameInfo;
        this.myUserInfo = builder.myUserInfo;
        this.otherInfo = builder.otherInfo;
        this.mGameUrl = builder.mGameUrl;
        this.roomid = builder.roomid;
        this.laugh = builder.laugh;
        this.teamUserInfoList = builder.teamUserInfoList;
        this.ext = builder.ext;
        this.gameResult = builder.gameResult;
        this.multiMode = builder.multiMode;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(GameModel copy) {
        Builder builder = new Builder();
        builder.gameInfo = copy.getGameInfo();
        builder.myUserInfo = copy.getMyUserInfo();
        builder.otherInfo = copy.getOtherInfo();
        builder.mGameUrl = copy.getGameUrl();
        builder.roomid = copy.getRoomid();
        builder.laugh = copy.getLaugh();
        builder.teamUserInfoList = copy.getTeamUserInfoList();
        builder.ext = copy.getExt();
        builder.gameResult = copy.getGameResult();
        builder.multiMode = copy.getMultiMode();
        return builder;
    }

    public GameInfo getGameInfo() {
        return this.gameInfo;
    }

    public UserInfoBean getMyUserInfo() {
        return this.myUserInfo;
    }

    public UserInfoBean getOtherInfo() {
        return this.otherInfo;
    }

    public String getGameUrl() {
        return this.mGameUrl;
    }

    public String getRoomid() {
        return this.roomid;
    }

    public static boolean checkBean(GameModel gameModel) {
        if (gameModel.getGameInfo() == null || gameModel.getOtherInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkBean gameinfo null", (Object[])new Object[0]);
            }
            return false;
        }
        if (StringUtils.isEmpty((String)gameModel.getGameUrl())) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkBean getGame_url null", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public static boolean checkBeanWithOutUserInfo(GameModel gameModel) {
        if (gameModel.getGameInfo() == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkBean gameinfo null", (Object[])new Object[0]);
            }
            return false;
        }
        if (StringUtils.isEmpty((String)gameModel.getGameUrl())) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"checkBean getGame_url null", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public List<TeamUserInfo> getTeamUserInfoList() {
        return this.teamUserInfoList;
    }

    public String getLaugh() {
        return this.laugh;
    }

    public Map<String, Object> getExt() {
        return this.ext;
    }

    public <T> T getExt(String key, T defaultValue) {
        if (TextUtils.isEmpty((CharSequence)key) || this.ext == null) {
            return defaultValue;
        }
        Object v = this.ext.get(key);
        if (v != null && v.getClass().isInstance(defaultValue)) {
            return (T)v;
        }
        return defaultValue;
    }

    public String getGameResult() {
        return this.gameResult;
    }

    public int getMultiMode() {
        return this.multiMode;
    }

    public static final class Builder {
        private GameInfo gameInfo;
        private UserInfoBean myUserInfo;
        private UserInfoBean otherInfo;
        private String mGameUrl;
        private String roomid;
        private String laugh;
        private List<TeamUserInfo> teamUserInfoList;
        private Map<String, Object> ext;
        private String gameResult;
        private int multiMode;

        private Builder() {
        }

        public Builder gameInfo(GameInfo val) {
            this.gameInfo = val;
            return this;
        }

        public Builder myUserInfo(UserInfoBean val) {
            this.myUserInfo = val;
            return this;
        }

        public Builder otherInfo(UserInfoBean val) {
            this.otherInfo = val;
            return this;
        }

        public Builder game_url(String val) {
            this.mGameUrl = val;
            return this;
        }

        public Builder roomid(String val) {
            this.roomid = val;
            return this;
        }

        public Builder laugh(String val) {
            this.laugh = val;
            return this;
        }

        public Builder teamUserInfoList(List<TeamUserInfo> val) {
            this.teamUserInfoList = val;
            return this;
        }

        public synchronized Builder ext(Map<String, Object> val) {
            this.ext = val;
            return this;
        }

        public synchronized Builder addExt(String key, Object value) {
            if (TextUtils.isEmpty((CharSequence)key) || value == null) {
                return this;
            }
            if (this.ext == null) {
                this.ext = new HashMap<String, Object>();
            }
            this.ext.put(key, value);
            return this;
        }

        public Builder gameResult(String val) {
            this.gameResult = val;
            return this;
        }

        public Builder multiMode(int val) {
            this.multiMode = val;
            return this;
        }

        public GameModel build() {
            return new GameModel(this);
        }
    }
}

