/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.viewtree;

import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import com.yy.base.logger.MLog;
import java.lang.ref.WeakReference;

public class ViewTreeInfo {
    private MyGlobalLayoutListener mOnGlobalLayoutListener;
    private View mView;

    public ViewTreeInfo(View view) {
        this.mView = view;
    }

    public void setOnGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
        if (this.mOnGlobalLayoutListener != null) {
            this.onDetachedListener();
        }
        this.mOnGlobalLayoutListener = new MyGlobalLayoutListener(onGlobalLayoutListener);
    }

    public void onAttachedListener() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info("ViewTreeInfo", "onAttachedListener!", new Object[0]);
        }
        if (this.mOnGlobalLayoutListener != null && this.mView != null) {
            ViewTreeObserver viewTreeObserver = this.mView.getViewTreeObserver();
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mOnGlobalLayoutListener);
        }
    }

    public void onDetachedListener() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info("ViewTreeInfo", "onDetachedListener!", new Object[0]);
        }
        if (this.mOnGlobalLayoutListener != null && this.mView != null) {
            ViewTreeObserver viewTreeObserver = this.mView.getViewTreeObserver();
            if (Build.VERSION.SDK_INT >= 16) {
                viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mOnGlobalLayoutListener);
            } else {
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mOnGlobalLayoutListener);
            }
        }
    }

    private static class MyGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WeakReference<ViewTreeObserver.OnGlobalLayoutListener> globalLayoutListener;

        MyGlobalLayoutListener(ViewTreeObserver.OnGlobalLayoutListener layoutListener) {
            this.globalLayoutListener = new WeakReference<ViewTreeObserver.OnGlobalLayoutListener>(layoutListener);
        }

        public void onGlobalLayout() {
            ViewTreeObserver.OnGlobalLayoutListener layoutListener;
            if (this.globalLayoutListener != null && (layoutListener = (ViewTreeObserver.OnGlobalLayoutListener)this.globalLayoutListener.get()) != null) {
                layoutListener.onGlobalLayout();
            }
        }
    }
}

