/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.memory;

import android.app.ActivityManager;
import android.content.Context;
import android.text.format.Formatter;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MemoryUtil {
    public static final String TAG = "Memory";
    private static ActivityManager sAm;

    private static List<String> getMemInfo() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/proc/meminfo"));
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFieldFromMeminfo(String field) throws IOException {
        Pattern p = Pattern.compile(field + "\\s*:\\s*(.*)");
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/meminfo"));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String string2 = m.group(1);
                return string2;
            }
        }
        return null;
    }

    private static String getMemTotal() {
        String result = null;
        try {
            result = MemoryUtil.getFieldFromMeminfo("MemTotal");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String getMemAvailable() {
        String result = null;
        try {
            result = MemoryUtil.getFieldFromMeminfo("MemAvailable");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static long availMemory() {
        ActivityManager am = (ActivityManager)RuntimeContext.sApplicationContext.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        if (am != null) {
            am.getMemoryInfo(mi);
        }
        return mi.availMem;
    }

    private static ActivityManager getActivityManager() {
        if (sAm != null) {
            return sAm;
        }
        sAm = (ActivityManager)RuntimeContext.sApplicationContext.getSystemService("activity");
        return sAm;
    }

    public static String getAvailMemory() {
        ActivityManager am = MemoryUtil.getActivityManager();
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        if (am != null) {
            am.getMemoryInfo(mi);
        }
        return Formatter.formatFileSize((Context)RuntimeContext.sApplicationContext, (long)mi.availMem);
    }

    public static String getTotalMemory() {
        ActivityManager activityManager = MemoryUtil.getActivityManager();
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        if (activityManager != null) {
            activityManager.getMemoryInfo(mi);
        }
        return Formatter.formatFileSize((Context)RuntimeContext.sApplicationContext, (long)mi.totalMem);
    }

    public static ActivityManager.MemoryInfo getMemoryInfo() {
        ActivityManager activityManager = MemoryUtil.getActivityManager();
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        if (activityManager != null) {
            activityManager.getMemoryInfo(mi);
        }
        return mi;
    }

    public static void logForMemoryDetail(final String info) {
        YYTaskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                int m = 0x100000;
                Runtime r = Runtime.getRuntime();
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info(MemoryUtil.TAG, "MemTotal = " + MemoryUtil.getTotalMemory() + " MemAvailable = " + MemoryUtil.getAvailMemory() + "  info = " + info, new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info(MemoryUtil.TAG, "maxMemory:" + r.maxMemory() / (long)m + "M", new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info(MemoryUtil.TAG, "totalMemory:" + r.totalMemory() / (long)m + "M", new Object[0]);
                }
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info(MemoryUtil.TAG, "freeMemory:" + r.freeMemory() / (long)m + "M", new Object[0]);
                }
            }
        });
    }
}

