/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils.filestorage;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import androidx.core.content.ContextCompat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.PackageUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.IUIDFetcher;
import com.yy.base.utils.filestorage.OldFileStorageUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FileStorageUtils
extends OldFileStorageUtils {
    public static final String TAG = "FileStorageUtils";
    public static final long STORAGE_THREE_TEN_M = 0x3C00000L;
    @SuppressLint(value={"StaticFieldLeak"})
    private static final FileStorageUtils sInstance = new FileStorageUtils();
    BroadcastReceiver mExternalStorageReceiver;
    volatile boolean mExternalStorageAvailable = false;
    volatile boolean mExternalStorageWriteable = false;
    private Context mContext;
    private volatile boolean mExternalStorageChecked = false;
    private volatile Runnable mCheckAvailableSizeRunnalbe = null;
    private static String sInternalCacheDir;
    private static String sInternalFileDir;
    private static String sExternalCacheDir;
    private static String sExternalFileDir;
    private IUIDFetcher mUIDFetcher;
    private volatile long sSystemTotalSize = -1L;
    private volatile long sSystemAvailableSize = -1L;
    private volatile boolean sAvailableSizeHasChecked = false;
    public static String APP_PACKAGE_NAME;
    private static volatile boolean sHagoInstallOnSDCard;
    private static volatile boolean sJudgeHagoInstallOnSDCard;
    private static final String DIR = "filecache";

    public void setUIDFetcher(IUIDFetcher uidFetcher) {
        this.mUIDFetcher = uidFetcher;
    }

    public static FileStorageUtils getInstance() {
        return sInstance;
    }

    public void setAppContext(Context context) {
        this.mContext = context;
    }

    public void clearRootDirByChangeEnvSetting() {
        if (RuntimeContext.sIsDebuggable) {
            YYFileUtils.removeFilesInDir(this.getExternalCacheRootDir());
            YYFileUtils.removeFilesInDir(this.getExternalFileRootDir());
            YYFileUtils.removeFilesInDir(this.getInternalFileRootDir());
            YYFileUtils.removeFilesInDir(this.getInternalCacheRootDir());
        }
    }

    public String getInternalCacheRootDir() {
        if (sInternalCacheDir == null) {
            try {
                File file;
                Context context = this.mContext == null ? RuntimeContext.sApplicationContext : this.mContext;
                sInternalCacheDir = context.getCacheDir().getAbsolutePath();
                if (RuntimeContext.isHagoPartySdk() && !(file = new File(sInternalCacheDir = sInternalCacheDir + File.separator + "party")).exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception e) {
                sInternalCacheDir = this.getExternalCacheRootDir();
                MLog.error((Object)TAG, "getInternalCacheRootDir error", e, new Object[0]);
            }
        }
        return sInternalCacheDir;
    }

    public String getInternalFileRootDir() {
        if (sInternalFileDir == null) {
            try {
                File file;
                Context context = this.mContext == null ? RuntimeContext.sApplicationContext : this.mContext;
                sInternalFileDir = context.getFilesDir().getAbsolutePath();
                if (RuntimeContext.isHagoPartySdk() && !(file = new File(sInternalFileDir = sInternalFileDir + File.separator + "party")).exists()) {
                    file.mkdirs();
                }
            }
            catch (Exception e) {
                sInternalFileDir = this.getExternalFileRootDir();
                MLog.error((Object)TAG, "getInternalFileRootDir error", e, new Object[0]);
            }
        }
        return sInternalFileDir;
    }

    public String getExternalFileRootDir() {
        if (sExternalFileDir == null) {
            Context context = this.mContext == null ? RuntimeContext.sApplicationContext : this.mContext;
            File externalFilesDir = context.getExternalFilesDir(null);
            sExternalFileDir = externalFilesDir == null ? (sInternalFileDir != null ? sInternalFileDir : context.getFilesDir().getAbsolutePath()) : externalFilesDir.getAbsolutePath();
            if (RuntimeContext.isHagoPartySdk()) {
                sExternalFileDir = sExternalFileDir + File.separator + "party";
                try {
                    File file = new File(sExternalFileDir);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, e.getMessage(), new Object[0]);
                }
            }
        }
        return sExternalFileDir;
    }

    public String getExternalCacheRootDir() {
        if (sExternalCacheDir == null) {
            Context context = this.mContext == null ? RuntimeContext.sApplicationContext : this.mContext;
            File externalCacheDir = context.getExternalCacheDir();
            sExternalCacheDir = externalCacheDir == null ? (sInternalCacheDir != null ? sInternalCacheDir : context.getCacheDir().getAbsolutePath()) : externalCacheDir.getAbsolutePath();
            if (RuntimeContext.isHagoPartySdk()) {
                sExternalCacheDir = sExternalCacheDir + File.separator + "party";
                try {
                    File file = new File(sExternalCacheDir);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, e.getMessage(), new Object[0]);
                }
            }
        }
        return sExternalCacheDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getDir(String uniqueDirName, boolean createNotExist, boolean internal, boolean userArea, int dirType) {
        if (StringUtils.isEmpty(uniqueDirName)) {
            throw new IllegalArgumentException("dir name can not be null");
        }
        this.validateDir(uniqueDirName);
        String rootDir = this.getRootDir(internal, dirType);
        String dirPath = rootDir + File.separator + uniqueDirName;
        if (this.mUIDFetcher != null && userArea && this.mUIDFetcher.getUid() > 0L) {
            dirPath = dirPath + File.separator + this.mUIDFetcher.getUid();
        }
        String string2 = dirPath.intern();
        synchronized (string2) {
            boolean result;
            File dir = new File(dirPath);
            if (!YYFileUtils.isDirExisted(dir) && !(result = dir.mkdirs())) {
                String tips = String.format("Can't create dir: %s", dir.getAbsolutePath());
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException(tips);
                }
                MLog.error((Object)TAG, tips, new Object[0]);
            }
            return dir;
        }
    }

    public File getCacheDirWithDebug(String uniqueDirName) {
        if (RuntimeContext.sIsDebuggable) {
            return this.getExternalCacheDir(uniqueDirName);
        }
        return this.getInternalCacheDir(uniqueDirName);
    }

    public File getFileDirWithDebug(String uniqueDirName) {
        if (RuntimeContext.sIsDebuggable) {
            return this.getExternalFileDir(uniqueDirName);
        }
        return this.getInternalFileDir(uniqueDirName);
    }

    @Override
    public File getInternalCacheDir(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, true, false, 0);
    }

    @Override
    public File getInternalFileDir(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, true, false, 1);
    }

    @Override
    public File getInternalCacheDirWithUserArea(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, true, true, 0);
    }

    @Override
    public File getInternalFileDirWithUserArea(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, true, true, 1);
    }

    @Override
    public File getExternalCacheDir(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, false, false, 0);
    }

    @Override
    public File getExternalFileDir(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, false, false, 1);
    }

    @Override
    public File getExternalCacheDirWithUserArea(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, false, true, 0);
    }

    @Override
    public File getExternalFileDirWithUserArea(String uniqueDirName) {
        return this.getDir(uniqueDirName, true, false, true, 1);
    }

    @Override
    public File getTempDir() {
        return this.getDir("tmp", true, false, false, 0);
    }

    @Override
    public File getTempDir(String uniqueDirName) {
        return this.getDir("tmp" + File.separator + uniqueDirName, true, false, false, 0);
    }

    private void validateDir(String uniqueDirName) {
        if (RuntimeContext.sIsDebuggable) {
            try {
                if (uniqueDirName.startsWith(File.separator)) {
                    throw new IllegalArgumentException("uniqueDirName can not start with '/'");
                }
                if (uniqueDirName.endsWith(File.separator)) {
                    throw new IllegalArgumentException("uniqueDirName can not end with '/'");
                }
                String[] depths = uniqueDirName.split(File.separator);
                if (depths.length > 3) {
                    throw new IllegalArgumentException(String.format("dir max depth is over 3 : %s", uniqueDirName));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SuppressLint(value={"IfUsage"})
    private String getRootDir(boolean internal, int dirType) {
        if (internal) {
            if (dirType == 0) {
                return this.getInternalCacheRootDir();
            }
            if (dirType == 1) {
                return this.getInternalFileRootDir();
            }
        } else {
            if (dirType == 0) {
                return this.getExternalCacheRootDir();
            }
            if (dirType == 1) {
                return this.getExternalFileRootDir();
            }
        }
        throw new IllegalArgumentException(String.format("can not get root dir: internal %s , dirType %s", internal, dirType));
    }

    public boolean isExternalStorageAvailable() {
        this.startExternalState();
        return this.mExternalStorageAvailable;
    }

    public boolean isExternalStorageWriteable() {
        this.startExternalState();
        return this.mExternalStorageWriteable;
    }

    public void startExternalState() {
    }

    public void updateExternalStorageState() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            this.mExternalStorageWriteable = true;
            this.mExternalStorageAvailable = true;
        } else if ("mounted_ro".equals(state)) {
            this.mExternalStorageAvailable = true;
            this.mExternalStorageWriteable = false;
        } else {
            this.mExternalStorageWriteable = false;
            this.mExternalStorageAvailable = false;
        }
    }

    private void startWatchingExternalStorage() {
        if (this.mContext == null) {
            MLog.error((Object)TAG, "mContext null when startWatchingExternalStorage", new Object[0]);
            return;
        }
        this.mExternalStorageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("ExternalStorageReceiver", "Storage: " + intent.getData(), new Object[0]);
                }
                FileStorageUtils.this.updateExternalStorageState();
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MEDIA_MOUNTED");
        filter.addAction("android.intent.action.MEDIA_REMOVED");
        this.mContext.registerReceiver(this.mExternalStorageReceiver, filter);
    }

    public synchronized void stopWatchingExternalStorage() {
        if (this.mContext == null) {
            MLog.error((Object)TAG, "mContext null when stopWatchingExternalStorage", new Object[0]);
            return;
        }
        if (this.mExternalStorageReceiver != null) {
            this.mContext.unregisterReceiver(this.mExternalStorageReceiver);
        }
    }

    private void checkAvailableSize(final IGetAvailableSize callBack) {
        if (this.mCheckAvailableSizeRunnalbe == null) {
            this.mCheckAvailableSizeRunnalbe = new Runnable(){

                @Override
                public void run() {
                    FileStorageUtils.this.sAvailableSizeHasChecked = false;
                    FileStorageUtils.this.sSystemTotalSize = YYFileUtils.getSystemTotalSize();
                    FileStorageUtils.this.sSystemAvailableSize = YYFileUtils.getSystemAvailable();
                    FileStorageUtils.this.sAvailableSizeHasChecked = true;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info(FileStorageUtils.TAG, " sSystemTotalSize %s sSystemAvailableSize %s", String.valueOf(FileStorageUtils.this.sSystemTotalSize), String.valueOf(FileStorageUtils.this.sSystemAvailableSize));
                    }
                }
            };
        } else {
            YYTaskExecutor.removeTask(this.mCheckAvailableSizeRunnalbe);
        }
        YYTaskExecutor.execute(this.mCheckAvailableSizeRunnalbe, new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onCallBackInMainThread(FileStorageUtils.this.sSystemTotalSize, FileStorageUtils.this.sSystemAvailableSize);
                }
            }
        }, 5000L);
    }

    public void getAvailableSize(final IGetAvailableSize callBack) {
        if (!this.sAvailableSizeHasChecked) {
            this.checkAvailableSize(callBack);
        } else if (callBack != null) {
            Runnable commnad = new Runnable(){

                @Override
                public void run() {
                    if (callBack != null) {
                        callBack.onCallBackInMainThread(FileStorageUtils.this.sSystemTotalSize, FileStorageUtils.this.sSystemAvailableSize);
                    }
                }
            };
            if (YYTaskExecutor.isMainThread()) {
                commnad.run();
            } else {
                YYTaskExecutor.postToMainThread(commnad);
            }
        }
    }

    public void hasEnoughAvailableSize(final IHasEnoughAvailableSizeTwo callBack) {
        this.getAvailableSize(new IGetAvailableSize(){

            @Override
            public void onCallBackInMainThread(long systemTotalSize, long systemAvailableSize) {
                if (systemTotalSize <= 0L || systemAvailableSize <= 0L) {
                    if (callBack != null) {
                        callBack.onCallBackInMainThread(false);
                    }
                    return;
                }
                if (systemAvailableSize < 0x3C00000L) {
                    if (callBack != null) {
                        callBack.onCallBackInMainThread(true);
                    }
                } else if (callBack != null) {
                    callBack.onCallBackInMainThread(false);
                }
            }
        });
    }

    public static boolean isHagoInstallOnSDCard() {
        if (sJudgeHagoInstallOnSDCard) {
            return sHagoInstallOnSDCard;
        }
        sHagoInstallOnSDCard = PackageUtils.isInstallOnSDCard(APP_PACKAGE_NAME);
        sJudgeHagoInstallOnSDCard = true;
        return sHagoInstallOnSDCard;
    }

    public void onForeGroundChange(boolean fore) {
        if (fore) {
            this.sAvailableSizeHasChecked = false;
        }
    }

    public synchronized String getStrFromFile(boolean internal, String fileName) {
        File file = FileStorageUtils.getInstance().getDirAndCreate(internal, DIR, false);
        File configFile = new File(file, fileName);
        String result = "";
        if (configFile.exists()) {
            try {
                result = new String(YYFileUtils.getBytesFromFile(configFile));
                if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                    MLog.info(TAG, "get file %s str length %d", configFile.getAbsolutePath(), result != null ? result.length() : 0);
                }
            }
            catch (IOException e) {
                MLog.error(TAG, e);
            }
        }
        return result;
    }

    public synchronized String removeFile(boolean internal, String fileName) {
        File file = FileStorageUtils.getInstance().getDirAndCreate(internal, DIR, false);
        File configFile = new File(file, fileName);
        String result = "";
        if (configFile.exists()) {
            YYFileUtils.delete(configFile);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean saveObject(Object object, String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        File file = FileStorageUtils.getInstance().getDirAndCreate(true, DIR, false);
        ObjectOutputStream fos = null;
        File configFile = new File(file, fileName);
        try {
            configFile.delete();
            configFile.createNewFile();
            fos = new ObjectOutputStream(new FileOutputStream(configFile));
            fos.writeObject(object);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            MLog.error(TAG, e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object getObject(String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return null;
        }
        File file = FileStorageUtils.getInstance().getDirAndCreate(true, DIR, false);
        File configFile = new File(file, fileName);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(configFile));
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public synchronized boolean saveToFile(boolean internal, String strData, String fileName) {
        if (StringUtils.isEmpty(fileName)) {
            return false;
        }
        if (strData == null) {
            strData = "";
        }
        File file = FileStorageUtils.getInstance().getDirAndCreate(internal, DIR, false);
        File configFile = new File(file, fileName);
        try {
            YYFileUtils.writeBytesToFile(configFile, strData.getBytes(), false);
            if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                MLog.info(TAG, "save file %s str length %d", configFile.getAbsolutePath(), strData != null ? strData.length() : 0);
            }
            return true;
        }
        catch (IOException e) {
            MLog.error(TAG, e);
            return false;
        }
    }

    public static boolean isAvailableInternalStorgeNotEnough() {
        long available;
        if (!SettingFlags.getBoolean("checksasize", true)) {
            MLog.error((Object)"DiskCacheChecker", "switch off!", new Object[0]);
            return false;
        }
        int minNum = SettingFlags.getIntValue("storage_warning_value", 30) * 1024;
        if (minNum > 102400) {
            minNum = 102400;
        }
        if (RuntimeContext.sIsDebuggable && (minNum = 1024 * SettingFlags.getIntValue("checkstoragetestvalue", 30)) <= 0) {
            minNum = 30720;
        }
        if ((available = YYFileUtils.getAvailableInternalStorgeSize()) > 0L && available < (long)minNum) {
            MLog.error((Object)"DiskCacheChecker", "AvailableInternalStorgeSize %d not enough, check size %d!", (int)available, minNum);
            return true;
        }
        MLog.error((Object)"DiskCacheChecker", "AvailableInternalStorgeSize %d enough, check size %d!", (int)available, minNum);
        return false;
    }

    public static boolean isStoragePermissionGranted(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    static {
        sHagoInstallOnSDCard = false;
        sJudgeHagoInstallOnSDCard = false;
    }

    public static interface IHasEnoughAvailableSizeTwo {
        public void onCallBackInMainThread(boolean var1);
    }

    public static interface IGetAvailableSize {
        public void onCallBackInMainThread(long var1, long var3);
    }
}

