/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedPreferencesExecutor {
    private static final String Tag = "SharedPreferencesExecutor";
    private static int MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() > 4 ? 10 : 6;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private ArrayList<SharedPreferencesRunnable> mRunnablesToPost = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addTask(Runnable task) {
        SharedPreferencesExecutor sharedPreferencesExecutor = this;
        synchronized (sharedPreferencesExecutor) {
            this.mRunnablesToPost.add(new SharedPreferencesRunnable(task));
        }
        this.executeNext();
        return true;
    }

    private void onTaskFinished(SharedPreferencesRunnable runnable) {
        this.mCurrentActiveTasks.decrementAndGet();
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        SharedPreferencesRunnable myRunnable = null;
        SharedPreferencesExecutor sharedPreferencesExecutor = this;
        synchronized (sharedPreferencesExecutor) {
            if (this.mRunnablesToPost.size() > 0 && this.mCurrentActiveTasks.get() < MAX_CONCURRENCY_TASKS) {
                myRunnable = this.mRunnablesToPost.get(0);
                this.mRunnablesToPost.remove(0);
                if (myRunnable != null) {
                    this.mCurrentActiveTasks.incrementAndGet();
                }
            }
        }
        if (myRunnable != null) {
            YYTaskExecutor.execute(myRunnable, 0L, 5);
        }
    }

    private class SharedPreferencesRunnable
    implements Runnable {
        private Runnable mRunnable;

        public SharedPreferencesRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                try {
                    if (this.mRunnable != null) {
                        if (MLog.isLogLevelBlowInfo()) {
                            MLog.info(SharedPreferencesExecutor.Tag, "onTaskStarted, RunnablesToPost:%d", SharedPreferencesExecutor.this.mRunnablesToPost.size());
                        }
                        this.mRunnable.run();
                    }
                    SharedPreferencesExecutor.this.onTaskFinished(this);
                    if (RuntimeContext.sIsDebuggable && this.mRunnable != null) {
                        SharedPreferencesExecutor sharedPreferencesExecutor = SharedPreferencesExecutor.this;
                        synchronized (sharedPreferencesExecutor) {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info(SharedPreferencesExecutor.Tag, "onTaskFinished:" + this.mRunnable + "  RunnablesToPost" + SharedPreferencesExecutor.this.mRunnablesToPost.size(), new Object[0]);
                            }
                            break block11;
                        }
                    }
                    if (this.mRunnable != null && MLog.isLogLevelBlowInfo()) {
                        MLog.info(SharedPreferencesExecutor.Tag, "onTaskFinished, RunnablesToPost:%d", SharedPreferencesExecutor.this.mRunnablesToPost.size());
                    }
                }
                catch (Throwable throwable) {
                    SharedPreferencesExecutor.this.onTaskFinished(this);
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info(SharedPreferencesExecutor.Tag, "onTaskFinished:" + this.mRunnable + " error:" + throwable, new Object[0]);
                    }
                    throw throwable;
                }
            }
        }
    }
}

