/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import androidx.annotation.StyleRes;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.Locale;

public class LocaleUtil {
    public static boolean isHindi() {
        String country = SystemUtils.getHagoCountry();
        return !FP.empty(country) && country.equalsIgnoreCase("IN") || "hi".equalsIgnoreCase(Locale.getDefault().getLanguage());
    }

    public static Context applyLocale(Context base, Locale locale) {
        MLog.debug("LocaleUtil", "applyLocale:" + locale, new Object[0]);
        if (!Locale.getDefault().equals(locale)) {
            MLog.debug("LocaleUtil", "setDefault" + Locale.getDefault() + "\uff0capplyLocale diff:" + locale, new Object[0]);
            Locale.setDefault(locale);
        }
        Configuration configuration = base.getResources().getConfiguration();
        LocaleUtil.updateConfiguration(configuration, locale);
        if (Build.VERSION.SDK_INT >= 17) {
            return base.createConfigurationContext(configuration);
        }
        base.getResources().updateConfiguration(configuration, base.getResources().getDisplayMetrics());
        return base;
    }

    public static void updateConfiguration(Configuration configuration, Locale locale) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (Build.VERSION.SDK_INT >= 24) {
            for (int i = 0; i < configuration.getLocales().size(); ++i) {
                locales.add(configuration.getLocales().get(i));
            }
            if (locales.indexOf(locale) != 0) {
                locales.remove(locale);
                locales.add(0, locale);
            }
            configuration.setLocales(new LocaleList(locales.toArray(new Locale[0])));
        } else if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLocale(locale);
        } else {
            configuration.locale = locale;
        }
    }

    public static Locale getContextLocale(Context context) {
        return LocaleUtil.getConfigurationLocale(context.getResources().getConfiguration());
    }

    public static Locale getConfigurationLocale(Configuration configuration) {
        Locale locale = null;
        if (configuration == null) {
            return Locale.getDefault();
        }
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList list = configuration.getLocales();
            locale = list.get(0);
        } else {
            locale = configuration.locale;
        }
        return locale == null ? Locale.getDefault() : locale;
    }

    public static Context changeAppLanguage(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        if (Build.VERSION.SDK_INT >= 17) {
            configuration.setLocale(locale);
        } else {
            configuration.locale = locale;
        }
        DisplayMetrics dm = resources.getDisplayMetrics();
        resources.updateConfiguration(configuration, dm);
        return context;
    }

    public static Context attachBaseContext(Context context, Locale locale) {
        if (locale == null || TextUtils.isEmpty((CharSequence)locale.getLanguage())) {
            return context;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleUtil.updateResources(context, locale);
        }
        LocaleUtil.changeAppLanguage(context, locale);
        return context;
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.setLocale(locale);
        configuration.setLocales(new LocaleList(new Locale[]{locale}));
        return context.createConfigurationContext(configuration);
    }

    public static Context updateBaseContext12(Context context, Locale locale, @StyleRes int themeResId) {
        Context newContext = LocaleUtil.updateBaseContextLocale(context, locale);
        final Configuration configuration = newContext.getResources().getConfiguration();
        ContextThemeWrapper wrappedContext = new ContextThemeWrapper(context, themeResId){

            public void applyOverrideConfiguration(Configuration overrideConfiguration) {
                if (overrideConfiguration != null) {
                    overrideConfiguration.setTo(configuration);
                }
                super.applyOverrideConfiguration(overrideConfiguration);
            }
        };
        return wrappedContext;
    }

    public static Context updateBaseContextLocale(Context context, Locale locale) {
        Context newContext = Build.VERSION.SDK_INT >= 24 ? LocaleUtil.updateResourcesLocale(context, locale) : LocaleUtil.updateResourcesLocaleLegacy(context, locale);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Locale set default ");
        stringBuilder.append(locale);
        Log.i((String)"jkl", (String)stringBuilder.toString());
        Locale.setDefault(locale);
        return newContext;
    }

    private static Context updateResourcesLocale(Context context, Locale locale) {
        Configuration configuration = context.getResources().getConfiguration();
        configuration.setLocale(locale);
        return context.createConfigurationContext(configuration);
    }

    private static Context updateResourcesLocaleLegacy(Context context, Locale locale) {
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        return context;
    }
}

