/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SharedPreferencesImpl;
import com.yy.hago.xlog.KLogUtils;
import java.io.File;
import java.util.Set;

public class JustApplySharedPreferencesImpl
extends SharedPreferencesImpl {
    private static final String CRASH_SHARED = "Crash";
    private static final String CRASH_ANR_SHARED = "ANRDB";
    private static final String LOCALE_LANGUAGE_CONFIG = "locale_language_config";
    private static final String FACEBOOK_FACEBOOK_EXPERIMENTATION_CONFIGURATION = "ExperimentationConfiguration";
    private boolean inWhiteList;
    private boolean inBlackList;
    private String fileName;
    private int mode;

    public JustApplySharedPreferencesImpl(File file, int mode) {
        super(file, mode);
        String fileName;
        String string2 = fileName = file != null ? file.getName() : "";
        if (fileName == null) {
            fileName = "";
        }
        if (fileName.startsWith(CRASH_SHARED) || fileName.startsWith(CRASH_ANR_SHARED)) {
            this.inWhiteList = true;
        } else if (fileName.equals(LOCALE_LANGUAGE_CONFIG)) {
            this.inWhiteList = true;
        } else if (fileName.startsWith(FACEBOOK_FACEBOOK_EXPERIMENTATION_CONFIGURATION)) {
            this.inBlackList = true;
        } else if (fileName.contains("com.facebook")) {
            this.inBlackList = true;
        }
        this.fileName = fileName;
        this.mode = mode;
        if (RuntimeContext.isInGray() && KLogUtils.isInitialized()) {
            if (KLogUtils.isInitialized()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("JustApplySharedPreferencesImpl", "file:%s", fileName);
                }
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"JustApplySharedPreferencesImpl", (String)("file:" + fileName));
            }
        }
    }

    @Override
    public SharedPreferences.Editor edit() {
        SharedPreferences.Editor editor = super.edit();
        if (editor == null) {
            return editor;
        }
        if (this.inWhiteList) {
            return editor;
        }
        if (this.inBlackList) {
            return new MyEditor(editor, this.fileName, this.mode);
        }
        return editor;
    }

    public static final class MyEditor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor originEditor;
        private String fileName;
        private int mode;

        public MyEditor(SharedPreferences.Editor editor, String fileName, int mode) {
            this.originEditor = editor;
            this.fileName = fileName;
            this.mode = mode;
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            this.originEditor.putString(key, value);
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            this.originEditor.putStringSet(key, values);
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.originEditor.putInt(key, value);
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.originEditor.putLong(key, value);
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.originEditor.putFloat(key, value);
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.originEditor.putBoolean(key, value);
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.originEditor.remove(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.originEditor.clear();
            return this;
        }

        public boolean commit() {
            if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
                MLog.info("JustApplySharedPreferencesImpl", "commit fileName:%s, %d", this.fileName, this.mode);
            }
            if (YYTaskExecutor.isMainThread()) {
                this.originEditor.apply();
                return true;
            }
            return this.originEditor.commit();
        }

        public void apply() {
            this.originEditor.apply();
        }
    }
}

