/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.media.ThumbnailUtils;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.Base64Utils;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class BitmapUtils {
    private static final String TAG = "BitmapUtils";

    public static JSONObject handleVideoThumbnailToBase64(String videoPath) {
        block7: {
            if (FP.empty(videoPath)) {
                MLog.warn("handleVideoThumbnailToBase64", "[ReturnBase64ImgToWeb].videoPath is null", new Object[0]);
                return null;
            }
            Bitmap bitmap = null;
            JSONObject bitmapJsonObject = null;
            ByteArrayOutputStream baos = null;
            try {
                bitmap = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)3);
                if (bitmap != null) {
                    bitmapJsonObject = JsonParser.obtainJSONObject();
                    baos = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
                    String base64Img = Base64Utils.encodeToString(baos.toByteArray(), 2);
                    bitmapJsonObject.put("localFileName", (Object)videoPath);
                    bitmapJsonObject.put("thumbnail", (Object)base64Img);
                    baos.flush();
                    baos.close();
                    bitmap.recycle();
                    bitmap = null;
                    baos = null;
                    return bitmapJsonObject;
                }
            }
            catch (Throwable t) {
                MLog.error((Object)"handleVideoThumbnailRetToWeb", "[handleVideoThumbnailRetToWeb].t=" + t + ",videoPath" + videoPath, new Object[0]);
                if (bitmap != null) {
                    bitmap.recycle();
                }
                if (baos == null) break block7;
                try {
                    baos.flush();
                    baos.close();
                }
                catch (IOException e) {
                    MLog.error((Object)"handleVideoThumbnailRetToWeb", "[handleVideoThumbnailRetToWeb].e=" + e, new Object[0]);
                }
            }
        }
        return null;
    }

    public static JSONObject handleImgThumbnailToBase64(String imgPath) {
        if (FP.empty(imgPath)) {
            MLog.warn("handleImgThumbnailToBase64", "[ReturnBase64ImgToWeb].imgPath is null", new Object[0]);
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        try {
            int beHeight;
            int beWidth;
            int be;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = YYImageUtils.decodeFile(imgPath, options);
            options.inJustDecodeBounds = false;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("handleImgThumbnailToBase64", "[ReturnBase64ImgToWeb].Img origin  w=" + options.outWidth + ",h=" + options.outHeight, new Object[0]);
            }
            int n = be = (beWidth = options.outWidth / 96) < (beHeight = options.outHeight / 96) ? beWidth : beHeight;
            if (be <= 0) {
                be = 1;
            }
            options.inSampleSize = be;
            baos = new ByteArrayOutputStream();
            bitmap = YYImageUtils.decodeFile(imgPath, options);
            if (imgPath.endsWith("jpg") || imgPath.endsWith("jpeg")) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 100, baos);
            }
            String base64Img = Base64Utils.encodeToString(((ByteArrayOutputStream)baos).toByteArray(), 2);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("handleImgThumbnailToBase64", "[ReturnBase64ImgToWeb].Img now w=" + options.outWidth + ",h=" + options.outHeight + ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() + ",base64Img=" + base64Img.substring(0, 50), new Object[0]);
            }
            bitmapJsonObject = JsonParser.obtainJSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    MLog.error((Object)"handleThumbnailRetToWeb", "[handleThumbnailRetToWeb].IOException=" + e.getMessage(), new Object[0]);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            MLog.error((Object)"handleThumbnailRetToWeb", "[handleThumbnailRetToWeb].e=" + t + ",imgs=" + imgPath, new Object[0]);
        }
        return bitmapJsonObject;
    }

    public static String handleImageToBase64JsonStr(String[] clipPaths) {
        if (clipPaths != null && clipPaths.length > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.length; ++i) {
                JSONObject jsonObject = BitmapUtils.handleImageToBase64(clipPaths[i], 1280, 720);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("handleImageToBase64JsonStr", "[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length(), new Object[0]);
                }
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static String handleImageToBase64JsonStr(List<String> clipPaths) {
        return BitmapUtils.handleImageToBase64JsonStrWithCompress(clipPaths, 1280, 720);
    }

    public static String handleImageToBase64JsonStrWithCompress(List<String> clipPaths, int reqWidth, int reqHeight) {
        if (clipPaths != null && clipPaths.size() > 0) {
            JSONArray bitmapJsonArray = new JSONArray();
            for (int i = 0; i < clipPaths.size(); ++i) {
                JSONObject jsonObject = BitmapUtils.handleImageToBase64(clipPaths.get(i), reqWidth, reqHeight);
                if (jsonObject == null) continue;
                bitmapJsonArray.put((Object)jsonObject);
            }
            if (bitmapJsonArray.length() > 0) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("handleImageToBase64JsonStr", "[handleImageToBase64JsonStr].imgSizes=" + bitmapJsonArray.length(), new Object[0]);
                }
                return bitmapJsonArray.toString();
            }
        }
        return "";
    }

    public static JSONObject handleImageToBase64(String imgPath, int reqWidth, int reqHeight) {
        if (FP.empty(imgPath)) {
            MLog.warn("handleImageToBase64", "[handleImageToBase64].imgPath is null", new Object[0]);
            return null;
        }
        JSONObject bitmapJsonObject = null;
        OutputStream baos = null;
        Bitmap bitmap = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            bitmap = YYImageUtils.decodeFile(imgPath, options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, reqWidth, reqHeight);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("handleImageToBase64", "[handleImageToBase64].Img origin  w=" + options.outWidth + ",h=" + options.outHeight + ",reqw=" + reqWidth + ",reqh=" + reqHeight + ",simple=" + options.inSampleSize, new Object[0]);
            }
            baos = new ByteArrayOutputStream();
            bitmap = YYImageUtils.decodeFile(imgPath, options);
            int pos = imgPath.lastIndexOf(".");
            String suffix = null;
            if (pos + 1 < imgPath.length()) {
                suffix = imgPath.substring(pos + 1, imgPath.length());
            }
            if (!FP.empty(suffix) && (suffix.equalsIgnoreCase("jpg") || suffix.equalsIgnoreCase("jpeg"))) {
                bitmap.compress(Bitmap.CompressFormat.JPEG, 80, baos);
            } else {
                bitmap.compress(Bitmap.CompressFormat.PNG, 80, baos);
            }
            String base64Img = Base64Utils.encodeToString(((ByteArrayOutputStream)baos).toByteArray(), 2);
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("handleImageToBase64", "[handleImageToBase64].Img now w=" + options.outWidth + ",h=" + options.outHeight + ",inSampleSize=" + options.inSampleSize + ",base64Img.size=" + base64Img.length() + ",base64Img=" + base64Img.substring(0, 50), new Object[0]);
            }
            bitmapJsonObject = JsonParser.obtainJSONObject();
            bitmapJsonObject.put("thumbnail", (Object)base64Img);
            bitmapJsonObject.put("localFileName", (Object)imgPath);
            ((ByteArrayOutputStream)baos).close();
            bitmap.recycle();
            bitmap = null;
            baos = null;
        }
        catch (Throwable t) {
            if (baos != null) {
                try {
                    baos.flush();
                    ((ByteArrayOutputStream)baos).close();
                }
                catch (IOException e) {
                    MLog.error((Object)"handleImageToBase64", "[handleImageToBase64].IOException=" + e.getMessage(), new Object[0]);
                }
            }
            if (bitmap != null) {
                bitmap.recycle();
            }
            MLog.error((Object)"handleImageToBase64", "[handleImageToBase64].e=" + t + ",imgs=" + imgPath, new Object[0]);
        }
        return bitmapJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64(String path) {
        if (YYTaskExecutor.isMainThread()) {
            MLog.error((Object)TAG, "do not convert image to base64 in mainThread", Log.getStackTraceString((Throwable)new Throwable()));
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("do not convert image to base64 in mainThread");
            }
        }
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        FileInputStream is = null;
        byte[] data = null;
        String result = null;
        try {
            is = new FileInputStream(path);
            data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            result = Base64.encodeToString((byte[])data, (int)0);
        }
        catch (IOException e) {
            MLog.error(TAG, e);
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    MLog.error(TAG, e);
                }
            }
        }
        return result;
    }

    public static String base64ToFile(String base64Str, String imageName) {
        if (YYTaskExecutor.isMainThread()) {
            MLog.error((Object)TAG, "do not convert base64 to file in mainThread", Log.getStackTraceString((Throwable)new Throwable()));
            if (RuntimeContext.sIsDebuggable) {
                throw new IllegalStateException("do not convert base64 to file in mainThread");
            }
        }
        Bitmap bitmap = BitmapUtils.stringtoBitmap(base64Str);
        String imagePath = YYFileUtils.getYYTempDir();
        String saveResult = ViewImage.saveImgToLocal(bitmap, imageName, imagePath, Bitmap.CompressFormat.JPEG);
        return saveResult;
    }

    public static Bitmap stringtoBitmap(String string2) {
        Bitmap bitmap = null;
        try {
            byte[] bitmapArray = Base64.decode((String)string2, (int)0);
            bitmap = BitmapFactory.decodeByteArray((byte[])bitmapArray, (int)0, (int)bitmapArray.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static Bitmap mirror(Bitmap source) {
        Matrix matrix = new Matrix();
        matrix.postScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap crop(Bitmap srcBitmap, int x, int y, int width, int height) {
        Bitmap cropBitmap = Bitmap.createBitmap((Bitmap)srcBitmap, (int)x, (int)y, (int)width, (int)height);
        if (srcBitmap != null && !srcBitmap.equals(cropBitmap) && !srcBitmap.isRecycled()) {
            srcBitmap.recycle();
            srcBitmap = null;
        }
        return cropBitmap;
    }

    public static Bitmap adjustOpacity(Bitmap bitmap, int opacity) {
        Bitmap mutableBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(mutableBitmap);
        int colour = (opacity & 0xFF) << 24;
        canvas.drawColor(colour, PorterDuff.Mode.DST_IN);
        return mutableBitmap;
    }

    @Nullable
    public static Bitmap getBitmapFromDrawable(Context context, Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        Bitmap bitmap = ImageLoader.getBitmapFromCustomDrawable(drawable2);
        if (bitmap != null) {
            return bitmap;
        }
        if (drawable2 instanceof TransitionDrawable) {
            try {
                Drawable layer1 = ((TransitionDrawable)drawable2).getDrawable(1);
                if (layer1 instanceof BitmapDrawable) {
                    return ((BitmapDrawable)layer1).getBitmap();
                }
                bitmap = ImageLoader.getBitmapFromCustomDrawable(layer1);
                if (bitmap != null) {
                    return bitmap;
                }
            }
            catch (Exception e) {
                MLog.error((Object)TAG, "Get TransitionDrawable error.", e, new Object[0]);
            }
        }
        try {
            if (drawable2 instanceof ColorDrawable) {
                bitmap = Glide.get(context).getBitmapPool().get(1, 1, Bitmap.Config.ARGB_8888);
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "getBitmapFromDrawable reuse bitmap %b", bitmap != null);
                }
                if (bitmap == null) {
                    bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
            } else {
                if (drawable2.getIntrinsicWidth() < 0) {
                    return null;
                }
                bitmap = Glide.get(context).getBitmapPool().get(drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight(), Bitmap.Config.ARGB_8888);
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "getBitmapFromDrawable reuse bitmap %b", bitmap != null);
                }
                if (bitmap == null) {
                    bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
            }
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError e) {
            return null;
        }
    }
}

