/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.glideadapter;

import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.SdkNormalExecutorAdapter;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.taskexecutor.glideadapter.GlideExecutorDelegate;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.concurrent.ExecutorService;

public class GlideExecutorAdapter {
    public static ExecutorService newDiskCacheExecutor(int threadCount, String name, GlideExecutor.UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutorAdapter.newExecutor(threadCount, name);
    }

    public static ExecutorService newSourceExecutor(int threadCount, String name, GlideExecutor.UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutorAdapter.newExecutor(threadCount, name);
    }

    public static ExecutorService newUnlimitedSourceExecutor() {
        return GlideExecutorAdapter.newExecutor(8, "GLideUnlimitedSource");
    }

    public static ExecutorService newAnimationExecutor(int threadCount, GlideExecutor.UncaughtThrowableStrategy uncaughtThrowableStrategy) {
        return GlideExecutorAdapter.newExecutor(threadCount, "GLideAnimation");
    }

    public static ExecutorService newExecutor(int threadCount, String name) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info("GlideExecutorAdapter", "newExecutor name:%s, threadCount:%d!", name, threadCount);
        }
        SdkNormalExecutorAdapter executorAdapter = new SdkNormalExecutorAdapter(threadCount, name);
        if (YYTaskExecutor.getThreadPriorityType() == 3) {
            return new GlideExecutorDelegate(YYTaskExecutor.getThreadPool(), executorAdapter, false);
        }
        return new GlideExecutorDelegate(YYTaskExecutor.getWorkPriorityThreadPool(), executorAdapter, true);
    }

    public static boolean useDelegate() {
        if (YYTaskExecutor.getThreadPriorityType() == 2) {
            return SystemUtils.isShowEnvSetting() || SettingFlags.getBoolean("imageuseourexcutornew", true);
        }
        return SystemUtils.isShowEnvSetting();
    }
}

