/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import android.annotation.SuppressLint;
import android.util.Log;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.ThreadHookHelper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import com.yy.hago.xlog.KLogUtils;

@SuppressLint(value={"ThreadUsage"})
public class YYThread
extends Thread {
    private Runnable target;
    private String name;
    private IQueueTaskExecutor mExecutor;
    private static int sIndex = 0;

    public YYThread() {
        ++sIndex;
    }

    public YYThread(Runnable target) {
        super(target);
        this.target = target;
    }

    public YYThread(ThreadGroup group, Runnable target) {
        super(group, target);
        this.target = target;
    }

    public YYThread(String name) {
        super(name);
        this.name = name;
    }

    public YYThread(ThreadGroup group, String name) {
        super(group, name);
        this.name = name;
    }

    public YYThread(Runnable target, String name) {
        super(target, name);
        this.target = target;
        this.name = name;
    }

    public YYThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, name);
        this.target = target;
        this.name = name;
    }

    public YYThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, name, stackSize);
        this.target = target;
        this.name = name;
    }

    @Override
    public synchronized void start() {
        if (!this.useProxy()) {
            super.start();
            if (SystemUtils.isShowEnvSetting()) {
                PerfActionLog.add("ThreadCreate_YYThread" + sIndex, new Object[0]);
            }
            return;
        }
        if (this.mExecutor == null) {
            this.mExecutor = YYTaskExecutor.createAQueueExcuter(this.shouldUseHighPriority());
        }
        if (RuntimeContext.isInGray()) {
            if (KLogUtils.isInitialized()) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("YYThead", "start,%s", this.name != null ? this.name : "");
                }
            } else if (RuntimeContext.isLocalBuild()) {
                Log.i((String)"YYThead", (String)("start," + (this.name != null ? this.name : "")));
            }
        }
        if (this.target != null) {
            this.mExecutor.execute(this.target, 0L);
        } else {
            this.mExecutor.execute(this, 0L);
            if (SystemUtils.isShowEnvSetting()) {
                PerfActionLog.add("ThreadCreate_YYThread" + sIndex, new Object[0]);
            }
        }
    }

    @Override
    public void run() {
        if (!this.useProxy()) {
            super.run();
            return;
        }
        if (this.target != null) {
            this.target.run();
        }
    }

    private boolean useProxy() {
        return ThreadHookHelper.shouldHookOneThread(this.name);
    }

    private boolean shouldUseHighPriority() {
        return ThreadHookHelper.shouldOneThreadUseHighPriority(this.name);
    }
}

