/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYSingleThreadExecutor
implements ScheduledExecutorService {
    private static final String TAG = "YYSingleThreadExecutor";
    private static ScheduledExecutorService sSingleThreadExecutorBack = null;
    private IQueueTaskExecutor mQueueTaskExecutor = null;
    private boolean shutDown = false;

    public YYSingleThreadExecutor() {
        if (sSingleThreadExecutorBack == null) {
            sSingleThreadExecutorBack = Executors.newSingleThreadScheduledExecutor();
        }
        this.mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    }

    @Override
    public void shutdown() {
        this.shutDown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutDown = true;
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return this.shutDown;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support submit!");
        }
        return null;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support submit!");
        }
        return sSingleThreadExecutorBack.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            RuntimeException exception = new RuntimeException("YYSingleThread not support submit!");
            if (exception.toString().contains("com.yy.transvod.player.core.NetStatManager.updateNetInfo")) {
                return sSingleThreadExecutorBack.submit(task);
            }
            return sSingleThreadExecutorBack.submit(task);
        }
        return sSingleThreadExecutorBack.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support invokeAll!");
        }
        return sSingleThreadExecutorBack.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support invokeAll!");
        }
        return sSingleThreadExecutorBack.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support invokeAny!");
        }
        return sSingleThreadExecutorBack.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        if (YYSingleThreadExecutor.needMonitorSupport()) {
            throw new RuntimeException("YYSingleThread not support invokeAny!");
        }
        return sSingleThreadExecutorBack.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (SystemUtils.isShowEnvSetting() && MLog.isLogLevelBlowInfo()) {
            MLog.info(TAG, "execute task:%s", command);
        }
        this.mQueueTaskExecutor.execute(command, 0L);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (SystemUtils.isShowEnvSetting() && MLog.isLogLevelBlowInfo()) {
            MLog.info(TAG, "schedule task:%s", command);
        }
        return sSingleThreadExecutorBack.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return sSingleThreadExecutorBack.schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return sSingleThreadExecutorBack.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return sSingleThreadExecutorBack.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    private static boolean needMonitorSupport() {
        return RuntimeContext.isInGray();
    }
}

