/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.startup;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActivityStackManager
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityStackManager";
    private boolean currentActivityIsMain;
    private boolean mainIsExist;
    private Activity mainActivity;
    private int resumed;
    private int paused;
    private List<Activity> mActivitys = new ArrayList<Activity>();
    private WeakReference<Activity> sCurrentActivityWeakRef;

    public static ActivityStackManager getInstance() {
        return ActivityStackHolder.INSTANCE;
    }

    private ActivityStackManager() {
    }

    public void init(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public Activity currentActivity() {
        this.checkMainThread();
        if (this.mActivitys.isEmpty()) {
            return null;
        }
        Activity activity = this.mActivitys.get(this.mActivitys.size() - 1);
        return activity;
    }

    public void finishCurrentActivity() {
        this.checkMainThread();
        if (this.mActivitys == null || this.mActivitys.isEmpty()) {
            return;
        }
        Activity activity = this.mActivitys.get(this.mActivitys.size() - 1);
        this.finishActivity(activity);
    }

    public void finishActivity(Activity activity) {
        this.checkMainThread();
        if (this.mActivitys == null || this.mActivitys.isEmpty()) {
            return;
        }
        if (activity != null) {
            this.mActivitys.remove(activity);
            activity.finish();
        }
    }

    public void finishActivity(Class<?> cls) {
        this.checkMainThread();
        if (this.mActivitys.isEmpty()) {
            return;
        }
        Iterator<Activity> iterator = this.mActivitys.iterator();
        while (iterator.hasNext()) {
            Activity activity = iterator.next();
            if (!activity.getClass().equals(cls)) continue;
            iterator.remove();
            activity.finish();
        }
    }

    public Activity findActivity(Class<?> cls) {
        this.checkMainThread();
        Activity targetActivity = null;
        for (Activity activity : this.mActivitys) {
            if (!activity.getClass().equals(cls)) continue;
            targetActivity = activity;
            break;
        }
        return targetActivity;
    }

    public Activity getTopActivity() {
        this.checkMainThread();
        Activity mBaseActivity = null;
        int size = this.mActivitys.size() - 1;
        if (size < 0) {
            return null;
        }
        mBaseActivity = this.mActivitys.get(size);
        return mBaseActivity;
    }

    public String getTopActivityName() {
        this.checkMainThread();
        Activity mBaseActivity = null;
        int size = this.mActivitys.size() - 1;
        if (size < 0) {
            return null;
        }
        mBaseActivity = this.mActivitys.get(size);
        return mBaseActivity.getClass().getName();
    }

    public void finishAllActivity() {
        this.checkMainThread();
        for (Activity activity : this.mActivitys) {
            activity.finish();
        }
        this.mActivitys.clear();
    }

    public void appExit() {
        this.checkMainThread();
        try {
            MLog.debug(TAG, "app exit", new Object[0]);
            this.finishAllActivity();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "app exit error", e, new Object[0]);
        }
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (!this.checkMainExist(activity)) {
            this.mActivitys.add(activity);
            if (this.isMainActivity(activity)) {
                this.mainActivity = activity;
                this.currentActivityIsMain = true;
                this.mainIsExist = true;
            } else {
                this.currentActivityIsMain = false;
            }
        }
        MLog.debug(TAG, "activityList:size:" + this.mActivitys.size(), new Object[0]);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.resumed;
        this.setCurrentActivity(activity);
    }

    public void onActivityPaused(Activity activity) {
        ++this.paused;
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mActivitys.remove(activity);
        MLog.debug(TAG, "activityList:size:" + this.mActivitys.size(), new Object[0]);
    }

    public boolean checkMainExist(Activity activity) {
        return this.mainIsExist && this.isMainActivity(activity);
    }

    public Activity getMainActivity() {
        return this.mainActivity;
    }

    @Nullable
    public Activity getFirstMainActivity() {
        for (Activity activity : this.mActivitys) {
            if (!this.isMainActivity(activity)) continue;
            return activity;
        }
        return null;
    }

    private boolean isMainActivity(Activity activity) {
        return TextUtils.equals((CharSequence)activity.getClass().getName(), (CharSequence)"com.yy.hiyo.MainActivity");
    }

    public void finishActivitysTopofMain() {
        this.checkMainThread();
        if (this.mActivitys == null || this.mActivitys.isEmpty()) {
            return;
        }
        while (!this.currentActivityIsMain) {
            Activity activity = this.mActivitys.get(this.mActivitys.size() - 1);
            if (!TextUtils.equals((CharSequence)activity.getClass().getName(), (CharSequence)"com.yy.hiyo.MainActivity")) {
                this.finishActivity(activity);
                continue;
            }
            this.currentActivityIsMain = true;
        }
    }

    private void checkMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            throw new UnsupportedOperationException("only support main thread!");
        }
    }

    public boolean isAppForeground() {
        return this.resumed > this.paused;
    }

    public Activity getCurrentActivity() {
        Activity currentActivity = null;
        if (this.sCurrentActivityWeakRef != null) {
            currentActivity = (Activity)this.sCurrentActivityWeakRef.get();
        }
        return currentActivity;
    }

    public void setCurrentActivity(Activity activity) {
        this.sCurrentActivityWeakRef = new WeakReference<Activity>(activity);
    }

    private static class ActivityStackHolder {
        private static final ActivityStackManager INSTANCE = new ActivityStackManager();

        private ActivityStackHolder() {
        }
    }
}

