/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.okhttp.listener;

import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.listener.AbstractBizTag;
import com.yy.base.okhttp.listener.BizTag;
import com.yy.base.okhttp.listener.NetStatMetrics;
import com.yy.base.okhttp.listener.NetStatMetricsImpl;
import com.yy.base.okhttp.listener.OkHttpStatMetric;
import com.yy.base.okhttp.request.OkHttpStatDelegate;
import com.yy.base.utils.network.NetworkUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Connection;
import okhttp3.ConnectionPool;
import okhttp3.EventListener;
import okhttp3.Handshake;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.connection.RealConnection;

public class OkHttpStat
extends EventListener {
    private static final String TAG = "OkHttpStat";
    public static final String X_YMICRO_API_SERVICE_NAME = "X-Ymicro-Api-Service-Name";
    public static final String X_YMICRO_API_METHOD_NAME = "X-Ymicro-Api-Method-Name";
    private long mCallStartNanos = System.currentTimeMillis();
    private long mDnsStart = 0L;
    private long mDnsEnd = 0L;
    private long mConnectStart = 0L;
    private long mSecureConnectStart = 0L;
    private long mSecureConnectEnd = 0L;
    private long mConnectEnd = 0L;
    private long mConnectionAcquired = 0L;
    private long mRequestHeadersStart = 0L;
    private long mRequestHeadersEnd = 0L;
    private long mResponseHeadersStart = 0L;
    private long mResponseHeadersEnd = 0L;
    private long mResponseBodyStart = 0L;
    private long mRequestEnd = 0L;
    private long mTotalTime = 0L;
    private String mRemoteIp;
    private String mSource;
    private boolean mReuse = true;
    private String mContentEncoding;
    private final Call mCall;
    private final String mUrl;
    @Nullable
    private WeakReference<RealConnection> mRealConnectionRef;
    private String mTag;
    private long mByteCount = -1L;
    private int mCode = -999;
    private int mRedirectsTimes = 0;
    private OkHttpStatMetric mOkHttpStatMetric;
    private AbstractBizTag mAbstractBizTag;
    private final boolean mCloseWhenTimeout;
    private String mSname = "";
    private String mYmicMethod = "";

    public OkHttpStat(Call call, boolean closeWhenTimeout) {
        this.mCall = call;
        this.mUrl = call.request().url().toString();
        this.mCloseWhenTimeout = closeWhenTimeout;
        this.mAbstractBizTag = (AbstractBizTag)call.request().tag(BizTag.class);
        MLog.debug(TAG, "bizTag is " + this.mAbstractBizTag, new Object[0]);
        if (this.mAbstractBizTag != null) {
            this.mTag = this.mAbstractBizTag.logTag();
        }
    }

    private static void handlerStat(NetStatMetrics netStatMetrics) {
        if (OkHttpStatDelegate.isStatSwitchOn()) {
            OkHttpStatDelegate.onStat(netStatMetrics);
        }
    }

    private HashMap<String, Object> proParams() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("dnsstart", this.mDnsStart);
        hashMap.put("dnsend", this.mDnsEnd);
        hashMap.put("connstart", this.mConnectStart);
        hashMap.put("secureconnstart", this.mSecureConnectStart);
        hashMap.put("secureconnend", this.mSecureConnectEnd);
        hashMap.put("connend", this.mConnectEnd);
        hashMap.put("connacquired", this.mConnectionAcquired);
        hashMap.put("reqheaderstart", this.mRequestHeadersStart);
        hashMap.put("reqheaderend", this.mRequestHeadersEnd);
        hashMap.put("respheaderstart", this.mResponseHeadersStart);
        hashMap.put("respheaderend", this.mResponseHeadersEnd);
        hashMap.put("respbodystart", this.mResponseBodyStart);
        hashMap.put("reqend", this.mRequestEnd);
        hashMap.put("remoteip", this.mRemoteIp);
        hashMap.put("protocol", this.mSource);
        hashMap.put("reuse", this.mReuse);
        hashMap.put("redirects", this.mRedirectsTimes);
        hashMap.put("receivedbytecount", this.mByteCount);
        return hashMap;
    }

    private boolean codeInit() {
        return this.mCode != -999;
    }

    private void recordEventLog(String name, Call call) {
        if (RuntimeContext.sIsDebuggable) {
            FeatureLog.d(this.mTag, "okhttp " + name + "  " + call.request().url().url().toString(), new Object[0]);
        }
    }

    private long time() {
        return System.currentTimeMillis() - this.mCallStartNanos;
    }

    public void callStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.recordEventLog("callStart 0", call);
        super.callStart(call);
    }

    public void dnsStart(Call call, String domainName) {
        if (call != this.mCall) {
            return;
        }
        this.mDnsStart = this.time();
        this.recordEventLog("mDnsStart " + this.mDnsStart, call);
        super.dnsStart(call, domainName);
    }

    public void dnsEnd(Call call, String domainName, List<InetAddress> inetAddressList) {
        if (call != this.mCall) {
            return;
        }
        this.mDnsEnd = this.time();
        this.recordEventLog("mDnsEnd " + this.mDnsEnd, call);
        super.dnsEnd(call, domainName, inetAddressList);
    }

    public void connectStart(Call call, InetSocketAddress inetSocketAddress, Proxy proxy) {
        if (call != this.mCall) {
            return;
        }
        this.mConnectStart = this.time();
        this.mReuse = false;
        this.mRemoteIp = inetSocketAddress.getAddress().getHostAddress();
        this.recordEventLog("mConnectStart " + this.mConnectStart, call);
        super.connectStart(call, inetSocketAddress, proxy);
    }

    public void secureConnectStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.mSecureConnectStart = this.time();
        this.mReuse = false;
        this.recordEventLog("mSecureConnectStart " + this.mSecureConnectStart, call);
        super.secureConnectStart(call);
    }

    public void secureConnectEnd(Call call, @Nullable Handshake handshake) {
        if (call != this.mCall) {
            return;
        }
        this.mSecureConnectEnd = this.time();
        this.mReuse = false;
        this.recordEventLog("mSecureConnectEnd " + this.mSecureConnectEnd, call);
        super.secureConnectEnd(call, handshake);
    }

    public void connectEnd(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol) {
        if (call != this.mCall) {
            return;
        }
        this.mConnectEnd = this.time();
        if (protocol != null) {
            this.mSource = protocol.toString();
        }
        this.mReuse = false;
        this.mRemoteIp = inetSocketAddress.getAddress().getHostAddress();
        this.recordEventLog("mConnectEnd time = " + this.mConnectEnd, call);
        super.connectEnd(call, inetSocketAddress, proxy, protocol);
    }

    public void connectFailed(Call call, InetSocketAddress inetSocketAddress, Proxy proxy, @Nullable Protocol protocol, IOException ioe) {
        if (call != this.mCall) {
            return;
        }
        if (protocol != null) {
            this.mSource = protocol.toString();
        }
        this.mRemoteIp = inetSocketAddress.getAddress().getHostAddress();
        this.recordEventLog("connectFailed " + this.time(), call);
        super.connectFailed(call, inetSocketAddress, proxy, protocol, ioe);
    }

    public void connectionAcquired(Call call, Connection connection) {
        if (call != this.mCall) {
            return;
        }
        this.mConnectionAcquired = this.time();
        this.mSource = connection.protocol().toString();
        this.mRemoteIp = connection.route().socketAddress().getAddress().getHostAddress();
        this.recordEventLog("mConnectionAcquired " + this.mConnectionAcquired + "  ip = " + this.mRemoteIp + " mReuse = " + this.mReuse, call);
        this.mSname = call.request().header(X_YMICRO_API_SERVICE_NAME);
        this.mYmicMethod = call.request().header(X_YMICRO_API_METHOD_NAME);
        if (connection instanceof RealConnection) {
            this.mRealConnectionRef = new WeakReference<RealConnection>((RealConnection)connection);
        }
        super.connectionAcquired(call, connection);
    }

    public void connectionReleased(Call call, Connection connection) {
        if (call != this.mCall) {
            return;
        }
        this.mSource = connection.protocol().toString();
        this.mRemoteIp = connection.route().socketAddress().getAddress().getHostAddress();
        this.recordEventLog("connectionReleased " + this.time(), call);
        super.connectionReleased(call, connection);
    }

    public void requestHeadersStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.mRequestHeadersStart = this.time();
        this.recordEventLog("mRequestHeadersStart " + this.mRequestHeadersStart, call);
        super.requestHeadersStart(call);
    }

    public void requestHeadersEnd(Call call, Request request) {
        if (call != this.mCall) {
            return;
        }
        this.mRequestHeadersEnd = this.time();
        this.recordEventLog("mRequestHeadersEnd " + this.mRequestHeadersEnd, call);
        super.requestHeadersEnd(call, request);
    }

    public void requestBodyStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.recordEventLog("requestBodyStart " + this.time(), call);
        super.requestBodyStart(call);
    }

    public void requestBodyEnd(Call call, long byteCount) {
        if (call != this.mCall) {
            return;
        }
        this.recordEventLog("requestBodyEnd " + this.time(), call);
        super.requestBodyEnd(call, byteCount);
    }

    public void responseHeadersStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.mResponseHeadersStart = this.time();
        this.recordEventLog("mResponseHeadersStart " + this.time(), call);
        super.responseHeadersStart(call);
    }

    public boolean isSuccessful() {
        return this.mCode >= 200 && this.mCode < 300;
    }

    public void responseHeadersEnd(Call call, Response response) {
        if (call != this.mCall) {
            return;
        }
        this.mResponseHeadersEnd = this.time();
        if (response != null && response.body() != null) {
            this.mByteCount = response.body().contentLength();
        }
        if (response != null) {
            this.mSource = response.protocol().toString();
            this.mCode = response.code();
            this.mContentEncoding = response.header("Content-Encoding");
            if (this.isRedirects(call.request().method(), this.mCode)) {
                ++this.mRedirectsTimes;
            }
        }
        this.mOkHttpStatMetric = new OkHttpStatMetric();
        this.recordEventLog("mResponseHeadersEnd " + this.time() + " code = " + this.mCode + " mByteCount = " + this.mByteCount + " mContentEncoding = " + this.mContentEncoding, call);
        super.responseHeadersEnd(call, response);
    }

    public void responseBodyStart(Call call) {
        if (call != this.mCall) {
            return;
        }
        this.mResponseBodyStart = this.time();
        this.recordEventLog("mResponseBodyStart time = " + this.mResponseBodyStart, call);
        super.responseBodyStart(call);
    }

    public void responseBodyEnd(Call call, long byteCount) {
        if (call != this.mCall) {
            return;
        }
        this.mTotalTime = this.mRequestEnd = this.time();
        this.mByteCount = byteCount;
        this.mOkHttpStatMetric = new OkHttpStatMetric();
        this.recordEventLog("responseBodyEnd " + this.time() + " mByteCount = " + this.mByteCount + "  call = " + call + " mCall = " + this.mCall, call);
        super.responseBodyEnd(call, byteCount);
    }

    public void callEnd(Call call) {
        if (call != this.mCall) {
            return;
        }
        super.callEnd(call);
        this.recordEventLog("callEnd " + this.mRequestEnd, call);
        if (OkHttpStatDelegate.isStatSwitchOn() && !this.isRedirects(call.request().method(), this.mCode) && this.mOkHttpStatMetric != null && this.codeInit()) {
            NetStatMetricsImpl netStatMetrics = new NetStatMetricsImpl(this.proParams(), this.mAbstractBizTag, this.mCode, call.isCanceled() ? 2 : 0, null, call.request().method(), this.mUrl, this.mContentEncoding, this.mSname, this.mYmicMethod);
            OkHttpStat.handlerStat(netStatMetrics);
        }
        this.mOkHttpStatMetric = null;
    }

    public void callFailed(Call call, IOException ioe) {
        if (call != this.mCall) {
            return;
        }
        this.mTotalTime = this.time();
        int errCode = NetworkUtils.getErrorCodeByExc(ioe);
        NetStatMetricsImpl netStatMetrics = new NetStatMetricsImpl(this.proParams(), this.mAbstractBizTag, errCode, call.isCanceled() ? 2 : 1, ioe, call.request().method(), this.mUrl, this.mContentEncoding, this.mSname, this.mYmicMethod);
        OkHttpStat.handlerStat(netStatMetrics);
        this.logStat(netStatMetrics, "okhttp");
        this.recordEventLog("callFailed " + this.mTotalTime + "   e = " + ioe + " isCancel = " + call.isCanceled() + " call = " + call + " mCall = " + this.mCall, call);
        this.mOkHttpStatMetric = null;
        this.handleCallFailed(call, ioe);
        super.callFailed(call, ioe);
    }

    private boolean isRedirects(String method, int httpCode) {
        if (httpCode == 308 || httpCode == 307) {
            return "GET".equals(method) || "HEAD".equals(method);
        }
        return httpCode == 300 || httpCode == 301 || httpCode == 303;
    }

    private void logStat(NetStatMetrics netStatMetrics, String netType) {
        boolean failover;
        BizTag bizTag = null;
        AbstractBizTag abstractBizTag = netStatMetrics.getBizTag();
        if (abstractBizTag instanceof BizTag) {
            bizTag = (BizTag)abstractBizTag;
        }
        int businessType = bizTag != null ? bizTag.businessType : -1;
        boolean isFile = bizTag != null && bizTag.isFile;
        boolean bl = failover = bizTag != null && bizTag.failOver;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i("FTQuicNet", "\nnetType = " + netType + "\nbusinessType = " + businessType + "\nurl = " + netStatMetrics.getUrl() + "\ncode = " + netStatMetrics.getCode() + "\nrequestMethod = " + netStatMetrics.getMethod() + "\nbodyLength = " + netStatMetrics.getReceivedByteCount() + "\nsource = " + netStatMetrics.getProtocol() + "\nexpendTime = " + netStatMetrics.getTotalTimeMs() + "\nisRetry = " + netStatMetrics.isRetry() + "\nisFile = " + isFile + "\nremoteIp = " + netStatMetrics.getRemoteIp() + "\nreuse = " + netStatMetrics.getSocketReused() + "\nfailover = " + failover + "\ncdnname = \ncontentEncoding = " + netStatMetrics.getContentEncoding() + "\nfinishedReason = " + (netStatMetrics.getFinishedReason() == 0 ? "sucess" : (netStatMetrics.getFinishedReason() == 2 ? "cancel" : "fail")) + "\n" + (netStatMetrics.getException() != null ? "errMsg = " + netStatMetrics.getException().toString() : ""), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCallFailed(Call call, IOException ex) {
        RealConnection conn;
        if (ex == null || !this.mCloseWhenTimeout || call.isCanceled()) {
            return;
        }
        MLog.debug(TAG, "handleCallFailed: " + ex.getMessage(), new Object[0]);
        RealConnection realConnection = conn = this.mRealConnectionRef == null ? null : (RealConnection)this.mRealConnectionRef.get();
        if (conn == null) {
            return;
        }
        if (ex instanceof SocketTimeoutException) {
            ConnectionPool pool = this.getConnectionPool(conn);
            if (pool == null) {
                conn.noNewStreams = true;
                MLog.error((Object)TAG, "pool is null sockettimeout connection onNewStreams set true", new Object[0]);
            } else {
                ConnectionPool connectionPool = pool;
                synchronized (connectionPool) {
                    conn.noNewStreams = true;
                    MLog.error((Object)TAG, "sockettimeout connection onNewStreams set true", new Object[0]);
                }
            }
        }
    }

    @Nullable
    private ConnectionPool getConnectionPool(RealConnection connection) {
        try {
            Field field = connection.getClass().getDeclaredField("connectionPool");
            field.setAccessible(true);
            return (ConnectionPool)field.get(connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

