/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Looper;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.widget.AppCompatTextView;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableUtil;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.Monitor;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ToastUtils;

public class YYTextView
extends AppCompatTextView
implements IRecycleView {
    private boolean mIsAttachToWindow;
    private boolean mSettingDrawable;
    private float[] radius;
    private Drawable radiusDrawable;
    private boolean isNoWrapSpace = false;
    private TextUtils.TruncateAt mRealEllipsize;

    public YYTextView(Context context) {
        super(context);
        this.adjustEllipsize();
        this.init(null);
        this.mRealEllipsize = this.getEllipsize();
    }

    public YYTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
        this.adjustEllipsize();
        this.init(attrs);
        this.mRealEllipsize = this.getEllipsize();
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        super.setEllipsize(where);
        this.mRealEllipsize = where;
    }

    public YYTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
        this.adjustEllipsize();
        this.init(attrs);
        this.mRealEllipsize = this.getEllipsize();
    }

    private void init(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        this.logCreate();
        TypedArray typedArray = this.getResources().obtainAttributes(attrs, R.styleable.YYTextView);
        this.isNoWrapSpace = typedArray.getBoolean(R.styleable.YYTextView_no_wrap_space, false);
        if (this.getBackground() instanceof ColorDrawable && typedArray.hasValue(R.styleable.YYTextView_radius)) {
            float radius = typedArray.getDimension(R.styleable.YYTextView_radius, -1.0f);
            float topLeft = typedArray.getDimension(R.styleable.YYTextView_top_left, radius);
            float topRight = typedArray.getDimension(R.styleable.YYTextView_top_right, radius);
            float bottomLeft = typedArray.getDimension(R.styleable.YYTextView_bottom_left, radius);
            float bottomRight = typedArray.getDimension(R.styleable.YYTextView_bottom_right, radius);
            this.setRadius(topLeft, topRight, bottomRight, bottomLeft);
        }
        typedArray.recycle();
    }

    public void setRadius(float radius) {
        this.setRadius(radius, radius, radius, radius);
    }

    public void setRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.radius = this.isInEditMode() || LanguageUtils.isLtr() ? new float[]{topLeft, topLeft, topRight, topRight, bottomRight, bottomRight, bottomLeft, bottomLeft} : new float[]{topRight, topRight, topLeft, topLeft, bottomLeft, bottomLeft, bottomRight, bottomRight};
        this.updateRadiusBackground(this.radius);
    }

    private void updateRadiusBackground(float[] radius) {
        if (this.getBackground() instanceof ColorDrawable) {
            int color = ((ColorDrawable)this.getBackground()).getColor();
            this.radiusDrawable = DrawableUtil.getRoundDrawable(radius, color);
            this.setBackground(this.radiusDrawable);
        } else if (this.getBackground() instanceof GradientDrawable) {
            GradientDrawable gradientDrawable = (GradientDrawable)this.getBackground();
            gradientDrawable.setCornerRadii(radius);
            this.radiusDrawable = gradientDrawable;
            this.setBackground((Drawable)gradientDrawable);
        }
    }

    public void setBackground(Drawable background) {
        super.setBackground(background);
        if (this.radius != null && background != this.radiusDrawable) {
            this.updateRadiusBackground(this.radius);
        }
    }

    private void adjustEllipsize() {
        if (this.getMaxLines() == 1 && Build.VERSION.SDK_INT <= 20) {
            this.setEllipsize(null);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isNoWrapSpace && View.MeasureSpec.getMode((int)widthMeasureSpec) == 0) {
            int width = (int)Math.ceil(this.getMaxLineWidth(this.getLayout()));
            int height = this.getMeasuredHeight();
            this.setMeasuredDimension(Math.min(width + this.getPaddingStart() + this.getPaddingEnd(), this.getMeasuredWidth()), height);
        }
    }

    private float getMaxLineWidth(Layout layout) {
        float maximumWidth = 0.0f;
        int lines = layout.getLineCount();
        for (int i = 0; i < lines; ++i) {
            maximumWidth = Math.max(layout.getLineWidth(i), maximumWidth);
        }
        return maximumWidth;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        DrawableRecycler.onVisibilityChanged(this, visibility);
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        DrawableRecycler.onAttachedToWindow(this);
        super.setEllipsize(this.mRealEllipsize);
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        DrawableRecycler.onDetachedFromWindow(this);
        super.setEllipsize(null);
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mSettingDrawable = true;
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, background);
        super.setBackgroundDrawable(background);
        this.mSettingDrawable = false;
    }

    public void setBackgroundResource(int resid) {
        this.mSettingDrawable = true;
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, resid);
        super.setBackgroundResource(resid);
        this.mSettingDrawable = false;
    }

    public boolean onPreDraw() {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                return super.onPreDraw();
            }
            catch (IndexOutOfBoundsException e) {
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast(this.getContext(), "YYTextView onPreDraw IndexOutOfBoundsException", 1);
                }
                MLog.error("YYTextView", e);
                return true;
            }
        }
        return super.onPreDraw();
    }

    protected void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                super.onDraw(canvas);
            }
            catch (IndexOutOfBoundsException e) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException(e);
                }
                MLog.error((Object)"YYTextView", "YYTextView ondraw, exception:", e.toString());
            }
        } else if (Build.VERSION.SDK_INT <= 20) {
            try {
                super.onDraw(canvas);
            }
            catch (StackOverflowError e) {
                if ("asus".equalsIgnoreCase(Build.BRAND)) {
                    return;
                }
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException(e);
                }
                Monitor.IExceptionCallBack iExceptionCallBack = Monitor.getExceptionCallBack();
                if (iExceptionCallBack != null) {
                    iExceptionCallBack.onYYTextViewDrawException(e);
                }
                MLog.error((Object)"YYTextView", "YYTextView ondraw, exception:", e, new Object[0]);
            }
        } else {
            super.onDraw(canvas);
        }
    }

    public Drawable getBackground() {
        if (!this.mSettingDrawable) {
            DrawableRecycler.onGetBackground(this);
        }
        Drawable drawable = super.getBackground();
        if (!this.mSettingDrawable) {
            DrawableRecycler.onGetBackgroundEnd(this);
        }
        return drawable;
    }

    @Override
    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    @Override
    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    @Override
    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post(new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error("YYTextView", e);
            return null;
        }
    }

    private void checkViewLevel() {
        int viewLevel = this.getLevelInWindow(1, (View)this);
        if (viewLevel > 15) {
            String name;
            try {
                name = this.getResources().getResourceEntryName(this.getId());
            }
            catch (Resources.NotFoundException e) {
                name = "unkown";
            }
            if (viewLevel > 20) {
                MLog.error((Object)"ViewLevel", "fix bug level:%d textView id:%d name:%s", viewLevel, this.getId(), name);
            } else {
                MLog.error((Object)"ViewLevel", "check level:%d textView id:%d name:%s", viewLevel, this.getId(), name);
            }
        } else if (MLog.isLogLevelBlowInfo()) {
            MLog.info("ViewLevel", "level:%d textView id:%d", viewLevel, this.getId());
        }
    }

    private int getLevelInWindow(int currentLevel, View parent) {
        if (parent == null || parent.getParent() == null || !(parent.getParent() instanceof View)) {
            return currentLevel;
        }
        return this.getLevelInWindow(++currentLevel, (View)parent.getParent());
    }

    public void setNoWrapSpace(boolean noWrapSpace) {
        this.isNoWrapSpace = noWrapSpace;
    }

    public boolean isNoWrapSpace() {
        return this.isNoWrapSpace;
    }
}

