/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.viewpager.widget.ViewPager;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYScrollView;
import com.yy.base.memoryrecycle.views.YYTextView;

public class RecycleUtils {
    private static void onWindowShownOrHidden(ViewGroup viewGroup, boolean shown) {
        if (viewGroup == null) {
            return;
        }
        int childSize = viewGroup.getChildCount();
        if (childSize > 0) {
            View child = null;
            for (int i = 0; i < childSize; ++i) {
                child = viewGroup.getChildAt(i);
                if (child instanceof IRecycleView) {
                    if (shown) {
                        ((IRecycleView)child).onWindowRealVisible();
                        continue;
                    }
                    ((IRecycleView)child).onWindowInvisble();
                    continue;
                }
                if (child instanceof ViewGroup) {
                    if (shown) {
                        RecycleUtils.onWindowShown((ViewGroup)child);
                    } else {
                        RecycleUtils.onWindowHidden((ViewGroup)child);
                    }
                    if (!RuntimeContext.sIsDebuggable || !(child instanceof FrameLayout) && !(child instanceof RelativeLayout) && !(child instanceof LinearLayout) && !(child instanceof ConstraintLayout) && !(child instanceof YYScrollView) && !(child instanceof ViewPager) && !(child instanceof WebView)) continue;
                    MLog.error((Object)"RecycleUtils", "why this view not use his YY view:%s!", child);
                    continue;
                }
                if (!RuntimeContext.sIsDebuggable || !(child instanceof ImageView) && !(child instanceof Button) && !(child instanceof YYTextView) && !(child instanceof YYEditText) || child instanceof SVGAImageView) continue;
                MLog.error((Object)"RecycleUtils", "why this view not use his YY view:%s!", child);
            }
        }
    }

    public static void recycleAllImageView(ViewGroup viewGroup) {
        if (viewGroup == null) {
            return;
        }
        if (viewGroup instanceof IRecycleView && !((IRecycleView)viewGroup).canRecycleRes()) {
            return;
        }
        int childSize = viewGroup.getChildCount();
        if (childSize > 0) {
            View child = null;
            for (int i = 0; i < childSize; ++i) {
                child = viewGroup.getChildAt(i);
                if (child instanceof ViewGroup) {
                    RecycleUtils.recycleAllImageView((ViewGroup)child);
                    continue;
                }
                if (!(child instanceof IRecycleView)) continue;
                ((IRecycleView)child).recycleRes();
            }
        }
    }

    public static void onWindowShown(ViewGroup viewGroup) {
        RecycleUtils.onWindowShownOrHidden(viewGroup, true);
    }

    public static void onWindowHidden(ViewGroup viewGroup) {
        RecycleUtils.onWindowShownOrHidden(viewGroup, false);
    }
}

