/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.customcache;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;

public class YYLruBitmapPool
extends LruBitmapPool {
    private static boolean sDebug = ImageLoader.sDebugSwitch && RuntimeContext.sIsDebuggable;

    public YYLruBitmapPool(int maxSize) {
        super(maxSize);
    }

    @Override
    public synchronized void put(Bitmap bitmap) {
        if (bitmap != null && (double)bitmap.getByteCount() > 1572864.0) {
            if (sDebug && !MLog.isLogLevelAboveDebug()) {
                MLog.debug("YYLruBitmapPool", "not add bitmap exLarge:" + bitmap.getByteCount(), new Object[0]);
            }
            return;
        }
        if (bitmap != null && sDebug && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("YYLruBitmapPool", "add bitmap:" + bitmap.getWidth() + " " + bitmap.getHeight(), new Object[0]);
        }
        if (bitmap != null) {
            super.put(bitmap);
        }
    }

    @Override
    @TargetApi(value=12)
    public synchronized Bitmap getDirty(int width, int height, Bitmap.Config config) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        Bitmap result = super.getDirty(width, height, config);
        if (result != null && sDebug && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("YYLruBitmapPool", "get bitmap:" + result.getWidth() + " " + result.getHeight(), new Object[0]);
        }
        return result;
    }

    @Override
    public void trimMemory(int level) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info("YYLruBitmapPool", "trimMemory, level=" + level, new Object[0]);
        }
        if (level >= 40) {
            super.trimMemory(level);
        } else {
            super.trimMemory(40);
        }
    }
}

