/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.customcache;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import androidx.annotation.NonNull;
import com.yy.base.cache.lru.HotEndLruCache;
import com.yy.base.cache.lru.LruNode;
import com.yy.base.logger.MLog;

public class ImageCache {
    private HotEndLruCache<String, ImageCacheValue> mMemoryCache;
    private int memCacheSize;

    public ImageCache(Context context, AjaxImageCacheOption imageCacheOption) {
        this.memCacheSize = imageCacheOption.memCacheSize;
        this.init();
    }

    public ImageCache(Context context) {
        this(context, new AjaxImageCacheOption());
    }

    private static int getBitmapSize(BitmapDrawable value) {
        Bitmap bitmap = value.getBitmap();
        if (bitmap == null || bitmap.isRecycled()) {
            return 0;
        }
        if (Build.VERSION.SDK_INT > 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    private void init() {
        this.mMemoryCache = new HotEndLruCache<String, ImageCacheValue>(this.memCacheSize, 0.5f){

            @Override
            protected int getSize(ImageCacheValue value) {
                return value.getSize();
            }

            @Override
            protected void onNodeRemoved(boolean replaced, boolean manually, @NonNull LruNode<String, ImageCacheValue> node) {
                MLog.debug("ImageCache", "onNodeRemoved replaced: %b, key: %s", replaced, node.key);
            }
        };
    }

    public void addBitmapToCache(String data, BitmapDrawable value) {
        if (data == null || value == null) {
            return;
        }
        try {
            ImageCacheValue cacheValue = new ImageCacheValue(value);
            if (cacheValue.getSize() <= 0) {
                MLog.debug("ImageCache", "addBitmapToCache ignore, cacheValue size is less than zero", new Object[0]);
                return;
            }
            if (this.mMemoryCache != null) {
                this.mMemoryCache.put(data, cacheValue);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)"ImageCache", "addBitmapToCache error", ex, new Object[0]);
        }
    }

    public void removeBitmapFromCache(String data) {
        try {
            if (this.mMemoryCache != null) {
                this.mMemoryCache.remove(data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BitmapDrawable getBitmapFromMemCache(String data) {
        BitmapDrawable bitmapDrawable;
        ImageCacheValue cacheValue = null;
        if (this.mMemoryCache != null) {
            cacheValue = this.mMemoryCache.get(data);
        }
        if (cacheValue != null && (bitmapDrawable = cacheValue.getData()) != null) {
            if (bitmapDrawable.getBitmap() != null && !bitmapDrawable.getBitmap().isRecycled()) {
                return bitmapDrawable;
            }
            this.removeBitmapFromCache(data);
        }
        return null;
    }

    public void cleanMemCache() {
        try {
            MLog.debug("ImageCache", "clear", new Object[0]);
            this.mMemoryCache.clear();
        }
        catch (Exception e) {
            MLog.error((Object)"ImageCache", "cleanMemCache error:" + this.mMemoryCache.size(), new Object[0]);
        }
    }

    public void cleanHalfMemCache() {
        block8: {
            try {
                MLog.debug("ImageCache", "cleanHalfMemCache", new Object[0]);
                if (this.mMemoryCache.size() > 12288) {
                    this.mMemoryCache.trimTo(this.mMemoryCache.size() / 2);
                } else {
                    this.mMemoryCache.trimTo(this.mMemoryCache.size() / 3);
                }
            }
            catch (IllegalStateException e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("ImageCache", "error:" + (this.mMemoryCache != null ? Integer.valueOf(this.mMemoryCache.size()) : "0"), new Object[0]);
                }
            }
            catch (IllegalAccessError e) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("ImageCache", "error:" + (this.mMemoryCache != null ? Integer.valueOf(this.mMemoryCache.size()) : "0"), new Object[0]);
                }
            }
            catch (NoSuchMethodError e) {
                if (!MLog.isLogLevelBlowInfo()) break block8;
                MLog.info("ImageCache", "error:" + (this.mMemoryCache != null ? Integer.valueOf(this.mMemoryCache.size()) : "0"), new Object[0]);
            }
        }
    }

    public static class ImageCacheValue {
        private int mSize;
        private BitmapDrawable mData;

        ImageCacheValue(BitmapDrawable data) {
            this.mData = data;
            this.mSize = ImageCache.getBitmapSize(data);
            if (this.mSize > 0) {
                this.mSize = Math.max(1, (int)Math.ceil((float)this.mSize / 1024.0f));
            }
        }

        public int getSize() {
            return this.mSize;
        }

        public BitmapDrawable getData() {
            return this.mData;
        }
    }

    public static class AjaxImageCacheOption {
        public static final int DEFAULT_MEM_CACHE_SIZE = 10240;
        public static final int DEFAULT_MAX_MEM_CACHE_SIZE = Build.VERSION.SDK_INT > 20 ? 15360 : 10240;
        private int memCacheSize = 10240;
        private int maxMemCacheSize = DEFAULT_MAX_MEM_CACHE_SIZE;

        public AjaxImageCacheOption() {
            this.setMemCacheSizePercent(0.1f);
        }

        public void setMaxMemorySize(int size) {
            this.maxMemCacheSize = size;
        }

        public void setMemCacheSizePercent(float percent) {
            if (percent < 0.05f || percent > 0.8f) {
                throw new IllegalArgumentException("setMemCacheSizePercent - percent must be between 0.05 and 0.8 (inclusive)");
            }
            this.memCacheSize = Math.min(Math.round(percent * (float)Runtime.getRuntime().maxMemory() / 1024.0f), this.maxMemCacheSize);
        }
    }
}

