/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.resource.bitmap.BitmapTransitionOptions;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.bumptech.glide.request.target.DrawableImageViewTarget;
import com.bumptech.glide.request.target.ImageViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.bumptech.glide.signature.EmptySignature;
import com.bumptech.glide.util.Util;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.DataCacheKey;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageLoaderBackUrl;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.httptohttpsstrategyimpl.HttpsSchemeTransformStrategy;
import com.yy.base.imageloader.strategy.StrategySelector;
import com.yy.base.imageloader.strategy.StrategyStatus;
import com.yy.base.imageloader.transform.GlideCircleTransform;
import com.yy.base.imageloader.transform.GlideRoundTransform;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.network.NetworkUtils;

public class ImageLoaderType {
    private static BitmapTransitionOptions sCrossFade = BitmapTransitionOptions.withCrossFade(600);

    public static <T> RequestBuilder<T> buildByScaleType(RequestBuilder<T> requestOptions, RecycleImageView imageView) {
        if (!requestOptions.isTransformationSet() && requestOptions.isTransformationAllowed() && imageView.getScaleType() != null) {
            switch (imageView.getScaleType()) {
                case CENTER_CROP: {
                    requestOptions = (RequestBuilder)requestOptions.clone().optionalCenterCrop();
                    break;
                }
                case CENTER_INSIDE: {
                    requestOptions = (RequestBuilder)requestOptions.clone().optionalCenterInside();
                    break;
                }
                case FIT_CENTER: 
                case FIT_START: 
                case FIT_END: {
                    requestOptions = (RequestBuilder)requestOptions.clone().optionalFitCenter();
                    break;
                }
                case FIT_XY: {
                    requestOptions = (RequestBuilder)requestOptions.clone().optionalCenterInside();
                    break;
                }
            }
        }
        return requestOptions;
    }

    public static void loadWebPAnim(Context context, final String url, RecycleImageView imageView, final ImageLoader.ImageData imageData, boolean useMemCache, final int index, final ImageLoader.IMonitor monitor) {
        RequestBuilder<Drawable> requestBuilder = (RequestBuilder<Drawable>)((BaseRequestOptions)Glide.with(context).load(url)).diskCacheStrategy(imageData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC);
        if (imageData.thumbnail != null) {
            requestBuilder = requestBuilder.thumbnail((RequestBuilder<Drawable>)Glide.with(context).load(imageData.thumbnail));
        }
        if (imageData.placeholderDrawable != null) {
            requestBuilder = (RequestBuilder<Drawable>)requestBuilder.placeholder(imageData.placeholderDrawable);
        }
        if (imageData.errorDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorDrawable);
        }
        if (imageData.width != -1 && imageData.height != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.override(imageData.width, imageData.height);
        }
        if (imageData.sizeMultiplier > 0.0f && imageData.sizeMultiplier < 1.0f) {
            requestBuilder = (RequestBuilder)requestBuilder.sizeMultiplier(imageData.sizeMultiplier);
        }
        if (imageData.transformations == null || imageData.transformations.length <= 0) {
            if (imageData.circle) {
                requestBuilder = (RequestBuilder)requestBuilder.optionalTransform(new GlideCircleTransform());
            } else if (imageData.round != -1) {
                requestBuilder = (RequestBuilder)requestBuilder.optionalTransform(new GlideRoundTransform(imageData.round));
            }
        }
        if (imageData.skipMemCache || !useMemCache) {
            imageData.skipMemCache = true;
            requestBuilder = (RequestBuilder)requestBuilder.skipMemoryCache(true);
        }
        if (monitor != null) {
            monitor.onStart(index, true, url, imageData.width, imageData.height);
        }
        if (imageData.monitor != null) {
            imageData.monitor.onStart(index, true, imageData.originUrl, imageData.width, imageData.height);
        }
        requestBuilder = requestBuilder.listener(new RequestListener<Drawable>(){

            @Override
            public boolean onLoadFailed(final @Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                if (monitor != null) {
                    monitor.onError(index, url, e);
                }
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        imageData.loadSuccess = false;
                        if (imageData.listener != null) {
                            imageData.listener.onLoadFailed(e);
                        }
                        if (imageData.monitor != null) {
                            imageData.monitor.onError(index, imageData.originUrl, e);
                        }
                    }
                });
                MLog.error((Object)"ImageLoader", "loadWebPAnim error:" + url, e, new Object[0]);
                return false;
            }

            @Override
            public boolean onResourceReady(final Drawable resource, Object model, Target<Drawable> target, final DataSource dataSource, final boolean isFirstResource, final PerformanceData performanceData) {
                int size = 0;
                if (monitor != null || imageData.monitor != null) {
                    size = ImageUtil.checkBitmapSize(ImageLoader.getBitmapFromCustomDrawable(resource), url);
                }
                if (monitor != null) {
                    monitor.onSuccess(index, url, size, !isFirstResource, dataSource, performanceData);
                }
                final int fSize = size;
                YYTaskExecutor.postToMainThread(new Runnable(){

                    @Override
                    public void run() {
                        imageData.loadSuccess = true;
                        if (imageData.listener != null) {
                            imageData.listener.onResourceReady(resource, !isFirstResource, dataSource);
                        }
                        if (imageData.monitor != null) {
                            imageData.monitor.onSuccess(index, imageData.originUrl, fSize, !isFirstResource, dataSource, performanceData);
                        }
                    }
                });
                return false;
            }
        });
        requestBuilder = ImageLoaderType.buildByScaleType(requestBuilder, imageView);
        ((RequestBuilder)requestBuilder.format(imageData.decodeFormat)).into(new DrawableImageViewTarget((ImageView)imageView){

            @Override
            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                imageData.loadSuccess = true;
                super.onResourceReady(resource, transition);
            }
        });
    }

    public static void loadGifAnim(Context context, String url, RecycleImageView imageView, final ImageLoader.ImageData imageData, boolean useMemCache, float sizeMultiplier, final int index, final ImageLoader.IMonitor monitor) {
        if (StringUtils.isNotEmpty(url) && url.contains("/format,webp") && url.startsWith("http")) {
            MLog.debug("GifHandler", "gif use loadWebPAnim url " + url + "  w " + imageData.width + " h " + imageData.height, new Object[0]);
            ImageLoaderType.loadWebPAnim(context, url, imageView, imageData, useMemCache, index, monitor);
            return;
        }
        final String gifUrl = url != null && url.contains("/format,webp") ? url.replace("/format,webp", "") : url;
        RequestBuilder<Object> requestBuilder = (RequestBuilder)((BaseRequestOptions)Glide.with(context).asGif().load(gifUrl)).diskCacheStrategy(imageData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC);
        if (imageData.placeholderDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.placeholder(imageData.placeholderDrawable);
        } else if (imageData.placeholderId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.placeholder(imageData.placeholderId);
        }
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("GifHandler", "load gif:" + imageView.toString() + " url:" + (gifUrl == null ? "" : gifUrl) + "  w " + imageData.width + " h " + imageData.height, new Object[0]);
        }
        if (imageData.errorDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorDrawable);
        } else if (imageData.errorId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorId);
        }
        if (imageData.transformations != null && imageData.transformations.length > 0) {
            requestBuilder = (RequestBuilder)requestBuilder.transform(imageData.transformations);
        } else if (imageData.circle) {
            requestBuilder = (RequestBuilder)requestBuilder.transform((Transformation<Bitmap>)new GlideCircleTransform());
        } else if (imageData.round != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.transform((Transformation<Bitmap>)new GlideRoundTransform(imageData.round));
        }
        if (ImageUtil.isValidDimension(imageData.width) && ImageUtil.isValidDimension(imageData.height)) {
            requestBuilder = (RequestBuilder)requestBuilder.override(imageData.width, imageData.height);
        }
        if (sizeMultiplier > 0.0f & sizeMultiplier < 1.0f) {
            requestBuilder = (RequestBuilder)requestBuilder.sizeMultiplier(sizeMultiplier);
        } else if (imageData.sizeMultiplier > 0.0f && imageData.sizeMultiplier < 1.0f) {
            requestBuilder = (RequestBuilder)requestBuilder.sizeMultiplier(imageData.sizeMultiplier);
        }
        if (imageData.skipMemCache) {
            requestBuilder = (RequestBuilder)requestBuilder.skipMemoryCache(true);
        }
        if (imageData.listener != null || RuntimeContext.sIsDebuggable || monitor != null && StringUtils.isNotEmpty(gifUrl)) {
            if (monitor != null) {
                monitor.onStart(index, true, gifUrl, imageData.width, imageData.height);
            }
            if (imageData.monitor != null) {
                imageData.monitor.onStart(index, true, imageData.originUrl, imageData.width, imageData.height);
            }
            requestBuilder = requestBuilder.listener(new RequestListener<GifDrawable>(){

                @Override
                public boolean onLoadFailed(final @Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                    YYTaskExecutor.postToMainThread(new Runnable(){

                        @Override
                        public void run() {
                            imageData.loadSuccess = false;
                            if (imageData.listener != null) {
                                if (e == null) {
                                    imageData.listener.onLoadFailed(new Exception(""));
                                } else {
                                    imageData.listener.onLoadFailed(e);
                                }
                            }
                            if (imageData.monitor != null) {
                                imageData.monitor.onError(index, imageData.originUrl, e);
                            }
                        }
                    });
                    if (monitor != null) {
                        monitor.onError(index, gifUrl, e);
                    }
                    MLog.error((Object)"ImageLoader", "loadImage error:" + gifUrl, e, new Object[0]);
                    return false;
                }

                @Override
                public boolean onResourceReady(final GifDrawable resource, Object model, Target<GifDrawable> target, final DataSource dataSource, final boolean isFirstResource, final PerformanceData performanceData) {
                    int size = 0;
                    if (resource != null && (imageData.monitor != null || monitor != null)) {
                        size = ImageUtil.checkBitmapSize(ImageLoader.getBitmapFromCustomDrawable(resource), gifUrl);
                    }
                    final int gifSize = size;
                    YYTaskExecutor.postToMainThread(new Runnable(){

                        @Override
                        public void run() {
                            imageData.loadSuccess = true;
                            if (imageData.listener != null) {
                                imageData.listener.onResourceReady(resource, !isFirstResource, dataSource);
                            }
                            if (imageData.monitor != null) {
                                imageData.monitor.onSuccess(index, imageData.originUrl, gifSize, !isFirstResource, dataSource, performanceData);
                            }
                        }
                    });
                    if (monitor != null) {
                        monitor.onSuccess(index, gifUrl, size, !isFirstResource, dataSource, performanceData);
                    }
                    return false;
                }
            });
        }
        requestBuilder = ImageLoaderType.buildByScaleType(requestBuilder, imageView);
        requestBuilder.into(new ImageViewTarget<GifDrawable>((ImageView)imageView){

            @Override
            protected void setResource(@Nullable GifDrawable resource) {
                imageData.loadSuccess = true;
                ((ImageView)this.view).setImageDrawable((Drawable)resource);
            }
        });
    }

    public static void loadNormalImage(Context context, final String url, final RecycleImageView imageView, final ImageLoader.ImageData imageData, boolean useMemCache, final int retryTime, final boolean useBackUpUrl, final int index, final ImageLoader.IMonitor monitor, final ImageLoader.IMonitor hiidoMonitor) {
        RequestBuilder<Bitmap> requestBuilder = (RequestBuilder<Bitmap>)((BaseRequestOptions)Glide.with(context).asBitmap().load(url)).diskCacheStrategy(imageData.skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC);
        if (imageData.thumbnail != null) {
            requestBuilder = requestBuilder.thumbnail(((RequestBuilder)Glide.with(context).asBitmap().load(imageData.thumbnail)).addListener(new RequestListener<Bitmap>(){

                @Override
                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                    MLog.error((Object)"ImageLoader", "loadNormalImage thumbnail Error %s %s", e, model, imageView);
                    return false;
                }

                @Override
                public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                    MLog.debug("ImageLoader", "loadNormalImage thumbnail %s %s Source: %s", new Object[]{model, imageView, dataSource});
                    return false;
                }
            }));
        }
        MLog.debug("ImageLoader", "loadNormalImage thumbnail  Start %s %s", imageData.url, imageView);
        if (imageData.placeholderDrawable != null) {
            requestBuilder = (RequestBuilder<Bitmap>)requestBuilder.placeholder(imageData.placeholderDrawable);
        } else if (imageData.placeholderId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.placeholder(imageData.placeholderId);
        }
        if (imageData.errorDrawable != null) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorDrawable);
        } else if (imageData.errorId != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.error(imageData.errorId);
        }
        if (imageData.isOverrideSize && imageData.width != -1 && imageData.height != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.override(imageData.width, imageData.height);
        } else if (imageData.useOriginalSize) {
            requestBuilder = (RequestBuilder)requestBuilder.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        if (imageData.sizeMultiplier > 0.0f && imageData.sizeMultiplier < 1.0f) {
            requestBuilder = (RequestBuilder)requestBuilder.sizeMultiplier(imageData.sizeMultiplier);
        }
        if (imageData.transformations != null && imageData.transformations.length > 0) {
            requestBuilder = (RequestBuilder)requestBuilder.transform(imageData.transformations);
        } else if (imageData.circle) {
            requestBuilder = (RequestBuilder)requestBuilder.transform((Transformation<Bitmap>)new GlideCircleTransform());
        } else if (imageData.round != -1) {
            requestBuilder = (RequestBuilder)requestBuilder.transform(new CenterCrop(), new RoundedCorners(ResolutionUtils.dip2Px(imageData.round)));
        }
        if (RuntimeContext.getPhoneType() == 1 || !imageData.anim) {
            requestBuilder = (RequestBuilder)requestBuilder.dontAnimate();
        } else if (imageData.crossFade) {
            requestBuilder = requestBuilder.transition(sCrossFade);
        }
        if (imageData.skipMemCache || !useMemCache) {
            imageData.skipMemCache = true;
            requestBuilder = (RequestBuilder<Bitmap>)requestBuilder.skipMemoryCache(true);
        }
        if (monitor != null) {
            monitor.onStart(index, true, url, imageData.width, imageData.height);
        }
        if (hiidoMonitor != null && StringUtils.isNotEmpty(url)) {
            hiidoMonitor.onStart(index, true, url, imageData.width, imageData.height);
        }
        final String retryUrl = url;
        requestBuilder = requestBuilder.listener(new RequestListener<Bitmap>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                YYTaskExecutor.execute(() -> ImageLoaderType.onCallbackFail(e, retryTime, url, imageView, useBackUpUrl, retryUrl, imageData, monitor, hiidoMonitor, index), 50L);
                return false;
            }

            @Override
            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                MLog.debug("ImageLoader", "loadNormalImage %s %s Source: %s", new Object[]{model, imageView, dataSource});
                YYTaskExecutor.postToMainThread(() -> {
                    ImageLoaderType.onCallbackSuccess(imageData, resource, dataSource, isFirstResource, url, monitor, index);
                    if (!(dataSource != DataSource.REMOTE && dataSource != DataSource.DATA_DISK_CACHE || hiidoMonitor == null || TextUtils.isEmpty((CharSequence)url))) {
                        int size = 0;
                        if (resource != null && !resource.isRecycled()) {
                            size = Util.getBitmapByteSize(resource);
                        }
                        hiidoMonitor.onSuccess(index, url, size, !isFirstResource, dataSource, performanceData);
                    }
                });
                return false;
            }
        });
        requestBuilder = ImageLoaderType.buildByScaleType(requestBuilder, imageView);
        ((RequestBuilder)requestBuilder.format(imageData.decodeFormat)).into(new BitmapImageViewTarget((ImageView)imageView){

            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                imageData.loadSuccess = true;
                super.onResourceReady(resource, transition);
            }
        });
    }

    private static void onCallbackSuccess(ImageLoader.ImageData imageData, Bitmap resource, DataSource dataSource, boolean isFirstResource, String url, ImageLoader.IMonitor monitor, int loadId) {
        imageData.loadSuccess = true;
        StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.SUCESS, loadId);
        if (imageData.listener != null) {
            imageData.listener.onResourceReady(resource, !isFirstResource, dataSource);
        }
        int size = 0;
        if (resource != null) {
            size = ImageUtil.checkBitmapSize(resource, url);
        }
        if (monitor != null) {
            monitor.onSuccess(loadId, url, size, !isFirstResource, dataSource, null);
        }
        MLog.debug("ImageLoader", "loadImage %s finished, isFirstResource: %b", url, isFirstResource);
    }

    private static void onCallbackFail(@Nullable GlideException e, int retryTime, String url, RecycleImageView imageView, boolean useBackUpUrl, String retryUrl, ImageLoader.ImageData imageData, ImageLoader.IMonitor monitor, ImageLoader.IMonitor hiidoMonitor, int loadId) {
        boolean bitmapError;
        String errInfo;
        String string2 = errInfo = e != null ? e.toString() : "";
        if (errInfo.contains("setDataSource failed: status = 0x80000000") && (URLUtils.isHttpScheme(url) || URLUtils.isHttpsScheme(url))) {
            MLog.error((Object)"ImageLoader", "deleteExceptionCacheFile loadImage error:" + url, e, new Object[0]);
            Glide.get(RuntimeContext.sApplicationContext).clearDiskCache(ImageLoaderType.deleteExceptionCacheFile(url));
        }
        if (!errInfo.contains("404") && ImageLoaderType.enableRetry(bitmapError = ImageLoaderType.isBitmapError(e), retryTime, url)) {
            Runnable command = () -> ImageLoaderType.retryLoad(imageView, useBackUpUrl, retryUrl, monitor, loadId, url, retryTime, bitmapError);
            ImageLoaderType.executeRetryStrategy(command, retryTime);
            ImageLoaderType.printErrorCauses(url, retryTime, e);
            return;
        }
        ImageLoaderType.failCallback(imageData, url, e, monitor, hiidoMonitor, loadId);
        StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.FAIL, loadId);
    }

    private static void failCallback(ImageLoader.ImageData imageData, String url, Exception e, ImageLoader.IMonitor monitor, ImageLoader.IMonitor hiidoMonitor, int loadId) {
        YYTaskExecutor.postToMainThread(() -> {
            imageData.loadSuccess = false;
            if (imageData.listener != null) {
                if (e == null) {
                    imageData.listener.onLoadFailed(new Exception(""));
                } else {
                    imageData.listener.onLoadFailed(e);
                }
            }
            MLog.error((Object)"ImageLoader", "loadImage error:" + url, e, new Object[0]);
            if (monitor != null) {
                monitor.onError(loadId, url, e);
            }
            if (hiidoMonitor != null && StringUtils.isNotEmpty(url)) {
                hiidoMonitor.onError(loadId, url, e);
            }
        });
    }

    private static String getBackupUrl(String backupUrl, String originUrl) {
        if (StringUtils.isEmpty(backupUrl)) {
            backupUrl = ImageLoaderBackUrl.getBackupUrl(originUrl);
        }
        return backupUrl;
    }

    private static void printErrorCauses(String url, int retryTime, GlideException e) {
        if (StringUtils.isNotEmpty(url)) {
            MLog.error((Object)"ImageLoader", "loadImage error retry:" + retryTime + " " + url + " error:" + (e != null ? e.toString() : ""), new Object[0]);
            if (e != null) {
                for (Throwable t : e.getRootCauses()) {
                    MLog.error((Object)"ImageLoaderType", "Caused by", t, new Object[0]);
                }
            }
        }
    }

    private static void executeRetryStrategy(Runnable runnable, int retryTime) {
        if (YYTaskExecutor.isMainThread() && retryTime < 1) {
            runnable.run();
            return;
        }
        int delay = 0;
        delay = retryTime == 0 ? 0 : (retryTime == 1 ? 500 : 1000);
        YYTaskExecutor.postToMainThread(runnable, delay);
    }

    private static void retryLoad(RecycleImageView imageView, boolean useBackUpUrl, String retryUrl, ImageLoader.IMonitor monitor, int loadId, String originUrl, int retryTime, boolean bitmapError) {
        if (imageView == null) {
            return;
        }
        Object object = imageView.getTag(R.id.yy_image_data_id);
        if (ImageLoaderType.retryIgnore(object, useBackUpUrl, retryUrl)) {
            return;
        }
        boolean isUseBackupUrl = false;
        boolean isUseMemCache = false;
        ImageLoader.ImageData newImageData = (ImageLoader.ImageData)object;
        if (retryTime == 0) {
            StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorStatus(StrategyStatus.START, loadId);
            newImageData.url = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.START, newImageData.url);
            newImageData.backUrl = ImageLoaderType.getBackupUrl(newImageData.backUrl, newImageData.url);
            newImageData.backUrl = StrategySelector.getStrategySelector(HttpsSchemeTransformStrategy.class).strategySelectorResult(StrategyStatus.START, newImageData.backUrl);
            isUseBackupUrl = StringUtils.isNotEmpty(newImageData.backUrl);
            isUseMemCache = true;
            if (monitor != null) {
                monitor.onHappenHttpError(originUrl);
            }
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("ImageLoader", "use https retry!", new Object[0]);
            }
        } else if (!bitmapError) {
            isUseMemCache = true;
        }
        MLog.error((Object)"ImageLoader", "retryLoad url:" + newImageData.url + " back url " + newImageData.backUrl + " isUseBackupUrl " + isUseBackupUrl, new Object[0]);
        ImageLoader.loadImageInner(imageView, newImageData, retryTime + 1, isUseMemCache, -1.0f, isUseBackupUrl, loadId);
    }

    private static boolean isBitmapError(GlideException e) {
        String errorInfo = e != null ? e.toString() : "";
        return StringUtils.isNotEmpty(errorInfo) && errorInfo.contains("Problem decoding into existing bitmap");
    }

    private static boolean enableRetry(boolean bitmapError, int retryTime, String url) {
        if (!NetworkUtils.isNetworkAvailable(RuntimeContext.sApplicationContext)) {
            MLog.error((Object)"ImageLoader", "loadImage Network not Available!", new Object[0]);
            return false;
        }
        return (bitmapError && retryTime <= 3 || retryTime < 2) && StringUtils.isNotEmpty(url) && url.startsWith("http");
    }

    private static boolean retryIgnore(Object object, boolean useBackUpUrl, String retryUrl) {
        if (!(object instanceof ImageLoader.ImageData)) {
            MLog.error((Object)"ImageLoader", "loadImage ImageData not exist!", new Object[0]);
            return true;
        }
        ImageLoader.ImageData newImageData = (ImageLoader.ImageData)object;
        if (!useBackUpUrl && !StringUtils.equal(newImageData.url, retryUrl)) {
            return true;
        }
        return useBackUpUrl && !StringUtils.equal(newImageData.backUrl, retryUrl);
    }

    private static Key deleteExceptionCacheFile(String url) {
        return new DataCacheKey(new GlideUrl(url), EmptySignature.obtain());
    }
}

