/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.engine.PerformanceData;
import com.bumptech.glide.load.engine.executor.GlideExecutor;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.BigPicRecycler;
import com.yy.base.imageloader.GifHandler;
import com.yy.base.imageloader.GlideRegistry;
import com.yy.base.imageloader.IRecycler;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoaderBackUrl;
import com.yy.base.imageloader.ImageLoaderType;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.customcache.ImageCache;
import com.yy.base.imageloader.customcache.YYLruBitmapPool;
import com.yy.base.imageloader.customcache.YYLruResourceCache;
import com.yy.base.imageloader.transform.BlurTransformation;
import com.yy.base.imageloader.transform.YYBitmapTransformation;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SdkVersionUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.filestorage.FileOperatorQ;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;

public class ImageLoader {
    private static final String TAG = "ImageLoader";
    private static final int MAX_BITMAP_POOL_SIZE = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    private static final int MAX_RESOURCE_BITMAP_POOL_SIZE = Build.VERSION.SDK_INT > 20 ? 0x1400000 : 0xA00000;
    public static boolean sDebugSwitch = false;
    private static volatile YYLruResourceCache sGlideCache;
    private static volatile YYLruBitmapPool sBitmapPool;
    private static volatile ImageCache sNormalCache;
    private static int sBitmapPoolSize;
    private static int sResourceCacheSize;
    private static volatile boolean sLoadOrigin;
    private static volatile boolean sRecycleImageViewOn;
    private static volatile boolean sBigImageAutoRecycle;
    private static volatile int sBigRecycleSizeMultiplier;
    private static GlideExecutor sExecutor;
    private static boolean sResetDrawableToNulling;
    private static volatile IMonitor sMonitor;
    private static volatile int sIndex;
    private static volatile IMonitor hiidoMonitor;

    public static void init(int bitmapPoolSize, int memCacheSize, ModelLoaderFactory<GlideUrl, InputStream> modelLoaderFactory) {
        GlideRegistry.registry(modelLoaderFactory);
        if (bitmapPoolSize > 0) {
            sBitmapPoolSize = bitmapPoolSize;
        }
        if (memCacheSize > 0) {
            sResourceCacheSize = memCacheSize;
        }
        if (RuntimeContext.sApplicationContext instanceof Application) {
            IRecycler recycler = new IRecycler(){

                @Override
                public boolean recycle(RecycleImageView imageView) {
                    return ImageLoader.recycle(imageView);
                }

                @Override
                public boolean recovery(RecycleImageView imageView) {
                    return ImageLoader.recovery(imageView);
                }
            };
            GifHandler.init((Application)RuntimeContext.sApplicationContext, recycler);
            BigPicRecycler.init((Application)RuntimeContext.sApplicationContext, recycler);
        }
    }

    public static void updateSwitchs(boolean loadOrgin, boolean recycleImageViewOn, boolean bigImageAutoRecycle, int bigImageAutoRecycleSizeMultiplier) {
        sLoadOrigin = loadOrgin;
        sRecycleImageViewOn = recycleImageViewOn;
        sBigImageAutoRecycle = bigImageAutoRecycle;
        if (bigImageAutoRecycleSizeMultiplier > 0) {
            sBigRecycleSizeMultiplier = bigImageAutoRecycleSizeMultiplier;
        }
        BigPicRecycler.updateParams(sBigImageAutoRecycle, sBigRecycleSizeMultiplier);
    }

    public static void setExecutor(GlideExecutor executor) {
        if (executor != null) {
            sExecutor = executor;
        }
    }

    public static boolean fillExecutor(GlideBuilder glideBuilder) {
        if (glideBuilder != null && sExecutor != null) {
            glideBuilder.setSourceExecutor(sExecutor);
            return true;
        }
        return false;
    }

    public static YYLruBitmapPool getBitmapPool() {
        if (sBitmapPool == null) {
            sBitmapPool = new YYLruBitmapPool(sBitmapPoolSize);
        }
        return sBitmapPool;
    }

    public static YYLruResourceCache getResourceCache() {
        if (sGlideCache == null) {
            sGlideCache = new YYLruResourceCache(sResourceCacheSize);
        }
        return sGlideCache;
    }

    private static ImageCache getYYImageCache() {
        if (sNormalCache == null) {
            sNormalCache = new ImageCache(RuntimeContext.sApplicationContext);
        }
        return sNormalCache;
    }

    public static void preloadImage(Context context, String url) {
        ImageLoader.preloadImage(context, url, 0, 0);
    }

    public static void preloadImage(Context context, String url, int width, int height) {
        String backUpUrl;
        if (context == null || StringUtils.isEmpty(url)) {
            return;
        }
        int w = width;
        int h = height;
        if (w <= 0) {
            w = Integer.MIN_VALUE;
        }
        if (h <= 0) {
            h = Integer.MIN_VALUE;
        }
        String finalUrl = ImageLoaderBackUrl.urlTransform(null, url);
        if (RuntimeContext.sIsDebuggable && SettingFlags.getBoolean("DEBUGOOS_USE_WANGSU", false) && StringUtils.isNotEmpty(backUpUrl = ImageLoaderBackUrl.getBackupUrl(finalUrl))) {
            finalUrl = backUpUrl;
        }
        MLog.debug("preloadImage", "preload url: %s , width: %d, height: %d", finalUrl, w, h);
        if (ImageUtil.isWebPAnim(finalUrl)) {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).load(finalUrl)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        } else if (RuntimeContext.getPhoneType() != 1 && ImageUtil.isGifUrl(finalUrl)) {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).asGif().load(finalUrl)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        } else {
            ((RequestBuilder)((BaseRequestOptions)Glide.with(context).asBitmap().load(finalUrl)).diskCacheStrategy(DiskCacheStrategy.AUTOMATIC)).preload(w, h);
        }
    }

    public static boolean loadBlurImage(RecycleImageView v, String url, int placeholderId) {
        return ImageLoader.loadBlurImageRadius(v, url, 25, placeholderId);
    }

    public static boolean loadBlurImageRadius(RecycleImageView v, String url, int radius, int placeholderId) {
        ImageData imageData = Builder.resetData(v, url);
        Drawable placeholder = null;
        if (placeholderId > 0) {
            placeholder = ResourceUtils.getDrawable(placeholderId);
        }
        ImageLoader.loadBlur(v, imageData, url, url, placeholder, radius, false);
        return false;
    }

    public static void loadBlurImageByBlurPlaceholder(RecycleImageView v, String url, byte[] blurImageData) {
        if (!ImageLoader.loadBlurImage(v, url, 0)) {
            ImageLoader.loadBlur(v, Builder.check(v), blurImageData, url, 25, true);
        }
    }

    public static void loadImageByBlurPlaceholder(RecycleImageView v, String url, byte[] blurImageData, int width, int height) {
        ImageLoader.checkUrlSize(url);
        Builder.obtain(v, url).override(width, height).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        if (blurImageData != null && blurImageData.length > 0) {
            ImageLoader.loadBlur(v, Builder.check(v), blurImageData, url, 25, true);
        }
    }

    public static void loadImageByBlurPlaceholder(RecycleImageView v, String url, String blurUrl, int width, int height) {
        Builder.obtain(v, url).override(width, height).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        ImageLoader.loadBlur(v, Builder.check(v), blurUrl, url, null, 25, true);
    }

    public static void loadImageByBlurPlaceholder(RecycleImageView v, String url, String blurUrl, int width, int height, @Nullable ImageLoadListener listener) {
        Builder.obtain(v, url).override(width, height).load();
        if (!YYImageUtils.isHttpRequest(url)) {
            MLog.debug(TAG, "loadImageByBlurPlaceholder url: %s is not http, no need load blur placeholder", new Object[0]);
            return;
        }
        ImageLoader.loadBlur(v, Builder.check(v), blurUrl, url, null, 25, true, listener);
    }

    private static void loadBlur(final RecycleImageView v, final ImageData imageData, byte[] blurBytes, final String callUrl, int radius, final boolean checkMajorLoadSuccess) {
        ImageLoader.checkUrlSize(callUrl);
        YYTaskExecutor.execute(() -> {
            try {
                ((RequestBuilder)((RequestBuilder)Glide.with(v.getContext()).asBitmap().optionalTransform(new BlurTransformation(radius))).load(blurBytes)).into(new CustomTarget<Bitmap>(){

                    @Override
                    public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                        if (!(imageData == null || !StringUtils.equal(callUrl, imageData.originUrl) || checkMajorLoadSuccess && imageData.loadSuccess)) {
                            imageData.loadSuccess = true;
                            v.setImageBitmap(resource);
                        }
                    }

                    @Override
                    public void onLoadCleared(@Nullable Drawable placeholder) {
                    }
                });
            }
            catch (Exception ex) {
                MLog.error((Object)TAG, "loadBlur error", ex, new Object[0]);
            }
        });
    }

    private static void loadBlur(final RecycleImageView v, final ImageData imageData, final String blurUrl, final String callUrl, @Nullable Drawable placeholder, int radius, final boolean checkMajorLoadSuccess, final @Nullable ImageLoadListener listener) {
        String backUpUrl;
        ImageLoader.checkUrlSize(blurUrl);
        String finalUrl = ImageLoaderBackUrl.urlTransform(null, blurUrl);
        if (RuntimeContext.sIsDebuggable && SettingFlags.getBoolean("DEBUGOOS_USE_WANGSU", false) && StringUtils.isNotEmpty(backUpUrl = ImageLoaderBackUrl.getBackupUrl(finalUrl))) {
            finalUrl = backUpUrl;
        }
        final String fu = finalUrl;
        ((RequestBuilder)((RequestBuilder)((BaseRequestOptions)Glide.with((View)v).asBitmap().load(finalUrl)).optionalTransform(new BlurTransformation(radius))).placeholder(placeholder)).listener(new RequestListener<Bitmap>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                MLog.error((Object)ImageLoader.TAG, "loadBlur:" + blurUrl + " error", e, new Object[0]);
                if (listener != null) {
                    listener.onLoadFailed(e);
                }
                return true;
            }

            @Override
            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                if (listener != null) {
                    listener.onResourceReady(resource, !isFirstResource, dataSource);
                }
                if (resource == null || resource.isRecycled()) {
                    MLog.warn(ImageLoader.TAG, "loadBlur onResourceReady resource is null or recycled", new Object[0]);
                    return true;
                }
                MLog.debug("preloadImage", "loadBlur finish url: %s, dataSource: %s", fu, dataSource.name());
                YYTaskExecutor.postToMainThread(() -> {
                    if (!(imageData == null || !StringUtils.equal(imageData2.originUrl, callUrl) || checkMajorLoadSuccess && imageData2.loadSuccess)) {
                        imageData2.loadSuccess = true;
                        v.setImageBitmap(resource);
                    }
                });
                return true;
            }
        }).submit();
    }

    private static void checkUrlSize(String blurUrl) {
        if (RuntimeContext.sIsDebuggable && StringUtils.isNotEmpty(blurUrl) && URLUtils.isOurHostByUrl(blurUrl) && !blurUrl.contains("resize,")) {
            MLog.error("\u56fe\u7247\u52a0\u8f7d\u8fdd\u89c4", new RuntimeException("\u9700\u8981\u62fc\u63a5\u5c3a\u5bf8\uff1a" + blurUrl));
        }
    }

    private static void loadBlur(final RecycleImageView v, final ImageData imageData, final String blurUrl, final String callUrl, @Nullable Drawable placeholder, int radius, final boolean checkMajorLoadSuccess) {
        String backUpUrl;
        ImageLoader.checkUrlSize(blurUrl);
        String finalUrl = ImageLoaderBackUrl.urlTransform(null, blurUrl);
        if (RuntimeContext.sIsDebuggable && SettingFlags.getBoolean("DEBUGOOS_USE_WANGSU", false) && StringUtils.isNotEmpty(backUpUrl = ImageLoaderBackUrl.getBackupUrl(finalUrl))) {
            finalUrl = backUpUrl;
        }
        final String fu = finalUrl;
        ((RequestBuilder)((RequestBuilder)((BaseRequestOptions)Glide.with((View)v).asBitmap().load(finalUrl)).optionalTransform(new BlurTransformation(radius))).placeholder(placeholder)).listener(new RequestListener<Bitmap>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                MLog.error((Object)ImageLoader.TAG, "loadBlur:" + blurUrl + " error", e, new Object[0]);
                return true;
            }

            @Override
            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                if (resource == null || resource.isRecycled()) {
                    MLog.warn(ImageLoader.TAG, "loadBlur onResourceReady resource is null or recycled", new Object[0]);
                    return true;
                }
                MLog.debug("preloadImage", "loadBlur finish url: %s, dataSource: %s", fu, dataSource.name());
                YYTaskExecutor.postToMainThread(() -> {
                    if (!(imageData == null || !StringUtils.equal(imageData2.originUrl, callUrl) || checkMajorLoadSuccess && imageData2.loadSuccess)) {
                        imageData2.loadSuccess = true;
                        v.setImageBitmap(resource);
                    }
                });
                return true;
            }
        }).submit();
    }

    public static void loadImage(RecycleImageView recycleImageView, int placeholderId) {
        ImageLoader.loadImage(recycleImageView, null, placeholderId);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url) {
        ImageLoader.loadImage(recycleImageView, url, -1);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId) {
        ImageLoader.loadImage(recycleImageView, url, placeholderId, placeholderId);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, boolean crossFade) {
        ImageLoader.loadImage(recycleImageView, url, null, placeholderId, placeholderId, null, null, crossFade, null);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, int errorID) {
        ImageLoader.loadImage(recycleImageView, url, placeholderId, errorID, null);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, int placeholderId, int errorId, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, null, placeholderId, errorId, null, null, listener);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, String thumbnail, int placeholderId, int errorId, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, thumbnail, placeholderId, errorId, null, null, listener);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, Drawable placeholderDrawable) {
        ImageLoader.loadImage(recycleImageView, url, null, -1, -1, placeholderDrawable, null, null);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, Drawable placeholderDrawable, Drawable errorDrawable, ImageLoadListener listener) {
        if (RuntimeContext.sIsDebuggable && StringUtils.isNotEmpty(url) && !url.contains("resize,") && (StringUtils.isEmpty(RuntimeContext.getChannelId()) || url.contains("/uurl/"))) {
            MLog.error((Object)"Waring", "\u8bf7\u6ce8\u610f\uff0c\u52a0\u8f7d\u7684\u56fe\u7247\u6ca1\u6709\u62fc\u63a5\u5c3a\u5bf8\uff0c\u8bf7\u53c2\u8003\u4ee5\u4e0b\u7528\u6cd5\uff1aImageLoader.loadImage(ivhead, newData.getIconUrl() + YYImageUtils).getThumbSmall());", new Object[0]);
        }
        ImageLoader.loadImage(recycleImageView, url, null, -1, -1, placeholderDrawable, errorDrawable, listener);
    }

    public static void loadImage(RecycleImageView recycleImageView, String url, Object thumbnail, Drawable placeholderDrawable, Drawable errorDrawable, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, thumbnail, -1, -1, placeholderDrawable, errorDrawable, listener);
    }

    public static void clear(RecycleImageView recycleImageView) {
        try {
            Glide.with(RuntimeContext.sApplicationContext).clear((View)recycleImageView);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void clear(@Nullable Target<?> target) {
        try {
            Glide.with(RuntimeContext.sApplicationContext).clear(target);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void clearDiskCache() {
        YYTaskExecutor.execute(() -> Glide.get(RuntimeContext.sApplicationContext).clearDiskCache());
    }

    public static void loadImage(Context context, int resizeX, int resizeY, Drawable placeholder, YYImageView imageView, Uri uri) {
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ImageLoader_loadImage\uff1a%s", uri);
        }
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((BaseRequestOptions)Glide.with(context).load(uri)).placeholder(placeholder)).override(resizeX, resizeY)).priority(Priority.NORMAL)).centerCrop()).into(imageView);
    }

    private static void loadImage(RecycleImageView recycleImageView, String url, Object thumbnail, int placeholderId, int errorId, Drawable placeholderDrawable, Drawable errorDrawable, ImageLoadListener listener) {
        ImageLoader.loadImage(recycleImageView, url, thumbnail, placeholderId, errorId, placeholderDrawable, errorDrawable, false, listener);
    }

    private static void loadImage(RecycleImageView recycleImageView, String url, Object thumbnail, int placeholderId, int errorId, Drawable placeholderDrawable, Drawable errorDrawable, boolean crossFade, ImageLoadListener listener) {
        if (recycleImageView == null || recycleImageView.getContext() == null) {
            return;
        }
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ImageLoader_loadImage\uff1a%s", url);
        }
        Builder.obtain(recycleImageView, url, placeholderId).thumbnail(thumbnail).error(errorId).error(errorDrawable).placeholder(placeholderDrawable).setSizeMultiplier(-1.0f).setCrossFade(crossFade).setListener(listener).load();
    }

    public static void loadImage(RecycleImageView imageView, ImageData imageData) {
        String backUpUrl;
        String selectUrl;
        if (imageData == null || imageView == null) {
            return;
        }
        String originUrl = imageData.url;
        imageData.url = selectUrl = ImageLoaderBackUrl.urlTransform(imageView, originUrl + YYImageUtils.getThumb((View)imageView, false, originUrl));
        if (imageData.needCheckUrl) {
            ImageLoader.checkUrlSize(imageData.url);
        }
        if (RuntimeContext.sIsDebuggable && SettingFlags.getBoolean("DEBUGOOS_USE_WANGSU", false) && StringUtils.isNotEmpty(backUpUrl = ImageLoaderBackUrl.getBackupUrl(imageData.url))) {
            imageData.url = backUpUrl;
            MLog.debug(TAG, "useBackupUrl test %s", selectUrl);
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> ImageLoader.loadImageInner(imageView, imageData));
        } else {
            ImageLoader.loadImageInner(imageView, imageData);
        }
    }

    public static void loadCorpImageWithNineBg(RecycleImageView recycleImageView, String url, int placeholderNinePngId) {
        ImageLoader.loadCorpImageWithNineBg(recycleImageView, url, placeholderNinePngId, true);
    }

    public static void loadCorpImageWithNineBg(final RecycleImageView recycleImageView, String url, final int placeholderNinePngId, boolean ani) {
        if (recycleImageView == null) {
            return;
        }
        recycleImageView.setBackgroundResource(placeholderNinePngId);
        Builder builder = Builder.obtain(recycleImageView, url);
        builder.setListener(new ImageLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
                if (recycleImageView != null) {
                    recycleImageView.setBackgroundResource(placeholderNinePngId);
                }
            }

            @Override
            public void onResourceReady(Object resource, boolean isFromMemoryCache, DataSource dataSource) {
                if (recycleImageView != null) {
                    recycleImageView.setBackgroundDrawable(null);
                }
            }
        });
        builder.anim(ani);
        builder.load();
    }

    protected static void loadImageInner(RecycleImageView imageView, ImageData imageData) {
        ImageLoader.loadImageInner(imageView, imageData, 0, true, -1.0f, false, ImageLoader.generateIndex());
    }

    protected static void loadImageInner(@NonNull RecycleImageView imageView, @NonNull ImageData imageData, int retryTime, boolean useMemCache, float sizeMultiplier, boolean useBackUpUrl, int loadId) {
        Context context;
        String url;
        if (!useBackUpUrl && imageData.url != null && imageData.url.length() == 0) {
            imageData.url = null;
        }
        String string2 = url = useBackUpUrl ? imageData.backUrl : imageData.url;
        if (StringUtils.isEmpty(url) && (SettingFlags.getBoolean("imageemptyurl2", true) || RuntimeContext.isInGray())) {
            ImageLoader.clearHeadRequest(imageView);
            if (imageData.placeholderDrawable != null) {
                imageView.setImageDrawable(imageData.placeholderDrawable);
            } else if (imageData.placeholderId > 0) {
                imageView.setImageResource(imageData.placeholderId);
            } else if (imageData.errorDrawable != null) {
                imageView.setImageDrawable(imageData.errorDrawable);
            } else if (imageData.errorId > 0) {
                imageView.setImageResource(imageData.errorId);
            } else {
                imageView.setImageDrawable(null);
            }
            return;
        }
        if (!(ImageUtil.isValidDimension(imageData.width) && ImageUtil.isValidDimension(imageData.height) || imageView.getLayoutParams() == null || imageView.getLayoutParams().width <= 0 || imageView.getLayoutParams().height <= 0)) {
            imageData.width = imageView.getLayoutParams().width;
            imageData.height = imageView.getLayoutParams().height;
        }
        if ((context = imageView.getContext()) instanceof Activity) {
            if (((Activity)context).isDestroyed()) {
                return;
            }
            context = RuntimeContext.sApplicationContext;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug(TAG, "url:" + url, new Object[0]);
        } else if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info(TAG, "load url:%s!", url);
        }
        ImageLoader.clearHeadRequest(imageView);
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ImageLoader_loadImage\uff1a%s", url);
        }
        if (ImageUtil.isWebPAnim(url)) {
            ImageLoaderType.loadWebPAnim(context, url, imageView, imageData, useMemCache, loadId, sMonitor);
        } else if (imageData.enableGif && (RuntimeContext.getPhoneType() != 1 && imageData.asGif || ImageUtil.isGifUrl(url))) {
            ImageLoaderType.loadGifAnim(context, url, imageView, imageData, useMemCache, sizeMultiplier, loadId, sMonitor);
        } else {
            ImageLoaderType.loadNormalImage(context, url, imageView, imageData, useMemCache, retryTime, useBackUpUrl, loadId, sMonitor, hiidoMonitor);
        }
        ImageLoader.setImageDataToTag(imageView, imageData);
    }

    private static String getCacheKey(String url) {
        return url;
    }

    private static String getCacheKey(String url, int width, int height) {
        return StringUtils.isEmpty(url) ? url : "#W" + width + "#H" + height + url;
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        return true;
    }

    public static boolean addBitmapToCache(String key, BitmapDrawable bitmap, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key)) {
            return false;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key), bitmap);
        } else {
            ImageLoader.getYYImageCache().addBitmapToCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()), bitmap);
        }
        return true;
    }

    public static void removeBitmapFromCache(String key, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key)) {
            return;
        }
        if (imageConfig == null) {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key));
        } else {
            ImageLoader.getYYImageCache().removeBitmapFromCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
        }
    }

    @Nullable
    public static BitmapDrawable getBitmapFromCache(String key) {
        return ImageLoader.getBitmapFromCache(key, null);
    }

    public static BitmapDrawable getBitmapFromCache(String key, ImageConfig imageConfig) {
        if (StringUtils.isEmpty(key)) {
            return null;
        }
        if (imageConfig == null) {
            return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key));
        }
        return ImageLoader.getYYImageCache().getBitmapFromMemCache(ImageLoader.getCacheKey(key, imageConfig.getImagePrecision().getWidth(), imageConfig.getImagePrecision().getHeight()));
    }

    public static void removeBitmapFromCache(String key) {
        ImageLoader.removeBitmapFromCache(key, null);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener) {
        ImageLoader.loadBitmap(context, url, listener, ImageLoader.getDefaultMaxWidth(), ImageLoader.getDefaultMaxHeight(), false);
    }

    public static void pauseRequests() {
        Glide.with(RuntimeContext.sApplicationContext).pauseRequests();
    }

    public static void resumeRequests() {
        Glide.with(RuntimeContext.sApplicationContext).resumeRequests();
    }

    private static void loadBitmapInner(Context context, RecycleImageView recycleImageView, String originUrl, final BitmapLoadListener listener, int width, int height, boolean skipMemCache, boolean skipDiskCache, DecodeFormat format, YYBitmapTransformation ... bitmapTransformations) {
        final String url = ImageLoaderBackUrl.urlTransform(recycleImageView, originUrl);
        Context myContext = null;
        myContext = recycleImageView != null && recycleImageView.getContext() != null ? recycleImageView.getContext() : context;
        if (myContext instanceof Activity) {
            if (((Activity)myContext).isDestroyed()) {
                return;
            }
            myContext = RuntimeContext.sApplicationContext;
        }
        if (myContext == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && sDebugSwitch && MLog.isLogLevelBlowInfo()) {
            MLog.info(TAG, "url:" + url, new Object[0]);
        }
        if (SystemUtils.isShowEnvSetting()) {
            PerfActionLog.add("ImageLoader_loadBitmap\uff1a%s", url);
        }
        ImageLoader.clearHeadRequest(recycleImageView);
        int rWidth = ImageUtil.isValidDimension(width) ? width : Integer.MIN_VALUE;
        int rHeight = ImageUtil.isValidDimension(height) ? height : Integer.MIN_VALUE;
        final WeakReference<RecycleImageView> imageView = new WeakReference<RecycleImageView>(recycleImageView);
        final IMonitor monitor = sMonitor;
        final int index = ImageLoader.generateIndex();
        if (monitor != null && StringUtils.isNotEmpty(url)) {
            monitor.onStart(index, false, url, width, height);
        }
        CustomTarget<Bitmap> target = new CustomTarget<Bitmap>(rWidth, rHeight){

            @Override
            public void onResourceReady(@NonNull Bitmap resource, @Nullable Transition<? super Bitmap> transition) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
                if (listener != null) {
                    listener.onResourceReady(resource);
                }
                int size = ImageUtil.checkBitmapSize(resource, url);
                if (monitor != null && StringUtils.isNotEmpty(url)) {
                    monitor.onSuccess(index, url, size, false, null, null);
                }
            }

            @Override
            public void onLoadCleared(Drawable placeholder) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
                if (monitor != null) {
                    monitor.onClear(index);
                }
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                RecycleImageView imageView1 = (RecycleImageView)imageView.get();
                if (imageView1 != null) {
                    imageView1.setTag(R.id.yy_glide_target_id, null);
                }
                Exception e = new Exception("");
                if (listener != null) {
                    listener.onLoadFailed(e);
                }
                if (monitor != null) {
                    monitor.onError(index, url, e);
                }
                MLog.error((Object)ImageLoader.TAG, "loadBitmap error: " + url, new Object[0]);
            }
        };
        if (recycleImageView != null) {
            recycleImageView.setTag(R.id.yy_glide_target_id, target);
        }
        Object request = Glide.with(myContext).asBitmap().load(url);
        if (bitmapTransformations != null && bitmapTransformations.length > 0) {
            request = (RequestBuilder)((BaseRequestOptions)request).transform(bitmapTransformations);
        }
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)request).apply((BaseRequestOptions)new RequestOptions().downsample(DownsampleStrategy.AT_MOST)).diskCacheStrategy(skipDiskCache ? DiskCacheStrategy.NONE : DiskCacheStrategy.AUTOMATIC)).skipMemoryCache(skipMemCache)).format(format != null ? format : DecodeFormat.PREFER_RGB_565)).into(target);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight, boolean skipCache) {
        ImageLoader.loadBitmap(context, url, listener, maxWidth, maxHeight, skipCache, DecodeFormat.PREFER_RGB_565, (YYBitmapTransformation[])null);
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight, boolean skipCache, DecodeFormat format, YYBitmapTransformation ... bitmapTransformations) {
        if (StringUtils.isEmpty(url)) {
            return;
        }
        ImageLoader.checkUrlSize(url);
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> ImageLoader.loadBitmapInner(context, null, url, listener, maxWidth, maxHeight, skipCache, skipCache, format, bitmapTransformations));
        } else {
            ImageLoader.loadBitmapInner(context, null, url, listener, maxWidth, maxHeight, skipCache, skipCache, format, bitmapTransformations);
        }
    }

    private static void loadBitmap(RecycleImageView imageView, String url, BitmapLoadListener listener, int maxWidth, int maxHeight, boolean skipMemCache, boolean skipDiskCache, YYBitmapTransformation ... bitmapTransformations) {
        if (StringUtils.isEmpty(url)) {
            return;
        }
        if (SystemUtils.isShowEnvSetting() && (imageView == null || !(imageView.getTag(R.id.yy_recycled_check_url) instanceof Boolean))) {
            ImageLoader.checkUrlSize(url);
        }
        if (!YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.postToMainThread(() -> ImageLoader.loadBitmapInner(imageView.getContext(), imageView, url, listener, maxWidth, maxHeight, skipMemCache, skipDiskCache, DecodeFormat.PREFER_RGB_565, bitmapTransformations));
        } else {
            ImageLoader.loadBitmapInner(imageView.getContext(), imageView, url, listener, maxWidth, maxHeight, skipMemCache, skipDiskCache, DecodeFormat.PREFER_RGB_565, bitmapTransformations);
        }
    }

    public static void loadBitmap(Context context, String url, BitmapLoadListener listener, int maxWidth, int maxHeight) {
        ImageLoader.loadBitmap(context, url, listener, maxWidth, maxHeight, false);
    }

    public static void preloadBitmap(String url, ImageConfig imageConfig, int resid) {
        int width = -1;
        int height = -1;
        if (imageConfig != null) {
            width = imageConfig.getImagePrecision().getWidth() * 2;
            height = imageConfig.getImagePrecision().getHeight() * 2;
        }
        ImageLoader.preloadBitmap(url, imageConfig, resid, width, height);
    }

    private static int getDefaultMaxWidth() {
        int width = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getWidth() * 0.85f);
        if (width <= 0) {
            width = Integer.MIN_VALUE;
        }
        return width;
    }

    private static int getDefaultMaxHeight() {
        int height = (int)((float)ImageConfig.fullImageConfig().getImagePrecision().getHeight() * 0.85f);
        if (height <= 0) {
            height = Integer.MIN_VALUE;
        }
        return height;
    }

    public static void preloadBitmap(final String url, final ImageConfig imageConfig, int resid, int maxWidth, int maxHeight) {
        int height;
        int width;
        if (ImageLoader.getBitmapFromCache(url, imageConfig) != null) {
            return;
        }
        ImageLoader.checkUrlSize(url);
        if (resid > 0) {
            ImageUtil.getBitmapDrawableFromResource(resid, imageConfig);
        }
        if (maxHeight > 0 && maxWidth > 0) {
            width = maxWidth;
            height = maxHeight;
        } else {
            width = ImageLoader.getDefaultMaxWidth();
            height = ImageLoader.getDefaultMaxHeight();
        }
        if (!StringUtils.isEmpty(url)) {
            ImageLoader.loadBitmap(RuntimeContext.sApplicationContext, url, new BitmapLoadListener(){

                @Override
                public void onLoadFailed(Exception e) {
                }

                @Override
                public void onResourceReady(Bitmap bitmap) {
                    if (bitmap != null) {
                        ImageLoader.addBitmapToCache(url, new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), bitmap), imageConfig);
                    }
                }
            }, width, height, true);
        }
    }

    private static ImageBitmapData getImageBitmapData(String url, int resid) {
        ImageBitmapData imageData = new ImageBitmapData();
        imageData.url = url;
        imageData.placeholderId = resid;
        return imageData;
    }

    private static void setImageDataToTag(RecycleImageView imageView, ImageData imageData) {
        if (imageData != null) {
            imageData.canRecycle = true;
        }
        imageView.setTag(R.id.yy_image_data_id, imageData);
    }

    private static void setImageBitmapDataToTag(RecycleImageView imageView, ImageBitmapData imageData) {
        if (imageData != null) {
            imageData.canRecycle = true;
        }
        imageView.setTag(R.id.yy_image_data_id, imageData);
    }

    private static void clearHeadRequest(RecycleImageView imageView) {
        if (imageView != null) {
            Object target = imageView.getTag(R.id.yy_glide_target_id);
            if (target instanceof Target) {
                ImageLoader.clear((Target)target);
                imageView.setTag(R.id.yy_glide_target_id, null);
            } else {
                ImageLoader.clear(imageView);
            }
        }
    }

    public static void loadBitmap(RecycleImageView imageView, String url, int placeResId) {
        if (url == null || imageView == null) {
            return;
        }
        ImageLoader.loadBitmap(imageView, url, placeResId, Integer.MIN_VALUE, Integer.MIN_VALUE);
    }

    public static void loadBitmap(final RecycleImageView imageView, final String url, final int placeResId, int maxWidth, int maxHeight) {
        if (url == null || imageView == null) {
            return;
        }
        BitmapDrawable drawableFromCache = ImageLoader.getBitmapFromCache(url);
        if (drawableFromCache != null) {
            ImageLoader.clearHeadRequest(imageView);
            imageView.setImageDrawable((Drawable)drawableFromCache);
            ImageLoader.setImageBitmapDataToTag(imageView, ImageLoader.getImageBitmapData(url, placeResId));
            return;
        }
        imageView.setImageResource(placeResId);
        final WeakReference<RecycleImageView> fImageView = new WeakReference<RecycleImageView>(imageView);
        if (imageView != null) {
            ImageLoader.setImageBitmapDataToTag(imageView, ImageLoader.getImageBitmapData(url, placeResId));
        }
        ImageLoader.loadBitmap(imageView, url, new BitmapLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
            }

            @Override
            public void onResourceReady(Bitmap bitmap) {
                if (bitmap != null) {
                    BitmapDrawable drawable = new BitmapDrawable(RuntimeContext.sApplicationContext.getResources(), bitmap);
                    ImageLoader.addBitmapToCache(url, drawable);
                    RecycleImageView theImageView = (RecycleImageView)fImageView.get();
                    if (theImageView != null) {
                        theImageView.setImageDrawable((Drawable)drawable);
                        ImageLoader.setImageBitmapDataToTag(imageView, ImageLoader.getImageBitmapData(url, placeResId));
                    }
                }
            }
        }, maxWidth, maxHeight, true, false, new YYBitmapTransformation[0]);
    }

    public static void savePhotoSync(String url, File saveTo) throws Exception {
        if (RuntimeContext.sIsDebuggable && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("please don not call savePhotoSync in Main Thread!");
        }
        if (StringUtils.isEmpty(url) || saveTo == null) {
            throw new RuntimeException("savePhotoSync : url or saveto is null");
        }
        FutureTarget<File> future = ((RequestBuilder)Glide.with(RuntimeContext.sApplicationContext).load(url)).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE);
        File cacheFile = (File)future.get();
        if (cacheFile == null) {
            throw new RuntimeException("savePhotoSync : load url error" + url);
        }
        YYFileUtils.copyFile(cacheFile, saveTo);
        ImageLoader.loadBitmap(RuntimeContext.sApplicationContext, cacheFile.getAbsolutePath(), new BitmapLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
            }

            @Override
            public void onResourceReady(Bitmap bitmap) {
            }
        });
    }

    public static void savePhotoSyncToMedia(String url, File saveTo, String fileName) throws Exception {
        if (RuntimeContext.sIsDebuggable && YYTaskExecutor.isMainThread()) {
            throw new RuntimeException("please don not call savePhotoSyncToMedia in Main Thread!");
        }
        if (StringUtils.isEmpty(url)) {
            throw new RuntimeException("savePhotoSyncToMedia : url or saveto is null");
        }
        FutureTarget<File> future = ((RequestBuilder)Glide.with(RuntimeContext.sApplicationContext).load(url)).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE);
        File cacheFile = (File)future.get();
        if (cacheFile != null) {
            if (SdkVersionUtils.hasScopedStorage()) {
                FileOperatorQ.INSTANCE.saveMediaFile(cacheFile.getAbsolutePath(), false, fileName);
            } else {
                YYFileUtils.copyFile(cacheFile, saveTo);
            }
        } else {
            throw new RuntimeException("savePhotoSyncToMedia : load url error" + url);
        }
        ImageLoader.loadBitmap(RuntimeContext.sApplicationContext, cacheFile.getAbsolutePath(), new BitmapLoadListener(){

            @Override
            public void onLoadFailed(Exception e) {
            }

            @Override
            public void onResourceReady(Bitmap bitmap) {
            }
        });
    }

    private static void handlePhotoSave(@NonNull String url, final @NonNull File saveTo, final ISavePicListener listener) {
        ((RequestBuilder)Glide.with(RuntimeContext.sApplicationContext).asBitmap().load(url)).addListener(new RequestListener<Bitmap>(){

            @Override
            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Bitmap> target, boolean isFirstResource) {
                YYTaskExecutor.postToMainThread(() -> {
                    if (listener != null) {
                        listener.onFailed(e);
                    }
                });
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onResourceReady(Bitmap resource, Object model, Target<Bitmap> target, DataSource dataSource, boolean isFirstResource, PerformanceData performanceData) {
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(saveTo);
                    resource.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
                    YYTaskExecutor.postToMainThread(() -> {
                        if (listener != null) {
                            listener.onSuccess();
                        }
                    });
                }
                catch (Exception e) {
                    YYTaskExecutor.postToMainThread(() -> {
                        if (listener != null) {
                            listener.onFailed(e);
                        }
                    });
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                return true;
            }
        }).submit();
    }

    public static void savePhotoSync(String url, File saveTo, ISavePicListener listener) {
        if (StringUtils.isEmpty(url) || saveTo == null) {
            YYTaskExecutor.postToMainThread(() -> {
                if (listener != null) {
                    listener.onFailed(new Exception("savePhotoSync fail, url or saveTo is null"));
                }
            });
            return;
        }
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute(() -> ImageLoader.handlePhotoSave(url, saveTo, listener));
        } else {
            ImageLoader.handlePhotoSave(url, saveTo, listener);
        }
    }

    public static Bitmap getBitmapFromCustomDrawable(Drawable drawable) {
        try {
            if (drawable != null) {
                if (drawable instanceof GifDrawable) {
                    return ((GifDrawable)drawable).getFirstFrame();
                }
                if (drawable instanceof BitmapDrawable) {
                    return ((BitmapDrawable)drawable).getBitmap();
                }
                if (drawable instanceof TransitionDrawable) {
                    TransitionDrawable td = (TransitionDrawable)drawable;
                    int index = td.getNumberOfLayers();
                    Drawable d = null;
                    for (int i = 0; i < index; ++i) {
                        d = td.getDrawable(i);
                        if (!(d instanceof BitmapDrawable)) continue;
                        return ((BitmapDrawable)d).getBitmap();
                    }
                }
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, "getBitmapFromCustomDrawable error", ex, new Object[0]);
        }
        return null;
    }

    public static void clearMemory() {
        if (RuntimeContext.sApplicationContext != null) {
            YYTaskExecutor.execute(() -> {
                Glide glide = Glide.get(RuntimeContext.sApplicationContext);
                YYTaskExecutor.postToMainThread(glide::clearMemory);
            });
        }
        if (sNormalCache != null) {
            sNormalCache.cleanMemCache();
        }
    }

    public static void trimMemory(int level) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info(TAG, "trimMemory:  " + level, new Object[0]);
        }
        if (RuntimeContext.sApplicationContext != null) {
            YYTaskExecutor.execute(() -> {
                Glide glide = Glide.get(RuntimeContext.sApplicationContext);
                YYTaskExecutor.postToMainThread(() -> glide.trimMemory(level));
            });
        }
        if (sNormalCache != null) {
            if (level >= 40) {
                sNormalCache.cleanMemCache();
            }
            sNormalCache.cleanHalfMemCache();
        }
    }

    public static void loadImageResource(int resource, RecycleImageView recycleImageView, ImageConfig imageConfig) {
        ImageUtil.loadImageResource(resource, recycleImageView, imageConfig);
    }

    private static boolean recycle(RecycleImageView imageView) {
        Object recycled;
        if (imageView == null || !sRecycleImageViewOn) {
            return false;
        }
        if (imageView.getImageDrawableInner() == null && (recycled = imageView.getTag(R.id.yy_recycled)) instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            return false;
        }
        Object data = imageView.getTag(R.id.yy_image_data_id);
        String url = "";
        boolean canRecycle = true;
        if (data instanceof ImageData) {
            ImageData imageData = (ImageData)data;
            url = imageData.url;
            canRecycle = imageData.canRecycle;
        } else if (data instanceof ImageBitmapData) {
            ImageBitmapData imageData = (ImageBitmapData)data;
            url = imageData.url;
            canRecycle = imageData.canRecycle;
        } else {
            return false;
        }
        if (!StringUtils.isEmpty(url) && canRecycle) {
            if (RuntimeContext.sIsDebuggable && sDebugSwitch && !MLog.isLogLevelAboveDebug()) {
                MLog.debug(TAG, "RecycleImageView recycle url:" + url, new Object[0]);
            }
            sResetDrawableToNulling = true;
            ImageLoader.clear(imageView);
            imageView.setImageDrawable(null);
            imageView.setTag(R.id.yy_recycled, true);
            sResetDrawableToNulling = false;
            return true;
        }
        return false;
    }

    public static void recycleByNotVisible(RecycleImageView imageView) {
        ImageLoader.recycle(imageView);
    }

    private static boolean recovery(RecycleImageView imageView) {
        if (imageView == null) {
            return false;
        }
        Object recycled = imageView.getTag(R.id.yy_recycled);
        if (recycled instanceof Boolean && ((Boolean)recycled).booleanValue()) {
            String url;
            Object data = imageView.getTag(R.id.yy_image_data_id);
            ImageData imageData = null;
            ImageBitmapData imageBitmapData = null;
            if (data instanceof ImageData) {
                imageData = (ImageData)data;
            } else if (data instanceof ImageBitmapData) {
                imageBitmapData = (ImageBitmapData)data;
            }
            if (imageData == null && imageBitmapData == null) {
                return false;
            }
            String string2 = url = imageData != null ? imageData.url : imageBitmapData.url;
            if (!StringUtils.isEmpty(url)) {
                if (RuntimeContext.sIsDebuggable && sDebugSwitch && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug(TAG, "RecycleImageView recovery url:" + url, new Object[0]);
                }
                if (imageData != null) {
                    imageData.needCheckUrl = false;
                    ImageLoader.loadImage(imageView, imageData);
                } else {
                    imageBitmapData.needCheckUrl = false;
                    if (SystemUtils.isShowEnvSetting()) {
                        imageView.setTag(R.id.yy_recycled_check_url, false);
                    }
                    ImageLoader.loadBitmap(imageView, url, imageBitmapData.placeholderId);
                }
                imageView.setTag(R.id.yy_recycled, false);
                if (!sRecycleImageViewOn) {
                    ImageLoader.setImageDataToTag(imageView, null);
                }
                return true;
            }
        }
        if (!sRecycleImageViewOn) {
            ImageLoader.setImageDataToTag(imageView, null);
        }
        return false;
    }

    public static void recoveryByBeVisible(RecycleImageView imageView) {
        ImageLoader.recovery(imageView);
    }

    public static void onImageDrawableUpdated(RecycleImageView imageView, Drawable drawable) {
        GifHandler.onImageDrawableUpdated(imageView, drawable);
        if (sResetDrawableToNulling && drawable == null) {
            return;
        }
        if (sRecycleImageViewOn) {
            if (drawable == null) {
                Object data = imageView.getTag(R.id.yy_image_data_id);
                if (data instanceof ImageData) {
                    ImageData imageData = (ImageData)data;
                    imageData.canRecycle = false;
                } else if (data instanceof ImageBitmapData) {
                    ImageBitmapData imageData = (ImageBitmapData)data;
                    imageData.canRecycle = false;
                }
                imageView.setTag(R.id.yy_recycled, false);
            }
        } else {
            ImageLoader.setImageDataToTag(imageView, null);
            imageView.setTag(R.id.yy_recycled, false);
        }
    }

    public static void setMonitor(IMonitor monitor) {
        sMonitor = monitor;
    }

    public static void setHiidoMonitor(IMonitor monitor) {
        hiidoMonitor = monitor;
    }

    private static int generateIndex() {
        return ++sIndex;
    }

    public static void pause(Context context) {
        if (context == null) {
            return;
        }
        Glide.with(context).pauseRequestsRecursive();
    }

    public static void resume(Context context) {
        Glide.with(context).resumeRequestsRecursive();
    }

    static {
        sBitmapPoolSize = MAX_BITMAP_POOL_SIZE;
        sResourceCacheSize = MAX_RESOURCE_BITMAP_POOL_SIZE;
        sLoadOrigin = false;
        sRecycleImageViewOn = true;
        sBigImageAutoRecycle = true;
        sBigRecycleSizeMultiplier = 5;
        sResetDrawableToNulling = false;
        sIndex = 0;
    }

    public static class ImageBitmapData {
        private static final int INVALID_ID = -1;
        public String url;
        public int placeholderId = -1;
        public boolean canRecycle = true;
        public boolean needCheckUrl = true;

        private ImageBitmapData() {
        }
    }

    public static class ImageData {
        public static final int INVALID_ID = -1;
        public static final int INVALID_SIZE = -1;
        public ImageLoadListener listener;
        public Drawable placeholderDrawable;
        public Drawable errorDrawable;
        public YYBitmapTransformation[] transformations;
        public String originUrl;
        public String url;
        public Object thumbnail;
        public String backUrl;
        public float sizeMultiplier = RuntimeContext.getPhoneType() == 1 ? 0.85f : 1.0f;
        public int placeholderId = -1;
        public int errorId = -1;
        public int width = -1;
        public int height = -1;
        public boolean circle = false;
        public int round = -1;
        public boolean skipMemCache = false;
        public boolean skipDiskCache = false;
        public boolean anim = true;
        public boolean enableGif = true;
        public boolean asGif = false;
        public DecodeFormat decodeFormat = DecodeFormat.PREFER_RGB_565;
        public boolean useOriginalSize = false;
        public boolean canRecycle = true;
        public boolean crossFade = false;
        public boolean loadSuccess = false;
        public IMonitor monitor;
        public boolean isOverrideSize = false;
        public boolean needCheckUrl = true;

        private ImageData() {
        }

        public void reset() {
            this.url = null;
            this.originUrl = null;
            this.backUrl = null;
            this.thumbnail = null;
            this.decodeFormat = DecodeFormat.PREFER_RGB_565;
            this.canRecycle = true;
            this.placeholderId = -1;
            this.errorId = -1;
            this.sizeMultiplier = RuntimeContext.getPhoneType() == 1 ? 0.85f : 1.0f;
            this.width = -1;
            this.height = -1;
            this.useOriginalSize = false;
            this.enableGif = true;
            this.asGif = false;
            this.crossFade = false;
            this.anim = true;
            this.circle = false;
            this.round = -1;
            this.listener = null;
            this.placeholderDrawable = null;
            this.errorDrawable = null;
            this.transformations = null;
            this.skipMemCache = false;
            this.skipDiskCache = false;
            this.loadSuccess = false;
            this.monitor = null;
            this.isOverrideSize = false;
        }
    }

    public static class Builder {
        private RecycleImageView mView;
        private ImageData mData;

        private Builder() {
        }

        Builder(RecycleImageView recycleImageView, String url) {
            this(recycleImageView, url, -1);
        }

        Builder(RecycleImageView recycleImageView, String url, int placeholderId) {
            this.mView = recycleImageView;
            Object dataObject = recycleImageView.getTag(R.id.yy_image_data_id);
            if (dataObject instanceof ImageData) {
                this.mData = (ImageData)dataObject;
                this.mData.reset();
            } else {
                this.mData = new ImageData();
                recycleImageView.setTag(R.id.yy_image_data_id, this.mData);
            }
            this.mData.originUrl = url;
            this.mData.url = url;
            this.mData.placeholderId = placeholderId;
        }

        public static Builder obtain(RecycleImageView recycleImageView, String url) {
            return new Builder(recycleImageView, url);
        }

        public static Builder obtain(RecycleImageView recycleImageView, String url, int placeholderId) {
            return new Builder(recycleImageView, url, placeholderId);
        }

        public static ImageData check(RecycleImageView recycleImageView) {
            Object dataObject = recycleImageView.getTag(R.id.yy_image_data_id);
            if (dataObject instanceof ImageData) {
                return (ImageData)dataObject;
            }
            return null;
        }

        public static ImageData resetData(RecycleImageView recycleImageView, String url) {
            Object dataObject = recycleImageView.getTag(R.id.yy_image_data_id);
            if (dataObject instanceof ImageData) {
                ImageData imageData = (ImageData)dataObject;
                imageData.reset();
                imageData.originUrl = url;
                imageData.url = url;
                return imageData;
            }
            ImageData imageData = new ImageData();
            imageData.originUrl = url;
            imageData.url = url;
            recycleImageView.setTag(R.id.yy_image_data_id, imageData);
            return imageData;
        }

        public Builder setImageData(RecycleImageView imageView, ImageData imageData) {
            this.mView = imageView;
            this.mData = imageData;
            imageView.setTag(R.id.yy_image_data_id, imageData);
            return this;
        }

        public Builder thumbnail(Object thumbnail) {
            this.mData.thumbnail = thumbnail;
            return this;
        }

        public Builder placeholder(int placeholder) {
            this.mData.placeholderId = placeholder;
            return this;
        }

        public Builder error(int errorId) {
            this.mData.errorId = errorId;
            return this;
        }

        public Builder placeholder(Drawable drawable) {
            this.mData.placeholderDrawable = drawable;
            return this;
        }

        public Builder error(Drawable drawable) {
            this.mData.errorDrawable = drawable;
            return this;
        }

        public Builder override(int width, int height) {
            if (ImageUtil.isValidDimensions(width, height)) {
                this.mData.width = width;
                this.mData.height = height;
            } else if (RuntimeContext.sIsDebuggable && MLog.isLogLevelBlowInfo()) {
                MLog.info(ImageLoader.TAG, "override:Width and height must be > 0", new Object[0]);
            }
            return this;
        }

        public Builder useOriginalSize(boolean use) {
            this.mData.useOriginalSize = use;
            return this;
        }

        public Builder anim(boolean ani) {
            this.mData.anim = ani;
            return this;
        }

        public Builder setSizeMultiplier(float sizeMultiplier) {
            this.mData.sizeMultiplier = sizeMultiplier;
            return this;
        }

        public Builder setCircle(boolean circle) {
            this.mData.circle = circle;
            return this;
        }

        public Builder setTransform(YYBitmapTransformation ... bitmapTransformations) {
            if (bitmapTransformations != null && bitmapTransformations.length > 0) {
                this.mData.transformations = new YYBitmapTransformation[bitmapTransformations.length];
                for (int i = 0; i < bitmapTransformations.length; ++i) {
                    this.mData.transformations[i] = bitmapTransformations[i];
                }
            } else {
                this.mData.transformations = null;
            }
            return this;
        }

        public Builder enableGif(boolean enable) {
            this.mData.enableGif = enable;
            return this;
        }

        public Builder overrideSize(boolean override) {
            this.mData.isOverrideSize = override;
            return this;
        }

        public Builder asGif(boolean enable) {
            this.mData.asGif = enable;
            return this;
        }

        public Builder setRound(int dp) {
            this.mData.round = dp;
            return this;
        }

        public Builder setCrossFade(boolean crossFade) {
            this.mData.crossFade = crossFade;
            return this;
        }

        public Builder skipCache(boolean skip) {
            this.mData.skipMemCache = skip;
            return this;
        }

        public Builder skipDiskCache(boolean skip) {
            this.mData.skipDiskCache = skip;
            return this;
        }

        public Builder setListener(ImageLoadListener listener) {
            this.mData.listener = listener;
            return this;
        }

        public Builder setDecodeFormat(DecodeFormat decodeFormat) {
            if (decodeFormat == null) {
                return this;
            }
            this.mData.decodeFormat = decodeFormat;
            return this;
        }

        public void load() {
            ImageLoader.loadImage(this.mView, this.mData);
        }
    }

    public static interface IMonitor {
        public void onStart(int var1, boolean var2, String var3, int var4, int var5);

        public void onSuccess(int var1, String var2, int var3, boolean var4, DataSource var5, PerformanceData var6);

        public void onError(int var1, String var2, Exception var3);

        default public void onHappenHttpError(String url) {
        }

        public void onClear(int var1);
    }

    public static interface ImageLoadListener {
        public void onLoadFailed(Exception var1);

        public void onResourceReady(Object var1, boolean var2, DataSource var3);
    }

    public static interface ISavePicListener {
        public void onFailed(Exception var1);

        public void onSuccess();
    }

    public static interface BitmapLoadListener {
        public void onLoadFailed(Exception var1);

        public void onResourceReady(Bitmap var1);
    }
}

