/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader;

import android.app.Activity;
import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.view.ViewCompat;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.IRecycler;
import com.yy.base.imageloader.ImageConfig;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.ImageUtil;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.util.ArrayList;

public class BigPicRecycler {
    public static final int BIG_RECYCLE_SIZEMULTAIPLIER_WHEN_MEMORY_WARNING = 2;
    private static final ArrayList<YYTaskExecutor.RunnableEx> sRunnables = new ArrayList(12);
    private static volatile boolean sBigImageAutoRecycle = true;
    private static volatile int sBigRecycleSizeMultiplier = 5;
    private static IRecycler sRecycler;
    private static IRecoverInterceptor sRecoverInterceptor;

    public static void init(Application application, IRecycler recycler) {
        sRecycler = recycler;
        if (Build.VERSION.SDK_INT < 24) {
            application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                }

                public void onActivityStarted(Activity activity) {
                }

                public void onActivityResumed(Activity activity) {
                    for (YYTaskExecutor.RunnableEx runnableEx : sRunnables) {
                        if (runnableEx.getArg() != activity) continue;
                        YYTaskExecutor.removeRunnableFromMainThread(runnableEx);
                        sRunnables.remove(runnableEx);
                        break;
                    }
                    BigPicRecycler.recoveryBigPicIfNeed(activity);
                }

                public void onActivityPaused(Activity activity) {
                }

                public void onActivityStopped(Activity activity) {
                    YYTaskExecutor.RunnableEx runnableEx = new YYTaskExecutor.RunnableEx(){

                        @Override
                        public void run() {
                            if (this.getArg() instanceof Activity) {
                                BigPicRecycler.recycleBigPicIfNeed((Activity)this.getArg());
                            }
                            sRunnables.remove(this);
                        }
                    };
                    runnableEx.setArg(activity);
                    sRunnables.add(runnableEx);
                    YYTaskExecutor.postToMainThread(runnableEx, 5000L);
                }

                public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                }

                public void onActivityDestroyed(Activity activity) {
                    for (YYTaskExecutor.RunnableEx runnableEx : sRunnables) {
                        if (runnableEx.getArg() != activity) continue;
                        YYTaskExecutor.removeRunnableFromMainThread(runnableEx);
                        sRunnables.remove(runnableEx);
                        break;
                    }
                }
            });
        }
    }

    public static void updateParams(boolean bigImageAutoRecycle, int recycleSizeMultiplier) {
        sBigImageAutoRecycle = bigImageAutoRecycle;
        sBigRecycleSizeMultiplier = recycleSizeMultiplier;
        MLog.debug("ImageAuto_BigPicRecycler", "recycleBigPic switch:%d,multiplier:%d", bigImageAutoRecycle ? 1 : 0, recycleSizeMultiplier);
    }

    private static void recycleBigPicIfNeed(Activity activity) {
        View rootView;
        if (!sBigImageAutoRecycle || activity == null) {
            return;
        }
        if (RuntimeContext.sIsDebuggable && ImageLoader.sDebugSwitch && !MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
            MLog.debug("ImageAuto_BigPicRecycler", "recycleBigPic activity:" + activity.toString(), new Object[0]);
        }
        if ((rootView = activity.getWindow().getDecorView()) instanceof ViewGroup) {
            BigPicRecycler.recycleBigPicIfNeed((ViewGroup)rootView);
            rootView.setTag(R.id.yy_bigpic_recycled, (Object)true);
        }
    }

    private static void recoveryBigPicIfNeed(Activity activity) {
        if (activity == null) {
            return;
        }
        View rootView = activity.getWindow().getDecorView();
        if (rootView instanceof ViewGroup) {
            boolean needRecovery;
            boolean bl = needRecovery = rootView.getTag(R.id.yy_bigpic_recycled) instanceof Boolean ? (Boolean)rootView.getTag(R.id.yy_bigpic_recycled) : false;
            if (needRecovery || sBigImageAutoRecycle) {
                if (RuntimeContext.sIsDebuggable && ImageLoader.sDebugSwitch && !MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug("ImageAuto_BigPicRecycler", "recovery:" + activity.toString(), new Object[0]);
                }
                BigPicRecycler.recoveryBigPicIfNeed((ViewGroup)rootView);
                rootView.setTag(R.id.yy_bigpic_recycled, (Object)false);
            }
        }
    }

    public static void recycleBigPicIfNeedWhenMemoryWarning(ViewGroup viewGroup) {
        if (sRecoverInterceptor != null) {
            int value = sRecoverInterceptor.getBigRecycleSizeMultiplierWhenMemoryWarning();
            BigPicRecycler.recycleBigPicIfNeed(viewGroup, value > 0 ? value : sBigRecycleSizeMultiplier);
        } else {
            BigPicRecycler.recycleBigPicIfNeed(viewGroup);
        }
    }

    public static void recycleBigPicIfNeed(ViewGroup viewGroup) {
        BigPicRecycler.recycleBigPicIfNeed(viewGroup, sBigRecycleSizeMultiplier);
    }

    public static void recycleBigPicIfNeed(ViewGroup viewGroup, int bigRecycleSizeMultiplier) {
        if (!sBigImageAutoRecycle || viewGroup == null) {
            return;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                BigPicRecycler.recycleBigPicIfNeed((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            BigPicRecycler.recycleBigPicIfNeed((ImageView)child, bigRecycleSizeMultiplier);
        }
    }

    private static void recycleBigPicIfNeed(ImageView child, int bigRecycleSizeMultiplier) {
        RecycleImageView imageView;
        Drawable drawable2;
        if (child == null || !(child instanceof RecycleImageView)) {
            return;
        }
        if (bigRecycleSizeMultiplier <= 1) {
            bigRecycleSizeMultiplier = 1;
        }
        if ((drawable2 = (imageView = (RecycleImageView)child).getImageDrawableInner()) != null && !(drawable2 instanceof GifDrawable)) {
            Bitmap bitmap = ImageLoader.getBitmapFromCustomDrawable(drawable2);
            float size = ImageConfig.fullImageConfig().getImagePrecision().getHeight() * ImageConfig.fullImageConfig().getImagePrecision().getWidth();
            size = size < 777600.0f ? 77760.0f : (size *= 0.1f);
            int bitmapSize = ImageUtil.getBitmapSize(bitmap);
            if ((float)bitmapSize >= size * (float)bigRecycleSizeMultiplier && sRecycler != null && sRecycler.recycle(imageView)) {
                imageView.setTag(R.id.yy_bigpic_recycled, true);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("ImageAuto_BigPicRecycler", "recycle imageView:%s,size:%d", imageView.toString(), Float.valueOf(size));
                }
            }
        }
    }

    public static void recoveryBigPicIfNeed(ViewGroup viewGroup) {
        View view;
        if (!sBigImageAutoRecycle || viewGroup == null) {
            return;
        }
        if (sRecoverInterceptor != null && (view = sRecoverInterceptor.getRecoverView(viewGroup)) != viewGroup) {
            if (view instanceof ViewGroup) {
                viewGroup = (ViewGroup)view;
                BigPicRecycler.recoveryBigPicIfNeed(viewGroup);
            } else if (view instanceof ImageView) {
                BigPicRecycler.recoveryBigPicIfNeed((ImageView)view);
            }
            return;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                BigPicRecycler.recoveryBigPicIfNeed((ViewGroup)child);
                continue;
            }
            if (!(child instanceof ImageView)) continue;
            BigPicRecycler.recoveryBigPicIfNeed((ImageView)child);
        }
    }

    private static void recoveryBigPicIfNeed(ImageView child) {
        if (child == null || !(child instanceof RecycleImageView)) {
            return;
        }
        RecycleImageView imageView = (RecycleImageView)child;
        Drawable drawable2 = imageView.getImageDrawableInner();
        if (drawable2 == null) {
            boolean needRecovery;
            Object tag = imageView.getTag(R.id.yy_bigpic_recycled);
            boolean bl = needRecovery = tag instanceof Boolean ? (Boolean)tag : false;
            if (needRecovery && (imageView.closeAutoRecycleDrawables() || ViewCompat.isAttachedToWindow((View)imageView)) && sRecycler != null) {
                sRecycler.recovery(imageView);
                child.setTag(R.id.yy_bigpic_recycled, (Object)false);
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info("ImageAuto_BigPicRecycler", "recovery imageView:" + imageView.toString(), new Object[0]);
                }
            }
        }
    }

    public static void setRecoverInterceptor(IRecoverInterceptor recoverInterceptor) {
        sRecoverInterceptor = recoverInterceptor;
    }

    public static interface IRecoverInterceptor {
        public View getRecoverView(ViewGroup var1);

        public int getBigRecycleSizeMultiplierWhenMemoryWarning();
    }
}

