/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.kvo.map;

import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoSource;
import java.util.Map;

public class KvoHashMapHelper {
    public static final String KvoHashMap_EventArg_Key_Type = "KvoHashMap_EventArg_Key_Type";
    public static final String KvoHashMap_EventArg_Key_Length = "KvoHashMap_EventArg_Key_Length";

    public static <K, V> void notifyInsert(KvoSource source, String name, Map<K, V> map, int length) {
        KvoHashMapHelper.notifyKvoHashMapChange(source, name, map, KvoHashMapChangeType.KvoEventArg_Type_Insert, length);
    }

    public static <K, V> void notifyRangeRemove(KvoSource source, String name, Map<K, V> map, int length) {
        KvoHashMapHelper.notifyKvoHashMapChange(source, name, map, KvoHashMapChangeType.KvoEventArg_Type_Remove, length);
    }

    public static <K, V> void notifyRangeReplace(KvoSource source, String name, Map<K, V> map, int length) {
        KvoHashMapHelper.notifyKvoHashMapChange(source, name, map, KvoHashMapChangeType.KvoEventArg_Type_Replace, length);
    }

    public static <K, V> void notifyReload(KvoSource source, String name, Map<K, V> map) {
        KvoHashMapHelper.notifyKvoHashMapChange(source, name, map, KvoHashMapChangeType.KvoEventArg_Type_Reload, map.size());
    }

    private static <K, V> void notifyKvoHashMapChange(KvoSource source, String name, Map<K, V> map, KvoHashMapChangeType type, int length) {
        KvoEventIntent kvoEventIntent = KvoEventIntent.build(source, name);
        kvoEventIntent.setOldValue(map);
        kvoEventIntent.setNewValue(map);
        kvoEventIntent.putArg(KvoHashMap_EventArg_Key_Length, length);
        kvoEventIntent.putArg(KvoHashMap_EventArg_Key_Type, (Object)type);
        source.notifyEvent(kvoEventIntent);
    }

    public static enum KvoHashMapChangeType {
        KvoEventArg_Type_Insert,
        KvoEventArg_Type_Remove,
        KvoEventArg_Type_Replace,
        KvoEventArg_Type_Reload;

    }
}

