/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.event.core;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.core.EventIntent;
import com.yy.base.event.core.IEventThread;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Comparator;

public class EventReceiver {
    public static final int DEFAULT_EVENT_RECEIVER_PRIORITY = 0;
    static Comparator<EventReceiver> sEventReceiverComparator = (lhs, rhs) -> {
        if (lhs.mReceiverHashCode == rhs.mReceiverHashCode) {
            return 0;
        }
        int priorityResult = Integer.compare(rhs.priority, lhs.priority);
        return priorityResult > 0 ? 1 : (priorityResult < 0 ? -1 : Integer.compare(rhs.mReceiverHashCode, lhs.mReceiverHashCode));
    };
    @Nullable
    protected final IEventThread thread;
    protected final int priority;
    protected final int flag;
    protected final WeakReference<Object> target;
    protected final Method entry;
    protected final int mReceiverHashCode;

    public EventReceiver(Object target, Method entry, @Nullable IEventThread thread, int priority, int flag) {
        this.target = new WeakReference<Object>(target);
        this.entry = entry;
        this.thread = thread;
        this.flag = flag;
        this.priority = priority;
        this.mReceiverHashCode = StringUtils.combineStr(target.getClass(), entry, target.hashCode()).hashCode();
    }

    public boolean invoke(EventIntent eventIntent) {
        Object targetObj = this.target.get();
        if (targetObj == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info("FrameWork_Event", "invoke failed target has been recycled, method is : " + this.entry.toGenericString(), new Object[0]);
            }
            return false;
        }
        this.scheduleInvoke(targetObj, eventIntent);
        return true;
    }

    protected void scheduleInvoke(@NonNull Object targetObj, EventIntent eventIntent) {
        if (this.thread != null) {
            this.thread.post(() -> this.doInvoke(targetObj, eventIntent));
        } else {
            this.doInvoke(targetObj, eventIntent);
        }
    }

    protected void doInvoke(Object target, EventIntent eventIntent) {
        block2: {
            try {
                this.entry.invoke(target, eventIntent);
            }
            catch (Throwable e) {
                MLog.error((Object)"FrameWork_Event", "invoke failed target error : " + Log.getStackTraceString((Throwable)e) + " cause : " + e.getCause() + " method : " + this.entry.toString(), new Object[0]);
                if (!RuntimeContext.sIsDebuggable) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EventReceiver)) {
            return false;
        }
        EventReceiver other = (EventReceiver)obj;
        return other.mReceiverHashCode == this.mReceiverHashCode && other.entry == this.entry && this.thread == other.thread && this.priority == other.priority && this.flag == other.flag;
    }

    public boolean isValid() {
        return this.target.get() != null;
    }

    public int hashCode() {
        return this.mReceiverHashCode;
    }

    @NonNull
    public String toString() {
        return StringUtils.safeCombineStr("target : ", this.target.get(), " entry : ", this.entry, " thread : ", this.thread, " priority : ", this.priority, " mReceiverHashCode : ", this.mReceiverHashCode);
    }
}

