/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.emotion.base.emoji;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

public class EmojiSpan
extends ImageSpan {
    private int lineSpace;

    public EmojiSpan(Drawable drawable2, int lineSpace) {
        super(drawable2);
        this.lineSpace = lineSpace;
    }

    public EmojiSpan(Context context, int resourceId) {
        super(context, resourceId);
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fontMetricsInt) {
        Drawable drawable2 = this.getDrawable();
        Rect rect = drawable2.getBounds();
        if (fontMetricsInt != null) {
            Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
            int fontHeight = fmPaint.bottom - fmPaint.top;
            int drHeight = rect.bottom - rect.top;
            int top = drHeight / 2 - fontHeight / 4;
            int bottom = drHeight / 2 + fontHeight / 4;
            fontMetricsInt.ascent = -bottom;
            fontMetricsInt.top = -bottom;
            fontMetricsInt.bottom = top;
            fontMetricsInt.descent = top;
        }
        return rect.right;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable drawable2 = this.getDrawable();
        canvas.save();
        int transY = (bottom - top - drawable2.getBounds().bottom) / 2 + top - this.lineSpace;
        canvas.translate(x, (float)transY);
        drawable2.draw(canvas);
        canvas.restore();
    }
}

